/*
 * Decompiled with CFR 0.152.
 */
package com.github.houbb.compress.util;

import com.github.houbb.compress.annotation.CommonEager;
import com.github.houbb.compress.support.filter.PathCondition;
import com.github.houbb.heaven.util.lang.ObjectUtil;
import com.github.houbb.heaven.util.util.CollectionUtil;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

@CommonEager
public class PathUtil {
    private static final Path ROOT_PATH = Paths.get("/", new String[0]);

    public static List<Path> getConditionList(List<Path> pathList, PathCondition pathCondition) {
        if (CollectionUtil.isEmpty(pathList)) {
            return Collections.emptyList();
        }
        ArrayList<Path> conditionList = new ArrayList<Path>();
        for (Path path : pathList) {
            if (!pathCondition.condition(path)) continue;
            conditionList.add(path);
        }
        return conditionList;
    }

    public static String getRelativePath(Path parentPath, Path path) {
        String pathStr = path.toString();
        if (ObjectUtil.isNull((Object)parentPath)) {
            return pathStr;
        }
        if (parentPath.toString().length() <= 1) {
            return pathStr;
        }
        String parentPathStr = parentPath.toString();
        if (pathStr.startsWith(parentPathStr)) {
            return pathStr.substring(parentPathStr.length() + 1);
        }
        return pathStr;
    }

    public static Path getPublicParentPath(List<Path> pathList) {
        if (pathList.size() == 1) {
            return PathUtil.getParentPath(pathList.get(0));
        }
        ArrayList<List<String>> pathStrList = new ArrayList<List<String>>(pathList.size());
        for (Path path : pathList) {
            List<String> stringList = PathUtil.toStringList(PathUtil.getParentPaths(path));
            pathStrList.add(stringList);
        }
        List<String> publicParentPathStrs = PathUtil.retainAll(pathStrList);
        String maxLengthParent = PathUtil.getMaxLength(publicParentPathStrs);
        return Paths.get(maxLengthParent, new String[0]);
    }

    private static String getMaxLength(List<String> stringList) {
        String result = "";
        for (String string : stringList) {
            if (string.length() <= result.length()) continue;
            result = string;
        }
        return result;
    }

    public static List<Path> getParentPaths(Path path) {
        if (ObjectUtil.isNull((Object)path)) {
            return Collections.emptyList();
        }
        ArrayList<Path> pathList = new ArrayList<Path>();
        Path parentPath = path.getParent();
        while (ObjectUtil.isNotNull((Object)parentPath)) {
            pathList.add(parentPath);
            parentPath = parentPath.getParent();
        }
        if (CollectionUtil.isEmpty(pathList)) {
            pathList.add(ROOT_PATH);
        }
        return pathList;
    }

    public static Path getParentPath(Path path) {
        Path parentPath = path.getParent();
        if (ObjectUtil.isNull((Object)parentPath)) {
            return ROOT_PATH;
        }
        return parentPath;
    }

    public static List<String> toStringList(List<?> pathList) {
        if (CollectionUtil.isEmpty(pathList)) {
            return Collections.emptyList();
        }
        ArrayList<String> stringList = new ArrayList<String>(pathList.size());
        for (Object object : pathList) {
            if (!ObjectUtil.isNotNull(object)) continue;
            stringList.add(object.toString());
        }
        return stringList;
    }

    public static List<String> retainAll(List<List<String>> collectionList) {
        if (CollectionUtil.isEmpty(collectionList)) {
            return Collections.emptyList();
        }
        if (collectionList.size() == 1) {
            return collectionList.get(0);
        }
        List<String> result = collectionList.get(0);
        for (int i = 1; i < collectionList.size(); ++i) {
            result.retainAll((Collection)collectionList.get(i));
        }
        return result;
    }
}

