/*
 * Decompiled with CFR 0.152.
 */
package com.github.houbb.compress.context;

import com.github.houbb.compress.context.ICompressContext;
import com.github.houbb.compress.exception.CompressRuntimeException;
import com.github.houbb.heaven.annotation.NotThreadSafe;
import com.github.houbb.heaven.util.lang.StringUtil;
import com.github.houbb.heaven.util.util.ArrayUtil;
import com.github.houbb.heaven.util.util.CollectionUtil;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;

@NotThreadSafe
public class CompressContextBootstrap
implements ICompressContext {
    private List<Path> sourcePaths = new ArrayList<Path>();
    private Path targetPath;
    private String password = null;
    private boolean isRelativePath = true;

    private CompressContextBootstrap() {
    }

    public static CompressContextBootstrap source(String ... sourcePaths) {
        CompressContextBootstrap bootstrap = new CompressContextBootstrap();
        bootstrap.sources(sourcePaths);
        return bootstrap;
    }

    public CompressContextBootstrap target(String targetPath) {
        if (StringUtil.isEmpty((String)targetPath)) {
            throw new CompressRuntimeException("Target path not allow empty!");
        }
        this.targetPath = Paths.get(targetPath, new String[0]);
        return this;
    }

    public CompressContextBootstrap isRelativePath(boolean isRelativePath) {
        this.isRelativePath = isRelativePath;
        return this;
    }

    public CompressContextBootstrap password(String password) {
        this.password = password;
        return this;
    }

    @Override
    public List<Path> sourcePaths() {
        return this.sourcePaths;
    }

    @Override
    public Path sourcePathFirst() {
        if (CollectionUtil.isEmpty(this.sourcePaths)) {
            return null;
        }
        return this.sourcePaths.get(0);
    }

    @Override
    public Path targetPath() {
        return this.targetPath;
    }

    @Override
    public String password() {
        return this.password;
    }

    @Override
    public boolean isRelativePath() {
        return this.isRelativePath;
    }

    private CompressContextBootstrap sources(String ... sourcePaths) {
        if (ArrayUtil.isEmpty((Object[])sourcePaths)) {
            throw new CompressRuntimeException("Source paths not allow empty!");
        }
        for (String source : sourcePaths) {
            this.sourcePaths.add(Paths.get(source, new String[0]));
        }
        return this;
    }
}

