/*
 * Decompiled with CFR 0.152.
 */
package com.github.hi_fi.httpclient.security;

import com.github.hi_fi.httpclient.RestClient;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.net.ssl.HostnameVerifier;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.TrustSelfSignedStrategy;
import org.apache.http.conn.ssl.TrustStrategy;
import org.apache.http.ssl.SSLContextBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Certificate {
    private Log logger = LogFactory.getLog(RestClient.class);

    public KeyStore createCustomKeyStore(String path, String password) {
        try {
            KeyStore trustStore;
            if (password != null && path.endsWith(".jks")) {
                trustStore = KeyStore.getInstance("JKS");
                trustStore.load(new FileInputStream(path), password.toCharArray());
            } else {
                trustStore = KeyStore.getInstance(KeyStore.getDefaultType());
                trustStore.load(null);
                int i = 0;
                for (X509Certificate cert : this.getCertificatesFromFile(path)) {
                    trustStore.setCertificateEntry("Custom_entry_" + i, cert);
                    ++i;
                }
                this.logger.debug((Object)("Certificates in trustStore: " + i));
            }
            return trustStore;
        }
        catch (KeyStoreException e) {
            throw new RuntimeException(String.format("%s occurred. Error message: %s", e.getClass(), e.getMessage()));
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(String.format("%s occurred. Error message: %s", e.getClass(), e.getMessage()));
        }
        catch (CertificateException e) {
            throw new RuntimeException(String.format("%s occurred. Error message: %s", e.getClass(), e.getMessage()));
        }
        catch (IOException e) {
            throw new RuntimeException(String.format("%s occurred. Error message: %s", e.getClass(), e.getMessage()));
        }
    }

    private List<X509Certificate> getCertificatesFromFile(String path) {
        ArrayList<X509Certificate> certificateList = new ArrayList<X509Certificate>();
        try {
            String[] certificates = FileUtils.readFileToString((File)new File(path), (String)"UTF-8").split("-----BEGIN CERTIFICATE-----");
            for (String certificate : certificates = Arrays.copyOfRange(certificates, 1, certificates.length)) {
                certificate = "-----BEGIN CERTIFICATE-----" + certificate.split("-----END CERTIFICATE-----")[0] + "-----END CERTIFICATE-----";
                this.logger.trace((Object)certificate);
                certificateList.add(this.generateCertificateFromDER(certificate.getBytes()));
            }
            return certificateList;
        }
        catch (IOException e) {
            throw new RuntimeException("Couldn't read certificates. Error: " + e.getMessage());
        }
        catch (CertificateException e) {
            throw new RuntimeException("Certificate generation failed. Error: " + e.getMessage());
        }
    }

    private X509Certificate generateCertificateFromDER(byte[] certBytes) throws CertificateException {
        CertificateFactory factory = CertificateFactory.getInstance("X.509");
        return (X509Certificate)factory.generateCertificate(new ByteArrayInputStream(certBytes));
    }

    public SSLConnectionSocketFactory allowAllCertificates(KeyStore keyStore) {
        return this.allowAllCertificates(keyStore, null, null, null);
    }

    public SSLConnectionSocketFactory allowAllCertificates(KeyStore keyStore, String password, TrustStrategy keystoreTrustStrategy, HostnameVerifier keystoreHostnameVerifier) {
        SSLContextBuilder sshbuilder = new SSLContextBuilder();
        TrustSelfSignedStrategy trustStrategy = new TrustSelfSignedStrategy();
        Object hostnameVerifier = NoopHostnameVerifier.INSTANCE;
        if (keyStore != null) {
            trustStrategy = keystoreTrustStrategy;
            hostnameVerifier = keystoreHostnameVerifier;
        }
        try {
            if (password == null) {
                sshbuilder.loadTrustMaterial(keyStore, (org.apache.http.ssl.TrustStrategy)trustStrategy);
            } else {
                sshbuilder.loadTrustMaterial(null, (org.apache.http.ssl.TrustStrategy)trustStrategy).loadKeyMaterial(keyStore, password.toCharArray());
            }
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(String.format("%s occurred. Error message: %s", e.getClass(), e.getMessage()));
        }
        catch (KeyStoreException e) {
            throw new RuntimeException(String.format("%s occurred. Error message: %s", e.getClass(), e.getMessage()));
        }
        catch (UnrecoverableKeyException e) {
            throw new RuntimeException(String.format("%s occurred. Error message: %s", e.getClass(), e.getMessage()));
        }
        try {
            return new SSLConnectionSocketFactory(sshbuilder.build(), (HostnameVerifier)hostnameVerifier);
        }
        catch (KeyManagementException e) {
            throw new RuntimeException(String.format("%s occurred. Error message: %s", e.getClass(), e.getMessage()));
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(String.format("%s occurred. Error message: %s", e.getClass(), e.getMessage()));
        }
    }
}

