/*
 * Decompiled with CFR 0.152.
 */
package org.girod.javafx.svgimage.xml;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import javafx.geometry.Bounds;
import org.girod.javafx.svgimage.xml.LengthParser;
import org.girod.javafx.svgimage.xml.Viewport;

public class XMLNode {
    protected String name = null;
    protected XMLNode nodeParent = null;
    private int index = -1;
    protected final List<XMLNode> children = new ArrayList<XMLNode>();
    protected final Map<String, String> attributes = new TreeMap<String, String>();
    private String cData = null;

    public XMLNode(String nodeName) {
        int comma = nodeName.indexOf(58);
        this.name = comma != -1 ? nodeName.substring(comma + 1) : nodeName;
    }

    public XMLNode(XMLNode parent, String nodeName) {
        int comma = nodeName.indexOf(58);
        this.name = comma != -1 ? nodeName.substring(comma + 1) : nodeName;
        this.nodeParent = parent;
        this.constructDefaultAttributes();
    }

    private void constructDefaultAttributes() {
        if (this.nodeParent == null) {
            return;
        }
        Iterator<String> it = this.nodeParent.getAttributes().keySet().iterator();
        while (it.hasNext()) {
            String key;
            switch (key = it.next()) {
                case "fill": 
                case "stroke": 
                case "font-size": 
                case "font-family": 
                case "font-weight": 
                case "font-style": 
                case "stroke-width": 
                case "style": {
                    String value = this.nodeParent.getAttributeValue(key);
                    this.attributes.put(key, value);
                }
            }
        }
    }

    public XMLNode getParent() {
        return this.nodeParent;
    }

    private void setParent(XMLNode parent, int index) {
        this.nodeParent = parent;
        this.index = index;
    }

    public String getName() {
        return this.name;
    }

    public List<XMLNode> getChildren() {
        return this.children;
    }

    public XMLNode getFirstChild() {
        if (this.children.isEmpty()) {
            return null;
        }
        return this.children.get(0);
    }

    public XMLNode getLastChild() {
        if (this.children.isEmpty()) {
            return null;
        }
        return this.children.get(this.children.size() - 1);
    }

    public XMLNode getNextSibling() {
        if (this.nodeParent == null) {
            return null;
        }
        List<XMLNode> siblings = this.nodeParent.getChildren();
        if (siblings.size() < 2) {
            return null;
        }
        int theIndex = siblings.indexOf(this);
        if (siblings.size() > theIndex + 1) {
            return siblings.get(theIndex + 1);
        }
        return null;
    }

    public XMLNode getPreviousSibling() {
        if (this.nodeParent == null) {
            return null;
        }
        List<XMLNode> siblings = this.nodeParent.getChildren();
        if (siblings.size() < 2) {
            return null;
        }
        int _index = siblings.indexOf(this);
        if (_index > 0) {
            return siblings.get(_index - 1);
        }
        return null;
    }

    public void addChild(XMLNode child) {
        child.setParent(this, this.children.size());
        this.children.add(child);
    }

    public boolean hasChildren() {
        return !this.children.isEmpty();
    }

    public int countChildren() {
        return this.children.size();
    }

    public int countAttributes() {
        return this.attributes.size();
    }

    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    public String getAttributeValue(String attrName) {
        return this.attributes.get(attrName);
    }

    public boolean getAttributeValueAsBoolean(String attrName) {
        return this.getAttributeValueAsBoolean(attrName, false);
    }

    public boolean getAttributeValueAsBoolean(String attrName, boolean defaultValue) {
        if (this.attributes.containsKey(attrName)) {
            String attrvalue = this.attributes.get(attrName);
            try {
                return attrvalue.equals("true");
            }
            catch (NumberFormatException e) {
                return defaultValue;
            }
        }
        return defaultValue;
    }

    public float getAttributeValueAsFloat(String attrName) {
        return this.getAttributeValueAsFloat(attrName, 0.0f);
    }

    public float getAttributeValueAsFloat(String attrName, float defaultValue) {
        if (this.attributes.containsKey(attrName)) {
            String attrvalue = this.attributes.get(attrName);
            attrvalue = attrvalue.replace('\u2212', '-');
            try {
                float f = Float.parseFloat(attrvalue);
                return f;
            }
            catch (NumberFormatException e) {
                return defaultValue;
            }
        }
        return defaultValue;
    }

    public double getDoubleValue(String attrName) {
        return this.getLengthValue(attrName, null, 0.0);
    }

    public double getDoubleValue(String attrName, double defaultValue) {
        return this.getLengthValue(attrName, null, defaultValue);
    }

    public double getLengthValue(String attrName, Viewport viewport) {
        return this.getLengthValue(attrName, viewport, 0.0);
    }

    public double getPositionValue(String attrName, boolean isWidth, Viewport viewport) {
        return this.getPositionValue(attrName, isWidth, null, viewport, 0.0);
    }

    public double getPositionValue(String attrName, boolean isWidth, Bounds bounds, Viewport viewport) {
        return this.getPositionValue(attrName, isWidth, bounds, viewport, 0.0);
    }

    public double getLengthValue(String attrName, boolean isWidth, Viewport viewport) {
        return this.getLengthValue(attrName, isWidth, null, viewport, 0.0);
    }

    public double getLengthValue(String attrName, boolean isWidth, Bounds bounds, Viewport viewport) {
        return this.getLengthValue(attrName, isWidth, bounds, viewport, 0.0);
    }

    public double getLengthValue(String attrName, Viewport viewport, double defaultValue) {
        return this.getLengthValue(attrName, true, null, viewport, defaultValue);
    }

    public double getLineWidthValue(String attrName, Viewport viewport, double defaultValue) {
        if (this.attributes.containsKey(attrName)) {
            String attrvalue = this.attributes.get(attrName);
            attrvalue = attrvalue.replace('\u2212', '-');
            try {
                double d = LengthParser.parseLineWidth(attrvalue, viewport);
                return d;
            }
            catch (NumberFormatException e) {
                return defaultValue;
            }
        }
        return defaultValue;
    }

    public double getLengthValue(String attrName, boolean isWidth, Bounds bounds, Viewport viewport, double defaultValue) {
        if (this.attributes.containsKey(attrName)) {
            String attrvalue = this.attributes.get(attrName);
            attrvalue = attrvalue.replace('\u2212', '-');
            try {
                double d = LengthParser.parseLength(attrvalue, isWidth, bounds, viewport);
                return d;
            }
            catch (NumberFormatException e) {
                return defaultValue;
            }
        }
        return defaultValue;
    }

    public double getPositionValue(String attrName, boolean isWidth, Bounds bounds, Viewport viewport, double defaultValue) {
        if (this.attributes.containsKey(attrName)) {
            String attrvalue = this.attributes.get(attrName);
            attrvalue = attrvalue.replace('\u2212', '-');
            try {
                double d = LengthParser.parsePosition(attrvalue, isWidth, bounds, viewport);
                return d;
            }
            catch (NumberFormatException e) {
                return viewport.getDefaultPosition(defaultValue, isWidth);
            }
        }
        return viewport.getDefaultPosition(defaultValue, isWidth);
    }

    public int getAttributeValueAsInt(String attrName) {
        return this.getAttributeValueAsInt(attrName, 0);
    }

    public int getAttributeValueAsInt(String attrName, int defaultValue) {
        if (this.attributes.containsKey(attrName)) {
            String attrvalue = this.attributes.get(attrName);
            try {
                int i = Integer.parseInt(attrvalue);
                return i;
            }
            catch (NumberFormatException e) {
                return defaultValue;
            }
        }
        return defaultValue;
    }

    public void addAttribute(String attrName, int value) {
        this.attributes.put(attrName, Integer.toString(value));
    }

    public void addAttribute(String attrName, String value) {
        this.attributes.put(attrName, value);
    }

    public void addAttribute(String attrName, float value) {
        this.attributes.put(attrName, this.format(value));
    }

    public void addAttribute(String attrName, boolean value) {
        this.attributes.put(attrName, value ? "true" : "false");
    }

    public void setCDATA(String cData) {
        this.cData = cData;
    }

    public String getCDATA() {
        return this.cData;
    }

    public boolean hasCDATA() {
        return this.cData != null;
    }

    public boolean hasAttribute(String attrName) {
        return this.attributes.containsKey(attrName);
    }

    private String format(float f) {
        String s = String.format("%.1f", Float.valueOf(f));
        s = s.replace(",", ".");
        return s;
    }

    public String toString() {
        return this.name;
    }

    public int hashCode() {
        int hash = 3;
        hash = 23 * hash + Objects.hashCode(this.name);
        hash = 23 * hash + Objects.hashCode(this.nodeParent);
        hash = 23 * hash + this.index;
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        XMLNode other = (XMLNode)obj;
        if (this.index != other.index) {
            return false;
        }
        if (!Objects.equals(this.name, other.name)) {
            return false;
        }
        return Objects.equals(this.nodeParent, other.nodeParent);
    }
}

