/*
 * Decompiled with CFR 0.152.
 */
package org.girod.javafx.svgimage.xml;

import javafx.scene.shape.Shape;
import org.girod.javafx.svgimage.xml.Viewbox;

public class Viewport
extends Viewbox {
    private final boolean hasWidthAndHeight;
    private double scale = -1.0;
    private boolean isScaled = false;
    private boolean scaleLineWidth = true;

    public Viewport(double width, double height) {
        super(width, height);
        this.hasWidthAndHeight = true;
    }

    public Viewport() {
        super(0.0, 0.0);
        this.hasWidthAndHeight = false;
    }

    public double getBestWidth() {
        if (this.hasWidthAndHeight) {
            return this.width;
        }
        return this.viewboxWidth;
    }

    public double getBestHeight() {
        if (this.hasWidthAndHeight) {
            return this.height;
        }
        return this.viewboxHeight;
    }

    public void scaleShape(Shape shape) {
        if (this.isScaled) {
            shape.setScaleX(this.scale);
            shape.setScaleY(this.scale);
        }
    }

    public double getDefaultPosition(double defaultValue, boolean isWidth) {
        return defaultValue;
    }

    public double scalePosition(double value, boolean isWidth) {
        if (this.isScaled) {
            return value * this.scale;
        }
        return value;
    }

    public double scaleLength(double length) {
        if (this.isScaled) {
            return length * this.scale;
        }
        return length;
    }

    public double scaleLineWidth(double width) {
        if (this.scaleLineWidth) {
            return this.scaleLength(width);
        }
        return width;
    }

    public void setScale(double scale, boolean scaleLineWidth) {
        if (scale > 0.0) {
            this.isScaled = true;
            this.scaleLineWidth = scaleLineWidth;
            this.scale = scale;
        } else {
            this.isScaled = false;
            this.scaleLineWidth = false;
            this.scale = -1.0;
        }
    }

    public double getScale() {
        return this.scale;
    }

    public boolean isScaled() {
        return this.isScaled;
    }

    public boolean isScalingLineWidth() {
        return this.scaleLineWidth;
    }
}

