/*
 * Decompiled with CFR 0.152.
 */
package org.girod.javafx.svgimage.xml;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javafx.geometry.Bounds;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.effect.Light;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.paint.Stop;
import javafx.scene.shape.Circle;
import javafx.scene.shape.Ellipse;
import javafx.scene.shape.FillRule;
import javafx.scene.shape.Line;
import javafx.scene.shape.Polygon;
import javafx.scene.shape.Polyline;
import javafx.scene.shape.Rectangle;
import javafx.scene.shape.SVGPath;
import javafx.scene.shape.Shape;
import javafx.scene.text.Font;
import javafx.scene.text.FontPosture;
import javafx.scene.text.FontWeight;
import javafx.scene.text.Text;
import org.girod.javafx.svgimage.GlobalConfig;
import org.girod.javafx.svgimage.LoaderContext;
import org.girod.javafx.svgimage.xml.ExtendedFontPosture;
import org.girod.javafx.svgimage.xml.FilterSpec;
import org.girod.javafx.svgimage.xml.GradientSpec;
import org.girod.javafx.svgimage.xml.LinearGradientSpec;
import org.girod.javafx.svgimage.xml.ParserUtils;
import org.girod.javafx.svgimage.xml.PathParser;
import org.girod.javafx.svgimage.xml.RadialGradientSpec;
import org.girod.javafx.svgimage.xml.SVGStyleBuilder;
import org.girod.javafx.svgimage.xml.SVGTags;
import org.girod.javafx.svgimage.xml.SpanGroup;
import org.girod.javafx.svgimage.xml.TransformUtils;
import org.girod.javafx.svgimage.xml.Viewbox;
import org.girod.javafx.svgimage.xml.Viewport;
import org.girod.javafx.svgimage.xml.XMLNode;

public class SVGShapeBuilder
implements SVGTags {
    private static final Pattern NUMBER = Pattern.compile("\\d+");

    private SVGShapeBuilder() {
    }

    public static Shape buildRect(XMLNode xmlNode, Bounds bounds, Viewbox viewbox, Viewport viewport) {
        double x = 0.0;
        double y = 0.0;
        if (xmlNode.hasAttribute("x")) {
            x = xmlNode.getPositionValue("x", true, bounds, viewport);
        }
        if (xmlNode.hasAttribute("y")) {
            y = xmlNode.getPositionValue("y", false, viewport);
        }
        double width = xmlNode.getLengthValue("width", true, bounds, viewport, 0.0);
        double height = xmlNode.getLengthValue("height", false, bounds, viewport, 0.0);
        if (viewbox != null) {
            x = viewbox.scaleValue(true, x);
            y = viewbox.scaleValue(false, y);
            width = viewbox.scaleValue(true, width);
            height = viewbox.scaleValue(false, height);
        }
        Rectangle rect = new Rectangle(x, y, width, height);
        if (xmlNode.hasAttribute("rx")) {
            double rx = 2.0 * xmlNode.getLengthValue("rx", true, bounds, viewport, 0.0);
            rect.setArcWidth(rx);
        }
        if (xmlNode.hasAttribute("ry")) {
            double ry = 2.0 * xmlNode.getLengthValue("ry", false, bounds, viewport, 0.0);
            rect.setArcHeight(ry);
        }
        if (viewbox != null) {
            viewbox.scaleNode((Node)rect);
        }
        return rect;
    }

    public static Shape buildCircle(XMLNode xmlNode, Bounds bounds, Viewbox viewbox, Viewport viewport) {
        double cx = xmlNode.getPositionValue("cx", true, bounds, viewport, 0.0);
        double cy = xmlNode.getPositionValue("cy", false, bounds, viewport, 0.0);
        double r = xmlNode.getLengthValue("r", true, bounds, viewport, 0.0);
        if (viewbox != null) {
            cx = viewbox.scaleValue(true, cx);
            cy = viewbox.scaleValue(false, cy);
            r = viewbox.scaleValue(true, r);
        }
        Circle circle = new Circle(cx, cy, r);
        if (viewbox != null) {
            viewbox.scaleNode((Node)circle);
        }
        return circle;
    }

    public static void applyFontOblique(Text text) {
        String style = text.getStyle();
        String addStyle = "-fx-font-style: oblique;";
        if (style == null) {
            text.setStyle(addStyle);
        } else {
            style = style + addStyle;
            text.setStyle(style);
        }
    }

    public static void applyTextDecoration(Text text, String value) {
        String style = text.getStyle();
        String addStyle = null;
        StringTokenizer tok = new StringTokenizer(value, " ");
        while (tok.hasMoreTokens()) {
            String tk = tok.nextToken().trim();
            if (tk.isEmpty()) continue;
            if (tk.equals("underline")) {
                if (addStyle == null) {
                    addStyle = "-fx-underline: true;";
                    continue;
                }
                addStyle = addStyle + "-fx-underline: true;";
                continue;
            }
            if (!tk.equals("line-through")) continue;
            if (addStyle == null) {
                addStyle = "-fx-strikethrough: true;";
                continue;
            }
            addStyle = addStyle + "-fx-strikethrough: true;";
        }
        if (addStyle == null) {
            return;
        }
        if (style == null) {
            text.setStyle(addStyle);
        } else {
            style = style + addStyle;
            text.setStyle(style);
        }
    }

    public static FontPosture applyFontPosture(Text text, String value) {
        if (value == null) {
            return FontPosture.REGULAR;
        }
        if (value.equals("oblique")) {
            String style = text.getStyle();
            String addStyle = "-fx-font-style: oblique;";
            if (style == null) {
                text.setStyle(addStyle);
            } else {
                style = style + addStyle;
                text.setStyle(style);
            }
            return FontPosture.REGULAR;
        }
        FontPosture posture = SVGShapeBuilder.getFontPosture(value);
        return posture;
    }

    public static ExtendedFontPosture getExtendedFontPosture(String value) {
        if (value == null) {
            return new ExtendedFontPosture(FontPosture.REGULAR);
        }
        if (value.equals("italic")) {
            return new ExtendedFontPosture(FontPosture.ITALIC);
        }
        if (value.equals("oblique")) {
            return new ExtendedFontPosture(true);
        }
        return new ExtendedFontPosture(FontPosture.REGULAR);
    }

    public static FontPosture getFontPosture(String value) {
        FontPosture posture = FontPosture.REGULAR;
        if (value == null) {
            return posture;
        }
        if (value.equals("italic")) {
            posture = FontPosture.ITALIC;
        }
        return posture;
    }

    public static FontWeight getFontWeight(String value) {
        FontWeight weight = FontWeight.NORMAL;
        if (value == null) {
            return weight;
        }
        if (value.equals("bold")) {
            weight = FontWeight.BOLD;
        } else if (value.equals("bolder")) {
            weight = FontWeight.EXTRA_BOLD;
        } else if (value.equals("lighter")) {
            weight = FontWeight.LIGHT;
        } else {
            Matcher m = NUMBER.matcher(value);
            if (m.matches()) {
                int weightNumber = Integer.parseInt(value);
                weight = FontWeight.findByWeight((int)weightNumber);
            }
        }
        return weight;
    }

    public static SpanGroup buildTSpanGroup(XMLNode xmlNode, Bounds bounds, Viewbox viewbox, Viewport viewport) {
        Group group = new Group();
        double x = xmlNode.getLengthValue("x", true, bounds, viewport, 0.0);
        double y = xmlNode.getLengthValue("y", false, bounds, viewport, 0.0);
        if (viewbox != null) {
            x = viewbox.scaleValue(true, x);
            y = viewbox.scaleValue(false, y);
        }
        group.setLayoutX(x);
        group.setLayoutY(y);
        SpanGroup spanGroup = new SpanGroup(group);
        Text text = null;
        for (XMLNode childNode : xmlNode.getChildren()) {
            String name;
            switch (name = childNode.getName()) {
                case "tspan": {
                    text = SVGShapeBuilder.buildTspan(group, text, childNode, bounds, viewbox, viewport);
                    if (!xmlNode.hasAttribute("text-decoration")) break;
                    SVGShapeBuilder.applyTextDecoration(text, xmlNode.getAttributeValue("text-decoration"));
                }
            }
            if (text == null) continue;
            group.getChildren().add(text);
            spanGroup.addTSpan(childNode, text);
        }
        return spanGroup;
    }

    public static Text buildText(XMLNode xmlNode, Bounds bounds, Viewbox viewbox, Viewport viewport) {
        boolean hasFamily = xmlNode.hasAttribute("font-family");
        boolean hasSize = xmlNode.hasAttribute("font-size");
        String family = null;
        if (hasFamily) {
            family = xmlNode.getAttributeValue("font-family").replace("'", "");
        }
        double size = 12.0;
        if (hasSize) {
            size = ParserUtils.parseFontSize(xmlNode.getAttributeValue("font-size"));
        }
        size = viewport.scaleLength(size);
        FontWeight weight = SVGShapeBuilder.getFontWeight(xmlNode.getAttributeValue("font-weight"));
        FontPosture posture = SVGShapeBuilder.getFontPosture(xmlNode.getAttributeValue("font-style"));
        Font font = Font.font((String)family, (FontWeight)weight, (FontPosture)posture, (double)size);
        String cdata = xmlNode.getCDATA();
        if (cdata != null) {
            double x = xmlNode.getPositionValue("x", true, bounds, viewport, 0.0);
            double y = xmlNode.getPositionValue("y", false, bounds, viewport, 0.0);
            if (viewbox != null) {
                x = viewbox.scaleValue(true, x);
                y = viewbox.scaleValue(false, y);
            }
            Text text = new Text(x, y, cdata);
            if (xmlNode.hasAttribute("text-decoration")) {
                SVGShapeBuilder.applyTextDecoration(text, xmlNode.getAttributeValue("text-decoration"));
            }
            if (font != null) {
                text.setFont(font);
            }
            if (viewbox != null) {
                viewbox.scaleNode((Node)text);
            }
            return text;
        }
        return null;
    }

    public static Text buildTspan(Group group, Text previous, XMLNode xmlNode, Bounds bounds, Viewbox viewbox, Viewport viewport) {
        boolean hasFamily = xmlNode.hasAttribute("font-family");
        boolean hasSize = xmlNode.hasAttribute("font-size");
        String family = null;
        if (hasFamily) {
            family = xmlNode.getAttributeValue("font-family").replace("'", "");
        }
        double size = 12.0;
        if (hasSize) {
            size = ParserUtils.parseFontSize(xmlNode.getAttributeValue("font-size"));
        }
        size = viewport.scaleLength(size);
        FontWeight weight = SVGShapeBuilder.getFontWeight(xmlNode.getAttributeValue("font-weight"));
        FontPosture posture = SVGShapeBuilder.getFontPosture(xmlNode.getAttributeValue("font-style"));
        Font font = Font.font((String)family, (FontWeight)weight, (FontPosture)posture, (double)size);
        String cdata = xmlNode.getCDATA();
        if (cdata != null) {
            double x = 0.0;
            double y = 0.0;
            if (xmlNode.hasAttribute("dx")) {
                x = xmlNode.getPositionValue("dx", true, bounds, viewport, 0.0);
            } else if (xmlNode.hasAttribute("x")) {
                double _x = xmlNode.getPositionValue("x", true, bounds, viewport, 0.0);
                if (viewbox != null) {
                    _x = viewbox.scaleValue(true, _x);
                }
                x = _x - group.getLayoutX();
            } else if (previous != null) {
                x = previous.getLayoutX() + previous.getLayoutBounds().getWidth();
            }
            if (xmlNode.hasAttribute("dy")) {
                y = xmlNode.getPositionValue("dy", false, bounds, viewport, 0.0);
            } else if (xmlNode.hasAttribute("y")) {
                double _y = xmlNode.getPositionValue("y", true, bounds, viewport, 0.0);
                if (viewbox != null) {
                    _y = viewbox.scaleValue(false, _y);
                }
                y = _y - group.getLayoutY();
            }
            Text text = new Text(x, y, cdata);
            if (xmlNode.hasAttribute("text-decoration")) {
                SVGShapeBuilder.applyTextDecoration(text, xmlNode.getAttributeValue("text-decoration"));
            }
            if (font != null) {
                text.setFont(font);
            }
            return text;
        }
        return null;
    }

    private static List<Stop> convertStops(List<GradientSpec.StopSpec> specstops) {
        ArrayList<Stop> stops = new ArrayList<Stop>();
        for (GradientSpec.StopSpec theStop : specstops) {
            Stop stop = new Stop(theStop.offset, theStop.color);
            stops.add(stop);
        }
        return stops;
    }

    public static void buildRadialGradient(Map<String, GradientSpec> gradientSpecs, Map<String, Paint> gradients, XMLNode xmlNode, Viewport viewport) {
        if (xmlNode.hasAttribute("id")) {
            String id = xmlNode.getAttributeValue("id");
            String href = null;
            if (xmlNode.hasAttribute("xlink:href")) {
                href = xmlNode.getAttributeValue("xlink:href");
                href = href.startsWith("#") ? href.substring(1) : null;
            }
            RadialGradientSpec spec = new RadialGradientSpec(xmlNode, href);
            gradientSpecs.put(id, spec);
        }
    }

    private static double getGradientPos(XMLNode xmlNode, String id) {
        String attrvalue = xmlNode.getAttributeValue(id);
        if (attrvalue.endsWith("%") && attrvalue.length() > 1) {
            attrvalue = attrvalue.substring(0, attrvalue.length() - 1);
        }
        return ParserUtils.parseDoubleProtected(attrvalue) / 100.0;
    }

    public static void buildLinearGradient(Map<String, GradientSpec> gradientSpecs, Map<String, Paint> gradients, XMLNode xmlNode, Viewport viewport) {
        if (xmlNode.hasAttribute("id")) {
            String id = xmlNode.getAttributeValue("id");
            String href = null;
            if (xmlNode.hasAttribute("xlink:href")) {
                href = xmlNode.getAttributeValue("xlink:href");
                href = href.startsWith("#") ? href.substring(1) : null;
            }
            LinearGradientSpec spec = new LinearGradientSpec(xmlNode, href);
            gradientSpecs.put(id, spec);
        }
    }

    public static Node buildUse(XMLNode xmlNode, LoaderContext context, Bounds bounds, Viewport viewport) {
        String id = null;
        if (xmlNode.hasAttribute("href")) {
            id = xmlNode.getAttributeValue("href");
        } else if (xmlNode.hasAttribute("xlink:href")) {
            id = xmlNode.getAttributeValue("xlink:href");
        }
        if (id != null && id.startsWith("#")) {
            id = id.substring(1);
        }
        if (id != null && context.hasNamedNode(id)) {
            XMLNode namedNode = context.getNamedNode(id);
            Shape nodeFromUse = null;
            Viewbox viewbox = null;
            String name = namedNode.getName();
            SpanGroup spanGroup = null;
            if (context.hasSymbol(id)) {
                viewbox = context.getSymbol(id).getViewbox();
            }
            switch (name) {
                case "rect": {
                    nodeFromUse = SVGShapeBuilder.buildRect(namedNode, null, viewbox, viewport);
                    break;
                }
                case "circle": {
                    nodeFromUse = SVGShapeBuilder.buildCircle(namedNode, null, viewbox, viewport);
                    break;
                }
                case "ellipse": {
                    nodeFromUse = SVGShapeBuilder.buildEllipse(namedNode, null, viewbox, viewport);
                    break;
                }
                case "path": {
                    nodeFromUse = SVGShapeBuilder.buildPath(namedNode, null, viewbox, viewport);
                    break;
                }
                case "polygon": {
                    nodeFromUse = SVGShapeBuilder.buildPolygon(namedNode, null, viewbox, viewport);
                    break;
                }
                case "line": {
                    nodeFromUse = SVGShapeBuilder.buildLine(namedNode, null, viewbox, viewport);
                    break;
                }
                case "polyline": {
                    nodeFromUse = SVGShapeBuilder.buildPolyline(namedNode, null, viewbox, viewport);
                    break;
                }
                case "image": {
                    nodeFromUse = SVGShapeBuilder.buildImage(namedNode, context.url, null, viewbox, viewport);
                    break;
                }
                case "g": 
                case "symbol": {
                    nodeFromUse = SVGShapeBuilder.buildGroupForUse(context, namedNode, viewbox, viewport);
                    break;
                }
                case "text": {
                    nodeFromUse = SVGShapeBuilder.buildText(namedNode, null, viewbox, viewport);
                    if (nodeFromUse != null) break;
                    spanGroup = SVGShapeBuilder.buildTSpanGroup(namedNode, null, viewbox, viewport);
                }
            }
            if (nodeFromUse != null) {
                if (xmlNode.hasAttribute("x")) {
                    double x = xmlNode.getPositionValue("x", true, viewport);
                    nodeFromUse.setLayoutX(x);
                }
                if (xmlNode.hasAttribute("y")) {
                    double y = xmlNode.getPositionValue("y", true, viewport);
                    nodeFromUse.setLayoutY(y);
                }
                SVGStyleBuilder.setNodeStyle((Node)nodeFromUse, xmlNode, context, viewport);
                return nodeFromUse;
            }
            if (spanGroup != null) {
                Map<String, String> theStylesMap = ParserUtils.getStyles(namedNode);
                Iterator<SpanGroup.TSpan> it2 = spanGroup.getSpans().iterator();
                SpanGroup.TSpan previous = null;
                while (it2.hasNext()) {
                    SpanGroup.TSpan tspan = it2.next();
                    Text tspanText = tspan.text;
                    String theStyles = ParserUtils.mergeStyles(theStylesMap, tspan.node);
                    tspan.node.addAttribute("style", theStyles);
                    SVGShapeBuilder.addStyles(context, (Node)tspanText, tspan.node, viewport);
                    if (tspan.node.hasAttribute("baseline-shift")) {
                        String shiftValue = tspan.node.getAttributeValue("baseline-shift");
                        ParserUtils.setBaselineShift(tspanText, shiftValue);
                    }
                    if (!ParserUtils.hasXPosition(tspan.node) && previous != null) {
                        double width = previous.text.getLayoutBounds().getWidth();
                        tspanText.setLayoutX(width + previous.text.getLayoutX());
                    }
                    previous = tspan;
                }
                return spanGroup.getTextGroup();
            }
            return null;
        }
        return null;
    }

    private static Group buildGroupForUse(LoaderContext context, XMLNode xmlNode, Viewbox viewbox, Viewport viewport) {
        Group group = new Group();
        for (XMLNode childNode : xmlNode.getChildren()) {
            String name;
            Shape node = null;
            SpanGroup spanGroup = null;
            switch (name = childNode.getName()) {
                case "rect": {
                    node = SVGShapeBuilder.buildRect(childNode, null, viewbox, viewport);
                    break;
                }
                case "circle": {
                    node = SVGShapeBuilder.buildCircle(childNode, null, viewbox, viewport);
                    break;
                }
                case "ellipse": {
                    node = SVGShapeBuilder.buildEllipse(childNode, null, viewbox, viewport);
                    break;
                }
                case "path": {
                    node = SVGShapeBuilder.buildPath(childNode, null, viewbox, viewport);
                    break;
                }
                case "polygon": {
                    node = SVGShapeBuilder.buildPolygon(childNode, null, viewbox, viewport);
                    break;
                }
                case "line": {
                    node = SVGShapeBuilder.buildLine(childNode, null, viewbox, viewport);
                    break;
                }
                case "polyline": {
                    node = SVGShapeBuilder.buildPolyline(childNode, null, viewbox, viewport);
                    break;
                }
                case "image": {
                    node = SVGShapeBuilder.buildImage(childNode, context.url, null, viewbox, viewport);
                    break;
                }
                case "text": {
                    node = SVGShapeBuilder.buildText(childNode, null, viewbox, viewport);
                    if (node != null) break;
                    spanGroup = SVGShapeBuilder.buildTSpanGroup(childNode, null, viewbox, viewport);
                    break;
                }
                case "g": {
                    node = SVGShapeBuilder.buildGroupForUse(context, childNode, viewbox, viewport);
                }
            }
            if (node != null) {
                SVGShapeBuilder.addStyles(context, (Node)node, childNode, viewport);
                group.getChildren().add((Object)node);
                continue;
            }
            if (spanGroup == null) continue;
            Map<String, String> theStylesMap = ParserUtils.getStyles(childNode);
            Iterator<SpanGroup.TSpan> it2 = spanGroup.getSpans().iterator();
            SpanGroup.TSpan previous = null;
            while (it2.hasNext()) {
                SpanGroup.TSpan tspan = it2.next();
                Text tspanText = tspan.text;
                String theStyles = ParserUtils.mergeStyles(theStylesMap, tspan.node);
                tspan.node.addAttribute("style", theStyles);
                SVGShapeBuilder.addStyles(context, (Node)tspanText, tspan.node, viewport);
                if (tspan.node.hasAttribute("baseline-shift")) {
                    String shiftValue = tspan.node.getAttributeValue("baseline-shift");
                    ParserUtils.setBaselineShift(tspanText, shiftValue);
                }
                if (!ParserUtils.hasXPosition(tspan.node) && previous != null) {
                    double width = previous.text.getLayoutBounds().getWidth();
                    tspanText.setLayoutX(width + previous.text.getLayoutX());
                }
                previous = tspan;
            }
            group.getChildren().add((Object)spanGroup.getTextGroup());
        }
        return group;
    }

    private static void addStyles(LoaderContext context, Node node, XMLNode xmlNode, Viewport viewport) {
        SVGStyleBuilder.setNodeStyle(node, xmlNode, context, viewport);
        ParserUtils.setOpacity(node, xmlNode);
        ParserUtils.setVisibility(node, xmlNode);
        TransformUtils.setTransforms(node, xmlNode, viewport);
    }

    public static ImageView buildImage(XMLNode xmlNode, URL url, Bounds bounds, Viewbox viewbox, Viewport viewport) {
        Image image;
        double width = xmlNode.getLengthValue("width", true, bounds, viewport, 0.0);
        double height = xmlNode.getLengthValue("height", false, bounds, viewport, 0.0);
        double x = xmlNode.getLengthValue("x", true, bounds, viewport, 0.0);
        double y = xmlNode.getLengthValue("y", false, bounds, viewport, 0.0);
        String hrefAttribute = xmlNode.getAttributeValue("href");
        if (hrefAttribute == null) {
            hrefAttribute = xmlNode.getAttributeValue("xlink:href");
        }
        if (hrefAttribute != null && viewbox != null) {
            width = viewbox.scaleValue(true, width);
            height = viewbox.scaleValue(false, height);
            x = viewbox.scaleValue(true, x);
            y = viewbox.scaleValue(false, y);
        }
        if ((image = ParserUtils.getImage(url, hrefAttribute, width, height)) != null) {
            ImageView view = new ImageView(image);
            view.setX(x);
            view.setY(y);
            if (viewbox != null) {
                viewbox.scaleNode((Node)view);
            }
            return view;
        }
        return null;
    }

    public static Shape buildEllipse(XMLNode xmlNode, Bounds bounds, Viewbox viewbox, Viewport viewport) {
        double cx = xmlNode.getPositionValue("cx", true, bounds, viewport, 0.0);
        double cy = xmlNode.getPositionValue("cy", false, bounds, viewport, 0.0);
        double rx = xmlNode.getLengthValue("rx", true, bounds, viewport, 0.0);
        double ry = xmlNode.getLengthValue("ry", false, bounds, viewport, 0.0);
        if (viewbox != null) {
            cx = viewbox.scaleValue(true, cx);
            cy = viewbox.scaleValue(false, cy);
            rx = viewbox.scaleValue(true, rx);
            ry = viewbox.scaleValue(true, ry);
        }
        Ellipse ellipse = new Ellipse(cx, cy, rx, ry);
        if (viewbox != null) {
            viewbox.scaleNode((Node)ellipse);
        }
        return ellipse;
    }

    public static SVGPath buildPath(XMLNode xmlNode, Bounds bounds, Viewbox viewbox, Viewport viewport) {
        SVGPath path = new SVGPath();
        String content = xmlNode.getAttributeValue("d");
        FillRule rule = ParserUtils.getFillRule(xmlNode);
        if (rule != null) {
            path.setFillRule(rule);
        }
        content = content.replace('\u2212', '-');
        content = PathParser.parsePathContent(content, viewport);
        path.setContent(content);
        if (viewbox != null) {
            viewbox.scaleNode((Node)path);
        }
        return path;
    }

    public static Polygon buildPolygon(XMLNode xmlNode, Bounds bounds, Viewbox viewbox, Viewport viewport) {
        String pointsAttribute = xmlNode.getAttributeValue("points");
        Polygon polygon = new Polygon();
        StringTokenizer tokenizer = new StringTokenizer(pointsAttribute, " ");
        while (tokenizer.hasMoreTokens()) {
            String point = tokenizer.nextToken();
            StringTokenizer tokenizer2 = new StringTokenizer(point, ",");
            double x = ParserUtils.parsePositionValue(tokenizer2.nextToken(), true, bounds, viewport);
            double y = ParserUtils.parsePositionValue(tokenizer2.nextToken(), false, bounds, viewport);
            if (viewbox != null) {
                x = viewbox.scaleValue(true, x);
                y = viewbox.scaleValue(false, y);
            }
            polygon.getPoints().add((Object)x);
            polygon.getPoints().add((Object)y);
        }
        if (viewbox != null) {
            viewbox.scaleNode((Node)polygon);
        }
        return polygon;
    }

    public static Line buildLine(XMLNode xmlNode, Bounds bounds, Viewbox viewbox, Viewport viewport) {
        if (xmlNode.hasAttribute("x1") && xmlNode.hasAttribute("y1") && xmlNode.hasAttribute("x2") && xmlNode.hasAttribute("y2")) {
            double x1 = xmlNode.getPositionValue("x1", true, bounds, viewport);
            double y1 = xmlNode.getPositionValue("y1", false, bounds, viewport);
            double x2 = xmlNode.getPositionValue("x2", true, bounds, viewport);
            double y2 = xmlNode.getPositionValue("y2", false, bounds, viewport);
            if (viewbox != null) {
                x1 = viewbox.scaleValue(true, x1);
                y1 = viewbox.scaleValue(false, y1);
                x2 = viewbox.scaleValue(true, x2);
                y2 = viewbox.scaleValue(false, y2);
            }
            Line line = new Line(x1, y1, x2, y2);
            if (viewbox != null) {
                viewbox.scaleNode((Node)line);
            }
            return line;
        }
        return null;
    }

    public static Polyline buildPolyline(XMLNode xmlNode, Bounds bounds, Viewbox viewbox, Viewport viewport) {
        Polyline polyline = new Polyline();
        String pointsAttribute = xmlNode.getAttributeValue("points");
        StringTokenizer tokenizer = new StringTokenizer(pointsAttribute, " ");
        while (tokenizer.hasMoreTokens()) {
            String points = tokenizer.nextToken();
            StringTokenizer tokenizer2 = new StringTokenizer(points, ",");
            double x = ParserUtils.parsePositionValue(tokenizer2.nextToken(), true, bounds, viewport);
            double y = ParserUtils.parsePositionValue(tokenizer2.nextToken(), false, bounds, viewport);
            if (viewbox != null) {
                x = viewbox.scaleValue(true, x);
                y = viewbox.scaleValue(false, y);
            }
            polyline.getPoints().add((Object)x);
            polyline.getPoints().add((Object)y);
        }
        return polyline;
    }

    public static void buildFEGaussianBlur(FilterSpec spec, XMLNode node) {
        double stdDeviation = 0.0;
        String resultId = node.getAttributeValue("result");
        if (node.hasAttribute("stdDeviation")) {
            String stdDevS = node.getAttributeValue("stdDeviation");
            stdDevS = ParserUtils.parseFirstArgument(stdDevS);
            stdDeviation = ParserUtils.parseDoubleProtected(stdDevS);
        }
        FilterSpec.FEGaussianBlur effect = new FilterSpec.FEGaussianBlur(resultId, stdDeviation);
        if (node.hasAttribute("in")) {
            effect.setIn(node.getAttributeValue("in"));
        }
        spec.addEffect(resultId, effect);
    }

    public static void buildFEDropShadow(FilterSpec spec, XMLNode node, Viewport viewport) {
        double dx = node.getLengthValue("dx", true, viewport);
        double dy = node.getLengthValue("dy", true, viewport);
        double opacity = 1.0;
        double stdDeviation = 0.0;
        Color col = Color.BLACK;
        String resultId = node.getAttributeValue("result");
        if (node.hasAttribute("flood-opacity")) {
            opacity = node.getDoubleValue("flood-opacity", 1.0);
        }
        if (node.hasAttribute("stdDeviation")) {
            String stdDevS = node.getAttributeValue("stdDeviation");
            stdDevS = ParserUtils.parseFirstArgument(stdDevS);
            stdDeviation = ParserUtils.parseDoubleProtected(stdDevS);
        }
        if (node.hasAttribute("flood-color")) {
            String colorS = node.getAttributeValue("flood-color");
            col = ParserUtils.getColor(colorS, opacity);
        }
        FilterSpec.FEDropShadow effect = new FilterSpec.FEDropShadow(resultId, dx, dy, stdDeviation, col);
        if (node.hasAttribute("in")) {
            effect.setIn(node.getAttributeValue("in"));
        }
        spec.addEffect(resultId, effect);
    }

    public static void buildFEFlood(FilterSpec spec, XMLNode node, Viewport viewport) {
        double x = node.getLengthValue("x", true, viewport);
        double y = node.getLengthValue("y", true, viewport);
        double width = node.getLengthValue("width", true, viewport);
        double height = node.getLengthValue("height", true, viewport);
        double opacity = 1.0;
        Color col = Color.BLACK;
        String resultId = node.getAttributeValue("result");
        if (node.hasAttribute("flood-opacity")) {
            opacity = node.getDoubleValue("flood-opacity", 1.0);
        }
        if (node.hasAttribute("flood-color")) {
            String colorS = node.getAttributeValue("flood-color");
            col = ParserUtils.getColor(colorS, opacity);
        }
        FilterSpec.FEFlood effect = new FilterSpec.FEFlood(resultId, x, y, width, height, col);
        if (node.hasAttribute("in")) {
            effect.setIn(node.getAttributeValue("in"));
        }
        spec.addEffect(resultId, effect);
    }

    public static void buildFEOffset(FilterSpec spec, XMLNode node, Viewport viewport) {
        double dx = node.getLengthValue("dx", true, viewport);
        double dy = node.getLengthValue("dy", true, viewport);
        String resultId = node.getAttributeValue("result");
        FilterSpec.FEOffset effect = new FilterSpec.FEOffset(resultId, dx, dy);
        if (node.hasAttribute("in")) {
            effect.setIn(node.getAttributeValue("in"));
        }
        spec.addEffect(resultId, effect);
    }

    public static void buildFEImage(FilterSpec spec, URL url, XMLNode node, Viewport viewport) {
        double x = node.getLengthValue("x", true, viewport);
        double y = node.getLengthValue("y", true, viewport);
        double width = node.getLengthValue("width", true, viewport);
        double height = node.getLengthValue("height", true, viewport);
        String hrefAttribute = node.getAttributeValue("xlink:href");
        String resultId = node.getAttributeValue("result");
        Image image = null;
        URL imageUrl = null;
        try {
            imageUrl = new URL(hrefAttribute);
        }
        catch (MalformedURLException ex) {
            try {
                imageUrl = new URL(url, hrefAttribute);
            }
            catch (MalformedURLException ex1) {
                GlobalConfig.getInstance().handleParsingError("URL " + hrefAttribute + " is not well formed");
            }
        }
        if (imageUrl != null) {
            image = new Image(imageUrl.toString(), width, height, true, true);
        }
        FilterSpec.FEImage effect = new FilterSpec.FEImage(resultId, x, y, image);
        spec.addEffect(resultId, effect);
    }

    public static void buildFESpecularLighting(FilterSpec spec, XMLNode node, Viewport viewport) {
        XMLNode child = node.getFirstChild();
        if (child != null) {
            switch (child.getName()) {
                case "feDistantLight": {
                    double surfaceScale = node.getDoubleValue("surfaceScale", 1.5);
                    double specularConstant = node.getDoubleValue("specularConstant", 0.3);
                    double specularExponent = node.getDoubleValue("specularExponent", 20.0);
                    Color col = null;
                    if (node.hasAttribute("lighting-color")) {
                        String colorS = node.getAttributeValue("lighting-color");
                        col = ParserUtils.getColor(colorS);
                    }
                    double azimuth = child.getDoubleValue("azimuth");
                    double elevation = child.getDoubleValue("elevation");
                    Light.Distant light = new Light.Distant(azimuth, elevation, col);
                    String resultId = node.getAttributeValue("result");
                    FilterSpec.FESpecularLighting effect = new FilterSpec.FESpecularLighting(resultId, specularConstant, specularExponent, surfaceScale, (Light)light);
                    if (node.hasAttribute("in")) {
                        effect.setIn(node.getAttributeValue("in"));
                    }
                    spec.addEffect(resultId, effect);
                    break;
                }
                case "fePointLight": {
                    double surfaceScale = node.getDoubleValue("surfaceScale", 1.5);
                    double specularConstant = node.getDoubleValue("specularConstant", 0.3);
                    double specularExponent = node.getDoubleValue("specularExponent", 20.0);
                    Color col = null;
                    if (node.hasAttribute("lighting-color")) {
                        String colorS = node.getAttributeValue("lighting-color");
                        col = ParserUtils.getColor(colorS);
                    }
                    double x = child.getLengthValue("x", true, viewport);
                    double y = child.getLengthValue("y", true, viewport);
                    double z = child.getLengthValue("z", true, null);
                    Light.Point light = new Light.Point(x, y, z, col);
                    String resultId = node.getAttributeValue("result");
                    FilterSpec.FESpecularLighting effect = new FilterSpec.FESpecularLighting(resultId, specularConstant, specularExponent, surfaceScale, (Light)light);
                    if (node.hasAttribute("in")) {
                        effect.setIn(node.getAttributeValue("in"));
                    }
                    spec.addEffect(resultId, effect);
                    break;
                }
                case "feSpotLight": {
                    double surfaceScale = node.getDoubleValue("surfaceScale", 1.5);
                    double specularConstant = node.getDoubleValue("specularConstant", 0.3);
                    double specularExponent = node.getDoubleValue("specularExponent", 20.0);
                    Color col = null;
                    if (node.hasAttribute("lighting-color")) {
                        String colorS = node.getAttributeValue("lighting-color");
                        col = ParserUtils.getColor(colorS);
                    }
                    double x = child.getLengthValue("x", true, viewport);
                    double y = child.getLengthValue("y", false, viewport);
                    double z = child.getLengthValue("z", true, viewport);
                    double pointAtX = child.getLengthValue("pointsAtX", true, viewport);
                    double pointAtY = child.getLengthValue("pointsAtY", false, viewport);
                    double pointAtZ = child.getLengthValue("pointsAtZ", true, viewport);
                    Light.Spot light = new Light.Spot(x, y, z, specularExponent, col);
                    light.setPointsAtX(pointAtX);
                    light.setPointsAtY(pointAtY);
                    light.setPointsAtZ(pointAtZ);
                    String resultId = node.getAttributeValue("result");
                    FilterSpec.FESpecularLighting effect = new FilterSpec.FESpecularLighting(resultId, specularConstant, specularExponent, surfaceScale, (Light)light);
                    if (node.hasAttribute("in")) {
                        effect.setIn(node.getAttributeValue("in"));
                    }
                    spec.addEffect(resultId, effect);
                    break;
                }
            }
        }
    }

    public static void buildFEDiffuseLighting(FilterSpec spec, XMLNode node, Viewport viewport) {
        XMLNode child = node.getFirstChild();
        if (child != null) {
            switch (child.getName()) {
                case "feDistantLight": {
                    double diffuseConstant = node.getDoubleValue("diffuseConstant", 0.3);
                    Color col = null;
                    if (node.hasAttribute("lighting-color")) {
                        String colorS = node.getAttributeValue("lighting-color");
                        col = ParserUtils.getColor(colorS);
                    }
                    double azimuth = child.getDoubleValue("azimuth");
                    double elevation = child.getDoubleValue("elevation");
                    Light.Distant light = new Light.Distant(azimuth, elevation, col);
                    String resultId = node.getAttributeValue("result");
                    FilterSpec.FEDiffuseLighting effect = new FilterSpec.FEDiffuseLighting(resultId, diffuseConstant, (Light)light);
                    if (node.hasAttribute("in")) {
                        effect.setIn(node.getAttributeValue("in"));
                    }
                    spec.addEffect(resultId, effect);
                    break;
                }
                case "fePointLight": {
                    double diffuseConstant = node.getDoubleValue("diffuseConstant", 0.3);
                    Color col = null;
                    if (node.hasAttribute("lighting-color")) {
                        String colorS = node.getAttributeValue("lighting-color");
                        col = ParserUtils.getColor(colorS);
                    }
                    double x = child.getLengthValue("x", true, viewport);
                    double y = child.getLengthValue("y", true, viewport);
                    double z = child.getLengthValue("z", true, null);
                    Light.Point light = new Light.Point(x, y, z, col);
                    String resultId = node.getAttributeValue("result");
                    FilterSpec.FEDiffuseLighting effect = new FilterSpec.FEDiffuseLighting(resultId, diffuseConstant, (Light)light);
                    if (node.hasAttribute("in")) {
                        effect.setIn(node.getAttributeValue("in"));
                    }
                    spec.addEffect(resultId, effect);
                    break;
                }
                case "feSpotLight": {
                    double diffuseConstant = node.getDoubleValue("diffuseConstant", 0.3);
                    double specularExponent = node.getDoubleValue("specularExponent", 20.0);
                    Color col = null;
                    if (node.hasAttribute("lighting-color")) {
                        String colorS = node.getAttributeValue("lighting-color");
                        col = ParserUtils.getColor(colorS);
                    }
                    double x = child.getLengthValue("x", true, viewport);
                    double y = child.getLengthValue("y", false, viewport);
                    double z = child.getLengthValue("z", true, viewport);
                    double pointAtX = child.getLengthValue("pointsAtX", true, viewport);
                    double pointAtY = child.getLengthValue("pointsAtY", false, viewport);
                    double pointAtZ = child.getLengthValue("pointsAtZ", true, viewport);
                    Light.Spot light = new Light.Spot(x, y, z, specularExponent, col);
                    light.setPointsAtX(pointAtX);
                    light.setPointsAtY(pointAtY);
                    light.setPointsAtZ(pointAtZ);
                    String resultId = node.getAttributeValue("result");
                    FilterSpec.FEDiffuseLighting effect = new FilterSpec.FEDiffuseLighting(resultId, diffuseConstant, (Light)light);
                    if (node.hasAttribute("in")) {
                        effect.setIn(node.getAttributeValue("in"));
                    }
                    spec.addEffect(resultId, effect);
                    break;
                }
            }
        }
    }

    public static void buildFEComposite(FilterSpec spec, XMLNode node) {
        String resultId = node.getAttributeValue("result");
        String in = node.getAttributeValue("in");
        String in2 = node.getAttributeValue("in2");
        String operator = node.getAttributeValue("operator");
        short type = 0;
        switch (operator) {
            case "over": {
                type = 0;
                break;
            }
            case "in": {
                type = 1;
                break;
            }
            case "out": {
                type = 2;
                break;
            }
            case "atop": {
                type = 3;
                break;
            }
            case "xor": {
                type = 4;
                break;
            }
            case "arithmetic": {
                type = 5;
            }
        }
        FilterSpec.FEComposite effect = new FilterSpec.FEComposite(resultId, type, in, in2);
        spec.addEffect(resultId, effect);
    }

    public static void buildFEMerge(FilterSpec spec, XMLNode node) {
        String resultId = node.getAttributeValue("result");
        FilterSpec.FEMerge effect = new FilterSpec.FEMerge(resultId);
        spec.addEffect(resultId, effect);
        for (XMLNode child : node.getChildren()) {
            String in;
            if (!child.getName().equals("feMergeNode") || (in = child.getAttributeValue("in")) == null) continue;
            effect.addMergeNode(in);
        }
    }
}

