/*
 * Decompiled with CFR 0.152.
 */
package org.girod.javafx.svgimage.xml;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.girod.javafx.svgimage.xml.XMLNode;

public class PercentParser {
    private static final Pattern NUMBER = Pattern.compile("\\d+(\\.\\d+)?");
    private static final Pattern PERCENT_UNIT = Pattern.compile("(\\d+)(\\.\\d+)?%");

    private PercentParser() {
    }

    public static double parseValue(XMLNode node, String attrName, boolean allowAbsolute) {
        String valueAsString = node.getAttributeValue(attrName);
        if (valueAsString != null) {
            return PercentParser.parseValue(valueAsString, allowAbsolute);
        }
        return 0.0;
    }

    public static double parseValue(XMLNode node, String attrName) {
        return PercentParser.parseValue(node, attrName, false);
    }

    public static double parseValue(String value) {
        return PercentParser.parseValue(value, false);
    }

    public static double parseValue(String value, boolean allowAbsolute) {
        Matcher m = NUMBER.matcher(value = value.trim());
        if (m.matches()) {
            double parsedValue = Double.parseDouble(value);
            if (parsedValue < 0.0) {
                parsedValue = 0.0;
            } else if (!allowAbsolute && parsedValue > 1.0) {
                parsedValue = 1.0;
            }
            return parsedValue;
        }
        m = PERCENT_UNIT.matcher(value);
        if (m.matches()) {
            String startDigits = m.group(1);
            String endDigit = null;
            if (m.groupCount() > 1) {
                endDigit = m.group(2);
            }
            double parsedValue = endDigit == null ? Double.parseDouble(startDigits) : Double.parseDouble(startDigits + "." + endDigit);
            if ((parsedValue /= 100.0) < 0.0) {
                parsedValue = 0.0;
            } else if (parsedValue > 1.0) {
                parsedValue = 1.0;
            }
            return parsedValue;
        }
        return 0.0;
    }
}

