/*
 * Decompiled with CFR 0.152.
 */
package org.girod.javafx.svgimage.xml;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.girod.javafx.svgimage.xml.LengthParser;
import org.girod.javafx.svgimage.xml.ParserUtils;
import org.girod.javafx.svgimage.xml.Viewport;

public class PathParser {
    private static final short PATH_NONE = -1;
    private static final short MOVE_TO = 0;
    private static final short CLOSE_PATH = 1;
    private static final short LINE_TO = 2;
    private static final short HORIZONTAL_LINE_TO = 3;
    private static final short VERTICAL_LINE_TO = 4;
    private static final short CUBIC_CURVE = 5;
    private static final short SMOOTH_CUBIC_CURVE = 6;
    private static final short QUADRATIC_CURVE = 7;
    private static final short SMOOTH_QUADRATIC_CURVE = 8;
    private static final short ELLIPTICAL_CURVE = 9;
    private static final Pattern LETTER = Pattern.compile("[sSlLhHvVmMcCqQtTaAzZ]");
    private static final Pattern PLUSMINUS = Pattern.compile("[+-]?\\d*([eE][+-]\\d+)?(\\.\\d+)?");

    private PathParser() {
    }

    private static void decomposePart(List<String> list, String token) {
        int offset = 0;
        Matcher m = PLUSMINUS.matcher(token);
        String part = token;
        while (true) {
            boolean found;
            if (!(found = m.find(offset))) {
                list.add(part);
                break;
            }
            int start = m.start();
            int end = m.end();
            String value = token.substring(start, end);
            list.add(value);
            offset = end;
            if (offset >= token.length()) break;
            part = token.substring(offset);
        }
    }

    public static String parsePathContent(String content, Viewport viewport) {
        int type = -1;
        int index = 0;
        boolean isFirst = true;
        StringBuilder buf = new StringBuilder();
        ArrayList<String> list = new ArrayList<String>();
        StringTokenizer tok = new StringTokenizer(content, " ,");
        block43: while (tok.hasMoreTokens()) {
            String tk = tok.nextToken();
            Matcher m = LETTER.matcher(tk);
            int offset = 0;
            String part = tk;
            while (true) {
                boolean found;
                if (!(found = m.find(offset))) {
                    PathParser.decomposePart(list, part);
                    continue block43;
                }
                int start = m.start();
                int end = m.end();
                if (start > 0) {
                    String previousPart = tk.substring(offset, start);
                    PathParser.decomposePart(list, previousPart);
                }
                String letter = tk.substring(start, end);
                list.add(letter);
                offset = end;
                if (offset >= tk.length()) continue block43;
                part = tk.substring(offset);
            }
        }
        for (int i = 0; i < list.size(); ++i) {
            String tk;
            block22 : switch (tk = (String)list.get(i)) {
                case "m": 
                case "M": {
                    type = 0;
                    index = -1;
                    PathParser.addPathCommand(buf, tk, isFirst);
                    break;
                }
                case "h": 
                case "H": {
                    type = 3;
                    index = -1;
                    PathParser.addPathCommand(buf, tk, isFirst);
                    break;
                }
                case "v": 
                case "V": {
                    type = 4;
                    index = -1;
                    PathParser.addPathCommand(buf, tk, isFirst);
                    break;
                }
                case "l": 
                case "L": {
                    type = 2;
                    index = -1;
                    PathParser.addPathCommand(buf, tk, isFirst);
                    break;
                }
                case "c": 
                case "C": {
                    type = 5;
                    index = -1;
                    PathParser.addPathCommand(buf, tk, isFirst);
                    break;
                }
                case "q": 
                case "Q": {
                    type = 7;
                    index = -1;
                    PathParser.addPathCommand(buf, tk, isFirst);
                    break;
                }
                case "s": 
                case "S": {
                    type = 6;
                    index = -1;
                    PathParser.addPathCommand(buf, tk, isFirst);
                    break;
                }
                case "t": 
                case "T": {
                    type = 8;
                    index = -1;
                    PathParser.addPathCommand(buf, tk, isFirst);
                    break;
                }
                case "a": 
                case "A": {
                    type = 9;
                    index = -1;
                    PathParser.addPathCommand(buf, tk, isFirst);
                    break;
                }
                case "z": 
                case "Z": {
                    index = -1;
                    PathParser.addPathCommand(buf, tk, isFirst);
                    type = 1;
                    break;
                }
                default: {
                    switch (type) {
                        case 0: 
                        case 2: {
                            double d;
                            if (++index == 2) {
                                index = 0;
                            }
                            if (index == 0) {
                                d = LengthParser.parseLength(tk, true, viewport);
                                PathParser.addPathCommand(buf, d);
                                break block22;
                            }
                            if (index == 1) {
                                d = LengthParser.parseLength(tk, false, viewport);
                                PathParser.addPathCommand(buf, d);
                                break block22;
                            }
                            PathParser.addPathCommand(buf, tk);
                            break block22;
                        }
                        case 3: {
                            ++index;
                            double d = LengthParser.parseLength(tk, true, viewport);
                            PathParser.addPathCommand(buf, d);
                            break block22;
                        }
                        case 4: {
                            ++index;
                            double d = LengthParser.parseLength(tk, false, viewport);
                            PathParser.addPathCommand(buf, d);
                            break block22;
                        }
                        case 5: {
                            double d;
                            if (++index == 6) {
                                index = 0;
                            }
                            if (index == 0 || index == 2 || index == 4) {
                                d = LengthParser.parseLength(tk, true, viewport);
                                PathParser.addPathCommand(buf, d);
                                break block22;
                            }
                            if (index == 1 || index == 3 || index == 5) {
                                d = LengthParser.parseLength(tk, false, viewport);
                                PathParser.addPathCommand(buf, d);
                                break block22;
                            }
                            PathParser.addPathCommand(buf, tk);
                            break block22;
                        }
                        case 6: 
                        case 7: {
                            double d;
                            if (++index == 4) {
                                index = 0;
                            }
                            if (index == 0 || index == 2) {
                                d = LengthParser.parseLength(tk, true, viewport);
                                PathParser.addPathCommand(buf, d);
                                break block22;
                            }
                            if (index == 1 || index == 3) {
                                d = LengthParser.parseLength(tk, false, viewport);
                                PathParser.addPathCommand(buf, d);
                                break block22;
                            }
                            PathParser.addPathCommand(buf, tk);
                            break block22;
                        }
                        case 8: {
                            double d;
                            if (++index == 3) {
                                index = 0;
                            }
                            if (index == 0) {
                                d = LengthParser.parseLength(tk, true, viewport);
                                PathParser.addPathCommand(buf, d);
                                break block22;
                            }
                            if (index == 1) {
                                d = LengthParser.parseLength(tk, false, viewport);
                                PathParser.addPathCommand(buf, d);
                                break block22;
                            }
                            PathParser.addPathCommand(buf, tk);
                            break block22;
                        }
                        case 9: {
                            double d;
                            if (++index == 0) {
                                d = LengthParser.parseLength(tk, true, viewport);
                                PathParser.addPathCommand(buf, d);
                                break block22;
                            }
                            if (index == 1) {
                                d = LengthParser.parseLength(tk, false, viewport);
                                PathParser.addPathCommand(buf, d);
                                break block22;
                            }
                            if (index == 2) {
                                d = ParserUtils.parseDoubleProtected(tk);
                                PathParser.addPathCommand(buf, d);
                                break block22;
                            }
                            if (index == 3 || index == 4) {
                                PathParser.addPathCommand(buf, tk);
                                break block22;
                            }
                            if (index == 5) {
                                d = LengthParser.parseLength(tk, true, viewport);
                                PathParser.addPathCommand(buf, d);
                                break block22;
                            }
                            if (index == 6) {
                                d = LengthParser.parseLength(tk, false, viewport);
                                PathParser.addPathCommand(buf, d);
                                break block22;
                            }
                            PathParser.addPathCommand(buf, tk);
                            break block22;
                        }
                    }
                }
            }
            isFirst = false;
        }
        return buf.toString();
    }

    private static void addPathCommand(StringBuilder buf, double value) {
        buf.append(" ");
        buf.append(Double.toString(value));
    }

    private static void addPathCommand(StringBuilder buf, String command) {
        PathParser.addPathCommand(buf, command, false);
    }

    private static void addPathCommand(StringBuilder buf, String command, boolean isFirst) {
        if (!isFirst) {
            buf.append(" ");
        }
        buf.append(command);
    }
}

