/*
 * Decompiled with CFR 0.152.
 */
package org.girod.javafx.svgimage.xml;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javafx.geometry.Bounds;
import org.girod.javafx.svgimage.xml.Viewport;
import org.girod.javafx.svgimage.xml.XMLNode;

public class LengthParser {
    private static final Pattern NUMBER = Pattern.compile("\\-?\\d*(\\.\\d+)?");
    private static final Pattern NUMBER_UNIT = Pattern.compile("(\\-?\\d+)(\\.\\d*)?([a-z%A-Z]+)");
    private static final double INCH = 0.010416666666666666;
    private static final Viewport DEFAULT_VIEWPORT = new Viewport();

    private LengthParser() {
    }

    public static double parseLength(XMLNode node, Viewport viewport, String attrName) {
        return LengthParser.parseLength(node, true, null, viewport, attrName);
    }

    public static double parseLength(XMLNode node, boolean isWidth, Viewport viewport, String attrName) {
        String valueAsString = node.getAttributeValue(attrName);
        if (valueAsString != null) {
            return LengthParser.parseLength(valueAsString, isWidth, null, viewport);
        }
        return 0.0;
    }

    public static double parseLength(XMLNode node, boolean isWidth, Bounds bounds, Viewport viewport, String attrName) {
        String valueAsString = node.getAttributeValue(attrName);
        if (valueAsString != null) {
            return LengthParser.parseLength(valueAsString, isWidth, bounds, viewport);
        }
        return 0.0;
    }

    public static double parseLength(String lengthValue, Viewport viewport) {
        return LengthParser.parseLength(lengthValue, true, null, viewport);
    }

    public static double parseLength(String lengthValue, boolean isWidth, Viewport viewport) {
        return LengthParser.parseLength(lengthValue, isWidth, null, viewport);
    }

    public static double parsePosition(String lengthValue, boolean isWidth, Bounds bounds, Viewport viewport) {
        if (viewport == null) {
            viewport = DEFAULT_VIEWPORT;
        }
        lengthValue = lengthValue.trim();
        Matcher m = NUMBER.matcher(lengthValue = lengthValue.replace('\u2212', '-'));
        if (m.matches()) {
            if (bounds == null) {
                return viewport.scalePosition(Double.parseDouble(lengthValue), isWidth);
            }
            if (isWidth) {
                return viewport.scalePosition(bounds.getMinX() + Double.parseDouble(lengthValue) * bounds.getWidth(), isWidth);
            }
            return viewport.scalePosition(bounds.getMinY() + Double.parseDouble(lengthValue) * bounds.getHeight(), isWidth);
        }
        m = NUMBER_UNIT.matcher(lengthValue);
        if (m.matches()) {
            String unitS = m.group(m.groupCount());
            String startDigits = m.group(1);
            String endDigit = null;
            if (m.groupCount() > 1) {
                endDigit = m.group(2);
            }
            double parsedValue = endDigit == null ? Double.parseDouble(startDigits) : Double.parseDouble(startDigits + "." + endDigit);
            switch (unitS) {
                case "px": {
                    return viewport.scalePosition(parsedValue, isWidth);
                }
                case "pt": {
                    return viewport.scalePosition(parsedValue / 0.010416666666666666 * 72.0 / 96.0, isWidth);
                }
                case "in": {
                    return viewport.scalePosition(parsedValue / 0.010416666666666666, isWidth);
                }
                case "cm": {
                    return viewport.scalePosition(parsedValue / 0.010416666666666666 * 72.0 / 243.84, isWidth);
                }
                case "mm": {
                    return viewport.scalePosition(parsedValue / 0.010416666666666666 * 72.0 / 2438.4, isWidth);
                }
                case "%": {
                    if (viewport == null) {
                        return 0.0;
                    }
                    if (isWidth) {
                        return viewport.scalePosition(parsedValue * viewport.getBestWidth() / 100.0, isWidth);
                    }
                    return viewport.scalePosition(parsedValue * viewport.getBestHeight() / 100.0, isWidth);
                }
            }
            return parsedValue;
        }
        return 0.0;
    }

    public static double parseLineWidth(String lengthValue, Viewport viewport) {
        if (viewport == null) {
            viewport = DEFAULT_VIEWPORT;
        }
        lengthValue = lengthValue.trim();
        Matcher m = NUMBER.matcher(lengthValue = lengthValue.replace('\u2212', '-'));
        if (m.matches()) {
            if (viewport == null) {
                return Double.parseDouble(lengthValue);
            }
            return viewport.scaleLineWidth(Double.parseDouble(lengthValue));
        }
        m = NUMBER_UNIT.matcher(lengthValue);
        if (m.matches()) {
            String unitS = m.group(m.groupCount());
            String startDigits = m.group(1);
            String endDigit = null;
            if (m.groupCount() > 1) {
                endDigit = m.group(2);
            }
            double parsedValue = endDigit == null ? Double.parseDouble(startDigits) : Double.parseDouble(startDigits + "." + endDigit);
            switch (unitS) {
                case "px": {
                    return viewport.scaleLineWidth(parsedValue);
                }
                case "pt": {
                    return viewport.scaleLineWidth(parsedValue / 0.010416666666666666 * 72.0 / 96.0);
                }
                case "in": {
                    return viewport.scaleLineWidth(parsedValue / 0.010416666666666666);
                }
                case "cm": {
                    return viewport.scaleLineWidth(parsedValue / 0.010416666666666666 * 72.0 / 243.84);
                }
                case "mm": {
                    return viewport.scaleLineWidth(parsedValue / 0.010416666666666666 * 72.0 / 2438.4);
                }
                case "%": {
                    return viewport.scaleLineWidth(parsedValue * viewport.getBestWidth() / 100.0);
                }
            }
            return viewport.scaleLineWidth(parsedValue);
        }
        return 0.0;
    }

    public static double parseLength(String lengthValue, boolean isWidth, Bounds bounds, Viewport viewport) {
        if (viewport == null) {
            viewport = DEFAULT_VIEWPORT;
        }
        lengthValue = lengthValue.trim();
        Matcher m = NUMBER.matcher(lengthValue = lengthValue.replace('\u2212', '-'));
        if (m.matches()) {
            if (viewport == null) {
                return Double.parseDouble(lengthValue);
            }
            if (bounds == null) {
                return viewport.scaleLength(Double.parseDouble(lengthValue));
            }
            if (isWidth) {
                return viewport.scaleLength(Double.parseDouble(lengthValue) * bounds.getWidth());
            }
            return viewport.scaleLength(Double.parseDouble(lengthValue) * bounds.getHeight());
        }
        m = NUMBER_UNIT.matcher(lengthValue);
        if (m.matches()) {
            String unitS = m.group(m.groupCount());
            String startDigits = m.group(1);
            String endDigit = null;
            if (m.groupCount() > 1) {
                endDigit = m.group(2);
            }
            double parsedValue = endDigit == null ? Double.parseDouble(startDigits) : Double.parseDouble(startDigits + "." + endDigit);
            switch (unitS) {
                case "px": {
                    return viewport.scaleLength(parsedValue);
                }
                case "pt": {
                    return viewport.scaleLength(parsedValue / 0.010416666666666666 * 72.0 / 96.0);
                }
                case "in": {
                    return viewport.scaleLength(parsedValue / 0.010416666666666666);
                }
                case "cm": {
                    return viewport.scaleLength(parsedValue / 0.010416666666666666 * 72.0 / 243.84);
                }
                case "mm": {
                    return viewport.scaleLength(parsedValue / 0.010416666666666666 * 72.0 / 2438.4);
                }
                case "%": {
                    if (isWidth) {
                        return viewport.scaleLength(parsedValue * viewport.getBestWidth() / 100.0);
                    }
                    return viewport.scaleLength(parsedValue * viewport.getBestHeight() / 100.0);
                }
            }
            return viewport.scaleLength(parsedValue);
        }
        return 0.0;
    }
}

