/*
 * Decompiled with CFR 0.152.
 */
package org.girod.javafx.svgimage.tosvg.xml;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import org.girod.javafx.svgimage.tosvg.xml.XMLNodeUtilities;

public class XMLNode {
    protected String name = null;
    protected XMLNode nodeParent = null;
    private int index = -1;
    protected final List<XMLNode> children = new ArrayList<XMLNode>();
    protected final Map<String, String> attributes = new TreeMap<String, String>();
    private String cData = null;

    public XMLNode(String nodeName) {
        this.name = nodeName;
    }

    public XMLNode(XMLNode parent, String nodeName) {
        this.name = nodeName;
        this.nodeParent = parent;
    }

    XMLNode createCopyInstanceImpl() {
        XMLNode node = new XMLNode(this.nodeParent, this.name);
        return node;
    }

    public XMLNode copy() {
        XMLNode node = this.createCopyInstanceImpl();
        node.cData = this.cData;
        for (Map.Entry<String, String> entry : this.attributes.entrySet()) {
            node.attributes.put(entry.getKey(), entry.getValue());
        }
        Iterator<XMLNode> it2 = this.children.iterator();
        int index = 0;
        while (it2.hasNext()) {
            XMLNode child = it2.next();
            child = child.copy();
            child.setParent(node, index);
            node.children.add(child);
            ++index;
        }
        return node;
    }

    public List<XMLNode> getAllChildren(String name) {
        ArrayList<XMLNode> list = new ArrayList<XMLNode>();
        for (XMLNode node : this.children) {
            if (node.getName().equals(name)) {
                list.add(node);
            }
            List<XMLNode> childList = node.getAllChildren(name);
            list.addAll(childList);
        }
        return list;
    }

    public XMLNode getParent() {
        return this.nodeParent;
    }

    private void setParent(XMLNode parent, int index) {
        this.nodeParent = parent;
        this.index = index;
    }

    public String getName() {
        return this.name;
    }

    public List<XMLNode> getChildren() {
        return this.children;
    }

    public XMLNode getFirstChild() {
        if (this.children.isEmpty()) {
            return null;
        }
        return this.children.get(0);
    }

    public XMLNode getLastChild() {
        if (this.children.isEmpty()) {
            return null;
        }
        return this.children.get(this.children.size() - 1);
    }

    public XMLNode getNextSibling() {
        if (this.nodeParent == null) {
            return null;
        }
        List<XMLNode> siblings = this.nodeParent.getChildren();
        if (siblings.size() < 2) {
            return null;
        }
        int index = siblings.indexOf(this);
        if (siblings.size() > index + 1) {
            return siblings.get(index + 1);
        }
        return null;
    }

    public XMLNode getPreviousSibling() {
        if (this.nodeParent == null) {
            return null;
        }
        List<XMLNode> siblings = this.nodeParent.getChildren();
        if (siblings.size() < 2) {
            return null;
        }
        int index = siblings.indexOf(this);
        if (index > 0) {
            return siblings.get(index - 1);
        }
        return null;
    }

    public void addChild(XMLNode child) {
        child.setParent(this, this.children.size());
        this.children.add(child);
    }

    public boolean hasChildren() {
        return !this.children.isEmpty();
    }

    public int countChildren() {
        return this.children.size();
    }

    public int countAttributes() {
        return this.attributes.size();
    }

    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    public String getAttributeValue(String attrName) {
        return this.attributes.get(attrName);
    }

    public boolean getAttributeValueAsBoolean(String attrName) {
        return this.getAttributeValueAsBoolean(attrName, false);
    }

    public boolean getAttributeValueAsBoolean(String attrName, boolean defaultValue) {
        if (this.attributes.containsKey(attrName)) {
            String attrvalue = this.attributes.get(attrName);
            try {
                return attrvalue.equals("true");
            }
            catch (NumberFormatException e) {
                return defaultValue;
            }
        }
        return defaultValue;
    }

    public float getAttributeValueAsFloat(String attrName) {
        return this.getAttributeValueAsFloat(attrName, 0.0f);
    }

    public float getAttributeValueAsFloat(String attrName, float defaultValue) {
        if (this.attributes.containsKey(attrName)) {
            String attrvalue = this.attributes.get(attrName);
            try {
                float f = Float.parseFloat(attrvalue);
                return f;
            }
            catch (NumberFormatException e) {
                return defaultValue;
            }
        }
        return defaultValue;
    }

    public int getAttributeValueAsInt(String attrName) {
        return this.getAttributeValueAsInt(attrName, 0);
    }

    public int getAttributeValueAsInt(String attrName, int defaultValue) {
        if (this.attributes.containsKey(attrName)) {
            String attrvalue = this.attributes.get(attrName);
            try {
                int i = Integer.parseInt(attrvalue);
                return i;
            }
            catch (NumberFormatException e) {
                return defaultValue;
            }
        }
        return defaultValue;
    }

    public void addAttribute(String attrName, int value) {
        this.attributes.put(attrName, Integer.toString(value));
    }

    public void addAttribute(String attrName, String value) {
        this.attributes.put(attrName, value);
    }

    public void addAttribute(String attrName, float value) {
        this.attributes.put(attrName, this.format(value));
    }

    public void addAttribute(String attrName, double value) {
        this.attributes.put(attrName, this.format(value));
    }

    public void addAttribute(String attrName, boolean value) {
        this.attributes.put(attrName, value ? "true" : "false");
    }

    public void setCDATA(String cData) {
        this.cData = cData;
    }

    public String getCDATA() {
        return this.cData;
    }

    public boolean hasCDATA() {
        return this.cData != null;
    }

    public boolean hasAttribute(String attrName) {
        return this.attributes.containsKey(attrName);
    }

    private String format(float f) {
        String s = String.format("%.1f", Float.valueOf(f));
        s = s.replace(",", ".");
        return s;
    }

    private String format(double f) {
        String s = String.format("%.1f", f);
        s = s.replace(",", ".");
        return s;
    }

    public int hashCode() {
        int hash = 3;
        hash = 23 * hash + Objects.hashCode(this.name);
        hash = 23 * hash + Objects.hashCode(this.nodeParent);
        hash = 23 * hash + this.index;
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        XMLNode other = (XMLNode)obj;
        if (this.index != other.index) {
            return false;
        }
        if (!Objects.equals(this.name, other.name)) {
            return false;
        }
        return Objects.equals(this.nodeParent, other.nodeParent);
    }

    public String toString() {
        String str = XMLNodeUtilities.print(this, 2);
        return str;
    }
}

