/*
 * Decompiled with CFR 0.152.
 */
package org.girod.javafx.svgimage.tosvg.utils;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import javafx.collections.ObservableSet;
import javafx.css.CssMetaData;
import javafx.css.PseudoClass;
import javafx.css.Styleable;
import javafx.css.StyleableProperty;
import javafx.geometry.Insets;
import javafx.geometry.Rectangle2D;
import javafx.scene.Node;
import javafx.scene.image.Image;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.BackgroundImage;
import javafx.scene.layout.BackgroundPosition;
import javafx.scene.layout.BackgroundSize;
import javafx.scene.layout.Border;
import javafx.scene.layout.BorderStroke;
import javafx.scene.layout.BorderStrokeStyle;
import javafx.scene.layout.BorderWidths;
import javafx.scene.layout.CornerRadii;
import javafx.scene.layout.Region;
import javafx.scene.paint.Color;
import javafx.scene.paint.ImagePattern;
import javafx.scene.paint.Paint;
import javafx.scene.text.Font;
import javafx.scene.text.FontPosture;
import javafx.scene.text.FontWeight;
import javafx.scene.transform.Scale;
import org.girod.javafx.svgimage.tosvg.utils.CSSProperties;
import org.girod.javafx.svgimage.tosvg.utils.CSSProperty;
import org.girod.javafx.svgimage.tosvg.utils.NodeConverter;
import org.girod.javafx.svgimage.tosvg.wrappers.BackgroundWrapper;
import org.girod.javafx.svgimage.tosvg.wrappers.BorderWrapper;

public class Utilities
implements CSSProperties {
    private Utilities() {
    }

    public static String convertColor(Color color) {
        int red = (int)(255.0 * color.getRed());
        int green = (int)(255.0 * color.getGreen());
        int blue = (int)(255.0 * color.getBlue());
        return "rgb(" + red + "," + green + "," + blue + ")";
    }

    public static FontWeight getWeight(Font font) {
        StringTokenizer tok = new StringTokenizer(font.getStyle());
        while (tok.hasMoreTokens()) {
            String tk = tok.nextToken().toLowerCase();
            if (tk.equals("bold")) {
                return FontWeight.BOLD;
            }
            if (tk.equals("bolder")) {
                return FontWeight.EXTRA_BOLD;
            }
            if (!tk.equals("lighter")) continue;
            return FontWeight.LIGHT;
        }
        return FontWeight.NORMAL;
    }

    public static FontPosture getPosture(Font font) {
        StringTokenizer tok = new StringTokenizer(font.getStyle());
        while (tok.hasMoreTokens()) {
            String tk = tok.nextToken().toLowerCase();
            if (!tk.equals("italic")) continue;
            return FontPosture.ITALIC;
        }
        return FontPosture.REGULAR;
    }

    public static Set<String> extractPseudoClasses(Node node) {
        ObservableSet pseudoClasses = node.getPseudoClassStates();
        HashSet<String> set = new HashSet<String>();
        Iterator it = pseudoClasses.iterator();
        while (it.hasNext()) {
            set.add(((PseudoClass)it.next()).getPseudoClassName());
        }
        return set;
    }

    public static Map<String, CSSProperty> extractProperties(Node node) {
        HashMap<String, CSSProperty> props = new HashMap<String, CSSProperty>();
        List metaDatas = node.getCssMetaData();
        for (CssMetaData metaData : metaDatas) {
            StyleableProperty prop = metaData.getStyleableProperty((Styleable)node);
            String propName = metaData.getProperty();
            Object value = prop.getValue();
            if (value == null) continue;
            props.put(propName, new CSSProperty(prop, value));
        }
        return props;
    }

    public static List<BackgroundWrapper> getPaintList(Region region, Background background, NodeConverter converter, double opacity) {
        ArrayList<BackgroundWrapper> paints = new ArrayList<BackgroundWrapper>();
        List fills = background.getFills();
        List images = background.getImages();
        if (!images.isEmpty()) {
            for (BackgroundImage image : images) {
                BackgroundSize size = image.getSize();
                double width = size.getWidth();
                double height = size.getHeight();
                if (size.isContain()) {
                    width = region.getWidth();
                    height = region.getHeight();
                } else if (size.isWidthAsPercentage() || size.isHeightAsPercentage()) {
                    double fitWidth = region.getWidth();
                    double fitHeight = region.getHeight();
                    if (size.isWidthAsPercentage()) {
                        fitWidth = width * fitWidth;
                    }
                    if (size.isHeightAsPercentage()) {
                        fitHeight = height * fitHeight;
                    }
                    Image _image = image.getImage();
                    if (fitWidth < 0.0) {
                        fitHeight = _image.getWidth() / _image.getHeight() * fitHeight;
                    }
                    if (fitHeight < 0.0) {
                        fitHeight = _image.getHeight() / _image.getWidth() * fitWidth;
                    }
                    width = fitWidth;
                    height = fitHeight;
                }
                if (!(width > 0.0) || !(height > 0.0)) continue;
                Image _image1 = image.getImage();
                ImagePattern paint = new ImagePattern(_image1);
                Rectangle2D rec = new Rectangle2D(0.0, 0.0, width, height);
                BackgroundWrapper wrapper = new BackgroundWrapper((Paint)paint);
                wrapper.setImagePosition(image.getPosition());
                double x = rec.getMinX();
                double y = rec.getMinY();
                BackgroundPosition position = image.getPosition();
                if (converter.getAllProperties().containsKey("-fx-background-position")) {
                    position = (BackgroundPosition)converter.getAllProperties().get("-fx-background-position");
                }
                if (position != null) {
                    if (position.getHorizontalPosition() == 0.5) {
                        x += (region.getWidth() - width) / 2.0;
                    }
                    if (position.getVerticalPosition() == 0.5) {
                        y += (region.getHeight() - height) / 2.0;
                    }
                }
                wrapper.setPosition(x, y);
                wrapper.setImagePosition(image.getPosition());
                wrapper.setSize(rec.getWidth(), rec.getHeight());
                paints.add(wrapper);
            }
        }
        if (!fills.isEmpty()) {
            for (BackgroundFill fill : fills) {
                Paint paint = fill.getFill();
                Insets insets = fill.getInsets();
                double x = insets.getLeft();
                double y = insets.getTop();
                double width = region.getWidth() - insets.getRight();
                double height = region.getHeight() - insets.getBottom();
                if (!(width > 0.0) || !(height > 0.0) || paint == null) continue;
                BackgroundWrapper wrapper = new BackgroundWrapper(paint);
                CornerRadii radii = fill.getRadii();
                wrapper.setRadii(radii);
                wrapper.setPosition(x, y);
                wrapper.setSize(width, height);
                paints.add(wrapper);
            }
        }
        return paints;
    }

    public static List<BorderWrapper> getPaintList(Region region, Border border) {
        ArrayList<BorderWrapper> borders = new ArrayList<BorderWrapper>();
        List strokes = border.getStrokes();
        if (!strokes.isEmpty()) {
            for (BorderStroke stroke : strokes) {
                CornerRadii radii = stroke.getRadii();
                BorderWidths widths = stroke.getWidths();
                double width = (widths.getBottom() + widths.getLeft() + widths.getRight() + widths.getTop()) / 4.0;
                if (width == 0.0) continue;
                Paint paint = stroke.getBottomStroke();
                if (paint == null) {
                    paint = stroke.getLeftStroke();
                }
                if (paint == null) {
                    paint = stroke.getRightStroke();
                }
                if (paint == null) {
                    paint = stroke.getTopStroke();
                }
                if (paint == null) continue;
                BorderWrapper wrapper = new BorderWrapper(paint, width);
                BorderStrokeStyle strokeStyle = Utilities.mergeBorderStyles(stroke);
                if (strokeStyle != null) {
                    wrapper.setStrokeStyle(strokeStyle);
                }
                if (radii != null) {
                    wrapper.setRadii(radii);
                }
                borders.add(wrapper);
            }
        }
        return borders;
    }

    private static BorderStrokeStyle mergeBorderStyles(BorderStroke stroke) {
        BorderStrokeStyle botstyle = stroke.getBottomStyle();
        BorderStrokeStyle topstyle = stroke.getTopStyle();
        BorderStrokeStyle leftstyle = stroke.getLeftStyle();
        BorderStrokeStyle rightstyle = stroke.getRightStyle();
        if (botstyle.getDashArray().isEmpty() && topstyle.getDashArray().isEmpty() && leftstyle.getDashArray().isEmpty() && rightstyle.getDashArray().isEmpty()) {
            return null;
        }
        if (!botstyle.getDashArray().isEmpty()) {
            return botstyle;
        }
        if (!topstyle.getDashArray().isEmpty()) {
            return topstyle;
        }
        if (!leftstyle.getDashArray().isEmpty()) {
            return leftstyle;
        }
        if (!rightstyle.getDashArray().isEmpty()) {
            return rightstyle;
        }
        return null;
    }

    public static String getScale(Scale scale) {
        return "scale(" + scale.getX() + "," + scale.getY() + ")";
    }

    public static List<String> splitString(String string, int partitionSize) {
        ArrayList<String> parts = new ArrayList<String>();
        int len = string.length();
        for (int i = 0; i < len; i += partitionSize) {
            parts.add(string.substring(i, Math.min(len, i + partitionSize)));
        }
        return parts;
    }

    public static String getRelativePath(File baseDir, File file, boolean strict) {
        String newPath;
        File parent = file;
        String path = file.getAbsolutePath();
        boolean isUnderBaseDir = false;
        while ((parent = parent.getParentFile()) != null) {
            if (!parent.equals(baseDir)) continue;
            isUnderBaseDir = true;
            try {
                String path1 = baseDir.getCanonicalPath();
                String path2 = file.getCanonicalPath();
                int index = path2.lastIndexOf(path1);
                if (index == -1) continue;
                String dirPath = path1.substring(index);
                path = path2.substring(dirPath.length() + 1);
            }
            catch (IOException e) {
                System.err.println(e.getMessage());
            }
        }
        if (!isUnderBaseDir && !strict && (newPath = Utilities.convertToRelativePath(baseDir, file)) != null) {
            path = newPath;
        }
        path = path.replace('\\', '/');
        return path;
    }

    private static String convertToRelativePath(File baseDir, File file) {
        String[] relativeDirs;
        StringBuilder relPathBuilder = null;
        String absPath = baseDir.getAbsolutePath();
        String relPath = file.getAbsolutePath();
        absPath = absPath.replaceAll("\\\\", "/");
        relPath = relPath.replaceAll("\\\\", "/");
        String[] absoluteDirs = absPath.split("/");
        int length = absoluteDirs.length < (relativeDirs = relPath.split("/")).length ? absoluteDirs.length : relativeDirs.length;
        int lastCommonRoot = -1;
        int index = 0;
        while (index < length && absoluteDirs[index].equals(relativeDirs[index])) {
            lastCommonRoot = index++;
        }
        if (lastCommonRoot != -1) {
            relPathBuilder = new StringBuilder();
            for (index = lastCommonRoot + 1; index < absoluteDirs.length; ++index) {
                if (absoluteDirs[index].length() <= 0) continue;
                relPathBuilder.append("../");
            }
            for (index = lastCommonRoot + 1; index < relativeDirs.length - 1; ++index) {
                relPathBuilder.append(relativeDirs[index]).append("/");
            }
            relPathBuilder.append(relativeDirs[relativeDirs.length - 1]);
        }
        return relPathBuilder == null ? null : relPathBuilder.toString();
    }
}

