/*
 * Decompiled with CFR 0.152.
 */
package org.girod.javafx.svgimage.tosvg.utils;

import java.awt.Image;
import java.awt.Toolkit;
import java.awt.geom.AffineTransform;
import java.awt.image.FilteredImageSource;
import javafx.scene.transform.Rotate;
import javafx.scene.transform.Scale;
import javafx.scene.transform.Transform;
import javafx.scene.transform.Translate;
import javax.swing.GrayFilter;
import org.girod.javafx.svgimage.tosvg.utils.OpacityFilter;

public class AwtImageUtilities {
    private static final double ASSUME_ZERO = 0.001;

    private AwtImageUtilities() {
    }

    public static Image createDisabledImage(Image image) {
        GrayFilter filter = new GrayFilter(true, 20);
        FilteredImageSource producer = new FilteredImageSource(image.getSource(), filter);
        Image newImage = Toolkit.getDefaultToolkit().createImage(producer);
        return newImage;
    }

    public static Image createOpacifiedImage(Image image, double opacity, boolean multiply) {
        OpacityFilter filter = new OpacityFilter(opacity, multiply);
        FilteredImageSource producer = new FilteredImageSource(image.getSource(), filter);
        Image newImage = Toolkit.getDefaultToolkit().createImage(producer);
        return newImage;
    }

    public static double getRotationAngle(AffineTransform tr) {
        double m00 = tr.getScaleX();
        double m01 = tr.getShearX();
        double m10 = tr.getShearY();
        double m11 = tr.getScaleY();
        double norm = Math.sqrt(m00 * m00 + m11 * m11);
        if (norm == 0.0) {
            return m10 >= 0.0 ? 1.5707963267948966 : -1.5707963267948966;
        }
        double xy = m01 / norm;
        double xx = m00 / norm;
        double theta = -Math.atan2(xy, xx);
        if (Math.abs(theta) < 0.001) {
            return 0.0;
        }
        return theta;
    }

    private static boolean toApply(Transform tr) {
        Translate translate;
        boolean toApply = true;
        if (tr instanceof Rotate) {
            Rotate rotate = (Rotate)tr;
            if (rotate.getAngle() == 0.0) {
                toApply = false;
            }
        } else if (tr instanceof Scale) {
            Scale scale = (Scale)tr;
            if (scale.getMxx() == 1.0 && scale.getMyy() == 1.0) {
                toApply = false;
            }
        } else if (tr instanceof Translate && (translate = (Translate)tr).getTx() == 0.0 && translate.getTy() == 0.0) {
            toApply = false;
        }
        return toApply;
    }

    public static AffineTransform getTransform(Transform tr) {
        AffineTransform result = new AffineTransform();
        boolean toApply = AwtImageUtilities.toApply(tr);
        if (toApply) {
            AffineTransform transform = AwtImageUtilities.getAffineTransform(tr);
            result.concatenate(transform);
        }
        return result;
    }

    private static AffineTransform getAffineTransform(Transform tr) {
        AffineTransform affine;
        if (tr instanceof Rotate) {
            Rotate rotate = (Rotate)tr;
            double angle = Math.toRadians(rotate.getAngle());
            affine = AffineTransform.getRotateInstance(angle, rotate.getPivotX(), rotate.getPivotY());
        } else {
            affine = new AffineTransform(tr.getMxx(), tr.getMyx(), tr.getMxy(), tr.getMyy(), tr.getTx(), tr.getTy());
        }
        return affine;
    }
}

