/*
 * Decompiled with CFR 0.152.
 */
package org.girod.javafx.svgimage;

import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javafx.animation.Animation;
import javafx.scene.paint.Paint;
import org.girod.javafx.svgimage.LoaderParameters;
import org.girod.javafx.svgimage.SVGImage;
import org.girod.javafx.svgimage.xml.ClippingFactory;
import org.girod.javafx.svgimage.xml.FilterSpec;
import org.girod.javafx.svgimage.xml.GradientSpec;
import org.girod.javafx.svgimage.xml.Styles;
import org.girod.javafx.svgimage.xml.SymbolSpec;
import org.girod.javafx.svgimage.xml.Viewport;
import org.girod.javafx.svgimage.xml.XMLNode;

public class LoaderContext {
    public final SVGImage root;
    public final LoaderParameters params;
    public Viewport viewport = null;
    public Styles svgStyle = null;
    public final URL url;
    public final ClippingFactory clippingFactory = new ClippingFactory();
    public final Map<String, GradientSpec> gradientSpecs = new HashMap<String, GradientSpec>();
    public final Map<String, FilterSpec> filterSpecs = new HashMap<String, FilterSpec>();
    public final Map<String, Paint> gradients = new HashMap<String, Paint>();
    private Map<String, XMLNode> namedNodes = new HashMap<String, XMLNode>();
    private Map<String, SymbolSpec> symbols = new HashMap<String, SymbolSpec>();
    List<Animation> animations = new ArrayList<Animation>();
    public boolean effectsSupported = false;

    public LoaderContext(SVGImage root, LoaderParameters params, URL url) {
        this.root = root;
        this.params = params;
        this.url = url;
    }

    public void addNamedNode(String id, XMLNode xmlNode) {
        this.namedNodes.put(id, xmlNode);
    }

    public boolean hasReifiedNamedNode(String id) {
        return this.namedNodes.containsKey(id);
    }

    public boolean hasNamedNode(String id) {
        return this.namedNodes.containsKey(id) || this.symbols.containsKey(id);
    }

    public XMLNode getReifiedNamedNode(String id) {
        return this.namedNodes.get(id);
    }

    public XMLNode getNamedNode(String id) {
        if (this.namedNodes.containsKey(id)) {
            return this.namedNodes.get(id);
        }
        return this.symbols.get(id).getXMLNode();
    }

    public void addSymbol(String id, SymbolSpec symbol) {
        this.symbols.put(id, symbol);
    }

    public boolean hasSymbol(String id) {
        return this.symbols.containsKey(id);
    }

    public SymbolSpec getSymbol(String id) {
        return this.symbols.get(id);
    }

    public void addTransition(Animation animation) {
        this.animations.add(animation);
    }

    public void addAnimations(List<Animation> theAnimations) {
        this.animations.addAll(theAnimations);
    }

    public void playAnimations() {
        if (!this.animations.isEmpty()) {
            for (Animation tr : this.animations) {
                tr.play();
            }
        }
    }
}

