/*
 * Decompiled with CFR 0.152.
 */
package org.girod.javafx.svgimage.xml;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javafx.animation.Animation;
import javafx.animation.FillTransition;
import javafx.animation.Interpolator;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.ParallelTransition;
import javafx.animation.PathTransition;
import javafx.animation.RotateTransition;
import javafx.animation.ScaleTransition;
import javafx.animation.StrokeTransition;
import javafx.animation.Timeline;
import javafx.animation.Transition;
import javafx.animation.TranslateTransition;
import javafx.beans.property.DoubleProperty;
import javafx.beans.value.WritableValue;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.image.ImageView;
import javafx.scene.paint.Color;
import javafx.scene.shape.Circle;
import javafx.scene.shape.Ellipse;
import javafx.scene.shape.Line;
import javafx.scene.shape.Polygon;
import javafx.scene.shape.Polyline;
import javafx.scene.shape.Rectangle;
import javafx.scene.shape.SVGPath;
import javafx.scene.shape.Shape;
import javafx.util.Duration;
import org.girod.javafx.svgimage.xml.ParserUtils;
import org.girod.javafx.svgimage.xml.PathParser;
import org.girod.javafx.svgimage.xml.SVGTags;
import org.girod.javafx.svgimage.xml.TransformUtils;
import org.girod.javafx.svgimage.xml.Viewport;
import org.girod.javafx.svgimage.xml.XMLNode;

public class AnimationBuilder
implements SVGTags {
    private static final short TYPE_TRANSLATE = 0;
    private static final short TYPE_SCALE = 1;
    private static final short TYPE_ROTATE = 2;
    private static final short TYPE_SKEW_X = 3;
    private static final short TYPE_SKEW_Y = 4;
    private static final short ANIMATE_DEFAULT = 0;
    private static final short ANIMATE_VISIBILITY = 1;
    private static final short ANIMATE_STROKE = 2;
    private static final short ANIMATE_FILL = 3;
    private static final Pattern DURATION_PAT = Pattern.compile("(\\d+)(\\w+)");

    private AnimationBuilder() {
    }

    public static List<Animation> buildAnimations(XMLNode xmlNode, Node node, List<XMLNode> xmlAnims, Viewport viewport) {
        ParallelTransition parallel = null;
        ArrayList<Animation> transitionsList = new ArrayList<Animation>();
        if (xmlAnims.size() > 1) {
            parallel = new ParallelTransition(node);
            transitionsList.add((Animation)parallel);
        }
        for (XMLNode xmlAnim : xmlAnims) {
            String name;
            switch (name = xmlAnim.getName()) {
                case "animate": {
                    Animation animate = AnimationBuilder.buildAnimate(xmlNode, xmlAnim, node, parallel, viewport);
                    if (animate == null) break;
                    transitionsList.add(animate);
                    break;
                }
                case "animateMotion": {
                    Transition motionTransition = AnimationBuilder.buildAnimateMotion(xmlNode, xmlAnim, node, parallel, viewport);
                    if (motionTransition == null) break;
                    transitionsList.add((Animation)motionTransition);
                    break;
                }
                case "animateTransform": {
                    Transition transition = AnimationBuilder.buildAnimateTransform(xmlNode, xmlAnim, node, parallel, viewport);
                    if (transition == null) break;
                    transitionsList.add((Animation)transition);
                    break;
                }
            }
        }
        return transitionsList;
    }

    private static Duration parseDuration(String attrValue) {
        if (attrValue.equals("indefinite")) {
            return Duration.INDEFINITE;
        }
        Matcher m = DURATION_PAT.matcher(attrValue);
        if (m.matches()) {
            int time = Integer.parseInt(m.group(1));
            String type = m.group(2);
            if (type.equals("s")) {
                return Duration.seconds((double)time);
            }
            if (type.equals("ms")) {
                return Duration.millis((double)time);
            }
            if (type.equals("min")) {
                return Duration.minutes((double)time);
            }
            return Duration.ZERO;
        }
        return Duration.ZERO;
    }

    private static Animation buildAnimate(XMLNode xmlNode, XMLNode xmlAnim, Node node, ParallelTransition parallel, Viewport viewport) {
        String nodeName;
        if (!xmlAnim.hasAttribute("attributeName")) {
            return null;
        }
        DoubleProperty value = null;
        int animateType = 0;
        String attrName = xmlAnim.getAttributeValue("attributeName");
        block11 : switch (nodeName = xmlNode.getName()) {
            case "g": {
                Group group = (Group)node;
                switch (attrName) {
                    case "x": {
                        value = group.translateXProperty();
                        break;
                    }
                    case "y": {
                        value = group.translateYProperty();
                        break;
                    }
                    case "opacity": {
                        value = group.opacityProperty();
                        break;
                    }
                    case "visibility": {
                        value = group.opacityProperty();
                        animateType = 1;
                    }
                }
                break;
            }
            case "rect": {
                Rectangle rect = (Rectangle)node;
                switch (attrName) {
                    case "x": {
                        value = rect.xProperty();
                        break;
                    }
                    case "y": {
                        value = rect.yProperty();
                        break;
                    }
                    case "width": {
                        value = rect.widthProperty();
                        break;
                    }
                    case "height": {
                        value = rect.heightProperty();
                        break;
                    }
                    case "opacity": {
                        value = rect.opacityProperty();
                        break;
                    }
                    case "visibility": {
                        value = rect.opacityProperty();
                        animateType = 1;
                        break;
                    }
                    case "fill": {
                        value = rect.fillProperty();
                        animateType = 3;
                        break;
                    }
                    case "stroke": {
                        value = rect.strokeProperty();
                        animateType = 2;
                    }
                }
                break;
            }
            case "image": {
                ImageView imgView = (ImageView)node;
                switch (attrName) {
                    case "x": {
                        value = imgView.xProperty();
                        break;
                    }
                    case "y": {
                        value = imgView.yProperty();
                        break;
                    }
                    case "width": {
                        value = imgView.fitWidthProperty();
                        break;
                    }
                    case "height": {
                        value = imgView.fitHeightProperty();
                        break;
                    }
                    case "opacity": {
                        value = imgView.opacityProperty();
                        break;
                    }
                    case "visibility": {
                        value = imgView.opacityProperty();
                        animateType = 1;
                    }
                }
                break;
            }
            case "circle": {
                Circle circle = (Circle)node;
                switch (attrName) {
                    case "cx": {
                        value = circle.centerXProperty();
                        break;
                    }
                    case "cy": {
                        value = circle.centerYProperty();
                        break;
                    }
                    case "r": {
                        value = circle.radiusProperty();
                        break;
                    }
                    case "opacity": {
                        value = circle.opacityProperty();
                        break;
                    }
                    case "visibility": {
                        value = circle.opacityProperty();
                        animateType = 1;
                        break;
                    }
                    case "fill": {
                        value = circle.fillProperty();
                        animateType = 3;
                        break;
                    }
                    case "stroke": {
                        value = circle.strokeProperty();
                        animateType = 2;
                    }
                }
                break;
            }
            case "ellipse": {
                Ellipse ellipse = (Ellipse)node;
                switch (attrName) {
                    case "cx": {
                        value = ellipse.centerXProperty();
                        break;
                    }
                    case "cy": {
                        value = ellipse.centerYProperty();
                        break;
                    }
                    case "rx": {
                        value = ellipse.radiusXProperty();
                        break;
                    }
                    case "ry": {
                        value = ellipse.radiusYProperty();
                        break;
                    }
                    case "opacity": {
                        value = ellipse.opacityProperty();
                        break;
                    }
                    case "visibility": {
                        value = ellipse.opacityProperty();
                        animateType = 1;
                        break;
                    }
                    case "fill": {
                        value = ellipse.fillProperty();
                        animateType = 3;
                        break;
                    }
                    case "stroke": {
                        value = ellipse.strokeProperty();
                        animateType = 2;
                    }
                }
                break;
            }
            case "line": {
                Line line = (Line)node;
                switch (attrName) {
                    case "x1": {
                        value = line.startXProperty();
                        break;
                    }
                    case "y1": {
                        value = line.startYProperty();
                        break;
                    }
                    case "x2": {
                        value = line.endXProperty();
                        break;
                    }
                    case "y2": {
                        value = line.endYProperty();
                        break;
                    }
                    case "opacity": {
                        value = line.opacityProperty();
                        break;
                    }
                    case "visibility": {
                        value = line.opacityProperty();
                        animateType = 1;
                        break;
                    }
                    case "stroke": {
                        value = line.strokeProperty();
                        animateType = 2;
                    }
                }
                break;
            }
            case "polygon": {
                Polygon polygon = (Polygon)node;
                switch (attrName) {
                    case "opacity": {
                        value = polygon.opacityProperty();
                        break;
                    }
                    case "visibility": {
                        value = polygon.opacityProperty();
                        animateType = 1;
                        break;
                    }
                    case "fill": {
                        value = polygon.fillProperty();
                        animateType = 3;
                        break;
                    }
                    case "stroke": {
                        value = polygon.strokeProperty();
                        animateType = 2;
                    }
                }
                break;
            }
            case "polyline": {
                Polyline polyline = (Polyline)node;
                switch (attrName) {
                    case "opacity": {
                        value = polyline.opacityProperty();
                        break;
                    }
                    case "visibility": {
                        value = polyline.opacityProperty();
                        animateType = 1;
                        break;
                    }
                    case "stroke": {
                        value = polyline.strokeProperty();
                        animateType = 2;
                    }
                }
            }
            case "path": {
                SVGPath thePath = (SVGPath)node;
                switch (attrName) {
                    case "opacity": {
                        value = thePath.opacityProperty();
                        break block11;
                    }
                    case "visibility": {
                        value = thePath.opacityProperty();
                        animateType = 1;
                        break block11;
                    }
                    case "stroke": {
                        value = thePath.strokeProperty();
                        animateType = 2;
                    }
                }
            }
        }
        List<Double> fromArgs = null;
        List<Double> toArgs = null;
        if (animateType == 0) {
            fromArgs = AnimationBuilder.getFromArguments(xmlAnim, viewport);
            toArgs = AnimationBuilder.getToArguments(xmlAnim, viewport);
        }
        if (animateType == 0 && (fromArgs == null || toArgs == null || fromArgs.isEmpty() || toArgs.isEmpty())) {
            return null;
        }
        if (value != null) {
            Timeline animation;
            Duration beginDur = Duration.ZERO;
            if (xmlAnim.hasAttribute("begin")) {
                String begin = xmlAnim.getAttributeValue("begin");
                beginDur = AnimationBuilder.parseDuration(begin);
            }
            Duration duration = Duration.ZERO;
            if (xmlAnim.hasAttribute("dur")) {
                duration = AnimationBuilder.parseDuration(xmlAnim.getAttributeValue("dur"));
            }
            if (animateType == 1) {
                Timeline timeline;
                boolean fromVisible = AnimationBuilder.getFromVisibilityArgument(xmlAnim);
                boolean toVisible = AnimationBuilder.getToVisibilityArgument(xmlAnim);
                KeyValue fromValue = new KeyValue((WritableValue)value, (Object)(fromVisible ? 1 : 0), Interpolator.DISCRETE);
                KeyValue toValue = new KeyValue((WritableValue)value, (Object)(toVisible ? 1 : 0), Interpolator.DISCRETE);
                KeyFrame fromFrame = new KeyFrame(beginDur, new KeyValue[]{fromValue});
                KeyFrame toFrame = new KeyFrame(duration, new KeyValue[]{toValue});
                animation = timeline = new Timeline(new KeyFrame[]{fromFrame, toFrame});
            } else if (animateType == 2) {
                Color fromColor = AnimationBuilder.getFromColorArgument(xmlAnim);
                Color toColor = AnimationBuilder.getToColorArgument(xmlAnim);
                if (fromColor == null || toColor == null) {
                    return null;
                }
                StrokeTransition transition = parallel != null ? new StrokeTransition(duration) : new StrokeTransition(duration, (Shape)node);
                transition.setFromValue(fromColor);
                transition.setToValue(toColor);
                animation = transition;
            } else if (animateType == 3) {
                Color fromColor = AnimationBuilder.getFromColorArgument(xmlAnim);
                Color toColor = AnimationBuilder.getToColorArgument(xmlAnim);
                if (fromColor == null || toColor == null) {
                    return null;
                }
                FillTransition transition = parallel != null ? new FillTransition(duration) : new FillTransition(duration, (Shape)node);
                transition.setFromValue(fromColor);
                transition.setToValue(toColor);
                animation = transition;
            } else {
                Timeline timeline;
                animation = timeline = new Timeline();
                KeyValue fromValue = new KeyValue((WritableValue)value, (Object)fromArgs.get(0));
                KeyValue toValue = new KeyValue((WritableValue)value, (Object)toArgs.get(0));
                KeyFrame fromFrame = new KeyFrame(beginDur, new KeyValue[]{fromValue});
                KeyFrame toFrame = new KeyFrame(duration, new KeyValue[]{toValue});
                timeline.getKeyFrames().addAll((Object[])new KeyFrame[]{fromFrame, toFrame});
            }
            if (xmlAnim.hasAttribute("repeatCount")) {
                String repeatValue = xmlAnim.getAttributeValue("repeatCount");
                if (repeatValue.equals("indefinite")) {
                    animation.setCycleCount(-1);
                } else {
                    int count = ParserUtils.parseIntProtected(repeatValue);
                    animation.setCycleCount(count);
                }
            }
            if (parallel != null) {
                parallel.getChildren().add((Object)animation);
                return null;
            }
            return animation;
        }
        return null;
    }

    private static Transition buildAnimateMotion(XMLNode xmlNode, XMLNode xmlAnim, Node node, ParallelTransition parallel, Viewport viewport) {
        String begin;
        Duration beginDur;
        if (!xmlAnim.hasAttribute("path")) {
            return null;
        }
        String content = xmlAnim.getAttributeValue("path");
        content = content.replace('\u2212', '-');
        content = PathParser.parsePathContent(content, viewport);
        Duration duration = Duration.ZERO;
        if (xmlAnim.hasAttribute("dur")) {
            duration = AnimationBuilder.parseDuration(xmlAnim.getAttributeValue("dur"));
        }
        SVGPath path = new SVGPath();
        path.setContent(content);
        PathTransition transition = parallel != null ? new PathTransition(duration, (Shape)path) : new PathTransition(duration, (Shape)path, node);
        transition.setDuration(duration);
        if (xmlAnim.hasAttribute("repeatCount")) {
            String repeatValue = xmlAnim.getAttributeValue("repeatCount");
            if (repeatValue.equals("indefinite")) {
                transition.setCycleCount(-1);
            } else {
                int count = ParserUtils.parseIntProtected(repeatValue);
                transition.setCycleCount(count);
            }
        }
        if (xmlAnim.hasAttribute("begin") && (beginDur = AnimationBuilder.parseDuration(begin = xmlAnim.getAttributeValue("begin"))) != null) {
            transition.setDelay(beginDur);
        }
        return transition;
    }

    private static Transition buildAnimateTransform(XMLNode xmlNode, XMLNode xmlAnim, Node node, ParallelTransition parallel, Viewport viewport) {
        List<Double> fromArgs = AnimationBuilder.getFromArguments(xmlAnim, viewport);
        List<Double> toArgs = AnimationBuilder.getToArguments(xmlAnim, viewport);
        if (fromArgs == null || toArgs == null) {
            return null;
        }
        int type = 0;
        if (xmlAnim.hasAttribute("type")) {
            switch (xmlAnim.getAttributeValue("type")) {
                case "scale": {
                    type = 1;
                    break;
                }
                case "rotate": {
                    type = 2;
                    break;
                }
                case "skewX": {
                    type = 3;
                    break;
                }
                case "skewY": {
                    type = 4;
                }
            }
        }
        Duration duration = Duration.ZERO;
        if (xmlAnim.hasAttribute("dur")) {
            duration = AnimationBuilder.parseDuration(xmlAnim.getAttributeValue("dur"));
        }
        RotateTransition transition = null;
        switch (type) {
            case 2: {
                RotateTransition rotate = parallel != null ? new RotateTransition(duration) : new RotateTransition(duration, node);
                rotate.setDuration(duration);
                transition = rotate;
                if (fromArgs.size() == 1) {
                    rotate.setFromAngle(fromArgs.get(0).doubleValue());
                } else if (fromArgs.size() == 3) {
                    rotate.setFromAngle(fromArgs.get(0).doubleValue());
                }
                if (toArgs.size() < 1) break;
                rotate.setToAngle(toArgs.get(0).doubleValue());
                break;
            }
            case 0: {
                TranslateTransition translate = parallel != null ? new TranslateTransition(duration) : new TranslateTransition(duration, node);
                translate.setDuration(duration);
                transition = translate;
                if (fromArgs.size() == 2) {
                    translate.setFromX(fromArgs.get(0).doubleValue());
                    translate.setFromY(fromArgs.get(1).doubleValue());
                } else if (fromArgs.size() == 1) {
                    translate.setFromX(fromArgs.get(0).doubleValue());
                }
                if (toArgs.size() == 2) {
                    translate.setToX(toArgs.get(0).doubleValue());
                    translate.setToY(toArgs.get(1).doubleValue());
                    break;
                }
                if (toArgs.size() != 1) break;
                translate.setToX(toArgs.get(0).doubleValue());
                break;
            }
            case 1: {
                ScaleTransition scale = parallel != null ? new ScaleTransition(duration) : new ScaleTransition(duration, node);
                scale.setDuration(duration);
                transition = scale;
                if (fromArgs.size() == 1) {
                    scale.setFromX(fromArgs.get(0).doubleValue());
                    scale.setFromY(fromArgs.get(0).doubleValue());
                } else if (fromArgs.size() == 2) {
                    scale.setFromX(fromArgs.get(0).doubleValue());
                    scale.setFromY(fromArgs.get(1).doubleValue());
                }
                if (toArgs.size() == 1) {
                    scale.setToX(toArgs.get(0).doubleValue());
                    scale.setToY(toArgs.get(0).doubleValue());
                    break;
                }
                if (toArgs.size() != 2) break;
                scale.setToX(toArgs.get(0).doubleValue());
                scale.setToY(toArgs.get(1).doubleValue());
            }
        }
        if (transition != null) {
            String begin;
            Duration beginDur;
            if (xmlAnim.hasAttribute("repeatCount")) {
                String repeatValue = xmlAnim.getAttributeValue("repeatCount");
                if (repeatValue.equals("indefinite")) {
                    transition.setCycleCount(-1);
                } else {
                    int count = ParserUtils.parseIntProtected(repeatValue);
                    transition.setCycleCount(count);
                }
            }
            if (xmlAnim.hasAttribute("begin") && (beginDur = AnimationBuilder.parseDuration(begin = xmlAnim.getAttributeValue("begin"))) != null) {
                transition.setDelay(beginDur);
            }
            if (parallel != null) {
                parallel.getChildren().add((Object)transition);
                return null;
            }
            return transition;
        }
        return null;
    }

    private static Color getFromColorArgument(XMLNode xmlAnim) {
        if (xmlAnim.hasAttribute("from")) {
            String content = xmlAnim.getAttributeValue("from");
            return ParserUtils.getColor(content);
        }
        return null;
    }

    private static Color getToColorArgument(XMLNode xmlAnim) {
        if (xmlAnim.hasAttribute("to")) {
            String content = xmlAnim.getAttributeValue("to");
            return ParserUtils.getColor(content);
        }
        return null;
    }

    private static boolean getFromVisibilityArgument(XMLNode xmlAnim) {
        if (xmlAnim.hasAttribute("from")) {
            String content = xmlAnim.getAttributeValue("from");
            return ParserUtils.parseVisibility(content);
        }
        return true;
    }

    private static boolean getToVisibilityArgument(XMLNode xmlAnim) {
        if (xmlAnim.hasAttribute("to")) {
            String content = xmlAnim.getAttributeValue("to");
            return ParserUtils.parseVisibility(content);
        }
        return true;
    }

    private static List<Double> getFromArguments(XMLNode xmlAnim, Viewport viewport) {
        if (xmlAnim.hasAttribute("from")) {
            String content = xmlAnim.getAttributeValue("from");
            return TransformUtils.getTransformArgumentsForAnimation(content, viewport);
        }
        return null;
    }

    private static List<Double> getToArguments(XMLNode xmlAnim, Viewport viewport) {
        if (xmlAnim.hasAttribute("to")) {
            String content = xmlAnim.getAttributeValue("to");
            return TransformUtils.getTransformArgumentsForAnimation(content, viewport);
        }
        return null;
    }
}

