/*
 * Decompiled with CFR 0.152.
 */
package dataHandling.mySQL;

import dataHandling.mySQL.CustomMySQLAdapter;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import weka.classifiers.AbstractClassifier;
import weka.core.Attribute;
import weka.core.DenseInstance;
import weka.core.FastVector;
import weka.core.Instance;
import weka.core.Instances;

public class MetaDataDataBaseConnection {
    public static final String COLUMN_LABEL_METAFEATURE_COMPUTATION_TIME = "time";
    public static final String COLUMN_LABEL_METAFEATURE_RUN_ID = "metafeature_run_id";
    public static final String COLUMN_LABEL_METAFEATURE_VALUE = "metafeature_value";
    public static final String COLUMN_LABEL_METAFEATURE_SET_NAME = "metafeature_set_name";
    public static final String COLUMN_LABEL_METAFEATURE_GROUP_NAME = "metafeature_group";
    public static final String COLUMN_LABEL_METAFEATURE_NAME = "metafeature_name";
    public static final String TABLE_NAME_METAFEATURE_VALUES = "metafeature_values";
    public static final String TABLE_NAME_METAFEATURE_TIMES = "metafeature_times";
    public static final String TABLE_NAME_METAFEATURE_SET_MEMBERS = "metafeature_set_members";
    public static final String TABLE_NAME_METAFEATURE_SETS = "metafeature_sets";
    public static final String TABLE_NAME_METAFEATURE_GROUP_MEMBERS = "metafeature_group_members";
    public static final String TABLE_NAME_METAFEATURE_GROUPS = "metafeature_groups";
    public static final String TABLE_NAME_METAFEATURE_RUNS = "metafeature_runs";
    public static final String TABLE_NAME_DATASET_SETS = "dataset_sets";
    public static final String TABLE_NAME_DATASET_SET_MEMBERS = "dataset_set_members";
    public static final String COLUMN_LABEL_DATASET_ID = "dataset_id";
    public static final String COLUMN_LABEL_DATASET_ORIGIN = "dataset_origin";
    public static final String COLUMN_LABEL_DATASET_NAME = "dataset_name";
    public static final String COLUMN_LABEL_DATASET_SET_NAME = "dataset_set_name";
    public static final String TABLE_NAME_CLASSIFIER_SETS = "classifier_sets";
    public static final String TABLE_NAME_CLASSIFIER_SET_MEMBERS = "classifier_set_members";
    public static final String TABLE_NAME_CLASSIFIER_RUNS = "classifier_runs";
    public static final String COLUMN_LABEL_CLASSIFIER_RUN_ID = "classifier_run_id";
    public static final String COLUMN_LABEL_CLASSIFIER_NAME = "classifier_name";
    public static final String COLUMN_LABEL_CLASSIFIER_CONFIGURATION = "classifier_configuration";
    public static final String COLUMN_LABEL_CLASSIFIER_PERFORMANCE = "predictive_accuracy";
    public static final String COLUMN_LABEL_CLASSIFIER_SET_NAME = "classifier_set_name";
    public static final String COLUMN_LABEL_CLASSIFIER_EVALUATION_METHOD = "classifier_evaluation_method";
    public static final String COLUMN_LABEL_JOB_STATUS = "status";
    public static final String JOB_STATUS_CREATED = "created";
    public static final String JOB_STATUS_RUNNING = "running";
    public static final String JOB_STATUS_FINISHED = "finished";
    public static final String JOB_STATUS_ERROR = "error";
    public static final String dataset_origin_separator = ":";
    public static final String CLASSIFIER_NAME_CONFIG_SEPARATOR = " with configuration: ";
    private String host;
    private String user;
    private String password;
    private String database;
    private CustomMySQLAdapter adapter;

    public MetaDataDataBaseConnection(String host, String user, String password, String database) {
        this.host = host;
        this.user = user;
        this.password = password;
        this.database = database;
    }

    public Instances getClassifierPerformancesForDataSet(Integer datasetId, String datasetOrigin, String classifierSetName) throws SQLException {
        ArrayList<String> classifierSetMembers = this.getMembersOfClassifierSet(classifierSetName);
        String query = String.format("SELECT * FROM (SELECT %s, %s, %s, %s, %s FROM %s WHERE %s=? AND %s =?) AS selected_runs INNER JOIN (SELECT %s, %s FROM %s WHERE %s=?) AS selected_classifiers ON selected_runs.%s=selected_classifiers.%s  AND selected_runs.%s=selected_classifiers.%s", COLUMN_LABEL_DATASET_ID, COLUMN_LABEL_DATASET_ORIGIN, COLUMN_LABEL_CLASSIFIER_NAME, COLUMN_LABEL_CLASSIFIER_CONFIGURATION, COLUMN_LABEL_CLASSIFIER_PERFORMANCE, TABLE_NAME_CLASSIFIER_RUNS, COLUMN_LABEL_DATASET_ID, COLUMN_LABEL_DATASET_ORIGIN, COLUMN_LABEL_CLASSIFIER_NAME, COLUMN_LABEL_CLASSIFIER_CONFIGURATION, TABLE_NAME_CLASSIFIER_SET_MEMBERS, COLUMN_LABEL_CLASSIFIER_SET_NAME, COLUMN_LABEL_CLASSIFIER_NAME, COLUMN_LABEL_CLASSIFIER_NAME, COLUMN_LABEL_CLASSIFIER_CONFIGURATION, COLUMN_LABEL_CLASSIFIER_CONFIGURATION);
        this.openConnection();
        ResultSet resultSet = this.adapter.getResultsOfQuery(query, Arrays.asList(datasetId.toString(), datasetOrigin, classifierSetName));
        Instances result = this.getInstancesFromResultSetForClassifiers(resultSet, Arrays.asList(this.merge(datasetId, datasetOrigin)), classifierSetMembers, datasetId + "_" + classifierSetName + "_performanceValues");
        this.closeConnection();
        return result;
    }

    public Instances getClassifierPerformancesForDataSetSet(String dataSetSetName, String classifierSetName) throws SQLException {
        ArrayList<String> classifierSetMembers = this.getMembersOfClassifierSet(classifierSetName);
        ArrayList<String> datasetIds = this.getMembersOfDatasetSet(dataSetSetName);
        String query = String.format("SELECT * FROM (SELECT %s, %s, %s, %s, %s FROM %s WHERE EXISTS (SELECT * FROM %s WHERE %s=? AND %s.%s=%s.%s AND %s.%s=%s.%s)) AS selected_runs INNER JOIN (SELECT %s, %s FROM %s WHERE %s=?) AS selected_classifiers ON selected_runs.%s=selected_classifiers.%s  AND selected_runs.%s=selected_classifiers.%s", COLUMN_LABEL_DATASET_ID, COLUMN_LABEL_DATASET_ORIGIN, COLUMN_LABEL_CLASSIFIER_NAME, COLUMN_LABEL_CLASSIFIER_CONFIGURATION, COLUMN_LABEL_CLASSIFIER_PERFORMANCE, TABLE_NAME_CLASSIFIER_RUNS, TABLE_NAME_DATASET_SET_MEMBERS, COLUMN_LABEL_DATASET_SET_NAME, TABLE_NAME_CLASSIFIER_RUNS, COLUMN_LABEL_DATASET_ID, TABLE_NAME_DATASET_SET_MEMBERS, COLUMN_LABEL_DATASET_ID, TABLE_NAME_CLASSIFIER_RUNS, COLUMN_LABEL_DATASET_ORIGIN, TABLE_NAME_DATASET_SET_MEMBERS, COLUMN_LABEL_DATASET_ORIGIN, COLUMN_LABEL_CLASSIFIER_NAME, COLUMN_LABEL_CLASSIFIER_CONFIGURATION, TABLE_NAME_CLASSIFIER_SET_MEMBERS, COLUMN_LABEL_CLASSIFIER_SET_NAME, COLUMN_LABEL_CLASSIFIER_NAME, COLUMN_LABEL_CLASSIFIER_NAME, COLUMN_LABEL_CLASSIFIER_CONFIGURATION, COLUMN_LABEL_CLASSIFIER_CONFIGURATION);
        this.openConnection();
        ResultSet resultSet = this.adapter.getResultsOfQuery(query, Arrays.asList(dataSetSetName, classifierSetName));
        Instances result = this.getInstancesFromResultSetForClassifiers(resultSet, datasetIds, classifierSetMembers, dataSetSetName + "_" + classifierSetName + "_performanceValues");
        this.closeConnection();
        return result;
    }

    public Instances getMetaDataSetForDataSet(Integer datasetId, String datasetOrigin, String metaDataSetName) throws SQLException {
        ArrayList<String> metaDataSetMembers = this.getMembersOfMetadataSet(metaDataSetName);
        String query = String.format("SELECT %s, %s, %s, %s FROM (SELECT %s, %s, %s FROM %s WHERE %s=? AND %s=?) AS selected_runs INNER JOIN %s ON selected_runs.%s=%s.%s WHERE %s IN (SELECT %s FROM %s WHERE %s=?)", COLUMN_LABEL_DATASET_ID, COLUMN_LABEL_DATASET_ORIGIN, COLUMN_LABEL_METAFEATURE_NAME, COLUMN_LABEL_METAFEATURE_VALUE, COLUMN_LABEL_METAFEATURE_RUN_ID, COLUMN_LABEL_DATASET_ID, COLUMN_LABEL_DATASET_ORIGIN, TABLE_NAME_METAFEATURE_RUNS, COLUMN_LABEL_DATASET_ID, COLUMN_LABEL_DATASET_ORIGIN, TABLE_NAME_METAFEATURE_VALUES, COLUMN_LABEL_METAFEATURE_RUN_ID, TABLE_NAME_METAFEATURE_VALUES, COLUMN_LABEL_METAFEATURE_RUN_ID, COLUMN_LABEL_METAFEATURE_NAME, COLUMN_LABEL_METAFEATURE_NAME, TABLE_NAME_METAFEATURE_SET_MEMBERS, COLUMN_LABEL_METAFEATURE_SET_NAME);
        this.openConnection();
        ResultSet resultSet = this.adapter.getResultsOfQuery(query, Arrays.asList(datasetId.toString(), datasetOrigin, metaDataSetName));
        Instances result = this.getInstancesFromResultSetForMetaData(resultSet, Arrays.asList(this.merge(datasetId, datasetOrigin)), metaDataSetMembers, datasetId + "_" + metaDataSetName + "_metafeatures");
        this.closeConnection();
        return result;
    }

    public Instances getMetaDataSetForDataSetSet(String dataSetSetName, String metaDataSetSetName) throws SQLException {
        ArrayList<String> datasetIds = this.getMembersOfDatasetSet(dataSetSetName);
        ArrayList<String> metaDataSetMembers = this.getMembersOfMetadataSet(metaDataSetSetName);
        String query = String.format("SELECT %s, %s, %s, %s FROM (SELECT %s, %s, %s FROM %s WHERE EXISTS (SELECT * FROM %s WHERE %s=? AND %s.%s=%s.%s AND %s.%s=%s.%s)) AS selected_runs INNER JOIN %s ON selected_runs.%s=%s.%s WHERE %s IN (SELECT %s FROM %s WHERE %s=?) ORDER BY %s, %s", COLUMN_LABEL_DATASET_ID, COLUMN_LABEL_DATASET_ORIGIN, COLUMN_LABEL_METAFEATURE_NAME, COLUMN_LABEL_METAFEATURE_VALUE, COLUMN_LABEL_METAFEATURE_RUN_ID, COLUMN_LABEL_DATASET_ID, COLUMN_LABEL_DATASET_ORIGIN, TABLE_NAME_METAFEATURE_RUNS, TABLE_NAME_DATASET_SET_MEMBERS, COLUMN_LABEL_DATASET_SET_NAME, TABLE_NAME_METAFEATURE_RUNS, COLUMN_LABEL_DATASET_ID, TABLE_NAME_DATASET_SET_MEMBERS, COLUMN_LABEL_DATASET_ID, TABLE_NAME_METAFEATURE_RUNS, COLUMN_LABEL_DATASET_ORIGIN, TABLE_NAME_DATASET_SET_MEMBERS, COLUMN_LABEL_DATASET_ORIGIN, TABLE_NAME_METAFEATURE_VALUES, COLUMN_LABEL_METAFEATURE_RUN_ID, TABLE_NAME_METAFEATURE_VALUES, COLUMN_LABEL_METAFEATURE_RUN_ID, COLUMN_LABEL_METAFEATURE_NAME, COLUMN_LABEL_METAFEATURE_NAME, TABLE_NAME_METAFEATURE_SET_MEMBERS, COLUMN_LABEL_METAFEATURE_SET_NAME, COLUMN_LABEL_DATASET_ID, COLUMN_LABEL_DATASET_ORIGIN);
        this.openConnection();
        ResultSet resultSet = this.adapter.getResultsOfQuery(query, Arrays.asList(dataSetSetName, metaDataSetSetName));
        Instances result = this.getInstancesFromResultSetForMetaData(resultSet, datasetIds, metaDataSetMembers, dataSetSetName + "_" + metaDataSetSetName);
        this.closeConnection();
        return result;
    }

    public ArrayList<String> getMembersOfClassifierSet(String setName) throws SQLException {
        this.openConnection();
        String query = String.format("SELECT %s,%s FROM %s WHERE %s=? ORDER BY %s, %s", COLUMN_LABEL_CLASSIFIER_NAME, COLUMN_LABEL_CLASSIFIER_CONFIGURATION, TABLE_NAME_CLASSIFIER_SET_MEMBERS, COLUMN_LABEL_CLASSIFIER_SET_NAME, COLUMN_LABEL_CLASSIFIER_NAME, COLUMN_LABEL_CLASSIFIER_CONFIGURATION);
        ResultSet resultSet = this.adapter.getResultsOfQuery(query, Arrays.asList(setName));
        ArrayList<String> classifierSetMembers = new ArrayList<String>();
        while (resultSet.next()) {
            String classifierName = resultSet.getString(COLUMN_LABEL_CLASSIFIER_NAME);
            String classifierConfig = resultSet.getString(COLUMN_LABEL_CLASSIFIER_CONFIGURATION);
            classifierSetMembers.add(classifierName + CLASSIFIER_NAME_CONFIG_SEPARATOR + classifierConfig);
        }
        this.closeConnection();
        return classifierSetMembers;
    }

    public ArrayList<String> getMembersOfMetadataSet(String setName) throws SQLException {
        this.openConnection();
        String query = String.format("SELECT %s FROM %s WHERE %s=? ORDER BY %s", COLUMN_LABEL_METAFEATURE_NAME, TABLE_NAME_METAFEATURE_SET_MEMBERS, COLUMN_LABEL_METAFEATURE_SET_NAME, COLUMN_LABEL_METAFEATURE_NAME);
        ResultSet resultSet = this.adapter.getResultsOfQuery(query, Arrays.asList(setName));
        ArrayList<String> metaDataSetMembers = new ArrayList<String>();
        while (resultSet.next()) {
            String metafeatureName = resultSet.getString(COLUMN_LABEL_METAFEATURE_NAME);
            metaDataSetMembers.add(metafeatureName);
        }
        this.closeConnection();
        return metaDataSetMembers;
    }

    public ArrayList<String> getMembersOfDatasetSet(String setName) throws SQLException {
        this.openConnection();
        String query = String.format("SELECT %s, %s FROM %s WHERE %s=? ORDER BY %s, %s", COLUMN_LABEL_DATASET_ID, COLUMN_LABEL_DATASET_ORIGIN, TABLE_NAME_DATASET_SET_MEMBERS, COLUMN_LABEL_DATASET_SET_NAME, COLUMN_LABEL_DATASET_ID, COLUMN_LABEL_DATASET_ORIGIN);
        ResultSet resultSet = this.adapter.getResultsOfQuery(query, Arrays.asList(setName));
        TreeSet<String> metaDataSetMembers = new TreeSet<String>();
        while (resultSet.next()) {
            int datasetId = resultSet.getInt(COLUMN_LABEL_DATASET_ID);
            String datasetOrigin = resultSet.getString(COLUMN_LABEL_DATASET_ORIGIN);
            metaDataSetMembers.add(this.merge(datasetId, datasetOrigin));
        }
        this.closeConnection();
        System.out.println(metaDataSetMembers);
        System.out.println(((String)new ArrayList(metaDataSetMembers).get(0)).getClass().getName());
        return new ArrayList<String>(metaDataSetMembers);
    }

    public List<String> getAvailableClassifierSets() throws SQLException {
        return this.getAvailableSets(COLUMN_LABEL_CLASSIFIER_SET_NAME, TABLE_NAME_CLASSIFIER_SETS);
    }

    public List<String> getAvailableMetaDataSets() throws SQLException {
        return this.getAvailableSets(COLUMN_LABEL_METAFEATURE_SET_NAME, TABLE_NAME_METAFEATURE_SETS);
    }

    public List<String> getAvailableDataSetSets() throws SQLException {
        return this.getAvailableSets(COLUMN_LABEL_DATASET_SET_NAME, TABLE_NAME_DATASET_SETS);
    }

    public void addClassifierPerformance(int datasetId, String datasetOrigin, String classifierWithConfig, String evaluationMethod, double performance) throws SQLException {
        int runId = this.addClassifierExperiment(datasetId, datasetOrigin, classifierWithConfig, evaluationMethod);
        this.addClassifierPerformanceForRun(runId, performance);
    }

    public void addClassifierPerformanceForRun(int runId, double performance) throws SQLException {
        this.openConnection();
        HashMap<String, Integer> conditions = new HashMap<String, Integer>();
        conditions.put(COLUMN_LABEL_CLASSIFIER_RUN_ID, runId);
        HashMap<String, Object> updateValues = new HashMap<String, Object>();
        updateValues.put(COLUMN_LABEL_CLASSIFIER_PERFORMANCE, Double.isNaN(performance) ? -1.0 : performance);
        updateValues.put(COLUMN_LABEL_JOB_STATUS, JOB_STATUS_FINISHED);
        try {
            this.adapter.update(TABLE_NAME_CLASSIFIER_RUNS, updateValues, conditions);
        }
        catch (SQLException e) {
            System.err.println("Could not add classifier performance for run " + runId + " with performance value " + performance);
            throw e;
        }
        this.closeConnection();
    }

    public int addClassifierExperiment(int datasetId, String datasetOrigin, String classifierWithConfig, String evaluationMethod) throws SQLException {
        int runId;
        this.openConnection();
        String[] classifierNameAndConfig = classifierWithConfig.split(CLASSIFIER_NAME_CONFIG_SEPARATOR);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(COLUMN_LABEL_DATASET_ID, datasetId);
        map.put(COLUMN_LABEL_DATASET_ORIGIN, datasetOrigin);
        map.put(COLUMN_LABEL_CLASSIFIER_NAME, classifierNameAndConfig[0]);
        map.put(COLUMN_LABEL_CLASSIFIER_CONFIGURATION, classifierNameAndConfig[1]);
        map.put(COLUMN_LABEL_CLASSIFIER_EVALUATION_METHOD, evaluationMethod);
        try {
            runId = this.adapter.insert(TABLE_NAME_CLASSIFIER_RUNS, map);
        }
        catch (SQLException e) {
            System.err.println("Could not add classifier experiment: datasetId " + datasetId + "datasetOrigin" + datasetOrigin + " classifier " + classifierWithConfig + " evaluation method " + evaluationMethod);
            throw e;
        }
        this.closeConnection();
        return runId;
    }

    public void addMetaDataForDataSet(int datasetId, String datasetOrigin, HashMap<String, Double> featureValues, HashMap<String, Double> groupTimes, Integer runId) throws SQLException {
        int createdRunId = runId == null ? this.addMetaFeatureExperiment(datasetId, datasetOrigin) : runId.intValue();
        this.openConnection();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(COLUMN_LABEL_METAFEATURE_RUN_ID, createdRunId);
        for (Map.Entry<String, Double> entry : groupTimes.entrySet()) {
            map.put(COLUMN_LABEL_METAFEATURE_GROUP_NAME, entry.getKey());
            map.put(COLUMN_LABEL_METAFEATURE_COMPUTATION_TIME, entry.getValue());
            this.adapter.insert_noNewValues(TABLE_NAME_METAFEATURE_TIMES, map);
        }
        map = new HashMap();
        map.put(COLUMN_LABEL_METAFEATURE_RUN_ID, createdRunId);
        for (Map.Entry<String, Double> entry : featureValues.entrySet()) {
            map.put(COLUMN_LABEL_METAFEATURE_NAME, entry.getKey());
            double metafeatureValue = entry.getValue();
            map.put(COLUMN_LABEL_METAFEATURE_VALUE, Double.isNaN(metafeatureValue) ? -1.0 : metafeatureValue);
            this.adapter.insert_noNewValues(TABLE_NAME_METAFEATURE_VALUES, map);
        }
        HashMap<String, Integer> conditions = new HashMap<String, Integer>();
        conditions.put(COLUMN_LABEL_METAFEATURE_RUN_ID, createdRunId);
        HashMap<String, String> updateValues = new HashMap<String, String>();
        updateValues.put(COLUMN_LABEL_JOB_STATUS, JOB_STATUS_FINISHED);
        this.adapter.update(TABLE_NAME_METAFEATURE_RUNS, updateValues, conditions);
        this.closeConnection();
    }

    public int addMetaFeatureExperiment(int datasetId, String datasetOrigin) throws SQLException {
        this.openConnection();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(COLUMN_LABEL_DATASET_ID, datasetId);
        map.put(COLUMN_LABEL_DATASET_ORIGIN, datasetOrigin);
        int runId = this.adapter.insert(TABLE_NAME_METAFEATURE_RUNS, map);
        this.closeConnection();
        return runId;
    }

    public void addClassifierSet(String setName, List<AbstractClassifier> members) throws SQLException {
        this.openConnection();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(COLUMN_LABEL_CLASSIFIER_SET_NAME, setName);
        this.adapter.insert_noNewValues(TABLE_NAME_CLASSIFIER_SETS, map);
        map = new HashMap();
        map.put(COLUMN_LABEL_CLASSIFIER_SET_NAME, setName);
        for (AbstractClassifier member : members) {
            map.put(COLUMN_LABEL_CLASSIFIER_NAME, member.getClass().getName());
            map.put(COLUMN_LABEL_CLASSIFIER_CONFIGURATION, Arrays.toString(member.getOptions()));
            this.adapter.insert_noNewValues(TABLE_NAME_CLASSIFIER_SET_MEMBERS, map);
        }
        this.closeConnection();
    }

    public void addMetaDataSet(String setName, List<String> members) throws SQLException {
        this.openConnection();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(COLUMN_LABEL_METAFEATURE_SET_NAME, setName);
        this.adapter.insert_noNewValues(TABLE_NAME_METAFEATURE_SETS, map);
        map = new HashMap();
        map.put(COLUMN_LABEL_METAFEATURE_SET_NAME, setName);
        for (String member : members) {
            map.put(COLUMN_LABEL_METAFEATURE_NAME, member);
            this.adapter.insert_noNewValues(TABLE_NAME_METAFEATURE_SET_MEMBERS, map);
        }
        this.closeConnection();
    }

    public void addDatasetSet(String setName, List<Integer> memberIds, List<String> memberOrigins) throws SQLException {
        this.openConnection();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(COLUMN_LABEL_DATASET_SET_NAME, setName);
        this.adapter.insert_noNewValues(TABLE_NAME_DATASET_SETS, map);
        map = new HashMap();
        map.put(COLUMN_LABEL_DATASET_SET_NAME, setName);
        for (int i = 0; i < memberIds.size(); ++i) {
            map.put(COLUMN_LABEL_DATASET_ID, memberIds.get(i).toString());
            map.put(COLUMN_LABEL_DATASET_ORIGIN, memberOrigins.get(i));
            this.adapter.insert_noNewValues(TABLE_NAME_DATASET_SET_MEMBERS, map);
        }
        this.closeConnection();
    }

    public void addMetaFeatureGroup(Map<String, List<String>> metafeatureGroups) {
        this.openConnection();
        HashMap map = new HashMap();
        metafeatureGroups.forEach((name, list) -> {
            map.clear();
            list.forEach(elem -> {
                map.put(COLUMN_LABEL_METAFEATURE_GROUP_NAME, name);
                map.put(COLUMN_LABEL_METAFEATURE_NAME, elem);
                try {
                    this.adapter.insert_noNewValues(TABLE_NAME_METAFEATURE_GROUPS, map);
                }
                catch (SQLException e) {
                    throw new RuntimeException(e.getMessage());
                }
                System.out.println(name + " " + elem);
            });
        });
        this.closeConnection();
    }

    public static String[] convertOptionsStringToArray(String serializedOptions) {
        return (String[])Arrays.stream(serializedOptions.substring(1, serializedOptions.length() - 1).split(",")).map(String::trim).toArray(String[]::new);
    }

    public static String convertOptionsArrayToString(String[] options) {
        return Arrays.toString(options);
    }

    private Instances getInstancesFromResultSetForClassifiers(ResultSet resultSet, List<String> datasetIdentifiers, List<String> classifierSetMembers, String instancesName) throws SQLException {
        ArrayList<Attribute> attributes = new ArrayList<Attribute>();
        attributes.add(new Attribute(COLUMN_LABEL_DATASET_ID, (List)((FastVector)null)));
        classifierSetMembers.forEach(member -> attributes.add(new Attribute(member)));
        Instances instances = new Instances(instancesName, attributes, 0);
        TreeMap<String, DenseInstance> instancesForDataSets = new TreeMap<String, DenseInstance>();
        for (int i = 0; i < datasetIdentifiers.size(); ++i) {
            double[] values = new double[attributes.size()];
            Arrays.fill(values, Double.NaN);
            DenseInstance instance = new DenseInstance(1.0, values);
            instancesForDataSets.put(datasetIdentifiers.get(i), instance);
        }
        while (resultSet.next()) {
            Integer dataSetId = resultSet.getInt(COLUMN_LABEL_DATASET_ID);
            String datasetOrigin = resultSet.getString(COLUMN_LABEL_DATASET_ORIGIN);
            String classifierName = resultSet.getString(COLUMN_LABEL_CLASSIFIER_NAME);
            String classifierConfiguration = resultSet.getString(COLUMN_LABEL_CLASSIFIER_CONFIGURATION);
            Double performanceValue = resultSet.getDouble(COLUMN_LABEL_CLASSIFIER_PERFORMANCE);
            performanceValue = performanceValue == -1.0 ? Double.NaN : performanceValue;
            ((DenseInstance)instancesForDataSets.get(this.merge(dataSetId, datasetOrigin))).setValue(instances.attribute(classifierName + CLASSIFIER_NAME_CONFIG_SEPARATOR + classifierConfiguration).index(), performanceValue.doubleValue());
        }
        for (String datasetId_with_origin : instancesForDataSets.navigableKeySet()) {
            instances.add((Instance)instancesForDataSets.get(datasetId_with_origin));
            instances.get(instances.numInstances() - 1).setValue(0, datasetId_with_origin);
        }
        return instances;
    }

    private Instances getInstancesFromResultSetForMetaData(ResultSet resultSet, List<String> datasetIdentifiers, List<String> metaDataSetMembers, String instancesName) throws SQLException {
        ArrayList<Attribute> attributes = new ArrayList<Attribute>();
        attributes.add(new Attribute(COLUMN_LABEL_DATASET_ID, (List)((FastVector)null)));
        metaDataSetMembers.forEach(member -> attributes.add(new Attribute(member)));
        Instances instances = new Instances(instancesName, attributes, 0);
        TreeMap<String, DenseInstance> instancesForDataSets = new TreeMap<String, DenseInstance>();
        for (int i = 0; i < datasetIdentifiers.size(); ++i) {
            double[] values = new double[attributes.size()];
            Arrays.fill(values, Double.NaN);
            DenseInstance instance = new DenseInstance(1.0, values);
            instancesForDataSets.put(datasetIdentifiers.get(i), instance);
        }
        while (resultSet.next()) {
            Integer dataSetId = resultSet.getInt(COLUMN_LABEL_DATASET_ID);
            String datasetOrigin = resultSet.getString(COLUMN_LABEL_DATASET_ORIGIN);
            String metafeatureName = resultSet.getString(COLUMN_LABEL_METAFEATURE_NAME);
            Double metafeatureValue = resultSet.getDouble(COLUMN_LABEL_METAFEATURE_VALUE);
            metafeatureValue = metafeatureValue == -1.0 ? Double.NaN : metafeatureValue;
            ((DenseInstance)instancesForDataSets.get(this.merge(dataSetId, datasetOrigin))).setValue(instances.attribute(metafeatureName).index(), metafeatureValue.doubleValue());
        }
        for (String datasetId_with_origin : instancesForDataSets.navigableKeySet()) {
            instances.add((Instance)instancesForDataSets.get(datasetId_with_origin));
            instances.get(instances.numInstances() - 1).setValue(0, datasetId_with_origin);
        }
        return instances;
    }

    private List<String> getAvailableSets(String setNameColumn, String table) throws SQLException {
        String query = String.format("SELECT DISTINCT %s FROM %s", setNameColumn, table);
        this.openConnection();
        ResultSet resultSet = this.adapter.getResultsOfQuery(query);
        ArrayList<String> availableSets = new ArrayList<String>();
        while (resultSet.next()) {
            String setName = resultSet.getString(setNameColumn);
            availableSets.add(setName);
        }
        this.closeConnection();
        return availableSets;
    }

    private String merge(int datasetId, String datasetOrigin) {
        return datasetId + dataset_origin_separator + datasetOrigin;
    }

    private void openConnection() {
        this.adapter = new CustomMySQLAdapter(this.host, this.user, this.password, this.database);
    }

    private void closeConnection() {
        this.adapter.close();
    }
}

