/*
 * Decompiled with CFR 0.152.
 */
package dataHandling.mySQL;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang3.math.NumberUtils;

public class CustomMySQLAdapter
implements Serializable,
AutoCloseable {
    private final String driver;
    private final String host;
    private final String user;
    private final String password;
    private final String database;
    private Connection connect;
    private long timestampOfLastAction = Long.MIN_VALUE;
    private final Properties connectionProperties;

    public CustomMySQLAdapter(String host, String user, String password, String database) {
        this("mysql", host, user, password, database, new Properties());
    }

    public CustomMySQLAdapter(String driver, String host, String user, String password, String database, Properties connectionProperties) {
        this.driver = driver;
        this.host = host;
        this.user = user;
        this.password = password;
        this.database = database;
        this.connectionProperties = connectionProperties;
        Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

            @Override
            public void run() {
                System.out.println("Closing MySQL Connection");
                CustomMySQLAdapter.this.close();
            }
        }));
    }

    private void connect() throws SQLException {
        int tries = 0;
        while (true) {
            try {
                Properties connectionProps = new Properties(this.connectionProperties);
                connectionProps.put("user", this.user);
                connectionProps.put("password", this.password);
                this.connect = DriverManager.getConnection("jdbc:" + this.driver + "://" + this.host + "/" + this.database + "?verifyServerCertificate=false&requireSSL=true&useSSL=true", connectionProps);
                return;
            }
            catch (SQLException e) {
                System.err.println("Connection to server " + this.host + " failed with JDBC driver " + this.driver + " (attempt " + ++tries + " of 3), waiting 3 seconds and trying again.");
                e.printStackTrace();
                try {
                    Thread.sleep(3000L);
                    continue;
                }
                catch (InterruptedException e1) {
                    e1.printStackTrace();
                }
                if (tries < 3) continue;
                System.err.println("Quitting execution");
                System.exit(1);
                return;
            }
            break;
        }
    }

    public synchronized void checkConnection() throws SQLException {
        int renewAfterSeconds = 300;
        if (this.timestampOfLastAction + (long)(renewAfterSeconds * 1000) < System.currentTimeMillis()) {
            System.out.println("Reconnect to database");
            this.close();
            this.connect();
        }
        this.timestampOfLastAction = System.currentTimeMillis();
    }

    public ResultSet getRowsOfTable(String table) throws SQLException {
        return this.getRowsOfTable(table, new HashMap<String, String>());
    }

    public ResultSet getRowsOfTable(String table, Map<String, String> conditions) throws SQLException {
        StringBuilder conditionSB = new StringBuilder();
        ArrayList<String> values = new ArrayList<String>();
        for (String key : conditions.keySet()) {
            if (conditionSB.length() > 0) {
                conditionSB.append(" AND ");
            } else {
                conditionSB.append(" WHERE ");
            }
            conditionSB.append(key + " = (?)");
            values.add(conditions.get(key));
        }
        return this.getResultsOfQuery("SELECT * FROM `" + table + "`" + conditionSB.toString(), values);
    }

    public ResultSet getResultsOfQuery(String query) throws SQLException {
        return this.getResultsOfQuery(query, new ArrayList<String>());
    }

    public ResultSet getResultsOfQuery(String query, String[] values) throws SQLException {
        return this.getResultsOfQuery(query, Arrays.asList(values));
    }

    public ResultSet getResultsOfQuery(String query, List<String> values) throws SQLException {
        this.checkConnection();
        PreparedStatement statement = this.connect.prepareStatement(query);
        for (int i = 1; i <= values.size(); ++i) {
            statement.setString(i, values.get(i - 1));
        }
        return statement.executeQuery();
    }

    public int insert(String sql, String[] values) throws SQLException {
        return this.insert(sql, Arrays.asList(values));
    }

    public int insert(String sql, List<String> values) throws SQLException {
        this.checkConnection();
        PreparedStatement stmt = this.connect.prepareStatement(sql, 1);
        for (int i = 1; i <= values.size(); ++i) {
            String val = values.get(i - 1);
            if (NumberUtils.isCreatable((String)val)) {
                if (val.contains(".")) {
                    stmt.setDouble(i, NumberUtils.toDouble((String)val));
                    continue;
                }
                stmt.setInt(i, NumberUtils.toInt((String)val));
                continue;
            }
            stmt.setString(i, values.get(i - 1));
        }
        stmt.executeUpdate();
        ResultSet rs = stmt.getGeneratedKeys();
        rs.next();
        return rs.getInt(1);
    }

    public int insert(String table, Map<String, ? extends Object> map) throws SQLException {
        StringBuilder sb1 = new StringBuilder();
        StringBuilder sb2 = new StringBuilder();
        ArrayList<String> values = new ArrayList<String>();
        for (String key : map.keySet()) {
            if (map.get(key) == null) continue;
            if (sb1.length() != 0) {
                sb1.append(", ");
                sb2.append(", ");
            }
            sb1.append(key);
            sb2.append("?");
            values.add(map.get(key).toString());
        }
        String statement = "INSERT INTO " + table + " (" + sb1.toString() + ") VALUES (" + sb2.toString() + ")";
        return this.insert(statement, values);
    }

    public void insert_noNewValues(String table, Map<String, ? extends Object> map) throws SQLException {
        StringBuilder sb1 = new StringBuilder();
        StringBuilder sb2 = new StringBuilder();
        ArrayList<String> values = new ArrayList<String>();
        for (String key : map.keySet()) {
            if (map.get(key) == null) continue;
            if (sb1.length() != 0) {
                sb1.append(", ");
                sb2.append(", ");
            }
            sb1.append(key);
            sb2.append("?");
            values.add(map.get(key).toString());
        }
        String statement = "INSERT INTO " + table + " (" + sb1.toString() + ") VALUES (" + sb2.toString() + ")";
        this.insert_noNewValues(statement, values);
    }

    public void insert_noNewValues(String sql, List<String> values) throws SQLException {
        this.checkConnection();
        PreparedStatement stmt = this.connect.prepareStatement(sql, 1);
        for (int i = 1; i <= values.size(); ++i) {
            String val = values.get(i - 1);
            if (NumberUtils.isCreatable((String)val)) {
                if (val.contains(".")) {
                    stmt.setDouble(i, NumberUtils.toDouble((String)val));
                    continue;
                }
                stmt.setInt(i, NumberUtils.toInt((String)val));
                continue;
            }
            stmt.setString(i, values.get(i - 1));
        }
        stmt.executeUpdate();
    }

    public void update(String sql, String[] values) throws SQLException {
        this.update(sql, Arrays.asList(values));
    }

    public void update(String sql, List<? extends Object> values) throws SQLException {
        this.checkConnection();
        PreparedStatement stmt = this.connect.prepareStatement(sql);
        for (int i = 1; i <= values.size(); ++i) {
            stmt.setString(i, values.get(i - 1).toString());
        }
        stmt.executeUpdate();
    }

    public void update(String table, Map<String, ? extends Object> updateValues, Map<String, ? extends Object> conditions) throws SQLException {
        this.checkConnection();
        StringBuilder updateSB = new StringBuilder();
        ArrayList<String> values = new ArrayList<String>();
        for (String string : updateValues.keySet()) {
            if (updateSB.length() > 0) {
                updateSB.append(", ");
            }
            updateSB.append(string + " = (?)");
            values.add(updateValues.get(string).toString());
        }
        StringBuilder conditionSB = new StringBuilder();
        for (String key : conditions.keySet()) {
            if (conditionSB.length() > 0) {
                conditionSB.append(" AND ");
            }
            conditionSB.append(key + " = (?)");
            values.add(conditions.get(key).toString());
        }
        String string = "UPDATE " + table + " SET " + updateSB.toString() + " WHERE " + conditionSB.toString();
        PreparedStatement stmt = this.connect.prepareStatement(string);
        for (int i = 1; i <= values.size(); ++i) {
            stmt.setString(i, (String)values.get(i - 1));
        }
        stmt.executeUpdate();
    }

    @Override
    public void close() {
        try {
            if (this.connect != null) {
                this.connect.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String getDriver() {
        return this.driver;
    }
}

