/*
 * Decompiled with CFR 0.152.
 */
package me.hgj.jetpackmvvm.widget.alpha;

import android.view.View;
import java.lang.ref.WeakReference;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import me.hgj.jetpackmvvm.R;
import me.hgj.jetpackmvvm.widget.alpha.UIResHelper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\t\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0016\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\fJ\u0016\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00032\u0006\u0010\u0014\u001a\u00020\fJ\u000e\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\fJ\u000e\u0010\u0017\u001a\u00020\u00102\u0006\u0010\u0018\u001a\u00020\fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0005X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lme/hgj/jetpackmvvm/widget/alpha/UIAlphaViewHelper;", "", "target", "Landroid/view/View;", "mPressedAlpha", "", "mDisabledAlpha", "<init>", "(Landroid/view/View;FF)V", "mTarget", "Ljava/lang/ref/WeakReference;", "mChangeAlphaWhenPress", "", "mChangeAlphaWhenDisable", "mNormalAlpha", "onPressedChanged", "", "current", "pressed", "onEnabledChanged", "enabled", "setChangeAlphaWhenPress", "changeAlphaWhenPress", "setChangeAlphaWhenDisable", "changeAlphaWhenDisable", "JetpackMvvm_release"})
public final class UIAlphaViewHelper {
    private float mPressedAlpha;
    private float mDisabledAlpha;
    @Nullable
    private WeakReference<View> mTarget;
    private boolean mChangeAlphaWhenPress;
    private boolean mChangeAlphaWhenDisable;
    private final float mNormalAlpha;

    public UIAlphaViewHelper(@NotNull View target, float mPressedAlpha, float mDisabledAlpha) {
        float disabledAlpha;
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        this.mPressedAlpha = mPressedAlpha;
        this.mDisabledAlpha = mDisabledAlpha;
        this.mChangeAlphaWhenPress = true;
        this.mChangeAlphaWhenDisable = true;
        this.mNormalAlpha = 1.0f;
        this.mTarget = new WeakReference<View>(target);
        float pressedAlpha = UIResHelper.getAttrFloatValue(target.getContext(), R.attr.ui_alpha_pressed);
        if (!(pressedAlpha == 0.0f)) {
            this.mPressedAlpha = pressedAlpha;
        }
        if (!((disabledAlpha = UIResHelper.getAttrFloatValue(target.getContext(), R.attr.ui_alpha_disabled)) == 0.0f)) {
            this.mDisabledAlpha = disabledAlpha;
        }
    }

    public /* synthetic */ UIAlphaViewHelper(View view, float f, float f2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            f = 0.5f;
        }
        if ((n & 4) != 0) {
            f2 = 0.5f;
        }
        this(view, f, f2);
    }

    public final void onPressedChanged(@NotNull View current, boolean pressed) {
        Intrinsics.checkNotNullParameter((Object)current, (String)"current");
        WeakReference<View> weakReference = this.mTarget;
        Intrinsics.checkNotNull(weakReference);
        View view = (View)weakReference.get();
        if (view == null) {
            return;
        }
        View target = view;
        if (current.isEnabled()) {
            target.setAlpha(this.mChangeAlphaWhenPress && pressed && current.isClickable() ? this.mPressedAlpha : this.mNormalAlpha);
        } else if (this.mChangeAlphaWhenDisable) {
            target.setAlpha(this.mDisabledAlpha);
        }
    }

    public final void onEnabledChanged(@NotNull View current, boolean enabled) {
        float alphaForIsEnable;
        Intrinsics.checkNotNullParameter((Object)current, (String)"current");
        WeakReference<View> weakReference = this.mTarget;
        Intrinsics.checkNotNull(weakReference);
        View view = (View)weakReference.get();
        if (view == null) {
            return;
        }
        View target = view;
        float f = this.mChangeAlphaWhenDisable ? (enabled ? this.mNormalAlpha : this.mDisabledAlpha) : (alphaForIsEnable = this.mNormalAlpha);
        if (current != target && target.isEnabled() != enabled) {
            target.setEnabled(enabled);
        }
        target.setAlpha(alphaForIsEnable);
    }

    public final void setChangeAlphaWhenPress(boolean changeAlphaWhenPress) {
        this.mChangeAlphaWhenPress = changeAlphaWhenPress;
    }

    public final void setChangeAlphaWhenDisable(boolean changeAlphaWhenDisable) {
        this.mChangeAlphaWhenDisable = changeAlphaWhenDisable;
        WeakReference<View> weakReference = this.mTarget;
        Intrinsics.checkNotNull(weakReference);
        View target = (View)weakReference.get();
        if (target != null) {
            this.onEnabledChanged(target, target.isEnabled());
        }
    }
}

