/*
 * Decompiled with CFR 0.152.
 */
package me.hgj.jetpackmvvm.widget.loadsir.callback;

import android.content.Context;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.ProgressBar;
import android.widget.TextView;
import androidx.annotation.StyleRes;
import me.hgj.jetpackmvvm.widget.loadsir.callback.Callback;

public class ProgressCallback
extends Callback {
    private String title;
    private String subTitle;
    private int subTitleStyleRes = -1;
    private int titleStyleRes = -1;

    private ProgressCallback(Builder builder) {
        this.title = builder.title;
        this.subTitle = builder.subTitle;
        this.subTitleStyleRes = builder.subTitleStyleRes;
        this.titleStyleRes = builder.titleStyleRes;
        this.setSuccessVisible(builder.aboveable);
    }

    @Override
    protected int onCreateView() {
        return 0;
    }

    @Override
    protected View onBuildView(Context context) {
        return new LinearLayout(context);
    }

    @Override
    protected void onViewCreate(Context context, View view) {
        LinearLayout.LayoutParams lp = new LinearLayout.LayoutParams(-2, -2);
        lp.gravity = 17;
        LinearLayout ll = (LinearLayout)view;
        ll.setOrientation(1);
        ll.setGravity(17);
        ProgressBar progressBar = new ProgressBar(context);
        ll.addView((View)progressBar, (ViewGroup.LayoutParams)lp);
        if (!TextUtils.isEmpty((CharSequence)this.title)) {
            TextView tvTitle = new TextView(context);
            tvTitle.setText((CharSequence)this.title);
            if (this.titleStyleRes == -1) {
                tvTitle.setTextAppearance(context, 16973890);
            } else {
                tvTitle.setTextAppearance(context, this.titleStyleRes);
            }
            ll.addView((View)tvTitle, (ViewGroup.LayoutParams)lp);
        }
        if (!TextUtils.isEmpty((CharSequence)this.subTitle)) {
            TextView tvSubtitle = new TextView(context);
            tvSubtitle.setText((CharSequence)this.subTitle);
            if (this.subTitleStyleRes == -1) {
                tvSubtitle.setTextAppearance(context, 16973892);
            } else {
                tvSubtitle.setTextAppearance(context, this.subTitleStyleRes);
            }
            ll.addView((View)tvSubtitle, (ViewGroup.LayoutParams)lp);
        }
    }

    public static class Builder {
        private String title;
        private String subTitle;
        private int subTitleStyleRes = -1;
        private int titleStyleRes = -1;
        private boolean aboveable;

        public Builder setTitle(String title) {
            return this.setTitle(title, -1);
        }

        public Builder setTitle(String title, @StyleRes int titleStyleRes) {
            this.title = title;
            this.titleStyleRes = titleStyleRes;
            return this;
        }

        public Builder setSubTitle(String subTitle) {
            return this.setSubTitle(subTitle, -1);
        }

        public Builder setSubTitle(String subTitle, @StyleRes int subTitleStyleRes) {
            this.subTitle = subTitle;
            this.subTitleStyleRes = subTitleStyleRes;
            return this;
        }

        public Builder setAboveSuccess(boolean aboveable) {
            this.aboveable = aboveable;
            return this;
        }

        public ProgressCallback build() {
            return new ProgressCallback(this);
        }
    }
}

