/*
 * Decompiled with CFR 0.152.
 */
package me.hgj.jetpackmvvm.util.decoration;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.ColorInt;
import androidx.annotation.ColorRes;
import androidx.annotation.DrawableRes;
import androidx.core.content.ContextCompat;
import androidx.recyclerview.widget.GridLayoutManager;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import androidx.recyclerview.widget.StaggeredGridLayoutManager;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import me.hgj.jetpackmvvm.util.decoration.DividerOrientation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\r\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001:\u0001OB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0014\u0010(\u001a\u00020)2\f\b\u0001\u0010*\u001a\u00020+\"\u00020\u001dJ\u000e\u0010,\u001a\u00020)2\u0006\u0010-\u001a\u00020!J\u0010\u0010,\u001a\u00020)2\b\b\u0001\u0010.\u001a\u00020\u001dJ\u0010\u0010/\u001a\u00020)2\b\b\u0001\u00100\u001a\u00020\u001dJ\u000e\u0010/\u001a\u00020)2\u0006\u00100\u001a\u000201J\u0010\u00102\u001a\u00020)2\b\b\u0001\u00100\u001a\u00020\u001dJ\u0010\u00104\u001a\u00020)2\b\b\u0001\u00100\u001a\u00020\u001dJ\u000e\u00104\u001a\u00020)2\u0006\u00105\u001a\u000201J\u0010\u00106\u001a\u00020)2\b\b\u0001\u00100\u001a\u00020\u001dJ\u001a\u00107\u001a\u00020)2\b\b\u0002\u00108\u001a\u00020\u001d2\b\b\u0002\u00109\u001a\u00020\u0007J$\u0010:\u001a\u00020)2\b\b\u0002\u0010;\u001a\u00020\u001d2\b\b\u0002\u0010<\u001a\u00020\u001d2\b\b\u0002\u00109\u001a\u00020\u0007J(\u0010=\u001a\u00020)2\u0006\u0010>\u001a\u00020?2\u0006\u0010@\u001a\u00020A2\u0006\u0010B\u001a\u00020C2\u0006\u0010D\u001a\u00020EH\u0016J \u0010F\u001a\u00020)2\u0006\u0010G\u001a\u00020H2\u0006\u0010B\u001a\u00020C2\u0006\u0010D\u001a\u00020EH\u0016J\u0010\u0010I\u001a\u00020)2\u0006\u0010J\u001a\u00020KH\u0002J\u0018\u0010L\u001a\u00020)2\u0006\u0010G\u001a\u00020H2\u0006\u0010B\u001a\u00020CH\u0002J\u0018\u0010M\u001a\u00020)2\u0006\u0010G\u001a\u00020H2\u0006\u0010B\u001a\u00020CH\u0002J\u0018\u0010N\u001a\u00020)2\u0006\u0010G\u001a\u00020H2\u0006\u0010B\u001a\u00020CH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\t\"\u0004\b\u000e\u0010\u000bR$\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u00078F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0011\u0010\t\"\u0004\b\u0012\u0010\u000bR\u001a\u0010\u0013\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\t\"\u0004\b\u0015\u0010\u000bR\u001a\u0010\u0016\u001a\u00020\u0017X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010 \u001a\u0004\u0018\u00010!X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\"\u0010\"\u001a\n\u0012\u0004\u0012\u00020\u001d\u0018\u00010#X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b$\u0010%\"\u0004\b&\u0010'R\u000e\u00103\u001a\u00020\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006P"}, d2={"Lme/hgj/jetpackmvvm/util/decoration/DefaultDecoration;", "Landroidx/recyclerview/widget/RecyclerView$ItemDecoration;", "context", "Landroid/content/Context;", "<init>", "(Landroid/content/Context;)V", "startVisible", "", "getStartVisible", "()Z", "setStartVisible", "(Z)V", "endVisible", "getEndVisible", "setEndVisible", "value", "includeVisible", "getIncludeVisible", "setIncludeVisible", "expandVisible", "getExpandVisible", "setExpandVisible", "orientation", "Lme/hgj/jetpackmvvm/util/decoration/DividerOrientation;", "getOrientation", "()Lme/hgj/jetpackmvvm/util/decoration/DividerOrientation;", "setOrientation", "(Lme/hgj/jetpackmvvm/util/decoration/DividerOrientation;)V", "size", "", "marginStart", "marginEnd", "divider", "Landroid/graphics/drawable/Drawable;", "typePool", "", "getTypePool", "()Ljava/util/List;", "setTypePool", "(Ljava/util/List;)V", "addType", "", "typeArray", "", "setDrawable", "drawable", "drawableRes", "setColor", "color", "", "setColorRes", "background", "setBackground", "colorString", "setBackgroundRes", "setDivider", "width", "dp", "setMargin", "start", "end", "getItemOffsets", "outRect", "Landroid/graphics/Rect;", "view", "Landroid/view/View;", "parent", "Landroidx/recyclerview/widget/RecyclerView;", "state", "Landroidx/recyclerview/widget/RecyclerView$State;", "onDraw", "canvas", "Landroid/graphics/Canvas;", "adjustOrientation", "layoutManager", "Landroidx/recyclerview/widget/RecyclerView$LayoutManager;", "drawHorizontal", "drawVertical", "drawGrid", "Edge", "JetpackMvvm_release"})
@SourceDebugExtension(value={"SMAP\nDefaultDecoration.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DefaultDecoration.kt\nme/hgj/jetpackmvvm/util/decoration/DefaultDecoration\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,684:1\n13493#2,2:685\n*S KotlinDebug\n*F\n+ 1 DefaultDecoration.kt\nme/hgj/jetpackmvvm/util/decoration/DefaultDecoration\n*L\n89#1:685,2\n*E\n"})
public final class DefaultDecoration
extends RecyclerView.ItemDecoration {
    @NotNull
    private final Context context;
    private boolean startVisible;
    private boolean endVisible;
    private boolean expandVisible;
    @NotNull
    private DividerOrientation orientation;
    private int size;
    private int marginStart;
    private int marginEnd;
    @Nullable
    private Drawable divider;
    @Nullable
    private List<Integer> typePool;
    private int background;

    public DefaultDecoration(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
        this.orientation = DividerOrientation.HORIZONTAL;
        this.size = 1;
    }

    public final boolean getStartVisible() {
        return this.startVisible;
    }

    public final void setStartVisible(boolean bl) {
        this.startVisible = bl;
    }

    public final boolean getEndVisible() {
        return this.endVisible;
    }

    public final void setEndVisible(boolean bl) {
        this.endVisible = bl;
    }

    public final boolean getIncludeVisible() {
        return this.startVisible && this.endVisible;
    }

    public final void setIncludeVisible(boolean value) {
        this.startVisible = value;
        this.endVisible = value;
    }

    public final boolean getExpandVisible() {
        return this.expandVisible;
    }

    public final void setExpandVisible(boolean bl) {
        this.expandVisible = bl;
    }

    @NotNull
    public final DividerOrientation getOrientation() {
        return this.orientation;
    }

    public final void setOrientation(@NotNull DividerOrientation dividerOrientation) {
        Intrinsics.checkNotNullParameter((Object)((Object)dividerOrientation), (String)"<set-?>");
        this.orientation = dividerOrientation;
    }

    @Nullable
    public final List<Integer> getTypePool() {
        return this.typePool;
    }

    public final void setTypePool(@Nullable List<Integer> list) {
        this.typePool = list;
    }

    public final void addType(int ... typeArray) {
        Intrinsics.checkNotNullParameter((Object)typeArray, (String)"typeArray");
        if (this.typePool == null) {
            this.typePool = new ArrayList();
        }
        int[] $this$forEach$iv = typeArray;
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv.length;
        for (int i = 0; i < n; ++i) {
            int element$iv;
            int it = element$iv = $this$forEach$iv[i];
            boolean bl = false;
            List<Integer> list = this.typePool;
            if (list == null) continue;
            list.add(it);
        }
    }

    public final void setDrawable(@NotNull Drawable drawable2) {
        Intrinsics.checkNotNullParameter((Object)drawable2, (String)"drawable");
        this.divider = drawable2;
    }

    public final void setDrawable(@DrawableRes int drawableRes) {
        Drawable drawable2;
        Drawable drawable3 = ContextCompat.getDrawable((Context)this.context, (int)drawableRes);
        if (drawable3 == null) {
            throw new IllegalArgumentException("Drawable cannot be find");
        }
        this.divider = drawable2 = drawable3;
    }

    public final void setColor(@ColorInt int color2) {
        this.divider = (Drawable)new ColorDrawable(color2);
    }

    public final void setColor(@NotNull String color2) {
        Intrinsics.checkNotNullParameter((Object)color2, (String)"color");
        int parseColor = Color.parseColor((String)color2);
        this.divider = (Drawable)new ColorDrawable(parseColor);
    }

    public final void setColorRes(@ColorRes int color2) {
        int colorRes = ContextCompat.getColor((Context)this.context, (int)color2);
        this.divider = (Drawable)new ColorDrawable(colorRes);
    }

    public final void setBackground(@ColorInt int color2) {
        this.background = color2;
    }

    public final void setBackground(@NotNull String colorString) {
        Intrinsics.checkNotNullParameter((Object)colorString, (String)"colorString");
        try {
            this.background = Color.parseColor((String)colorString);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Unknown color: " + colorString);
        }
    }

    public final void setBackgroundRes(@ColorRes int color2) {
        this.background = ContextCompat.getColor((Context)this.context, (int)color2);
    }

    public final void setDivider(int width, boolean dp) {
        if (!dp) {
            this.size = width;
        } else {
            float density = this.context.getResources().getDisplayMetrics().density;
            this.size = MathKt.roundToInt((float)(density * (float)width));
        }
    }

    public static /* synthetic */ void setDivider$default(DefaultDecoration defaultDecoration, int n, boolean bl, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = 1;
        }
        if ((n2 & 2) != 0) {
            bl = false;
        }
        defaultDecoration.setDivider(n, bl);
    }

    public final void setMargin(int start, int end, boolean dp) {
        if (!dp) {
            this.marginStart = start;
            this.marginEnd = end;
        } else {
            float density = this.context.getResources().getDisplayMetrics().density;
            this.marginStart = MathKt.roundToInt((float)((float)start * density));
            this.marginEnd = MathKt.roundToInt((float)((float)end * density));
        }
    }

    public static /* synthetic */ void setMargin$default(DefaultDecoration defaultDecoration, int n, int n2, boolean bl, int n3, Object object) {
        if ((n3 & 1) != 0) {
            n = 0;
        }
        if ((n3 & 2) != 0) {
            n2 = 0;
        }
        if ((n3 & 4) != 0) {
            bl = true;
        }
        defaultDecoration.setMargin(n, n2, bl);
    }

    public void getItemOffsets(@NotNull Rect outRect, @NotNull View view, @NotNull RecyclerView parent, @NotNull RecyclerView.State state) {
        int n;
        int n2;
        Intrinsics.checkNotNullParameter((Object)outRect, (String)"outRect");
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        RecyclerView.LayoutManager layoutManager = parent.getLayoutManager();
        if (layoutManager == null) {
            return;
        }
        RecyclerView.LayoutManager layoutManager2 = layoutManager;
        int position = parent.getChildAdapterPosition(view);
        if (this.divider == null) {
            n2 = this.size;
        } else {
            Drawable drawable2 = this.divider;
            if (!(drawable2 != null ? drawable2.getIntrinsicHeight() == -1 : false)) {
                Drawable drawable3 = this.divider;
                Intrinsics.checkNotNull((Object)drawable3);
                n2 = drawable3.getIntrinsicHeight();
            } else {
                Drawable drawable4 = this.divider;
                if (!(drawable4 != null ? drawable4.getIntrinsicWidth() == -1 : false)) {
                    Drawable drawable5 = this.divider;
                    Intrinsics.checkNotNull((Object)drawable5);
                    n2 = drawable5.getIntrinsicWidth();
                } else {
                    n2 = this.size;
                }
            }
        }
        int height = n2;
        if (this.divider == null) {
            n = this.size;
        } else {
            Drawable drawable6 = this.divider;
            if (!(drawable6 != null ? drawable6.getIntrinsicWidth() == -1 : false)) {
                Drawable drawable7 = this.divider;
                Intrinsics.checkNotNull((Object)drawable7);
                n = drawable7.getIntrinsicWidth();
            } else {
                Drawable drawable8 = this.divider;
                if (!(drawable8 != null ? drawable8.getIntrinsicHeight() == -1 : false)) {
                    Drawable drawable9 = this.divider;
                    Intrinsics.checkNotNull((Object)drawable9);
                    n = drawable9.getIntrinsicHeight();
                } else {
                    n = this.size;
                }
            }
        }
        int width = n;
        Edge edge = Edge.Companion.computeEdge(position, layoutManager2);
        this.adjustOrientation(layoutManager2);
        switch (WhenMappings.$EnumSwitchMapping$0[this.orientation.ordinal()]) {
            case 1: {
                int top = this.startVisible && edge.getTop() ? height : 0;
                int bottom = this.endVisible && edge.getBottom() || !edge.getBottom() ? height : 0;
                outRect.set(0, top, 0, bottom);
                break;
            }
            case 2: {
                int left = this.startVisible && edge.getLeft() ? width : 0;
                int right = this.endVisible && edge.getRight() || !edge.getRight() ? width : 0;
                outRect.set(left, 0, right, 0);
                break;
            }
            case 3: {
                int bottom;
                int n3;
                RecyclerView.LayoutManager right = layoutManager2;
                int spanCount = right instanceof GridLayoutManager ? ((GridLayoutManager)layoutManager2).getSpanCount() : (right instanceof StaggeredGridLayoutManager ? ((StaggeredGridLayoutManager)layoutManager2).getSpanCount() : 1);
                RecyclerView.LayoutManager layoutManager3 = layoutManager2;
                int spanGroupCount = layoutManager3 instanceof GridLayoutManager ? ((GridLayoutManager)layoutManager2).getSpanSizeLookup().getSpanGroupIndex(state.getItemCount() - 1, spanCount) + 1 : (layoutManager3 instanceof StaggeredGridLayoutManager ? (int)Math.ceil((float)state.getItemCount() / (float)spanCount) : 1);
                RecyclerView.LayoutManager layoutManager4 = layoutManager2;
                if (layoutManager4 instanceof GridLayoutManager) {
                    n3 = ((GridLayoutManager)layoutManager2).getSpanSizeLookup().getSpanIndex(position, spanCount);
                } else if (layoutManager4 instanceof StaggeredGridLayoutManager) {
                    View view2 = layoutManager2.findViewByPosition(position);
                    Intrinsics.checkNotNull((Object)view2);
                    ViewGroup.LayoutParams layoutParams = view2.getLayoutParams();
                    Intrinsics.checkNotNull((Object)layoutParams, (String)"null cannot be cast to non-null type androidx.recyclerview.widget.StaggeredGridLayoutManager.LayoutParams");
                    n3 = ((StaggeredGridLayoutManager.LayoutParams)layoutParams).getSpanIndex();
                } else {
                    n3 = 0;
                }
                int spanIndex = n3;
                RecyclerView.LayoutManager layoutManager5 = layoutManager2;
                int spanGroupIndex = layoutManager5 instanceof GridLayoutManager ? ((GridLayoutManager)layoutManager2).getSpanSizeLookup().getSpanGroupIndex(position, spanCount) : (layoutManager5 instanceof StaggeredGridLayoutManager ? (int)Math.ceil((float)(position + 1) / (float)spanCount) - 1 : 0);
                int spanSize = layoutManager2 instanceof GridLayoutManager ? ((GridLayoutManager)layoutManager2).getSpanSizeLookup().getSpanSize(position) : 1;
                RecyclerView.LayoutManager layoutManager6 = layoutManager2;
                int orientation = layoutManager6 instanceof GridLayoutManager ? ((GridLayoutManager)layoutManager2).getOrientation() : (layoutManager6 instanceof StaggeredGridLayoutManager ? ((StaggeredGridLayoutManager)layoutManager2).getOrientation() : 1);
                int left = this.endVisible && orientation == 1 ? width - spanIndex * width / spanCount : (this.startVisible && orientation == 0 ? width - spanIndex * width / spanCount : spanIndex * width / spanCount);
                int right2 = this.endVisible && orientation == 1 ? (spanIndex + spanSize) * width / spanCount : (this.startVisible && orientation == 0 ? (spanIndex + spanSize) * width / spanCount : width - (spanIndex + spanSize) * width / spanCount);
                int top = layoutManager2 instanceof StaggeredGridLayoutManager ? (orientation == 1 ? (edge.getTop() ? (this.startVisible ? height : 0) : 0) : (edge.getLeft() ? (this.endVisible ? width : 0) : 0)) : ((this.startVisible || this.endVisible) && orientation == 1 ? height - spanGroupIndex * height / spanGroupCount : spanGroupIndex * height / spanGroupCount);
                int n4 = layoutManager2 instanceof StaggeredGridLayoutManager ? (orientation == 1 ? (edge.getBottom() ? (this.startVisible ? height : 0) : height) : (edge.getRight() ? (this.endVisible ? width : 0) : height)) : (this.startVisible && orientation == 1 && layoutManager2 instanceof StaggeredGridLayoutManager ? (spanGroupIndex == 0 ? height : 0) : (bottom = (this.startVisible || this.endVisible) && orientation == 1 ? (spanGroupIndex + 1) * height / spanGroupCount : height - (spanGroupIndex + 1) * height / spanGroupCount));
                if (orientation == 1) {
                    outRect.set(left, top, right2, bottom);
                    break;
                }
                outRect.set(top, left, bottom, right2);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
    }

    public void onDraw(@NotNull Canvas canvas, @NotNull RecyclerView parent, @NotNull RecyclerView.State state) {
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        RecyclerView.LayoutManager layoutManager = parent.getLayoutManager();
        if (layoutManager == null || this.divider == null) {
            return;
        }
        this.adjustOrientation(layoutManager);
        switch (WhenMappings.$EnumSwitchMapping$0[this.orientation.ordinal()]) {
            case 1: {
                this.drawHorizontal(canvas, parent);
                break;
            }
            case 2: {
                this.drawVertical(canvas, parent);
                break;
            }
            case 3: {
                this.drawGrid(canvas, parent);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
    }

    private final void adjustOrientation(RecyclerView.LayoutManager layoutManager) {
        if (!(layoutManager instanceof GridLayoutManager) && layoutManager instanceof LinearLayoutManager) {
            RecyclerView.LayoutManager layoutManager2 = layoutManager;
            LinearLayoutManager linearLayoutManager = layoutManager2 instanceof LinearLayoutManager ? (LinearLayoutManager)layoutManager2 : null;
            this.orientation = (linearLayoutManager != null ? linearLayoutManager.getOrientation() == 1 : false) ? DividerOrientation.HORIZONTAL : DividerOrientation.VERTICAL;
        } else if (layoutManager instanceof StaggeredGridLayoutManager) {
            this.orientation = DividerOrientation.GRID;
        }
    }

    private final void drawHorizontal(Canvas canvas, RecyclerView parent) {
        canvas.save();
        int left = 0;
        int right = 0;
        if (parent.getClipToPadding()) {
            left = parent.getPaddingLeft() + this.marginStart;
            right = parent.getWidth() - parent.getPaddingRight() - this.marginEnd;
        } else {
            left = 0 + this.marginStart;
            right = parent.getWidth() - this.marginEnd;
        }
        int n = parent.getChildCount();
        for (int i = 0; i < n; ++i) {
            int top;
            Drawable drawable2;
            RecyclerView.LayoutManager layoutManager;
            View child = parent.getChildAt(i);
            int position = parent.getChildAdapterPosition(child);
            if (parent.getLayoutManager() == null) {
                return;
            }
            Edge edge = Edge.Companion.computeEdge(position, layoutManager);
            if (this.orientation != DividerOrientation.GRID && !this.endVisible && edge.getBottom()) continue;
            if (this.divider == null) continue;
            Drawable $this$drawHorizontal_u24lambda_u241 = drawable2;
            boolean bl = false;
            Rect decoratedBounds = new Rect();
            parent.getDecoratedBoundsWithMargins(child, decoratedBounds);
            int firstBottom = $this$drawHorizontal_u24lambda_u241.getIntrinsicHeight() == -1 ? decoratedBounds.top + this.size : decoratedBounds.top + $this$drawHorizontal_u24lambda_u241.getIntrinsicHeight();
            int firstTop = decoratedBounds.top;
            int bottom = decoratedBounds.bottom;
            int n2 = top = $this$drawHorizontal_u24lambda_u241.getIntrinsicHeight() == -1 ? bottom - this.size : bottom - $this$drawHorizontal_u24lambda_u241.getIntrinsicHeight();
            if (this.background != 0) {
                Paint paint = new Paint();
                paint.setColor(this.background);
                paint.setStyle(Paint.Style.FILL);
                if (this.startVisible && edge.getTop()) {
                    Rect firstRect = new Rect(parent.getPaddingLeft(), firstTop, parent.getWidth() - parent.getPaddingRight(), firstBottom);
                    canvas.drawRect(firstRect, paint);
                }
                Rect rect = new Rect(parent.getPaddingLeft(), top, parent.getWidth() - parent.getPaddingRight(), bottom);
                canvas.drawRect(rect, paint);
            }
            if (this.startVisible && edge.getTop()) {
                $this$drawHorizontal_u24lambda_u241.setBounds(left, firstTop, right, firstBottom);
                $this$drawHorizontal_u24lambda_u241.draw(canvas);
            }
            $this$drawHorizontal_u24lambda_u241.setBounds(left, top, right, bottom);
            $this$drawHorizontal_u24lambda_u241.draw(canvas);
        }
        canvas.restore();
    }

    private final void drawVertical(Canvas canvas, RecyclerView parent) {
        canvas.save();
        int top = 0;
        int bottom = 0;
        if (parent.getClipToPadding()) {
            top = parent.getPaddingTop() + this.marginStart;
            bottom = parent.getHeight() - parent.getPaddingBottom() - this.marginEnd;
        } else {
            top = 0 + this.marginStart;
            bottom = parent.getHeight() - this.marginEnd;
        }
        int childCount = parent.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            int left;
            Drawable drawable2;
            RecyclerView.LayoutManager layoutManager;
            View child = parent.getChildAt(i);
            int position = parent.getChildAdapterPosition(child);
            if (parent.getLayoutManager() == null) {
                return;
            }
            Edge edge = Edge.Companion.computeEdge(position, layoutManager);
            if (this.orientation != DividerOrientation.GRID && !this.endVisible && edge.getRight()) continue;
            if (this.divider == null) continue;
            Drawable $this$drawVertical_u24lambda_u242 = drawable2;
            boolean bl = false;
            Rect decoratedBounds = new Rect();
            parent.getDecoratedBoundsWithMargins(child, decoratedBounds);
            int firstRight = $this$drawVertical_u24lambda_u242.getIntrinsicWidth() == -1 ? decoratedBounds.left + this.size : decoratedBounds.left + $this$drawVertical_u24lambda_u242.getIntrinsicWidth();
            int firstLeft = decoratedBounds.left;
            int right = MathKt.roundToInt((float)((float)decoratedBounds.right + child.getTranslationX()));
            int n = left = $this$drawVertical_u24lambda_u242.getIntrinsicWidth() == -1 ? right - this.size : right - $this$drawVertical_u24lambda_u242.getIntrinsicWidth();
            if (this.background != 0) {
                Paint paint = new Paint();
                paint.setColor(this.background);
                paint.setStyle(Paint.Style.FILL);
                if (this.startVisible && edge.getLeft()) {
                    Rect firstRect = new Rect(firstLeft, parent.getPaddingTop(), firstRight, parent.getHeight() - parent.getPaddingBottom());
                    canvas.drawRect(firstRect, paint);
                }
                Rect rect = new Rect(left, parent.getPaddingTop(), right, parent.getHeight() - parent.getPaddingBottom());
                canvas.drawRect(rect, paint);
            }
            if (this.startVisible && edge.getLeft()) {
                $this$drawVertical_u24lambda_u242.setBounds(firstLeft, top, firstRight, bottom);
                $this$drawVertical_u24lambda_u242.draw(canvas);
            }
            $this$drawVertical_u24lambda_u242.setBounds(left, top, right, bottom);
            $this$drawVertical_u24lambda_u242.draw(canvas);
        }
        canvas.restore();
    }

    private final void drawGrid(Canvas canvas, RecyclerView parent) {
        canvas.save();
        int childCount = parent.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            Drawable drawable2;
            int width;
            int n;
            RecyclerView.LayoutManager layoutManager;
            View child = parent.getChildAt(i);
            int position = parent.getChildAdapterPosition(child);
            if (parent.getLayoutManager() == null) {
                return;
            }
            Edge edge = Edge.Companion.computeEdge(position, layoutManager);
            if (this.divider == null) {
                n = this.size;
            } else {
                Drawable drawable3 = this.divider;
                if (!(drawable3 != null ? drawable3.getIntrinsicHeight() == -1 : false)) {
                    Drawable drawable4 = this.divider;
                    Intrinsics.checkNotNull((Object)drawable4);
                    n = drawable4.getIntrinsicHeight();
                } else {
                    Drawable drawable5 = this.divider;
                    if (!(drawable5 != null ? drawable5.getIntrinsicWidth() == -1 : false)) {
                        Drawable drawable6 = this.divider;
                        Intrinsics.checkNotNull((Object)drawable6);
                        n = drawable6.getIntrinsicWidth();
                    } else {
                        n = this.size;
                    }
                }
            }
            int height = n;
            if (this.divider == null) {
                v5 = this.size;
            } else {
                Drawable drawable7 = this.divider;
                if (!(drawable7 != null ? drawable7.getIntrinsicWidth() == -1 : false)) {
                    Drawable drawable8 = this.divider;
                    Intrinsics.checkNotNull((Object)drawable8);
                    v5 = drawable8.getIntrinsicWidth();
                } else {
                    Drawable drawable9 = this.divider;
                    if (!(drawable9 != null ? drawable9.getIntrinsicHeight() == -1 : false)) {
                        Drawable drawable10 = this.divider;
                        Intrinsics.checkNotNull((Object)drawable10);
                        v5 = drawable10.getIntrinsicHeight();
                    } else {
                        v5 = width = this.size;
                    }
                }
            }
            if (this.divider == null) continue;
            Drawable $this$drawGrid_u24lambda_u243 = drawable2;
            boolean bl = false;
            ViewGroup.LayoutParams layoutParams = child.getLayoutParams();
            Intrinsics.checkNotNull((Object)layoutParams, (String)"null cannot be cast to non-null type androidx.recyclerview.widget.RecyclerView.LayoutParams");
            RecyclerView.LayoutParams layoutParams2 = (RecyclerView.LayoutParams)layoutParams;
            Rect bounds = new Rect(child.getLeft() + layoutParams2.leftMargin, child.getTop() + layoutParams2.topMargin, child.getRight() + layoutParams2.rightMargin, child.getBottom() + layoutParams2.bottomMargin);
            if (!this.endVisible && edge.getRight()) {
                $this$drawGrid_u24lambda_u243.setBounds(bounds.left - width, bounds.top - height, bounds.right - this.marginEnd, bounds.top);
                $this$drawGrid_u24lambda_u243.draw(canvas);
            } else if (!this.endVisible && !edge.getTop() && edge.getLeft()) {
                $this$drawGrid_u24lambda_u243.setBounds(bounds.left + this.marginStart, bounds.top - height, bounds.right + width, bounds.top);
                $this$drawGrid_u24lambda_u243.draw(canvas);
            } else if (!edge.getTop() || this.startVisible && edge.getTop()) {
                $this$drawGrid_u24lambda_u243.setBounds(bounds.left - width, bounds.top - height, bounds.right + width, bounds.top);
                $this$drawGrid_u24lambda_u243.draw(canvas);
            }
            if (!this.endVisible && edge.getRight()) {
                $this$drawGrid_u24lambda_u243.setBounds(bounds.left - width, bounds.bottom, bounds.right - this.marginEnd, bounds.bottom + height);
                $this$drawGrid_u24lambda_u243.draw(canvas);
            } else if (!this.endVisible && !edge.getBottom() && edge.getLeft()) {
                $this$drawGrid_u24lambda_u243.setBounds(bounds.left + this.marginStart, bounds.bottom, bounds.right + width, bounds.bottom + height);
                $this$drawGrid_u24lambda_u243.draw(canvas);
            } else if (!edge.getBottom() || this.startVisible && edge.getBottom()) {
                $this$drawGrid_u24lambda_u243.setBounds(bounds.left - width, bounds.bottom, bounds.right + width, bounds.bottom + height);
                $this$drawGrid_u24lambda_u243.draw(canvas);
            }
            if (edge.getTop() && !this.endVisible && !edge.getLeft()) {
                $this$drawGrid_u24lambda_u243.setBounds(bounds.left - width, bounds.top + this.marginStart, bounds.left, bounds.bottom);
                $this$drawGrid_u24lambda_u243.draw(canvas);
            } else if (edge.getBottom() && !this.endVisible && !edge.getLeft()) {
                $this$drawGrid_u24lambda_u243.setBounds(bounds.left - width, bounds.top, bounds.left, bounds.bottom - this.marginEnd);
                $this$drawGrid_u24lambda_u243.draw(canvas);
            } else if (!edge.getLeft() || this.endVisible && edge.getLeft()) {
                $this$drawGrid_u24lambda_u243.setBounds(bounds.left - width, bounds.top, bounds.left, bounds.bottom);
                $this$drawGrid_u24lambda_u243.draw(canvas);
            }
            if (edge.getTop() && !this.endVisible && !edge.getRight()) {
                $this$drawGrid_u24lambda_u243.setBounds(bounds.right, bounds.top + this.marginStart, bounds.right + width, bounds.bottom);
                $this$drawGrid_u24lambda_u243.draw(canvas);
                continue;
            }
            if (edge.getBottom() && !this.endVisible && !edge.getRight()) {
                $this$drawGrid_u24lambda_u243.setBounds(bounds.right, bounds.top, bounds.right + width, bounds.bottom - this.marginEnd);
                $this$drawGrid_u24lambda_u243.draw(canvas);
                continue;
            }
            if (edge.getRight() && (!this.endVisible || !edge.getRight())) continue;
            $this$drawGrid_u24lambda_u243.setBounds(bounds.right, bounds.top, bounds.right + width, bounds.bottom);
            $this$drawGrid_u24lambda_u243.draw(canvas);
        }
        canvas.restore();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0017\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB/\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0007\u0010\bJ\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0003H\u00c6\u0003J1\u0010\u0017\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0018\u001a\u00020\u00032\b\u0010\u0019\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001a\u001a\u00020\u001bH\u00d6\u0001J\t\u0010\u001c\u001a\u00020\u001dH\u00d6\u0001R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u001a\u0010\u0004\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\n\"\u0004\b\u000e\u0010\fR\u001a\u0010\u0005\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\n\"\u0004\b\u0010\u0010\fR\u001a\u0010\u0006\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\n\"\u0004\b\u0012\u0010\f\u00a8\u0006\u001f"}, d2={"Lme/hgj/jetpackmvvm/util/decoration/DefaultDecoration$Edge;", "", "left", "", "top", "right", "bottom", "<init>", "(ZZZZ)V", "getLeft", "()Z", "setLeft", "(Z)V", "getTop", "setTop", "getRight", "setRight", "getBottom", "setBottom", "component1", "component2", "component3", "component4", "copy", "equals", "other", "hashCode", "", "toString", "", "Companion", "JetpackMvvm_release"})
    public static final class Edge {
        @NotNull
        public static final Companion Companion = new Companion(null);
        private boolean left;
        private boolean top;
        private boolean right;
        private boolean bottom;

        public Edge(boolean left, boolean top, boolean right, boolean bottom) {
            this.left = left;
            this.top = top;
            this.right = right;
            this.bottom = bottom;
        }

        public /* synthetic */ Edge(boolean bl, boolean bl2, boolean bl3, boolean bl4, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                bl = false;
            }
            if ((n & 2) != 0) {
                bl2 = false;
            }
            if ((n & 4) != 0) {
                bl3 = false;
            }
            if ((n & 8) != 0) {
                bl4 = false;
            }
            this(bl, bl2, bl3, bl4);
        }

        public final boolean getLeft() {
            return this.left;
        }

        public final void setLeft(boolean bl) {
            this.left = bl;
        }

        public final boolean getTop() {
            return this.top;
        }

        public final void setTop(boolean bl) {
            this.top = bl;
        }

        public final boolean getRight() {
            return this.right;
        }

        public final void setRight(boolean bl) {
            this.right = bl;
        }

        public final boolean getBottom() {
            return this.bottom;
        }

        public final void setBottom(boolean bl) {
            this.bottom = bl;
        }

        public final boolean component1() {
            return this.left;
        }

        public final boolean component2() {
            return this.top;
        }

        public final boolean component3() {
            return this.right;
        }

        public final boolean component4() {
            return this.bottom;
        }

        @NotNull
        public final Edge copy(boolean left, boolean top, boolean right, boolean bottom) {
            return new Edge(left, top, right, bottom);
        }

        public static /* synthetic */ Edge copy$default(Edge edge, boolean bl, boolean bl2, boolean bl3, boolean bl4, int n, Object object) {
            if ((n & 1) != 0) {
                bl = edge.left;
            }
            if ((n & 2) != 0) {
                bl2 = edge.top;
            }
            if ((n & 4) != 0) {
                bl3 = edge.right;
            }
            if ((n & 8) != 0) {
                bl4 = edge.bottom;
            }
            return edge.copy(bl, bl2, bl3, bl4);
        }

        @NotNull
        public String toString() {
            return "Edge(left=" + this.left + ", top=" + this.top + ", right=" + this.right + ", bottom=" + this.bottom + ")";
        }

        public int hashCode() {
            int result = Boolean.hashCode(this.left);
            result = result * 31 + Boolean.hashCode(this.top);
            result = result * 31 + Boolean.hashCode(this.right);
            result = result * 31 + Boolean.hashCode(this.bottom);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Edge)) {
                return false;
            }
            Edge edge = (Edge)other;
            if (this.left != edge.left) {
                return false;
            }
            if (this.top != edge.top) {
                return false;
            }
            if (this.right != edge.right) {
                return false;
            }
            return this.bottom == edge.bottom;
        }

        public Edge() {
            this(false, false, false, false, 15, null);
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t\u00a8\u0006\n"}, d2={"Lme/hgj/jetpackmvvm/util/decoration/DefaultDecoration$Edge$Companion;", "", "<init>", "()V", "computeEdge", "Lme/hgj/jetpackmvvm/util/decoration/DefaultDecoration$Edge;", "position", "", "layoutManager", "Landroidx/recyclerview/widget/RecyclerView$LayoutManager;", "JetpackMvvm_release"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final Edge computeEdge(int position, @NotNull RecyclerView.LayoutManager layoutManager) {
                Edge edge;
                Intrinsics.checkNotNullParameter((Object)layoutManager, (String)"layoutManager");
                int index = position + 1;
                int itemCount = layoutManager.getItemCount();
                Edge $this$computeEdge_u24lambda_u240 = edge = new Edge(false, false, false, false, 15, null);
                boolean bl = false;
                RecyclerView.LayoutManager layoutManager2 = layoutManager;
                if (layoutManager2 instanceof StaggeredGridLayoutManager) {
                    int spanCount = ((StaggeredGridLayoutManager)layoutManager).getSpanCount();
                    View view = layoutManager.findViewByPosition(position);
                    Intrinsics.checkNotNull((Object)view);
                    ViewGroup.LayoutParams layoutParams = view.getLayoutParams();
                    Intrinsics.checkNotNull((Object)layoutParams, (String)"null cannot be cast to non-null type androidx.recyclerview.widget.StaggeredGridLayoutManager.LayoutParams");
                    int spanIndex = ((StaggeredGridLayoutManager.LayoutParams)layoutParams).getSpanIndex() + 1;
                    if (((StaggeredGridLayoutManager)layoutManager).getOrientation() == 1) {
                        $this$computeEdge_u24lambda_u240.setLeft(spanIndex == 1);
                        $this$computeEdge_u24lambda_u240.setRight(spanIndex == spanCount);
                        $this$computeEdge_u24lambda_u240.setTop(index <= spanCount);
                        $this$computeEdge_u24lambda_u240.setBottom(index > itemCount - spanCount);
                    } else {
                        $this$computeEdge_u24lambda_u240.setLeft(index <= spanCount);
                        $this$computeEdge_u24lambda_u240.setRight(index > itemCount - spanCount);
                        $this$computeEdge_u24lambda_u240.setTop(spanIndex == 1);
                        $this$computeEdge_u24lambda_u240.setBottom(spanIndex == spanCount);
                    }
                } else if (layoutManager2 instanceof GridLayoutManager) {
                    GridLayoutManager.SpanSizeLookup spanSizeLookup = ((GridLayoutManager)layoutManager).getSpanSizeLookup();
                    int spanCount = ((GridLayoutManager)layoutManager).getSpanCount();
                    int spanGroupIndex = spanSizeLookup.getSpanGroupIndex(position, spanCount);
                    int maxSpanGroupIndex = (int)Math.ceil((float)itemCount / (float)spanCount);
                    int spanIndex = spanSizeLookup.getSpanIndex(position, spanCount) + 1;
                    int spanSize = spanSizeLookup.getSpanSize(position);
                    if (((GridLayoutManager)layoutManager).getOrientation() == 1) {
                        $this$computeEdge_u24lambda_u240.setLeft(spanIndex == 1);
                        $this$computeEdge_u24lambda_u240.setRight(spanIndex + spanSize - 1 == spanCount);
                        $this$computeEdge_u24lambda_u240.setTop(index <= spanCount && spanGroupIndex == spanSizeLookup.getSpanGroupIndex(position - 1, spanCount));
                        $this$computeEdge_u24lambda_u240.setBottom(spanGroupIndex == maxSpanGroupIndex - 1);
                    } else {
                        $this$computeEdge_u24lambda_u240.setLeft(spanGroupIndex == 0);
                        $this$computeEdge_u24lambda_u240.setRight(spanGroupIndex == maxSpanGroupIndex - 1);
                        $this$computeEdge_u24lambda_u240.setTop(spanIndex == 1);
                        $this$computeEdge_u24lambda_u240.setBottom(spanIndex + spanSize - 1 == spanCount);
                    }
                } else if (layoutManager2 instanceof LinearLayoutManager) {
                    if (((LinearLayoutManager)layoutManager).getOrientation() == 1) {
                        $this$computeEdge_u24lambda_u240.setLeft(true);
                        $this$computeEdge_u24lambda_u240.setRight(true);
                        $this$computeEdge_u24lambda_u240.setTop(index == 1);
                        $this$computeEdge_u24lambda_u240.setBottom(index == itemCount);
                    } else {
                        $this$computeEdge_u24lambda_u240.setLeft(index == 1);
                        $this$computeEdge_u24lambda_u240.setRight(index == itemCount);
                        $this$computeEdge_u24lambda_u240.setTop(true);
                        $this$computeEdge_u24lambda_u240.setBottom(true);
                    }
                }
                return edge;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[DividerOrientation.values().length];
            try {
                nArray[DividerOrientation.HORIZONTAL.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DividerOrientation.VERTICAL.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DividerOrientation.GRID.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

