/*
 * Decompiled with CFR 0.152.
 */
package me.hgj.jetpackmvvm.network.interceptor;

import android.content.Context;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import me.hgj.jetpackmvvm.base.KtxKt;
import me.hgj.jetpackmvvm.network.NetworkUtil;
import okhttp3.CacheControl;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\u0004\u00a8\u0006\f"}, d2={"Lme/hgj/jetpackmvvm/network/interceptor/CacheInterceptor;", "Lokhttp3/Interceptor;", "day", "", "(I)V", "getDay", "()I", "setDay", "intercept", "Lokhttp3/Response;", "chain", "Lokhttp3/Interceptor$Chain;", "JetpackMvvm_release"})
public final class CacheInterceptor
implements Interceptor {
    private int day;

    @NotNull
    public Response intercept(@NotNull Interceptor.Chain chain) {
        Intrinsics.checkParameterIsNotNull((Object)chain, (String)"chain");
        Request request2 = chain.request();
        if (!NetworkUtil.isNetworkAvailable((Context)KtxKt.getAppContext())) {
            request2 = request2.newBuilder().cacheControl(CacheControl.FORCE_CACHE).build();
        }
        Response response = chain.proceed(request2);
        if (!NetworkUtil.isNetworkAvailable((Context)KtxKt.getAppContext())) {
            int maxAge = 3600;
            response.newBuilder().removeHeader("Pragma").header("Cache-Control", "public, max-age=" + maxAge).build();
        } else {
            int maxStale = 86400 * this.day;
            response.newBuilder().removeHeader("Pragma").header("Cache-Control", "public, only-if-cached, max-stale=" + maxStale).build();
        }
        Response response2 = response;
        Intrinsics.checkExpressionValueIsNotNull((Object)response2, (String)"response");
        return response2;
    }

    public final int getDay() {
        return this.day;
    }

    public final void setDay(int n) {
        this.day = n;
    }

    public CacheInterceptor(int day) {
        this.day = day;
    }

    public /* synthetic */ CacheInterceptor(int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            n = 7;
        }
        this(n);
    }

    public CacheInterceptor() {
        this(0, 1, null);
    }
}

