/*
 * Decompiled with CFR 0.152.
 */
package me.hgj.jetpackmvvm.util;

import android.text.TextUtils;
import android.util.Log;

public class LogUtils {
    private static final String DEFAULT_TAG = "JetpackMvvm";
    private static boolean isLog = true;

    private LogUtils() {
        throw new IllegalStateException("you can't instantiate me!");
    }

    public static boolean isLog() {
        return isLog;
    }

    public static void setLog(boolean isLog) {
        LogUtils.isLog = isLog;
    }

    public static void debugInfo(String tag, String msg) {
        if (!isLog || TextUtils.isEmpty((CharSequence)msg)) {
            return;
        }
        Log.d((String)tag, (String)msg);
    }

    public static void debugInfo(String msg) {
        LogUtils.debugInfo(DEFAULT_TAG, msg);
    }

    public static void warnInfo(String tag, String msg) {
        if (!isLog || TextUtils.isEmpty((CharSequence)msg)) {
            return;
        }
        Log.w((String)tag, (String)msg);
    }

    public static void warnInfo(String msg) {
        LogUtils.warnInfo(DEFAULT_TAG, msg);
    }

    public static void debugLongInfo(String tag, String msg) {
        if (!isLog || TextUtils.isEmpty((CharSequence)msg)) {
            return;
        }
        msg = msg.trim();
        int maxLength = 3500;
        for (int index = 0; index < msg.length(); index += maxLength) {
            String sub = msg.length() <= index + maxLength ? msg.substring(index) : msg.substring(index, index + maxLength);
            Log.d((String)tag, (String)sub.trim());
        }
    }

    public static void debugLongInfo(String msg) {
        LogUtils.debugLongInfo(DEFAULT_TAG, msg);
    }
}

