/*
 * Decompiled with CFR 0.152.
 */
package com.obsez.android.lib.filechooser.tool;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Color;
import android.graphics.ColorFilter;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffColorFilter;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.support.annotation.NonNull;
import android.support.v4.content.ContextCompat;
import android.util.SparseArray;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ArrayAdapter;
import android.widget.TextView;
import com.obsez.android.lib.filechooser.R;
import com.obsez.android.lib.filechooser.internals.FileUtil;
import com.obsez.android.lib.filechooser.internals.UiUtil;
import com.obsez.android.lib.filechooser.internals.WrappedDrawable;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;

public class DirAdapter
extends ArrayAdapter<File> {
    private static SimpleDateFormat _formatter;
    private Drawable _defaultFolderIcon = null;
    private Drawable _defaultFileIcon = null;
    private boolean _resolveFileType = false;
    private PorterDuffColorFilter _colorFilter;
    private SparseArray<File> _selected = new SparseArray();
    private int _hoveredIndex;
    private List<Integer> _indexStack = new LinkedList<Integer>();

    public DirAdapter(Context cxt, List<File> entries, int resId) {
        super(cxt, resId, R.id.text, entries);
        this.init(null);
    }

    public DirAdapter(Context cxt, List<File> entries, int resId, String dateFormat) {
        super(cxt, resId, R.id.text, entries);
        this.init(dateFormat);
    }

    public DirAdapter(Context cxt, List<File> entries, int resource, int textViewResourceId) {
        super(cxt, resource, textViewResourceId, entries);
        this.init(null);
    }

    @SuppressLint(value={"SimpleDateFormat"})
    private void init(String dateFormat) {
        _formatter = new SimpleDateFormat(dateFormat != null && !"".equals(dateFormat.trim()) ? dateFormat.trim() : "yyyy/MM/dd HH:mm:ss");
        this._defaultFolderIcon = ContextCompat.getDrawable((Context)this.getContext(), (int)R.drawable.ic_folder);
        this._defaultFileIcon = ContextCompat.getDrawable((Context)this.getContext(), (int)R.drawable.ic_file);
        int accentColor = UiUtil.getThemeAccentColor(this.getContext());
        int red = Color.red((int)accentColor);
        int green = Color.green((int)accentColor);
        int blue = Color.blue((int)accentColor);
        int accentColorWithAlpha = Color.argb((int)40, (int)red, (int)green, (int)blue);
        this._colorFilter = new PorterDuffColorFilter(accentColorWithAlpha, PorterDuff.Mode.MULTIPLY);
    }

    @NonNull
    public View getView(int position, View convertView, @NonNull ViewGroup parent) {
        Drawable icon;
        ViewGroup rl = (ViewGroup)super.getView(position, convertView, parent);
        TextView tvName = (TextView)rl.findViewById(R.id.text);
        TextView tvSize = (TextView)rl.findViewById(R.id.txt_size);
        TextView tvDate = (TextView)rl.findViewById(R.id.txt_date);
        tvDate.setVisibility(0);
        File file = (File)super.getItem(position);
        if (file == null) {
            return rl;
        }
        tvName.setText((CharSequence)file.getName());
        if (file.isDirectory()) {
            icon = this._defaultFolderIcon.getConstantState().newDrawable();
            tvSize.setText((CharSequence)"");
            if (file.lastModified() != 0L) {
                tvDate.setText((CharSequence)_formatter.format(new Date(file.lastModified())));
            } else {
                tvDate.setVisibility(8);
            }
        } else {
            Drawable d = null;
            if (this._resolveFileType && (d = UiUtil.resolveFileTypeIcon(this.getContext(), Uri.fromFile((File)file))) != null) {
                d = new WrappedDrawable(d, 24.0f, 24.0f);
            }
            if (d == null) {
                d = this._defaultFileIcon;
            }
            icon = d.getConstantState().newDrawable();
            tvSize.setText((CharSequence)FileUtil.getReadableFileSize(file.length()));
            tvDate.setText((CharSequence)_formatter.format(new Date(file.lastModified())));
        }
        if (file.isHidden()) {
            PorterDuffColorFilter filter = new PorterDuffColorFilter(-2130706433, PorterDuff.Mode.SRC_ATOP);
            icon.mutate().setColorFilter((ColorFilter)filter);
        }
        tvName.setCompoundDrawablesWithIntrinsicBounds(icon, null, null, null);
        View root = rl.findViewById(R.id.root);
        if (this._selected.get(file.hashCode(), null) == null) {
            if (position == this._hoveredIndex) {
                root.getBackground().setColorFilter((ColorFilter)this._colorFilter);
            } else {
                root.getBackground().clearColorFilter();
            }
        } else {
            root.getBackground().setColorFilter((ColorFilter)this._colorFilter);
        }
        return rl;
    }

    public Drawable getDefaultFolderIcon() {
        return this._defaultFolderIcon;
    }

    public void setDefaultFolderIcon(Drawable defaultFolderIcon) {
        this._defaultFolderIcon = defaultFolderIcon;
    }

    public Drawable getDefaultFileIcon() {
        return this._defaultFileIcon;
    }

    public void setDefaultFileIcon(Drawable defaultFileIcon) {
        this._defaultFileIcon = defaultFileIcon;
    }

    public boolean isResolveFileType() {
        return this._resolveFileType;
    }

    public void setResolveFileType(boolean resolveFileType) {
        this._resolveFileType = resolveFileType;
    }

    public void setEntries(List<File> entries) {
        this.setNotifyOnChange(false);
        super.clear();
        this.setNotifyOnChange(true);
        super.addAll(entries);
    }

    public long getItemId(int position) {
        return ((File)this.getItem(position)).hashCode();
    }

    public void selectItem(int position) {
        int id2 = (int)this.getItemId(position);
        if (this._selected.get(id2, null) == null) {
            this._selected.append(id2, this.getItem(position));
        } else {
            this._selected.delete(id2);
        }
        this.notifyDataSetChanged();
    }

    public boolean isSelected(int position) {
        return this.isSelectedById((int)this.getItemId(position));
    }

    public boolean isSelectedById(int id2) {
        return this._selected.get(id2, null) != null;
    }

    public boolean isAnySelected() {
        return this._selected.size() > 0;
    }

    public boolean isOneSelected() {
        return this._selected.size() == 1;
    }

    public List<File> getSelected() {
        ArrayList<File> list = new ArrayList<File>();
        for (int i = 0; i < this._selected.size(); ++i) {
            list.add((File)this._selected.valueAt(i));
        }
        return list;
    }

    public void clearSelected() {
        this._selected.clear();
    }

    public int getHoveredIndex() {
        return this._hoveredIndex;
    }

    public void setHoveredIndex(int i) {
        this._hoveredIndex = i;
    }

    public int increaseHoveredIndex() {
        ++this._hoveredIndex;
        if (this._hoveredIndex >= super.getCount()) {
            this._hoveredIndex = super.getCount() - 1;
        }
        this.notifyDataSetInvalidated();
        return this._hoveredIndex;
    }

    public int decreaseHoveredIndex() {
        --this._hoveredIndex;
        if (this._hoveredIndex < 0) {
            this._hoveredIndex = 0;
        }
        this.notifyDataSetInvalidated();
        return this._hoveredIndex;
    }

    public int push() {
        this._indexStack.add(this._hoveredIndex);
        return this._hoveredIndex;
    }

    public int push(int index) {
        this._indexStack.add(index);
        this._hoveredIndex = index;
        return index;
    }

    public int pop() {
        if (!this._indexStack.isEmpty()) {
            int x = this._indexStack.get(this._indexStack.size() - 1);
            this._indexStack.remove(this._indexStack.size() - 1);
            this._hoveredIndex = x;
            return x;
        }
        return -1;
    }

    public void popAll() {
        this._indexStack.clear();
    }
}

