/*
 * Decompiled with CFR 0.152.
 */
package com.obsez.android.lib.filechooser.internals;

import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.content.res.Resources;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.webkit.MimeTypeMap;
import java.util.Iterator;
import java.util.List;

public final class UiUtil {
    public static float dip2px(float dipValue) {
        float scale = Resources.getSystem().getDisplayMetrics().density;
        return dipValue * scale + 0.5f;
    }

    public static int px2dip(int pxValue) {
        float scale = Resources.getSystem().getDisplayMetrics().density;
        return (int)((float)pxValue / scale + 0.5f);
    }

    public static Drawable resolveFileTypeIcon(Context ctx, Uri fileUri) {
        Intent intent = new Intent("android.intent.action.VIEW");
        intent.setData(fileUri);
        intent.setType(UiUtil.getMimeType(ctx, fileUri));
        PackageManager pm = ctx.getPackageManager();
        List matches = pm.queryIntentActivities(intent, 0);
        Iterator iterator = matches.iterator();
        if (iterator.hasNext()) {
            ResolveInfo match = (ResolveInfo)iterator.next();
            return match.loadIcon(pm);
        }
        return null;
    }

    public static String getMimeType(Context ctx, Uri uri) {
        String mimeType;
        if (uri.getScheme().equals("content")) {
            ContentResolver cr = ctx.getApplicationContext().getContentResolver();
            mimeType = cr.getType(uri);
        } else {
            String fileExtension = MimeTypeMap.getFileExtensionFromUrl((String)uri.toString());
            mimeType = MimeTypeMap.getSingleton().getMimeTypeFromExtension(fileExtension.toLowerCase());
        }
        return mimeType;
    }
}

