/*
 * Decompiled with CFR 0.152.
 */
package com.obsez.android.lib.filechooser;

import android.app.Activity;
import android.app.AlertDialog;
import android.app.Dialog;
import android.app.Fragment;
import android.content.Context;
import android.content.DialogInterface;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.Environment;
import android.support.annotation.DrawableRes;
import android.support.annotation.LayoutRes;
import android.support.annotation.Nullable;
import android.support.annotation.RequiresApi;
import android.support.annotation.StringRes;
import android.support.annotation.StyleRes;
import android.support.v4.content.ContextCompat;
import android.support.v4.view.ViewCompat;
import android.support.v7.view.ContextThemeWrapper;
import android.util.Log;
import android.util.TypedValue;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.view.Window;
import android.view.WindowManager;
import android.widget.AdapterView;
import android.widget.Button;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.TextView;
import android.widget.Toast;
import com.obsez.android.lib.filechooser.R;
import com.obsez.android.lib.filechooser.defBackPressed;
import com.obsez.android.lib.filechooser.internals.ExtFileFilter;
import com.obsez.android.lib.filechooser.internals.FileUtil;
import com.obsez.android.lib.filechooser.internals.RegexFileFilter;
import com.obsez.android.lib.filechooser.internals.UiUtil;
import com.obsez.android.lib.filechooser.keyListener;
import com.obsez.android.lib.filechooser.onShowListener;
import com.obsez.android.lib.filechooser.permissions.PermissionsUtil;
import com.obsez.android.lib.filechooser.tool.DirAdapter;
import com.obsez.android.lib.filechooser.tool.RootFile;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public class ChooserDialog
implements AdapterView.OnItemClickListener,
DialogInterface.OnClickListener,
AdapterView.OnItemLongClickListener {
    private boolean displayRoot;
    private String removableRoot = null;
    private String primaryRoot = null;
    Runnable _deleteModeIndicator;
    List<File> _entries = new ArrayList<File>();
    DirAdapter _adapter;
    File _currentDir;
    Context _context;
    AlertDialog _alertDialog;
    ListView _list;
    Result _result = null;
    boolean _dirOnly;
    private FileFilter _fileFilter;
    @StringRes
    private int _titleRes = -1;
    @StringRes
    private int _okRes = -1;
    @StringRes
    private int _negativeRes = -1;
    @Nullable
    private String _title;
    @Nullable
    private String _ok;
    @Nullable
    private String _negative;
    @DrawableRes
    private int _iconRes = -1;
    @Nullable
    private Drawable _icon;
    @LayoutRes
    private int _layoutRes = -1;
    @Deprecated
    @LayoutRes
    private int _rowLayoutRes = -1;
    private String _dateFormat;
    DialogInterface.OnClickListener _negativeListener;
    private DialogInterface.OnCancelListener _cancelListener2;
    private DialogInterface.OnDismissListener _onDismissListener;
    private boolean _disableTitle;
    boolean _enableOptions;
    private boolean _followDir;
    private boolean _displayPath = true;
    private TextView _pathView;
    private CustomizePathView _customizePathView;
    View _options;
    @StringRes
    int _createDirRes = -1;
    @StringRes
    int _deleteRes = -1;
    @StringRes
    int _newFolderCancelRes = -1;
    @StringRes
    int _newFolderOkRes = -1;
    @Nullable
    String _createDir;
    @Nullable
    String _delete;
    @Nullable
    String _newFolderCancel;
    @Nullable
    String _newFolderOk;
    @DrawableRes
    int _optionsIconRes = -1;
    @DrawableRes
    int _createDirIconRes = -1;
    @DrawableRes
    int _deleteIconRes = -1;
    @Nullable
    Drawable _optionsIcon;
    @Nullable
    Drawable _createDirIcon;
    @Nullable
    Drawable _deleteIcon;
    @Nullable
    View _newFolderView;
    boolean _dismissOnButtonClick = true;
    boolean _enableMultiple;
    private PermissionsUtil.OnPermissionListener _permissionListener;
    private AdapterSetter _adapterSetter = null;
    private CanNavigateUp _folderNavUpCB;
    private CanNavigateTo _folderNavToCB;
    private static final CanNavigateUp _defaultNavUpCB = dir -> dir != null && dir.canRead();
    private static final CanNavigateTo _defaultNavToCB = dir -> true;
    private OnBackPressedListener _onBackPressed = null;
    static final String sSdcardStorage = ".. SDCard Storage";
    static final String sPrimaryStorage = ".. Primary Storage";
    static final int CHOOSE_MODE_NORMAL = 0;
    static final int CHOOSE_MODE_DELETE = 1;
    static final int CHOOSE_MODE_SELECT_MULTIPLE = 2;
    int _chooseMode = 0;
    FileUtil.NewFolderFilter _newFolderFilter;

    public ChooserDialog() {
    }

    public ChooserDialog(Context cxt, @StyleRes int fileChooserTheme) {
        this._context = cxt;
        this.init(fileChooserTheme);
    }

    public ChooserDialog(Activity activity, @StyleRes int fileChooserTheme) {
        this._context = activity;
        this.init(fileChooserTheme);
    }

    public ChooserDialog(Fragment fragment, @StyleRes int fileChooserTheme) {
        this._context = fragment.getActivity();
        this.init(fileChooserTheme);
    }

    public ChooserDialog(Context cxt) {
        this._context = cxt;
        this.init();
    }

    public ChooserDialog(Activity activity) {
        this._context = activity;
        this.init();
    }

    public ChooserDialog(Fragment fragment) {
        this._context = fragment.getActivity();
        this.init();
    }

    public ChooserDialog with(Context cxt) {
        this._context = cxt;
        this.init();
        return this;
    }

    private void init() {
        this.init(null);
    }

    private void init(@Nullable @StyleRes Integer fileChooserTheme) {
        this._onBackPressed = new defBackPressed(this);
        if (fileChooserTheme == null) {
            TypedValue typedValue = new TypedValue();
            this._context = !this._context.getTheme().resolveAttribute(R.attr.fileChooserStyle, typedValue, true) ? new ContextThemeWrapper(this._context, R.style.FileChooserStyle) : new ContextThemeWrapper(this._context, typedValue.resourceId);
        } else {
            this._context = new ContextThemeWrapper(this._context, fileChooserTheme.intValue());
        }
    }

    public ChooserDialog withFilter(FileFilter ff) {
        this.withFilter(false, false, (String[])null);
        this._fileFilter = ff;
        return this;
    }

    public ChooserDialog withFilter(boolean dirOnly, boolean allowHidden, FileFilter ff) {
        this.withFilter(dirOnly, allowHidden, (String[])null);
        this._fileFilter = ff;
        return this;
    }

    public ChooserDialog withFilter(boolean allowHidden, String ... suffixes) {
        return this.withFilter(false, allowHidden, suffixes);
    }

    public ChooserDialog withFilter(boolean dirOnly, boolean allowHidden, String ... suffixes) {
        this._dirOnly = dirOnly;
        this._fileFilter = suffixes == null || suffixes.length == 0 ? (dirOnly ? file -> file.isDirectory() && (!file.isHidden() || allowHidden) : file -> !file.isHidden() || allowHidden) : new ExtFileFilter(this._dirOnly, allowHidden, suffixes);
        return this;
    }

    public ChooserDialog withFilterRegex(boolean dirOnly, boolean allowHidden, String pattern, int flags) {
        this._dirOnly = dirOnly;
        this._fileFilter = new RegexFileFilter(this._dirOnly, allowHidden, pattern, flags);
        return this;
    }

    public ChooserDialog withFilterRegex(boolean dirOnly, boolean allowHidden, String pattern) {
        this._dirOnly = dirOnly;
        this._fileFilter = new RegexFileFilter(this._dirOnly, allowHidden, pattern, 2);
        return this;
    }

    public ChooserDialog withStartFile(String startFile) {
        this._currentDir = startFile != null ? new File(startFile) : Environment.getExternalStorageDirectory();
        if (!this._currentDir.isDirectory()) {
            this._currentDir = this._currentDir.getParentFile();
        }
        if (this._currentDir == null) {
            this._currentDir = Environment.getExternalStorageDirectory();
        }
        return this;
    }

    public ChooserDialog dismissOnButtonClick(boolean dismissOnButtonClick) {
        this._dismissOnButtonClick = dismissOnButtonClick;
        if (this._onBackPressed instanceof defBackPressed) {
            defBackPressed dbp = (defBackPressed)this._onBackPressed;
            dbp._defaultLastBack = dismissOnButtonClick ? Dialog::dismiss : dialog -> {};
        }
        return this;
    }

    public ChooserDialog withChosenListener(Result r) {
        this._result = r;
        return this;
    }

    public ChooserDialog withOnBackPressedListener(OnBackPressedListener listener) {
        this._onBackPressed = listener;
        return this;
    }

    public ChooserDialog withOnLastBackPressedListener(OnBackPressedListener listener) {
        if (this._onBackPressed instanceof defBackPressed) {
            ((defBackPressed)this._onBackPressed)._onLastBackPressed = listener;
        }
        return this;
    }

    public ChooserDialog withResources(@StringRes int titleRes, @StringRes int okRes, @StringRes int cancelRes) {
        this._titleRes = titleRes;
        this._okRes = okRes;
        this._negativeRes = cancelRes;
        return this;
    }

    public ChooserDialog withStringResources(@Nullable String titleRes, @Nullable String okRes, @Nullable String cancelRes) {
        this._title = titleRes;
        this._ok = okRes;
        this._negative = cancelRes;
        return this;
    }

    public ChooserDialog enableOptions(boolean enableOptions) {
        this._enableOptions = enableOptions;
        return this;
    }

    public ChooserDialog withOptionResources(@StringRes int createDirRes, @StringRes int deleteRes, @StringRes int newFolderCancelRes, @StringRes int newFolderOkRes) {
        this._createDirRes = createDirRes;
        this._deleteRes = deleteRes;
        this._newFolderCancelRes = newFolderCancelRes;
        this._newFolderOkRes = newFolderOkRes;
        return this;
    }

    public ChooserDialog withOptionStringResources(@Nullable String createDir, @Nullable String delete, @Nullable String newFolderCancel, @Nullable String newFolderOk) {
        this._createDir = createDir;
        this._delete = delete;
        this._newFolderCancel = newFolderCancel;
        this._newFolderOk = newFolderOk;
        return this;
    }

    public ChooserDialog withOptionIcons(@DrawableRes int optionsIconRes, @DrawableRes int createDirIconRes, @DrawableRes int deleteRes) {
        this._optionsIconRes = optionsIconRes;
        this._createDirIconRes = createDirIconRes;
        this._deleteIconRes = deleteRes;
        return this;
    }

    public ChooserDialog withOptionIcons(@Nullable Drawable optionsIcon, @Nullable Drawable createDirIcon, @Nullable Drawable delete) {
        this._optionsIcon = optionsIcon;
        this._createDirIcon = createDirIcon;
        this._deleteIcon = delete;
        return this;
    }

    public ChooserDialog withNewFolderFilter(FileUtil.NewFolderFilter filter) {
        this._newFolderFilter = filter;
        return this;
    }

    public ChooserDialog withIcon(@DrawableRes int iconId) {
        this._iconRes = iconId;
        return this;
    }

    public ChooserDialog withIcon(@Nullable Drawable icon) {
        this._icon = icon;
        return this;
    }

    @RequiresApi(value=21)
    public ChooserDialog withLayoutView(@LayoutRes int layoutResId) {
        this._layoutRes = layoutResId;
        return this;
    }

    public ChooserDialog withRowLayoutView(@LayoutRes int layoutResId) {
        this._rowLayoutRes = layoutResId;
        return this;
    }

    public ChooserDialog withDateFormat() {
        return this.withDateFormat("yyyy/MM/dd HH:mm:ss");
    }

    public ChooserDialog withDateFormat(String format) {
        this._dateFormat = format;
        return this;
    }

    public ChooserDialog withNegativeButton(@StringRes int cancelTitle, DialogInterface.OnClickListener listener) {
        this._negativeRes = cancelTitle;
        this._negativeListener = listener;
        return this;
    }

    public ChooserDialog withNegativeButton(@Nullable String cancelTitle, DialogInterface.OnClickListener listener) {
        this._negative = cancelTitle;
        if (cancelTitle != null) {
            this._negativeRes = -1;
        }
        this._negativeListener = listener;
        return this;
    }

    public ChooserDialog withNegativeButtonListener(DialogInterface.OnClickListener listener) {
        this._negativeListener = listener;
        return this;
    }

    public ChooserDialog withOnCancelListener(DialogInterface.OnCancelListener listener) {
        this._cancelListener2 = listener;
        return this;
    }

    @RequiresApi(value=17)
    public ChooserDialog withOnDismissListener(DialogInterface.OnDismissListener listener) {
        this._onDismissListener = listener;
        return this;
    }

    public ChooserDialog withFileIcons(boolean tryResolveFileTypeAndIcon, Drawable fileIcon, Drawable folderIcon) {
        this._adapterSetter = adapter -> {
            if (fileIcon != null) {
                adapter.setDefaultFileIcon(fileIcon);
            }
            if (folderIcon != null) {
                adapter.setDefaultFolderIcon(folderIcon);
            }
            adapter.setResolveFileType(tryResolveFileTypeAndIcon);
        };
        return this;
    }

    public ChooserDialog withFileIconsRes(boolean tryResolveFileTypeAndIcon, int fileIcon, int folderIcon) {
        this._adapterSetter = adapter -> {
            if (fileIcon != -1) {
                adapter.setDefaultFileIcon(ContextCompat.getDrawable((Context)this._context, (int)fileIcon));
            }
            if (folderIcon != -1) {
                adapter.setDefaultFolderIcon(ContextCompat.getDrawable((Context)this._context, (int)folderIcon));
            }
            adapter.setResolveFileType(tryResolveFileTypeAndIcon);
        };
        return this;
    }

    public ChooserDialog withAdapterSetter(AdapterSetter setter) {
        this._adapterSetter = setter;
        return this;
    }

    public ChooserDialog withNavigateUpTo(CanNavigateUp cb) {
        this._folderNavUpCB = cb;
        return this;
    }

    public ChooserDialog withNavigateTo(CanNavigateTo cb) {
        this._folderNavToCB = cb;
        return this;
    }

    public ChooserDialog disableTitle(boolean disableTitle) {
        this._disableTitle = disableTitle;
        return this;
    }

    public ChooserDialog titleFollowsDir(boolean followDir) {
        this._followDir = followDir;
        return this;
    }

    public ChooserDialog followDir(boolean followDir) {
        this._followDir = followDir;
        return this;
    }

    public ChooserDialog displayPath(boolean displayPath) {
        this._displayPath = displayPath;
        return this;
    }

    public ChooserDialog customizePathView(CustomizePathView callback) {
        this._customizePathView = callback;
        return this;
    }

    public ChooserDialog enableMultiple(boolean enableMultiple) {
        this._enableMultiple = enableMultiple;
        return this;
    }

    public ChooserDialog build() {
        TypedArray ta = this._context.obtainStyledAttributes(R.styleable.FileChooser);
        int style2 = ta.getResourceId(R.styleable.FileChooser_fileChooserDialogStyle, R.style.FileChooserDialogStyle);
        AlertDialog.Builder builder = new AlertDialog.Builder((Context)new ContextThemeWrapper(this._context, style2), ta.getResourceId(R.styleable.FileChooser_fileChooserDialogStyle, R.style.FileChooserDialogStyle));
        ta.recycle();
        this._adapter = this._rowLayoutRes != -1 ? new DirAdapter(this._context, new ArrayList<File>(), this._rowLayoutRes, this._dateFormat) : new DirAdapter(this._context, this._dateFormat);
        if (this._adapterSetter != null) {
            this._adapterSetter.apply(this._adapter);
        }
        this.refreshDirs();
        builder.setAdapter((ListAdapter)this._adapter, (DialogInterface.OnClickListener)this);
        if (!this._disableTitle) {
            if (this._titleRes != -1) {
                builder.setTitle(this._titleRes);
            } else if (this._title != null) {
                builder.setTitle((CharSequence)this._title);
            } else {
                builder.setTitle(R.string.choose_file);
            }
        }
        if (this._iconRes != -1) {
            builder.setIcon(this._iconRes);
        } else if (this._icon != null) {
            builder.setIcon(this._icon);
        }
        if (this._layoutRes != -1 && Build.VERSION.SDK_INT >= 21) {
            builder.setView(this._layoutRes);
        }
        if (this._dirOnly || this._enableMultiple) {
            DialogInterface.OnClickListener listener = (dialog, which) -> {
                if (this._result != null) {
                    this._result.onChoosePath(this._currentDir.getAbsolutePath(), this._currentDir);
                }
            };
            if (this._okRes != -1) {
                builder.setPositiveButton(this._okRes, listener);
            } else if (this._ok != null) {
                builder.setPositiveButton((CharSequence)this._ok, listener);
            } else {
                builder.setPositiveButton(R.string.title_choose, listener);
            }
        }
        if (this._negativeRes != -1) {
            builder.setNegativeButton(this._negativeRes, this._negativeListener);
        } else if (this._negative != null) {
            builder.setNegativeButton((CharSequence)this._negative, this._negativeListener);
        } else {
            builder.setNegativeButton(R.string.dialog_cancel, this._negativeListener);
        }
        if (this._cancelListener2 != null) {
            builder.setOnCancelListener(this._cancelListener2);
        } else {
            builder.setOnCancelListener(dialog -> {
                Log.v((String)"Cancel", (String)"Cancel");
                dialog.cancel();
            });
        }
        if (Build.VERSION.SDK_INT >= 17 && this._onDismissListener != null) {
            builder.setOnDismissListener(this._onDismissListener);
        }
        builder.setOnKeyListener((DialogInterface.OnKeyListener)new keyListener(this));
        this._alertDialog = builder.create();
        this._alertDialog.setOnShowListener((DialogInterface.OnShowListener)new onShowListener(this));
        this._list = this._alertDialog.getListView();
        this._list.setOnItemClickListener((AdapterView.OnItemClickListener)this);
        if (this._enableMultiple) {
            this._list.setOnItemLongClickListener((AdapterView.OnItemLongClickListener)this);
        }
        return this;
    }

    private void showDialog() {
        Window window = this._alertDialog.getWindow();
        if (window != null) {
            TypedArray ta = this._context.obtainStyledAttributes(R.styleable.FileChooser);
            window.setLayout(-2, -2);
            window.setGravity(ta.getInt(R.styleable.FileChooser_fileChooserDialogGravity, 17));
            WindowManager.LayoutParams lp = window.getAttributes();
            lp.dimAmount = ta.getFloat(R.styleable.FileChooser_fileChooserDialogBackgroundDimAmount, 0.3f);
            lp.flags = 2;
            window.setAttributes(lp);
            ta.recycle();
        }
        this._alertDialog.show();
    }

    public ChooserDialog show() {
        String[] stringArray;
        if (this._alertDialog == null || this._list == null) {
            this.build();
        }
        if (Build.VERSION.SDK_INT < 23) {
            this.showDialog();
            return this;
        }
        if (this._permissionListener == null) {
            this._permissionListener = new PermissionsUtil.OnPermissionListener(){

                @Override
                public void onPermissionGranted(String[] permissions) {
                    boolean show = false;
                    for (String permission2 : permissions) {
                        if (!permission2.equals("android.permission.READ_EXTERNAL_STORAGE")) continue;
                        show = true;
                        break;
                    }
                    if (!show) {
                        return;
                    }
                    if (ChooserDialog.this._enableOptions) {
                        show = false;
                        for (String permission2 : permissions) {
                            if (!permission2.equals("android.permission.WRITE_EXTERNAL_STORAGE")) continue;
                            show = true;
                            break;
                        }
                    }
                    if (!show) {
                        return;
                    }
                    if (ChooserDialog.this._adapter.isEmpty()) {
                        ChooserDialog.this.refreshDirs();
                    }
                    ChooserDialog.this.showDialog();
                }

                @Override
                public void onPermissionDenied(String[] permissions) {
                }

                @Override
                public void onShouldShowRequestPermissionRationale(String[] permissions) {
                    Toast.makeText((Context)ChooserDialog.this._context, (CharSequence)"You denied the Read/Write permissions on SDCard.", (int)1).show();
                }
            };
        }
        if (this._enableOptions) {
            String[] stringArray2 = new String[2];
            stringArray2[0] = "android.permission.READ_EXTERNAL_STORAGE";
            stringArray = stringArray2;
            stringArray2[1] = "android.permission.WRITE_EXTERNAL_STORAGE";
        } else {
            String[] stringArray3 = new String[1];
            stringArray = stringArray3;
            stringArray3[0] = "android.permission.READ_EXTERNAL_STORAGE";
        }
        String[] permissions = stringArray;
        PermissionsUtil.checkPermissions(this._context, this._permissionListener, permissions);
        return this;
    }

    private void displayPath(String path) {
        if (this._pathView == null) {
            int rootId = this._context.getResources().getIdentifier("contentPanel", "id", "android");
            ViewGroup root = (ViewGroup)this._alertDialog.findViewById(rootId);
            if (root == null) {
                return;
            }
            Object params = root instanceof LinearLayout ? new LinearLayout.LayoutParams(-1, -2) : new FrameLayout.LayoutParams(-1, -2, 48);
            TypedArray ta = this._context.obtainStyledAttributes(R.styleable.FileChooser);
            int style2 = ta.getResourceId(R.styleable.FileChooser_fileChooserPathViewStyle, R.style.FileChooserPathViewStyle);
            ContextThemeWrapper context = new ContextThemeWrapper(this._context, style2);
            ta.recycle();
            ta = context.obtainStyledAttributes(R.styleable.FileChooser);
            this.displayRoot = ta.getBoolean(R.styleable.FileChooser_fileChooserPathViewDisplayRoot, true);
            this._pathView = new TextView((Context)context);
            root.addView((View)this._pathView, 0, (ViewGroup.LayoutParams)params);
            int elevation = ta.getInt(R.styleable.FileChooser_fileChooserPathViewElevation, 2);
            if (Build.VERSION.SDK_INT >= 21) {
                this._pathView.setElevation((float)elevation);
            } else {
                ViewCompat.setElevation((View)this._pathView, (float)elevation);
            }
            ta.recycle();
            if (this._customizePathView != null) {
                this._customizePathView.customize(this._pathView);
            }
        }
        if (path == null) {
            this._pathView.setVisibility(8);
            ViewGroup.MarginLayoutParams param = (ViewGroup.MarginLayoutParams)this._list.getLayoutParams();
            if (this._pathView.getParent() instanceof FrameLayout) {
                param.topMargin = this._pathView.getHeight();
            }
            this._list.setLayoutParams((ViewGroup.LayoutParams)param);
        } else {
            if (this.removableRoot == null || this.primaryRoot == null) {
                this.removableRoot = FileUtil.getStoragePath(this._context, true);
                this.primaryRoot = FileUtil.getStoragePath(this._context, false);
            }
            if (path.contains(this.removableRoot)) {
                path = path.substring(this.displayRoot ? this.removableRoot.lastIndexOf(47) + 1 : this.removableRoot.length());
            }
            if (path.contains(this.primaryRoot)) {
                path = path.substring(this.displayRoot ? this.primaryRoot.lastIndexOf(47) + 1 : this.primaryRoot.length());
            }
            this._pathView.setText((CharSequence)path);
            while (this._pathView.getLineCount() > 1) {
                int i = path.indexOf("/");
                if ((i = path.indexOf("/", i + 1)) == -1) break;
                path = "..." + path.substring(i);
                this._pathView.setText((CharSequence)path);
            }
            this._pathView.setVisibility(0);
            final ViewGroup.MarginLayoutParams param = (ViewGroup.MarginLayoutParams)this._list.getLayoutParams();
            if (this._pathView.getHeight() == 0) {
                ViewTreeObserver viewTreeObserver = this._pathView.getViewTreeObserver();
                viewTreeObserver.addOnPreDrawListener(new ViewTreeObserver.OnPreDrawListener(){

                    public boolean onPreDraw() {
                        if (ChooserDialog.this._pathView.getHeight() <= 0) {
                            return false;
                        }
                        ChooserDialog.this._pathView.getViewTreeObserver().removeOnPreDrawListener((ViewTreeObserver.OnPreDrawListener)this);
                        if (ChooserDialog.this._pathView.getParent() instanceof FrameLayout) {
                            param.topMargin = ChooserDialog.this._pathView.getHeight();
                        }
                        ChooserDialog.this._list.setLayoutParams((ViewGroup.LayoutParams)param);
                        return true;
                    }
                });
            } else {
                if (this._pathView.getParent() instanceof FrameLayout) {
                    param.topMargin = this._pathView.getHeight();
                }
                this._list.setLayoutParams((ViewGroup.LayoutParams)param);
            }
        }
    }

    private void listDirs() {
        this._entries.clear();
        if (this._currentDir == null) {
            this._currentDir = new File(FileUtil.getStoragePath(this._context, false));
        }
        File[] files = this._currentDir.listFiles(this._fileFilter);
        boolean up = false;
        if (this.removableRoot == null || this.primaryRoot == null) {
            this.removableRoot = FileUtil.getStoragePath(this._context, true);
            this.primaryRoot = FileUtil.getStoragePath(this._context, false);
        }
        if (!this.removableRoot.equals(this.primaryRoot)) {
            if (this._currentDir.getAbsolutePath().equals(this.primaryRoot)) {
                this._entries.add(new RootFile(sSdcardStorage));
                up = true;
            } else if (this._currentDir.getAbsolutePath().equals(this.removableRoot)) {
                this._entries.add(new RootFile(sPrimaryStorage));
                up = true;
            }
        }
        boolean displayPath = false;
        if (!up && this._currentDir.getParentFile() != null && this._currentDir.getParentFile().canRead()) {
            this._entries.add(new RootFile(".."));
            displayPath = true;
        }
        if (files == null) {
            return;
        }
        LinkedList<File> dirList = new LinkedList<File>();
        LinkedList<File> fileList = new LinkedList<File>();
        for (File f : files) {
            if (f.isDirectory()) {
                dirList.add(f);
                continue;
            }
            fileList.add(f);
        }
        this.sortByName(dirList);
        this.sortByName(fileList);
        this._entries.addAll(dirList);
        this._entries.addAll(fileList);
        if (this._alertDialog != null && !this._disableTitle && this._followDir) {
            if (displayPath) {
                this._alertDialog.setTitle((CharSequence)this._currentDir.getName());
            } else if (this._titleRes != -1) {
                this._alertDialog.setTitle(this._titleRes);
            } else if (this._title != null) {
                this._alertDialog.setTitle((CharSequence)this._title);
            } else {
                this._alertDialog.setTitle(R.string.choose_file);
            }
        }
        if (this._alertDialog != null && this._displayPath) {
            if (displayPath) {
                this.displayPath(this._currentDir.getPath());
            } else {
                this.displayPath(null);
            }
        }
    }

    private void sortByName(List<File> list) {
        Collections.sort(list, (f1, f2) -> f1.getName().toLowerCase().compareTo(f2.getName().toLowerCase()));
    }

    void createNewDirectory(String name) {
        if (FileUtil.createNewDirectory(name, this._currentDir)) {
            this.refreshDirs();
            return;
        }
        File newDir = new File(this._currentDir, name);
        Toast.makeText((Context)this._context, (CharSequence)("Couldn't create folder " + newDir.getName() + " at " + newDir.getAbsolutePath()), (int)1).show();
    }

    public void onItemClick(AdapterView<?> parent_, View list_, int position, long id_) {
        if (position < 0 || position >= this._entries.size()) {
            return;
        }
        boolean scrollToTop = false;
        File file = this._entries.get(position);
        if (file.getName().equals("..")) {
            if (!this._list.hasFocus()) {
                this._list.requestFocus();
            }
            this.doGoBack();
            return;
        }
        if (file.getName().contains(sSdcardStorage)) {
            if (this.removableRoot == null) {
                this.removableRoot = FileUtil.getStoragePath(this._context, true);
            }
            if ("mounted".equals(Environment.getExternalStorageState())) {
                this._currentDir = new File(this.removableRoot);
                int n = this._chooseMode = this._chooseMode == 1 ? 0 : this._chooseMode;
                if (this._deleteModeIndicator != null) {
                    this._deleteModeIndicator.run();
                }
                this._adapter.popAll();
            }
        } else if (file.getName().contains(sPrimaryStorage)) {
            if (this.primaryRoot == null) {
                this.primaryRoot = FileUtil.getStoragePath(this._context, false);
            }
            this._currentDir = new File(this.primaryRoot);
            int n = this._chooseMode = this._chooseMode == 1 ? 0 : this._chooseMode;
            if (this._deleteModeIndicator != null) {
                this._deleteModeIndicator.run();
            }
            this._adapter.popAll();
        } else {
            switch (this._chooseMode) {
                case 0: {
                    if (file.isDirectory()) {
                        if (this._folderNavToCB == null) {
                            this._folderNavToCB = _defaultNavToCB;
                        }
                        if (!this._folderNavToCB.canNavigate(file)) break;
                        this._currentDir = file;
                        scrollToTop = true;
                        this._adapter.push(position);
                        break;
                    }
                    if (this._dirOnly || this._result == null) break;
                    if (this._dismissOnButtonClick) {
                        this._alertDialog.dismiss();
                    }
                    this._result.onChoosePath(file.getAbsolutePath(), file);
                    if (this._enableMultiple) {
                        this._result.onChoosePath(this._currentDir.getAbsolutePath(), this._currentDir);
                    }
                    return;
                }
                case 2: {
                    if (file.isDirectory()) {
                        if (this._folderNavToCB == null) {
                            this._folderNavToCB = _defaultNavToCB;
                        }
                        if (!this._folderNavToCB.canNavigate(file)) break;
                        this._currentDir = file;
                        scrollToTop = true;
                        this._adapter.push();
                        break;
                    }
                    this._adapter.selectItem(position);
                    if (!this._adapter.isAnySelected()) {
                        this._chooseMode = 0;
                        this._alertDialog.getButton(-1).setVisibility(4);
                    }
                    this._result.onChoosePath(file.getAbsolutePath(), file);
                    break;
                }
                case 1: {
                    try {
                        FileUtil.deleteFileRecursively(file);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        Toast.makeText((Context)this._context, (CharSequence)e.getMessage(), (int)1).show();
                    }
                    this._chooseMode = 0;
                    if (this._deleteModeIndicator == null) break;
                    this._deleteModeIndicator.run();
                    break;
                }
            }
        }
        this.refreshDirs();
        if (scrollToTop) {
            this._list.setSelection(0);
        }
    }

    public boolean onItemLongClick(AdapterView<?> parent, View list, int position, long id2) {
        File file = this._entries.get(position);
        if (file.getName().equals("..") || file.getName().contains(sSdcardStorage) || file.getName().contains(sPrimaryStorage) || file.isDirectory()) {
            return true;
        }
        if (this._adapter.isSelected(position)) {
            return true;
        }
        this._result.onChoosePath(file.getAbsolutePath(), file);
        this._adapter.selectItem(position);
        this._chooseMode = 2;
        this._alertDialog.getButton(-1).setVisibility(0);
        if (this._deleteModeIndicator != null) {
            this._deleteModeIndicator.run();
        }
        return true;
    }

    public void onClick(DialogInterface dialog, int which) {
    }

    void refreshDirs() {
        this.listDirs();
        this._adapter.setEntries(this._entries);
    }

    public void dismiss() {
        this._alertDialog.dismiss();
    }

    boolean doMoveUp() {
        if (this._list.hasFocus()) {
            Log.d((String)"z", (String)("move up at " + this._adapter.getHoveredIndex()));
            int indexOld = this._adapter.getHoveredIndex();
            int index = this._adapter.decreaseHoveredIndex();
            if (indexOld >= 0 && indexOld != index) {
                UiUtil.ensureVisible(this._list, index);
                this._list.requestFocus();
            } else {
                this._list.setSelection(index);
            }
        } else if (this.buttonsHasFocus()) {
            this._list.requestFocus();
        }
        return true;
    }

    boolean doMoveDown() {
        if (this._list.hasFocus()) {
            Log.d((String)"z", (String)("move down at " + this._adapter.getHoveredIndex()));
            int indexOld = this._adapter.getHoveredIndex();
            int index = this._adapter.increaseHoveredIndex();
            if (indexOld >= 0 && indexOld != index) {
                UiUtil.ensureVisible(this._list, index);
                this._list.requestFocus();
            } else {
                this._list.setSelection(index);
                this.moveFocusToButtons();
            }
        }
        return true;
    }

    boolean doGoBack() {
        if (this._list.hasFocus()) {
            File f = this._currentDir.getParentFile();
            Log.d((String)"z", (String)("go back at " + this._adapter.getHoveredIndex() + ", go up level: " + f.getAbsolutePath()));
            if (this._folderNavUpCB == null) {
                this._folderNavUpCB = _defaultNavUpCB;
            }
            if (this._folderNavUpCB.canUpTo(f)) {
                this._currentDir = f;
                int n = this._chooseMode = this._chooseMode == 1 ? 0 : this._chooseMode;
                if (this._deleteModeIndicator != null) {
                    this._deleteModeIndicator.run();
                }
                this._adapter.pop();
                this.refreshDirs();
                this._list.setSelection(this._adapter.getHoveredIndex());
            }
        }
        return true;
    }

    boolean doEnter() {
        if (this._list.hasFocus()) {
            Log.d((String)"z", (String)("enter at " + this._adapter.getHoveredIndex()));
            int position = this._adapter.getHoveredIndex();
            this.onItemClick((AdapterView<?>)this._list, (View)this._list, position, -1L);
        } else if (this.buttonsHasFocus()) {
            this._alertDialog.getCurrentFocus().performClick();
        }
        return true;
    }

    boolean buttonsHasFocus() {
        View v = this._alertDialog.getCurrentFocus();
        return v instanceof Button;
    }

    private boolean moveFocusToButtons() {
        Button v = null;
        if (this._alertDialog.getButton(-3).getVisibility() == 0) {
            v = this._alertDialog.getButton(-3);
        }
        if (v == null && this._alertDialog.getButton(-2).getVisibility() == 0) {
            v = this._alertDialog.getButton(-2);
        }
        if (v == null && this._alertDialog.getButton(-1).getVisibility() == 0) {
            v = this._alertDialog.getButton(-1);
        }
        if (v != null) {
            v.requestFocus();
            return true;
        }
        return false;
    }

    boolean cancelFolderViewOrBack(DialogInterface dialog) {
        if (this._newFolderView != null && this._newFolderView.getVisibility() == 0) {
            this._newFolderView.setVisibility(8);
            return true;
        }
        this._onBackPressed.onBackPressed((AlertDialog)dialog);
        return true;
    }

    @FunctionalInterface
    public static interface CustomizePathView {
        public void customize(TextView var1);
    }

    @FunctionalInterface
    public static interface OnBackPressedListener {
        public void onBackPressed(AlertDialog var1);
    }

    @FunctionalInterface
    public static interface CanNavigateTo {
        public boolean canNavigate(File var1);
    }

    @FunctionalInterface
    public static interface CanNavigateUp {
        public boolean canUpTo(File var1);
    }

    @FunctionalInterface
    public static interface AdapterSetter {
        public void apply(DirAdapter var1);
    }

    @FunctionalInterface
    public static interface Result {
        public void onChoosePath(String var1, File var2);
    }
}

