/*
 * Decompiled with CFR 0.152.
 */
package com.obsez.android.lib.filechooser.internals;

import java.io.File;
import java.io.FileFilter;
import java.util.regex.Pattern;

public class RegexFileFilter
implements FileFilter {
    boolean m_allowHidden;
    boolean m_onlyDirectory;
    Pattern m_pattern;

    public RegexFileFilter() {
        this(null);
    }

    public RegexFileFilter(Pattern ptn) {
        this(false, false, ptn);
    }

    public RegexFileFilter(boolean dirOnly, boolean hidden, String ptn) {
        this.m_allowHidden = hidden;
        this.m_onlyDirectory = dirOnly;
        this.m_pattern = Pattern.compile(ptn, 2);
    }

    public RegexFileFilter(boolean dirOnly, boolean hidden, String ptn, int flags) {
        this.m_allowHidden = hidden;
        this.m_onlyDirectory = dirOnly;
        this.m_pattern = Pattern.compile(ptn, flags);
    }

    public RegexFileFilter(boolean dirOnly, boolean hidden, Pattern ptn) {
        this.m_allowHidden = hidden;
        this.m_onlyDirectory = dirOnly;
        this.m_pattern = ptn;
    }

    @Override
    public boolean accept(File pathname) {
        if (!this.m_allowHidden && pathname.isHidden()) {
            return false;
        }
        if (this.m_onlyDirectory && !pathname.isDirectory()) {
            return false;
        }
        if (this.m_pattern == null) {
            return true;
        }
        if (pathname.isDirectory()) {
            return true;
        }
        String name = pathname.getName();
        return this.m_pattern.matcher(name).matches();
    }
}

