/*
 * Decompiled with CFR 0.152.
 */
package com.obsez.android.lib.filechooser.internals;

import android.content.Context;
import android.os.Build;
import android.os.Environment;
import android.os.StatFs;
import android.os.storage.StorageManager;
import android.support.annotation.NonNull;
import android.text.InputFilter;
import android.text.SpannableStringBuilder;
import android.text.Spanned;
import java.io.File;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.DecimalFormat;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class FileUtil {
    public static String getExtension(File file) {
        if (file == null) {
            return null;
        }
        int dot = file.getName().lastIndexOf(".");
        if (dot >= 0) {
            return file.getName().substring(dot);
        }
        return "";
    }

    public static String getExtensionWithoutDot(File file) {
        String ext = FileUtil.getExtension(file);
        if (ext.length() == 0) {
            return ext;
        }
        return ext.substring(1);
    }

    public static String getReadableFileSize(long size) {
        int BYTES_IN_KILOBYTES = 1024;
        DecimalFormat dec = new DecimalFormat("###.#");
        String KILOBYTES = " KB";
        String MEGABYTES = " MB";
        String GIGABYTES = " GB";
        float fileSize = 0.0f;
        String suffix = " KB";
        if (size > 1024L && (fileSize = (float)(size / 1024L)) > 1024.0f) {
            if ((fileSize /= 1024.0f) > 1024.0f) {
                fileSize /= 1024.0f;
                suffix = " GB";
            } else {
                suffix = " MB";
            }
        }
        return String.valueOf(dec.format(fileSize) + suffix);
    }

    @NonNull
    public static String getStoragePath(Context context, boolean isRemovable) {
        StorageManager storageManager = (StorageManager)context.getSystemService("storage");
        Class<?> storageVolumeClazz = null;
        try {
            storageVolumeClazz = Class.forName("android.os.storage.StorageVolume");
            Method getVolumeList = storageManager.getClass().getMethod("getVolumeList", new Class[0]);
            Method getPath = storageVolumeClazz.getMethod("getPath", new Class[0]);
            Method isRemovableMtd = storageVolumeClazz.getMethod("isRemovable", new Class[0]);
            Object result = getVolumeList.invoke((Object)storageManager, new Object[0]);
            int length = Array.getLength(result);
            for (int i = 0; i < length; ++i) {
                Object storageVolumeElement = Array.get(result, i);
                String path = (String)getPath.invoke(storageVolumeElement, new Object[0]);
                boolean removable = (Boolean)isRemovableMtd.invoke(storageVolumeElement, new Object[0]);
                if (isRemovable != removable) continue;
                return path;
            }
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return Environment.getExternalStorageDirectory().getAbsolutePath();
    }

    public static long readSDCard(Context context, Boolean isRemovable) {
        return FileUtil.readSDCard(context, isRemovable, false);
    }

    public static long readSDCard(Context context, Boolean isRemovable, Boolean freeOrTotal) {
        DecimalFormat df = new DecimalFormat("0.00");
        if (FileUtil.getStoragePath(context, isRemovable) != null) {
            long availCount;
            long blockCount;
            long blockSize;
            StatFs sf = new StatFs(FileUtil.getStoragePath(context, isRemovable));
            if (Build.VERSION.SDK_INT > 18) {
                blockSize = sf.getBlockSizeLong();
                blockCount = sf.getBlockCountLong();
                availCount = sf.getFreeBlocksLong();
            } else {
                blockSize = sf.getBlockSize();
                blockCount = sf.getBlockCount();
                availCount = sf.getFreeBlocks();
            }
            return (freeOrTotal != false ? availCount : blockCount) * blockSize;
        }
        return -1L;
    }

    public static class NewFolderFilter
    implements InputFilter {
        private final int maxLength;
        private final Pattern pattern;

        public NewFolderFilter() {
            this(255, "^[^/<>|\\\\:&;#\n\r\t?*~\u0000-\u001f]*$");
        }

        public NewFolderFilter(int maxLength) {
            this(maxLength, "^[^/<>|\\\\:&;#\n\r\t?*~\u0000-\u001f]*$");
        }

        public NewFolderFilter(String pattern) {
            this(255, pattern);
        }

        public NewFolderFilter(int maxLength, String pattern) {
            this.maxLength = maxLength;
            this.pattern = Pattern.compile(pattern);
        }

        public CharSequence filter(CharSequence source, int start, int end, Spanned dest, int dstart, int dend) {
            Matcher matcher = this.pattern.matcher(source);
            if (!matcher.matches()) {
                return source instanceof SpannableStringBuilder ? dest.subSequence(dstart, dend) : "";
            }
            int keep = this.maxLength - (dest.length() - (dend - dstart));
            if (keep <= 0) {
                return "";
            }
            if (keep >= end - start) {
                return null;
            }
            if (Character.isHighSurrogate(source.charAt((keep += start) - 1)) && --keep == start) {
                return "";
            }
            return source.subSequence(start, keep).toString();
        }
    }
}

