/*
 * Decompiled with CFR 0.152.
 */
package com.obsez.android.lib.filechooser;

import android.app.Activity;
import android.app.AlertDialog;
import android.app.Fragment;
import android.content.Context;
import android.content.DialogInterface;
import android.graphics.ColorFilter;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffColorFilter;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.Environment;
import android.os.Handler;
import android.support.annotation.DrawableRes;
import android.support.annotation.LayoutRes;
import android.support.annotation.StringRes;
import android.support.v4.app.ActivityCompat;
import android.support.v4.content.ContextCompat;
import android.support.v4.view.ViewCompat;
import android.text.InputFilter;
import android.util.Log;
import android.view.KeyEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.widget.AdapterView;
import android.widget.Button;
import android.widget.EditText;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.Space;
import android.widget.TextView;
import android.widget.Toast;
import com.obsez.android.lib.filechooser.R;
import com.obsez.android.lib.filechooser.internals.ExtFileFilter;
import com.obsez.android.lib.filechooser.internals.FileUtil;
import com.obsez.android.lib.filechooser.internals.RegexFileFilter;
import com.obsez.android.lib.filechooser.internals.UiUtil;
import com.obsez.android.lib.filechooser.tool.DirAdapter;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;

public class ChooserDialog
implements AdapterView.OnItemClickListener,
DialogInterface.OnClickListener,
AdapterView.OnItemLongClickListener {
    private static File __sdcardRoot = new File(".. SDCard Storage"){

        @Override
        public boolean isDirectory() {
            return true;
        }

        @Override
        public boolean isHidden() {
            return false;
        }

        @Override
        public long lastModified() {
            return 0L;
        }
    };
    private static File __primaryRoot = new File(".. Primary Storage"){

        @Override
        public boolean isDirectory() {
            return true;
        }

        @Override
        public boolean isHidden() {
            return false;
        }

        @Override
        public long lastModified() {
            return 0L;
        }
    };
    private static File __normalParent = new File(".."){

        @Override
        public boolean isDirectory() {
            return true;
        }

        @Override
        public boolean isHidden() {
            return false;
        }

        @Override
        public long lastModified() {
            return 0L;
        }
    };
    private Runnable _deleteModeIndicator;
    private List<File> _entries = new ArrayList<File>();
    private DirAdapter _adapter;
    private File _currentDir;
    private Context _context;
    private AlertDialog _alertDialog;
    private ListView _list;
    private Result _result = null;
    private boolean _dirOnly;
    private FileFilter _fileFilter;
    @StringRes
    private int _titleRes = R.string.choose_file;
    @StringRes
    private int _okRes = R.string.title_choose;
    @StringRes
    private int _negativeRes = R.string.dialog_cancel;
    @DrawableRes
    private int _iconRes = -1;
    @LayoutRes
    private int _layoutRes = -1;
    @LayoutRes
    private int _rowLayoutRes = -1;
    private String _dateFormat;
    private DialogInterface.OnClickListener _negativeListener;
    private DialogInterface.OnCancelListener _cancelListener2;
    private DialogInterface.OnDismissListener _onDismissListener;
    private boolean _disableTitle;
    private boolean _enableOptions;
    private View _options;
    @StringRes
    private int _createDirRes = R.string.option_create_folder;
    @StringRes
    private int _deleteRes = R.string.options_delete;
    @StringRes
    private int _newFolderCancelRes = R.string.new_folder_cancel;
    @StringRes
    private int _newFolderOkRes = R.string.new_folder_ok;
    @DrawableRes
    private int _optionsIconRes = -1;
    @DrawableRes
    private int _createDirIconRes = -1;
    @DrawableRes
    private int _deleteIconRes = -1;
    private View _newFolderView;
    private boolean _dismissOnButtonClick = true;
    private boolean _enableMultiple;
    private AdapterSetter _adapterSetter = null;
    private CanNavigateUp _folderNavUpCB;
    private CanNavigateTo _folderNavToCB;
    private static final CanNavigateUp _defaultNavUpCB = new CanNavigateUp(){

        @Override
        public boolean canUpTo(File dir) {
            return dir != null && dir.canRead();
        }
    };
    private static final CanNavigateTo _defaultNavToCB = new CanNavigateTo(){

        @Override
        public boolean canNavigate(File dir) {
            return true;
        }
    };
    private OnBackPressedListener _onBackPressed = new OnBackPressedListener(){

        @Override
        public void onBackPressed(AlertDialog dialog) {
            if (ChooserDialog.this._entries.size() > 0 && ((File)ChooserDialog.this._entries.get(0)).getName().equals("..") || ((File)ChooserDialog.this._entries.get(0)).getName().contains(".. SDCard Storage") || ((File)ChooserDialog.this._entries.get(0)).getName().contains(".. Primary Storage")) {
                ChooserDialog.this.onItemClick(null, (View)ChooserDialog.this._list, 0, 0L);
            } else if (ChooserDialog.this._onLastBackPressed != null) {
                ChooserDialog.this._onLastBackPressed.onBackPressed(dialog);
            } else {
                ChooserDialog.this._defaultLastBack.onBackPressed(dialog);
            }
        }
    };
    private OnBackPressedListener _onLastBackPressed;
    private OnBackPressedListener _defaultLastBack = new OnBackPressedListener(){

        @Override
        public void onBackPressed(AlertDialog dialog) {
            dialog.dismiss();
        }
    };
    private static final int CHOOSE_MODE_NORMAL = 0;
    private static final int CHOOSE_MODE_DELETE = 1;
    private static final int CHOOSE_MODE_SELECT_MULTIPLE = 2;
    private int _chooseMode = 0;
    private FileUtil.NewFolderFilter _newFolderFilter;

    public ChooserDialog() {
    }

    public ChooserDialog(Context cxt) {
        this._context = cxt;
    }

    public ChooserDialog(Activity activity) {
        this._context = activity;
    }

    public ChooserDialog(Fragment fragment) {
        this._context = fragment.getActivity();
    }

    public ChooserDialog with(Context cxt) {
        this._context = cxt;
        return this;
    }

    public ChooserDialog withFilter(FileFilter ff) {
        this.withFilter(false, false, (String[])null);
        this._fileFilter = ff;
        return this;
    }

    public ChooserDialog withFilter(boolean dirOnly, boolean allowHidden, FileFilter ff) {
        this.withFilter(dirOnly, allowHidden, (String[])null);
        this._fileFilter = ff;
        return this;
    }

    public ChooserDialog withFilter(boolean allowHidden, String ... suffixes) {
        return this.withFilter(false, allowHidden, suffixes);
    }

    public ChooserDialog withFilter(boolean dirOnly, final boolean allowHidden, String ... suffixes) {
        this._dirOnly = dirOnly;
        this._fileFilter = suffixes == null || suffixes.length == 0 ? (dirOnly ? new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.isDirectory() && (!file.isHidden() || allowHidden);
            }
        } : new FileFilter(){

            @Override
            public boolean accept(File file) {
                return !file.isHidden() || allowHidden;
            }
        }) : new ExtFileFilter(this._dirOnly, allowHidden, suffixes);
        return this;
    }

    public ChooserDialog withFilterRegex(boolean dirOnly, boolean allowHidden, String pattern, int flags) {
        this._dirOnly = dirOnly;
        this._fileFilter = new RegexFileFilter(this._dirOnly, allowHidden, pattern, flags);
        return this;
    }

    public ChooserDialog withFilterRegex(boolean dirOnly, boolean allowHidden, String pattern) {
        this._dirOnly = dirOnly;
        this._fileFilter = new RegexFileFilter(this._dirOnly, allowHidden, pattern, 2);
        return this;
    }

    public ChooserDialog withStartFile(String startFile) {
        this._currentDir = startFile != null ? new File(startFile) : Environment.getExternalStorageDirectory();
        if (!this._currentDir.isDirectory()) {
            this._currentDir = this._currentDir.getParentFile();
        }
        if (this._currentDir == null) {
            this._currentDir = Environment.getExternalStorageDirectory();
        }
        return this;
    }

    public ChooserDialog dismissOnButtonClick(boolean dismissOnButtonClick) {
        this._dismissOnButtonClick = dismissOnButtonClick;
        this._defaultLastBack = dismissOnButtonClick ? new OnBackPressedListener(){

            @Override
            public void onBackPressed(AlertDialog dialog) {
                dialog.dismiss();
            }
        } : new OnBackPressedListener(){

            @Override
            public void onBackPressed(AlertDialog dialog) {
            }
        };
        return this;
    }

    public ChooserDialog withChosenListener(Result r) {
        this._result = r;
        return this;
    }

    public ChooserDialog withOnBackPressedListener(OnBackPressedListener listener) {
        this._onBackPressed = listener;
        return this;
    }

    public ChooserDialog withOnLastBackPressedListener(OnBackPressedListener listener) {
        this._onLastBackPressed = listener;
        return this;
    }

    public ChooserDialog withResources(@StringRes int titleRes, @StringRes int okRes, @StringRes int cancelRes) {
        this._titleRes = titleRes;
        this._okRes = okRes;
        this._negativeRes = cancelRes;
        return this;
    }

    public ChooserDialog enableOptions(boolean enableOptions) {
        this._enableOptions = enableOptions;
        return this;
    }

    public ChooserDialog withOptionResources(@StringRes int createDirRes, @StringRes int deleteRes, @StringRes int newFolderCancelRes, @StringRes int newFolderOkRes) {
        this._createDirRes = createDirRes;
        this._deleteRes = deleteRes;
        this._newFolderCancelRes = newFolderCancelRes;
        this._newFolderOkRes = newFolderOkRes;
        return this;
    }

    public ChooserDialog withOptionIcons(@DrawableRes int optionsIconRes, @DrawableRes int createDirIconRes, @DrawableRes int deleteRes) {
        this._optionsIconRes = optionsIconRes;
        this._createDirIconRes = createDirIconRes;
        this._deleteIconRes = deleteRes;
        return this;
    }

    public ChooserDialog withNewFolderFilter(FileUtil.NewFolderFilter filter) {
        this._newFolderFilter = filter;
        return this;
    }

    public ChooserDialog withIcon(@DrawableRes int iconId) {
        this._iconRes = iconId;
        return this;
    }

    public ChooserDialog withLayoutView(@LayoutRes int layoutResId) {
        this._layoutRes = layoutResId;
        return this;
    }

    public ChooserDialog withRowLayoutView(@LayoutRes int layoutResId) {
        this._rowLayoutRes = layoutResId;
        return this;
    }

    public ChooserDialog withDateFormat() {
        return this.withDateFormat("yyyy/MM/dd HH:mm:ss");
    }

    public ChooserDialog withDateFormat(String format) {
        this._dateFormat = format;
        return this;
    }

    public ChooserDialog withNegativeButton(@StringRes int cancelTitle, DialogInterface.OnClickListener listener) {
        this._negativeRes = cancelTitle;
        this._negativeListener = listener;
        return this;
    }

    public ChooserDialog withNegativeButtonListener(DialogInterface.OnClickListener listener) {
        this._negativeListener = listener;
        return this;
    }

    public ChooserDialog withOnCancelListener(DialogInterface.OnCancelListener listener) {
        this._cancelListener2 = listener;
        return this;
    }

    public ChooserDialog withOnDismissListener(DialogInterface.OnDismissListener listener) {
        if (Build.VERSION.SDK_INT >= 17) {
            this._onDismissListener = listener;
        }
        return this;
    }

    public ChooserDialog withFileIcons(final boolean tryResolveFileTypeAndIcon, final Drawable fileIcon, final Drawable folderIcon) {
        this._adapterSetter = new AdapterSetter(){

            @Override
            public void apply(DirAdapter adapter) {
                if (fileIcon != null) {
                    adapter.setDefaultFileIcon(fileIcon);
                }
                if (folderIcon != null) {
                    adapter.setDefaultFolderIcon(folderIcon);
                }
                adapter.setResolveFileType(tryResolveFileTypeAndIcon);
            }
        };
        return this;
    }

    public ChooserDialog withFileIconsRes(final boolean tryResolveFileTypeAndIcon, final int fileIcon, final int folderIcon) {
        this._adapterSetter = new AdapterSetter(){

            @Override
            public void apply(DirAdapter adapter) {
                if (fileIcon != -1) {
                    adapter.setDefaultFileIcon(ContextCompat.getDrawable((Context)ChooserDialog.this._context, (int)fileIcon));
                }
                if (folderIcon != -1) {
                    adapter.setDefaultFolderIcon(ContextCompat.getDrawable((Context)ChooserDialog.this._context, (int)folderIcon));
                }
                adapter.setResolveFileType(tryResolveFileTypeAndIcon);
            }
        };
        return this;
    }

    public ChooserDialog withAdapterSetter(AdapterSetter setter) {
        this._adapterSetter = setter;
        return this;
    }

    public ChooserDialog withNavigateUpTo(CanNavigateUp cb) {
        this._folderNavUpCB = cb;
        return this;
    }

    public ChooserDialog withNavigateTo(CanNavigateTo cb) {
        this._folderNavToCB = cb;
        return this;
    }

    public ChooserDialog disableTitle(boolean disableTitle) {
        this._disableTitle = disableTitle;
        return this;
    }

    public ChooserDialog enableMultiple(boolean enableMultiple) {
        this._enableMultiple = enableMultiple;
        return this;
    }

    public ChooserDialog build() {
        if (this._titleRes == 0 || this._okRes == 0 || this._negativeRes == 0) {
            throw new RuntimeException("withResources() should be called at first.");
        }
        AlertDialog.Builder builder = new AlertDialog.Builder(this._context);
        this._adapter = new DirAdapter(this._context, new ArrayList<File>(), this._rowLayoutRes != -1 ? this._rowLayoutRes : R.layout.li_row_textview, this._dateFormat);
        if (this._adapterSetter != null) {
            this._adapterSetter.apply(this._adapter);
        }
        this.refreshDirs();
        builder.setAdapter((ListAdapter)this._adapter, (DialogInterface.OnClickListener)this);
        if (!this._disableTitle) {
            builder.setTitle(this._titleRes);
        }
        if (this._iconRes != -1) {
            builder.setIcon(this._iconRes);
        }
        if (this._layoutRes != -1 && Build.VERSION.SDK_INT >= 21) {
            builder.setView(this._layoutRes);
        }
        if (this._dirOnly || this._enableMultiple) {
            builder.setPositiveButton(this._okRes, new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    if (ChooserDialog.this._result != null) {
                        ChooserDialog.this._result.onChoosePath(ChooserDialog.this._currentDir.getAbsolutePath(), ChooserDialog.this._currentDir);
                    }
                }
            });
        }
        builder.setNegativeButton(this._negativeRes, this._negativeListener);
        if (this._cancelListener2 != null) {
            builder.setOnCancelListener(this._cancelListener2);
        }
        if (Build.VERSION.SDK_INT >= 17 && this._onDismissListener != null) {
            builder.setOnDismissListener(this._onDismissListener);
        }
        builder.setOnKeyListener(new DialogInterface.OnKeyListener(){

            public boolean onKey(DialogInterface dialog, int keyCode, KeyEvent event) {
                switch (keyCode) {
                    case 111: {
                        if (event.getAction() == 1) {
                            if (ChooserDialog.this._newFolderView != null && ChooserDialog.this._newFolderView.getVisibility() == 0) {
                                ChooserDialog.this._newFolderView.setVisibility(4);
                                return true;
                            }
                            ChooserDialog.this._onBackPressed.onBackPressed((AlertDialog)dialog);
                        }
                        return true;
                    }
                    case 19: {
                        if (event.getAction() != 1) break;
                        return ChooserDialog.this.doMoveUp();
                    }
                    case 20: {
                        if (event.getAction() != 1) break;
                        return ChooserDialog.this.doMoveDown();
                    }
                    case 21: {
                        if (event.getAction() != 1) break;
                        return ChooserDialog.this.doGoBack();
                    }
                    case 22: 
                    case 23: {
                        if (event.getAction() != 1) break;
                        return ChooserDialog.this.doEnter();
                    }
                }
                return false;
            }
        });
        this._alertDialog = builder.create();
        this.setupOnShowListener();
        this._list = this._alertDialog.getListView();
        this._list.setOnItemClickListener((AdapterView.OnItemClickListener)this);
        if (this._enableMultiple) {
            this._list.setOnItemLongClickListener((AdapterView.OnItemLongClickListener)this);
        }
        return this;
    }

    private void setupOnShowListener() {
        this._alertDialog.setOnShowListener(new DialogInterface.OnShowListener(){

            public void onShow(final DialogInterface dialog) {
                if (!ChooserDialog.this._dismissOnButtonClick) {
                    Button negative = ((AlertDialog)dialog).getButton(-2);
                    Button positive = ((AlertDialog)dialog).getButton(-1);
                    negative.setOnClickListener(new View.OnClickListener(){

                        public void onClick(View v) {
                            if (ChooserDialog.this._negativeListener != null) {
                                ChooserDialog.this._negativeListener.onClick((DialogInterface)ChooserDialog.this._alertDialog, -2);
                            }
                        }
                    });
                    positive.setOnClickListener(new View.OnClickListener(){

                        public void onClick(View v) {
                            if (ChooserDialog.this._result != null && (ChooserDialog.this._dirOnly || ChooserDialog.this._enableMultiple)) {
                                ChooserDialog.this._result.onChoosePath(ChooserDialog.this._currentDir.getAbsolutePath(), ChooserDialog.this._currentDir);
                            }
                        }
                    });
                }
                if (ChooserDialog.this._createDirRes == 0 || ChooserDialog.this._newFolderCancelRes == 0 || ChooserDialog.this._newFolderOkRes == 0) {
                    throw new RuntimeException("withOptionResources() should be called at first.");
                }
                if (ChooserDialog.this._enableOptions) {
                    final int color = UiUtil.getThemeAccentColor(ChooserDialog.this._context);
                    final PorterDuffColorFilter filter = new PorterDuffColorFilter(color, PorterDuff.Mode.SRC_IN);
                    Button options = ((AlertDialog)dialog).getButton(-3);
                    options.setText((CharSequence)"");
                    options.setTextColor(color);
                    options.setVisibility(0);
                    Drawable drawable2 = ContextCompat.getDrawable((Context)ChooserDialog.this._context, (int)(ChooserDialog.this._optionsIconRes != -1 ? ChooserDialog.this._optionsIconRes : R.drawable.ic_menu_24dp));
                    if (drawable2 != null) {
                        drawable2.setColorFilter((ColorFilter)filter);
                        options.setCompoundDrawablesWithIntrinsicBounds(drawable2, null, null, null);
                    } else {
                        options.setCompoundDrawablesWithIntrinsicBounds(ChooserDialog.this._optionsIconRes != -1 ? ChooserDialog.this._optionsIconRes : R.drawable.ic_menu_24dp, 0, 0, 0);
                    }
                    final class Integer {
                        int Int = 0;

                        Integer() {
                        }
                    }
                    final Integer scroll = new Integer();
                    ChooserDialog.this._list.addOnLayoutChangeListener(new View.OnLayoutChangeListener(){
                        {
                        }

                        public void onLayoutChange(View v, int left, int top, int right, int bottom, int oldLeft, int oldTop, int oldRight, int oldBottom) {
                            int oldHeight = oldBottom - oldTop;
                            if (v.getHeight() != oldHeight) {
                                int offset = oldHeight - v.getHeight();
                                int newScroll = UiUtil.getListYScroll(ChooserDialog.this._list);
                                if (scroll.Int != newScroll) {
                                    offset += scroll.Int - newScroll;
                                }
                                if (Build.VERSION.SDK_INT >= 19) {
                                    ChooserDialog.this._list.scrollListBy(offset);
                                } else {
                                    ChooserDialog.this._list.scrollBy(0, offset);
                                }
                            }
                        }
                    });
                    final Runnable showOptions = new Runnable(){
                        {
                        }

                        @Override
                        public void run() {
                            final ViewGroup.MarginLayoutParams params = (ViewGroup.MarginLayoutParams)ChooserDialog.this._list.getLayoutParams();
                            if (ChooserDialog.this._options.getHeight() == 0) {
                                ViewTreeObserver viewTreeObserver = ChooserDialog.this._options.getViewTreeObserver();
                                viewTreeObserver.addOnPreDrawListener(new ViewTreeObserver.OnPreDrawListener(){

                                    public boolean onPreDraw() {
                                        if (ChooserDialog.this._options.getHeight() <= 0) {
                                            return false;
                                        }
                                        ChooserDialog.this._options.getViewTreeObserver().removeOnPreDrawListener((ViewTreeObserver.OnPreDrawListener)this);
                                        Handler handler = new Handler();
                                        handler.postDelayed(new Runnable(){

                                            @Override
                                            public void run() {
                                                scroll.Int = UiUtil.getListYScroll(ChooserDialog.this._list);
                                                if (ChooserDialog.this._options.getParent() instanceof LinearLayout) {
                                                    params.height = ((LinearLayout)ChooserDialog.this._options.getParent()).getHeight() - ChooserDialog.this._options.getHeight();
                                                } else {
                                                    params.bottomMargin = ChooserDialog.this._options.getHeight();
                                                }
                                                ChooserDialog.this._list.setLayoutParams((ViewGroup.LayoutParams)params);
                                                ChooserDialog.this._options.setVisibility(0);
                                            }
                                        }, 100L);
                                        return true;
                                    }
                                });
                            } else {
                                scroll.Int = UiUtil.getListYScroll(ChooserDialog.this._list);
                                ChooserDialog.this._options.setVisibility(0);
                                if (ChooserDialog.this._options.getParent() instanceof LinearLayout) {
                                    params.height = ((LinearLayout)ChooserDialog.this._options.getParent()).getHeight() - ChooserDialog.this._options.getHeight();
                                } else {
                                    params.bottomMargin = ChooserDialog.this._options.getHeight();
                                }
                                ChooserDialog.this._list.setLayoutParams((ViewGroup.LayoutParams)params);
                            }
                        }
                    };
                    final Runnable hideOptions = new Runnable(){
                        {
                        }

                        @Override
                        public void run() {
                            scroll.Int = UiUtil.getListYScroll(ChooserDialog.this._list);
                            ChooserDialog.this._options.setVisibility(4);
                            ViewGroup.MarginLayoutParams params = (ViewGroup.MarginLayoutParams)ChooserDialog.this._list.getLayoutParams();
                            if (ChooserDialog.this._options.getParent() instanceof LinearLayout) {
                                params.height = ((LinearLayout)ChooserDialog.this._options.getParent()).getHeight();
                            } else {
                                params.bottomMargin = 0;
                            }
                            ChooserDialog.this._list.setLayoutParams((ViewGroup.LayoutParams)params);
                        }
                    };
                    options.setOnClickListener(new View.OnClickListener(){

                        public void onClick(View view) {
                            if (ChooserDialog.this._options == null) {
                                int rootId = ChooserDialog.this._context.getResources().getIdentifier("contentPanel", "id", "android");
                                ViewGroup root1 = (ViewGroup)((AlertDialog)dialog).findViewById(rootId);
                                boolean linear = root1 instanceof LinearLayout;
                                final ViewGroup root = root1;
                                if (root == null) {
                                    return;
                                }
                                FrameLayout options = new FrameLayout(ChooserDialog.this._context);
                                Object params = linear ? new LinearLayout.LayoutParams(-1, (int)UiUtil.dip2px(48.0f)) : new FrameLayout.LayoutParams(-1, -2, 80);
                                root.addView((View)options, (ViewGroup.LayoutParams)params);
                                options.setOnClickListener(null);
                                options.setVisibility(4);
                                ChooserDialog.this._options = (View)options;
                                Button createDir = new Button(ChooserDialog.this._context, null, 16843567);
                                createDir.setText(ChooserDialog.this._createDirRes);
                                createDir.setTextColor(color);
                                Drawable plus = ContextCompat.getDrawable((Context)ChooserDialog.this._context, (int)(ChooserDialog.this._createDirIconRes != -1 ? ChooserDialog.this._createDirIconRes : R.drawable.ic_add_24dp));
                                if (plus != null) {
                                    plus.setColorFilter((ColorFilter)filter);
                                    createDir.setCompoundDrawablesWithIntrinsicBounds(plus, null, null, null);
                                } else {
                                    createDir.setCompoundDrawablesWithIntrinsicBounds(ChooserDialog.this._createDirIconRes != -1 ? ChooserDialog.this._createDirIconRes : R.drawable.ic_add_24dp, 0, 0, 0);
                                }
                                params = new FrameLayout.LayoutParams(-2, -2, 8388627);
                                params.leftMargin = 10;
                                options.addView((View)createDir, (ViewGroup.LayoutParams)params);
                                final Button delete = new Button(ChooserDialog.this._context, null, 16843567);
                                delete.setText(ChooserDialog.this._deleteRes);
                                delete.setTextColor(color);
                                Drawable bin = ContextCompat.getDrawable((Context)ChooserDialog.this._context, (int)(ChooserDialog.this._deleteIconRes != -1 ? ChooserDialog.this._deleteIconRes : R.drawable.ic_delete_24dp));
                                if (bin != null) {
                                    bin.setColorFilter((ColorFilter)filter);
                                    delete.setCompoundDrawablesWithIntrinsicBounds(bin, null, null, null);
                                } else {
                                    delete.setCompoundDrawablesWithIntrinsicBounds(ChooserDialog.this._deleteIconRes != -1 ? ChooserDialog.this._deleteIconRes : R.drawable.ic_delete_24dp, 0, 0, 0);
                                }
                                params = new FrameLayout.LayoutParams(-2, -2, 8388629);
                                params.rightMargin = 10;
                                options.addView((View)delete, (ViewGroup.LayoutParams)params);
                                createDir.setOnClickListener(new View.OnClickListener(){
                                    private EditText input = null;

                                    public void onClick(View view) {
                                        hideOptions.run();
                                        File newFolder = new File(ChooserDialog.this._currentDir, "New folder");
                                        int i = 1;
                                        while (newFolder.exists()) {
                                            newFolder = new File(ChooserDialog.this._currentDir, "New folder (" + i + ')');
                                            ++i;
                                        }
                                        if (this.input != null) {
                                            this.input.setText((CharSequence)newFolder.getName());
                                        }
                                        if (ChooserDialog.this._newFolderView == null) {
                                            try {
                                                ((AlertDialog)dialog).getWindow().clearFlags(131080);
                                                ((AlertDialog)dialog).getWindow().setSoftInputMode(4);
                                            }
                                            catch (NullPointerException e) {
                                                e.printStackTrace();
                                            }
                                            final FrameLayout overlay = new FrameLayout(ChooserDialog.this._context);
                                            overlay.setBackgroundColor(0x60FFFFFF);
                                            overlay.setScrollContainer(true);
                                            FrameLayout.LayoutParams params = new FrameLayout.LayoutParams(-1, -1, 17);
                                            root.addView((View)overlay, (ViewGroup.LayoutParams)params);
                                            overlay.setOnClickListener(null);
                                            overlay.setVisibility(4);
                                            ChooserDialog.this._newFolderView = (View)overlay;
                                            LinearLayout linearLayout = new LinearLayout(ChooserDialog.this._context);
                                            params = new FrameLayout.LayoutParams(-1, -2, 17);
                                            overlay.addView((View)linearLayout, (ViewGroup.LayoutParams)params);
                                            Space leftSpace = new Space(ChooserDialog.this._context);
                                            params = new LinearLayout.LayoutParams(0, -2, 2.0f);
                                            linearLayout.addView((View)leftSpace, (ViewGroup.LayoutParams)params);
                                            LinearLayout holder = new LinearLayout(ChooserDialog.this._context);
                                            holder.setOrientation(1);
                                            holder.setBackgroundColor(-1);
                                            if (Build.VERSION.SDK_INT >= 21) {
                                                holder.setElevation(25.0f);
                                            } else {
                                                ViewCompat.setElevation((View)holder, (float)25.0f);
                                            }
                                            params = new LinearLayout.LayoutParams(0, -2, 5.0f);
                                            linearLayout.addView((View)holder, (ViewGroup.LayoutParams)params);
                                            Space rightSpace = new Space(ChooserDialog.this._context);
                                            params = new LinearLayout.LayoutParams(0, -2, 2.0f);
                                            linearLayout.addView((View)rightSpace, (ViewGroup.LayoutParams)params);
                                            final EditText input = new EditText(ChooserDialog.this._context);
                                            input.setText((CharSequence)newFolder.getName());
                                            input.setSelectAllOnFocus(true);
                                            input.setSingleLine(true);
                                            input.setInputType(524464);
                                            input.setFilters(new InputFilter[]{ChooserDialog.this._newFolderFilter != null ? ChooserDialog.this._newFolderFilter : new FileUtil.NewFolderFilter()});
                                            input.setGravity(1);
                                            params = new LinearLayout.LayoutParams(-1, -2);
                                            params.setMargins(3, 2, 3, 0);
                                            holder.addView((View)input, (ViewGroup.LayoutParams)params);
                                            this.input = input;
                                            FrameLayout buttons = new FrameLayout(ChooserDialog.this._context);
                                            params = new LinearLayout.LayoutParams(-1, -2);
                                            holder.addView((View)buttons, (ViewGroup.LayoutParams)params);
                                            Button cancel = new Button(ChooserDialog.this._context, null, 16843567);
                                            cancel.setText(ChooserDialog.this._newFolderCancelRes);
                                            cancel.setTextColor(color);
                                            params = new FrameLayout.LayoutParams(-2, -2, 0x800003);
                                            buttons.addView((View)cancel, (ViewGroup.LayoutParams)params);
                                            Button ok = new Button(ChooserDialog.this._context, null, 16843567);
                                            ok.setText(ChooserDialog.this._newFolderOkRes);
                                            ok.setTextColor(color);
                                            params = new FrameLayout.LayoutParams(-2, -2, 0x800005);
                                            buttons.addView((View)ok, (ViewGroup.LayoutParams)params);
                                            input.setOnEditorActionListener(new TextView.OnEditorActionListener(){

                                                public boolean onEditorAction(TextView v, int actionId, KeyEvent event) {
                                                    if (actionId == 6) {
                                                        ChooserDialog.this.createNewDirectory(input.getText().toString());
                                                        UiUtil.hideKeyboardFrom(ChooserDialog.this._context, (View)input);
                                                        overlay.setVisibility(4);
                                                        return true;
                                                    }
                                                    return false;
                                                }
                                            });
                                            cancel.setOnClickListener(new View.OnClickListener(){

                                                public void onClick(View v) {
                                                    UiUtil.hideKeyboardFrom(ChooserDialog.this._context, (View)input);
                                                    overlay.setVisibility(4);
                                                }
                                            });
                                            ok.setOnClickListener(new View.OnClickListener(){

                                                public void onClick(View v) {
                                                    ChooserDialog.this.createNewDirectory(input.getText().toString());
                                                    UiUtil.hideKeyboardFrom(ChooserDialog.this._context, (View)input);
                                                    overlay.setVisibility(4);
                                                }
                                            });
                                        }
                                        if (ChooserDialog.this._newFolderView.getVisibility() == 4) {
                                            ChooserDialog.this._newFolderView.setVisibility(0);
                                        } else {
                                            ChooserDialog.this._newFolderView.setVisibility(4);
                                        }
                                    }
                                });
                                delete.setOnClickListener(new View.OnClickListener(){

                                    public void onClick(View v1) {
                                        hideOptions.run();
                                        if (ChooserDialog.this._chooseMode == 2) {
                                            boolean success = true;
                                            for (File file : ChooserDialog.this._adapter.getSelected()) {
                                                ChooserDialog.this._result.onChoosePath(file.getAbsolutePath(), file);
                                                if (!success) continue;
                                                try {
                                                    ChooserDialog.this.deleteFile(file);
                                                }
                                                catch (IOException e) {
                                                    Toast.makeText((Context)ChooserDialog.this._context, (CharSequence)e.getMessage(), (int)1).show();
                                                    success = false;
                                                }
                                            }
                                            ChooserDialog.this._adapter.clearSelected();
                                            ChooserDialog.this._alertDialog.getButton(-1).setVisibility(4);
                                            ChooserDialog.this._chooseMode = 0;
                                            ChooserDialog.this.refreshDirs();
                                            return;
                                        }
                                        ChooserDialog.this._chooseMode = ChooserDialog.this._chooseMode != 1 ? 1 : 0;
                                        if (ChooserDialog.this._deleteModeIndicator == null) {
                                            ChooserDialog.this._deleteModeIndicator = new Runnable(){

                                                @Override
                                                public void run() {
                                                    if (ChooserDialog.this._chooseMode == 1) {
                                                        int color = -2130771968;
                                                        PorterDuffColorFilter red = new PorterDuffColorFilter(-2130771968, PorterDuff.Mode.SRC_IN);
                                                        ChooserDialog.this._alertDialog.getButton(-3).getCompoundDrawables()[0].setColorFilter((ColorFilter)red);
                                                        ChooserDialog.this._alertDialog.getButton(-3).setTextColor(-2130771968);
                                                        delete.getCompoundDrawables()[0].setColorFilter((ColorFilter)red);
                                                        delete.setTextColor(-2130771968);
                                                    } else {
                                                        ChooserDialog.this._alertDialog.getButton(-3).getCompoundDrawables()[0].clearColorFilter();
                                                        ChooserDialog.this._alertDialog.getButton(-3).setTextColor(color);
                                                        delete.getCompoundDrawables()[0].clearColorFilter();
                                                        delete.setTextColor(color);
                                                    }
                                                }
                                            };
                                        }
                                        ChooserDialog.this._deleteModeIndicator.run();
                                    }
                                });
                            }
                            if (ChooserDialog.this._options.getVisibility() == 0) {
                                hideOptions.run();
                            } else {
                                showOptions.run();
                            }
                        }
                    });
                }
            }
        });
    }

    /*
     * Enabled aggressive block sorting
     */
    public ChooserDialog show() {
        block10: {
            if (this._alertDialog == null || this._list == null) {
                throw new RuntimeException("call build() before show().");
            }
            if (Build.VERSION.SDK_INT >= 23) {
                boolean PERMISSION_REQUEST_READ_AND_WRITE_EXTERNAL_STORAGE = false;
                if (this._enableOptions) {
                    int readPermissionCheck = ContextCompat.checkSelfPermission((Context)this._context, (String)"android.permission.READ_EXTERNAL_STORAGE");
                    int writePermissionCheck = ContextCompat.checkSelfPermission((Context)this._context, (String)"android.permission.WRITE_EXTERNAL_STORAGE");
                    if (readPermissionCheck == 0 && writePermissionCheck == 0) {
                        this._alertDialog.show();
                        break block10;
                    } else {
                        ActivityCompat.requestPermissions((Activity)((Activity)this._context), (String[])new String[]{"android.permission.READ_EXTERNAL_STORAGE", "android.permission.WRITE_EXTERNAL_STORAGE"}, (int)0);
                        readPermissionCheck = ContextCompat.checkSelfPermission((Context)this._context, (String)"android.permission.READ_EXTERNAL_STORAGE");
                        writePermissionCheck = ContextCompat.checkSelfPermission((Context)this._context, (String)"android.permission.WRITE_EXTERNAL_STORAGE");
                        if (readPermissionCheck == 0 && writePermissionCheck == 0) {
                            this._alertDialog.show();
                        }
                        return this;
                    }
                }
                int readPermissionCheck = ContextCompat.checkSelfPermission((Context)this._context, (String)"android.permission.READ_EXTERNAL_STORAGE");
                if (readPermissionCheck == 0) {
                    this._alertDialog.show();
                    break block10;
                } else {
                    ActivityCompat.requestPermissions((Activity)((Activity)this._context), (String[])new String[]{"android.permission.READ_EXTERNAL_STORAGE"}, (int)0);
                    readPermissionCheck = ContextCompat.checkSelfPermission((Context)this._context, (String)"android.permission.READ_EXTERNAL_STORAGE");
                    if (readPermissionCheck == 0) {
                        this._alertDialog.show();
                    }
                    return this;
                }
            }
            this._alertDialog.show();
        }
        if (this._enableMultiple) {
            this._alertDialog.getButton(-1).setVisibility(4);
        }
        return this;
    }

    private void listDirs() {
        this._entries.clear();
        if (this._currentDir == null) {
            this._currentDir = new File(FileUtil.getStoragePath(this._context, false));
        }
        File[] files = this._currentDir.listFiles(this._fileFilter);
        boolean up = false;
        String removableRoot = FileUtil.getStoragePath(this._context, true);
        String primaryRoot = FileUtil.getStoragePath(this._context, false);
        if (removableRoot != null) {
            if (this._currentDir.getAbsolutePath().equals(primaryRoot)) {
                this._entries.add(__sdcardRoot);
                up = true;
            } else if (this._currentDir.getAbsolutePath().equals(removableRoot)) {
                this._entries.add(__primaryRoot);
                up = true;
            }
        }
        if (!up && this._currentDir.getParentFile() != null && this._currentDir.getParentFile().canRead()) {
            this._entries.add(__normalParent);
        }
        if (files == null) {
            return;
        }
        LinkedList<File> dirList = new LinkedList<File>();
        LinkedList<File> fileList = new LinkedList<File>();
        for (File f : files) {
            if (f.isDirectory()) {
                dirList.add(f);
                continue;
            }
            fileList.add(f);
        }
        this.sortByName(dirList);
        this.sortByName(fileList);
        this._entries.addAll(dirList);
        this._entries.addAll(fileList);
    }

    private void sortByName(List<File> list) {
        Collections.sort(list, new Comparator<File>(){

            @Override
            public int compare(File f1, File f2) {
                return f1.getName().toLowerCase().compareTo(f2.getName().toLowerCase());
            }
        });
    }

    private void listDirs2() {
        this._entries.clear();
        File[] files = this._currentDir.listFiles();
        if (this._currentDir.getParent() != null) {
            this._entries.add(new File(".."));
        }
        if (files != null) {
            for (File file : files) {
                if (!file.isDirectory()) continue;
                this._entries.add(file);
            }
        }
        this.sortByName(this._entries);
    }

    private void createNewDirectory(String name) {
        File newDir = new File(this._currentDir, name);
        if (!newDir.exists() && newDir.mkdir()) {
            this.refreshDirs();
            return;
        }
        Toast.makeText((Context)this._context, (CharSequence)("Couldn't create folder " + newDir.getName() + " at " + newDir.getAbsolutePath()), (int)1).show();
    }

    private void deleteFile(File file) throws IOException {
        if (file.isDirectory()) {
            File[] entries;
            for (File entry : entries = file.listFiles()) {
                this.deleteFile(entry);
            }
        }
        if (!file.delete()) {
            throw new IOException("Couldn't delete \"" + file.getName() + "\" at \"" + file.getParent());
        }
    }

    public void onItemClick(AdapterView<?> parent_, View list_, int position, long id_) {
        if (position < 0 || position >= this._entries.size()) {
            return;
        }
        boolean scrollToTop = false;
        File file = this._entries.get(position);
        if (file.getName().equals("..")) {
            if (!this._list.hasFocus()) {
                this._list.requestFocus();
            }
            this.doGoBack();
            return;
        }
        if (file.getName().contains(".. SDCard Storage")) {
            String removableRoot = FileUtil.getStoragePath(this._context, true);
            if (removableRoot != null && "mounted".equals(Environment.getExternalStorageState())) {
                this._currentDir = new File(removableRoot);
                int n = this._chooseMode = this._chooseMode == 1 ? 0 : this._chooseMode;
                if (this._deleteModeIndicator != null) {
                    this._deleteModeIndicator.run();
                }
                this._adapter.popAll();
            }
        } else if (file.getName().contains(".. Primary Storage")) {
            String primaryRoot = FileUtil.getStoragePath(this._context, false);
            if (primaryRoot != null) {
                this._currentDir = new File(primaryRoot);
                int n = this._chooseMode = this._chooseMode == 1 ? 0 : this._chooseMode;
                if (this._deleteModeIndicator != null) {
                    this._deleteModeIndicator.run();
                }
                this._adapter.popAll();
            }
        } else {
            switch (this._chooseMode) {
                case 0: {
                    if (file.isDirectory()) {
                        if (this._folderNavToCB == null) {
                            this._folderNavToCB = _defaultNavToCB;
                        }
                        if (!this._folderNavToCB.canNavigate(file)) break;
                        this._currentDir = file;
                        scrollToTop = true;
                        this._adapter.push(position);
                        break;
                    }
                    if (this._dirOnly || this._result == null) break;
                    this._result.onChoosePath(file.getAbsolutePath(), file);
                    if (this._enableMultiple) {
                        this._result.onChoosePath(this._currentDir.getAbsolutePath(), this._currentDir);
                    }
                    if (this._dismissOnButtonClick) {
                        this._alertDialog.dismiss();
                    }
                    return;
                }
                case 2: {
                    if (file.isDirectory()) {
                        if (this._folderNavToCB == null) {
                            this._folderNavToCB = _defaultNavToCB;
                        }
                        if (!this._folderNavToCB.canNavigate(file)) break;
                        this._currentDir = file;
                        scrollToTop = true;
                        this._adapter.push();
                        break;
                    }
                    this._adapter.selectItem(position);
                    if (!this._adapter.isAnySelected()) {
                        this._chooseMode = 0;
                        this._alertDialog.getButton(-1).setVisibility(4);
                    }
                    this._result.onChoosePath(file.getAbsolutePath(), file);
                    break;
                }
                case 1: {
                    try {
                        this.deleteFile(file);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        Toast.makeText((Context)this._context, (CharSequence)e.getMessage(), (int)1).show();
                    }
                    this._chooseMode = 0;
                    if (this._deleteModeIndicator == null) break;
                    this._deleteModeIndicator.run();
                    break;
                }
            }
        }
        this.refreshDirs();
        if (scrollToTop) {
            this._list.setSelection(0);
        }
    }

    public boolean onItemLongClick(AdapterView<?> parent, View list, int position, long id2) {
        File file = this._entries.get(position);
        if (file.getName().equals("..") || file.getName().contains(".. SDCard Storage") || file.getName().contains(".. Primary Storage") || file.isDirectory()) {
            return true;
        }
        if (this._adapter.isSelected(position)) {
            return true;
        }
        this._result.onChoosePath(file.getAbsolutePath(), file);
        this._adapter.selectItem(position);
        this._chooseMode = 2;
        this._alertDialog.getButton(-1).setVisibility(0);
        this._deleteModeIndicator.run();
        return true;
    }

    public void onClick(DialogInterface dialog, int which) {
    }

    private void refreshDirs() {
        this.listDirs();
        this._adapter.setEntries(this._entries);
    }

    public void dismiss() {
        this._alertDialog.dismiss();
    }

    private boolean doMoveUp() {
        if (this._list.hasFocus()) {
            Log.d((String)"z", (String)("move up at " + this._adapter.getHoveredIndex()));
            int indexOld = this._adapter.getHoveredIndex();
            int index = this._adapter.decreaseHoveredIndex();
            if (indexOld >= 0 && indexOld != index) {
                UiUtil.ensureVisible(this._list, index);
                this._list.requestFocus();
            } else {
                this._list.setSelection(index);
                this.moveFocusToButtons();
            }
        } else if (this.buttonsHasFocus()) {
            this._list.requestFocus();
        }
        return true;
    }

    private boolean doMoveDown() {
        if (this._list.hasFocus()) {
            Log.d((String)"z", (String)("move down at " + this._adapter.getHoveredIndex()));
            int indexOld = this._adapter.getHoveredIndex();
            int index = this._adapter.increaseHoveredIndex();
            if (indexOld >= 0 && indexOld != index) {
                UiUtil.ensureVisible(this._list, index);
                this._list.requestFocus();
            } else {
                this._list.setSelection(index);
                this.moveFocusToButtons();
            }
        } else if (this.buttonsHasFocus()) {
            this._list.requestFocus();
        }
        return true;
    }

    private boolean doGoBack() {
        if (this._list.hasFocus()) {
            File f = this._currentDir.getParentFile();
            Log.d((String)"z", (String)("go back at " + this._adapter.getHoveredIndex() + ", go up level: " + f.getAbsolutePath()));
            if (this._folderNavUpCB == null) {
                this._folderNavUpCB = _defaultNavUpCB;
            }
            if (this._folderNavUpCB.canUpTo(f)) {
                this._currentDir = f;
                int n = this._chooseMode = this._chooseMode == 1 ? 0 : this._chooseMode;
                if (this._deleteModeIndicator != null) {
                    this._deleteModeIndicator.run();
                }
                this._adapter.pop();
                this.refreshDirs();
                this._list.setSelection(this._adapter.getHoveredIndex());
            }
        }
        return true;
    }

    private boolean doEnter() {
        if (this._list.hasFocus()) {
            Log.d((String)"z", (String)("enter at " + this._adapter.getHoveredIndex()));
            int position = this._adapter.getHoveredIndex();
            this.onItemClick((AdapterView<?>)this._list, (View)this._list, position, -1L);
        }
        return true;
    }

    private boolean buttonsHasFocus() {
        View v = this._alertDialog.getCurrentFocus();
        return v == this._alertDialog.getButton(-3) || v == this._alertDialog.getButton(-2) || v == this._alertDialog.getButton(-1);
    }

    private boolean moveFocusToButtons() {
        Button v = null;
        if (this._alertDialog.getButton(-3).getVisibility() == 0) {
            v = this._alertDialog.getButton(-3);
        }
        if (v == null && this._alertDialog.getButton(-2).getVisibility() == 0) {
            v = this._alertDialog.getButton(-2);
        }
        if (v == null && this._alertDialog.getButton(-1).getVisibility() == 0) {
            v = this._alertDialog.getButton(-1);
        }
        if (v != null) {
            v.requestFocus();
            return true;
        }
        return false;
    }

    @FunctionalInterface
    public static interface OnBackPressedListener {
        public void onBackPressed(AlertDialog var1);
    }

    @FunctionalInterface
    public static interface CanNavigateTo {
        public boolean canNavigate(File var1);
    }

    @FunctionalInterface
    public static interface CanNavigateUp {
        public boolean canUpTo(File var1);
    }

    @FunctionalInterface
    public static interface AdapterSetter {
        public void apply(DirAdapter var1);
    }

    @FunctionalInterface
    public static interface Result {
        public void onChoosePath(String var1, File var2);
    }
}

