/*
 * Decompiled with CFR 0.152.
 */
package com.hcaptcha.sdk;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.app.Activity;
import android.app.Dialog;
import android.content.DialogInterface;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.os.BadParcelableException;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Parcelable;
import android.view.InflateException;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import androidx.annotation.Nullable;
import androidx.fragment.app.DialogFragment;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentActivity;
import androidx.fragment.app.FragmentManager;
import com.hcaptcha.sdk.HCaptchaCompat;
import com.hcaptcha.sdk.HCaptchaConfig;
import com.hcaptcha.sdk.HCaptchaError;
import com.hcaptcha.sdk.HCaptchaException;
import com.hcaptcha.sdk.HCaptchaInternalConfig;
import com.hcaptcha.sdk.HCaptchaLog;
import com.hcaptcha.sdk.HCaptchaSize;
import com.hcaptcha.sdk.HCaptchaStateListener;
import com.hcaptcha.sdk.HCaptchaWebView;
import com.hcaptcha.sdk.HCaptchaWebViewHelper;
import com.hcaptcha.sdk.IHCaptchaVerifier;
import com.hcaptcha.sdk.R;
import java.io.Serializable;
import lombok.NonNull;

public final class HCaptchaDialogFragment
extends DialogFragment
implements IHCaptchaVerifier {
    private static final String TAG;
    static final String KEY_CONFIG = "hCaptchaConfig";
    static final String KEY_INTERNAL_CONFIG = "hCaptchaInternalConfig";
    static final String KEY_LISTENER = "hCaptchaDialogListener";
    static final /* synthetic */ boolean $assertionsDisabled;
    @Nullable
    private HCaptchaWebViewHelper webViewHelper;
    @androidx.annotation.NonNull
    private HCaptchaStateListener listener;
    private LinearLayout loadingContainer;
    private float defaultDimAmount = 0.6f;
    private boolean readyForInteraction = false;

    public static HCaptchaDialogFragment newInstance(@NonNull HCaptchaConfig hCaptchaConfig, @NonNull HCaptchaInternalConfig hCaptchaInternalConfig, @NonNull HCaptchaStateListener hCaptchaStateListener) {
        if (hCaptchaConfig != null) {
            if (hCaptchaInternalConfig != null) {
                if (hCaptchaStateListener != null) {
                    Bundle bundle;
                    HCaptchaLog.d("DialogFragment.newInstance");
                    Bundle bundle2 = bundle;
                    new Bundle().putSerializable(KEY_CONFIG, (Serializable)hCaptchaConfig);
                    bundle2.putSerializable(KEY_INTERNAL_CONFIG, (Serializable)hCaptchaInternalConfig);
                    bundle2.putParcelable(KEY_LISTENER, (Parcelable)hCaptchaStateListener);
                    HCaptchaDialogFragment hCaptchaDialogFragment = new HCaptchaDialogFragment();
                    hCaptchaDialogFragment.setArguments(bundle2);
                    return hCaptchaDialogFragment;
                }
                throw new NullPointerException("listener is marked non-null but is null");
            }
            throw new NullPointerException("internalConfig is marked non-null but is null");
        }
        throw new NullPointerException("config is marked non-null but is null");
    }

    private void hideLoadingContainer() {
        HCaptchaWebViewHelper hCaptchaWebViewHelper = this.webViewHelper;
        if (hCaptchaWebViewHelper != null && Boolean.TRUE.equals(hCaptchaWebViewHelper.getConfig().getLoading())) {
            this.loadingContainer.animate().alpha(0.0f).setDuration(200L).setListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

                public void onAnimationEnd(Animator animator) {
                    HCaptchaDialogFragment.this.loadingContainer.setVisibility(8);
                }
            });
        } else {
            hCaptchaWebViewHelper = this.getDialog();
            if (hCaptchaWebViewHelper != null) {
                HCaptchaWebViewHelper hCaptchaWebViewHelper2 = hCaptchaWebViewHelper;
                hCaptchaWebViewHelper2.getWindow().addFlags(2);
                hCaptchaWebViewHelper2.getWindow().setDimAmount(this.defaultDimAmount);
            }
        }
    }

    private View prepareRootView(@androidx.annotation.NonNull LayoutInflater layoutInflater, @Nullable ViewGroup viewGroup, @androidx.annotation.NonNull HCaptchaConfig hCaptchaConfig) {
        LayoutInflater layoutInflater2 = layoutInflater = layoutInflater.inflate(R.layout.hcaptcha_fragment, viewGroup, false);
        layoutInflater2.setFocusableInTouchMode(true);
        layoutInflater2.requestFocus();
        layoutInflater.setOnKeyListener((view, n, keyEvent) -> {
            if (!(n == 4 && keyEvent.getAction() == 0)) {
                return false;
            }
            if (!((HCaptchaDialogFragment)((Object)hCaptchaWebViewHelper)).readyForInteraction && Boolean.FALSE.equals(hCaptchaConfig.getLoading())) {
                return true;
            }
            HCaptchaWebViewHelper hCaptchaWebViewHelper = ((HCaptchaDialogFragment)((Object)hCaptchaWebViewHelper)).webViewHelper;
            return hCaptchaWebViewHelper != null && hCaptchaWebViewHelper.shouldRetry(new HCaptchaException(HCaptchaError.CHALLENGE_CLOSED));
        });
        return layoutInflater;
    }

    private HCaptchaWebView prepareWebView(@androidx.annotation.NonNull View object, @androidx.annotation.NonNull HCaptchaConfig hCaptchaConfig) {
        object = (HCaptchaWebView)object.findViewById(R.id.webView);
        if (Boolean.FALSE.equals(hCaptchaConfig.getLoading())) {
            object.setOnTouchListener((view, motionEvent) -> {
                if (!this.readyForInteraction && this.isAdded() && (this = this.getActivity()) != null) {
                    this.dispatchTouchEvent(motionEvent);
                    return true;
                }
                return view.performClick();
            });
        }
        return object;
    }

    static {
        $assertionsDisabled = HCaptchaDialogFragment.class.desiredAssertionStatus() ^ true;
        TAG = "HCaptchaDialogFragment";
    }

    public void onCreate(Bundle bundle) {
        HCaptchaDialogFragment hCaptchaDialogFragment = this;
        super.onCreate(bundle);
        hCaptchaDialogFragment.setStyle(2, R.style.HCaptchaDialogTheme);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public View onCreateView(@Nullable LayoutInflater layoutInflater, @Nullable ViewGroup object, @Nullable Bundle object2) {
        Handler handler;
        HCaptchaWebViewHelper hCaptchaWebViewHelper;
        HCaptchaDialogFragment hCaptchaDialogFragment = hCaptchaStateListener2;
        HCaptchaLog.d("DialogFragment.onCreateView");
        Bundle bundle = hCaptchaDialogFragment.getArguments();
        ((HCaptchaDialogFragment)((Object)hCaptchaStateListener2)).listener = HCaptchaCompat.getParcelable(bundle, KEY_LISTENER, HCaptchaStateListener.class);
        HCaptchaConfig hCaptchaConfig = HCaptchaCompat.getSerializable(bundle, KEY_CONFIG, HCaptchaConfig.class);
        HCaptchaInternalConfig hCaptchaInternalConfig = HCaptchaCompat.getSerializable(bundle, KEY_INTERNAL_CONFIG, HCaptchaInternalConfig.class);
        if (hCaptchaDialogFragment.listener == null || hCaptchaConfig == null || hCaptchaInternalConfig == null) throw new AssertionError();
        if (layoutInflater == null) throw new InflateException("inflater is null");
        Object object3 = hCaptchaStateListener2;
        Object object4 = object3;
        layoutInflater = super.prepareRootView(layoutInflater, (ViewGroup)object, hCaptchaConfig);
        HCaptchaLog.d("DialogFragment.onCreateView inflated");
        HCaptchaWebView hCaptchaWebView = super.prepareWebView((View)layoutInflater, hCaptchaConfig);
        LinearLayout linearLayout = (LinearLayout)layoutInflater.findViewById(R.id.loadingContainer);
        ((HCaptchaDialogFragment)object4).loadingContainer = linearLayout;
        int n = Boolean.TRUE.equals(hCaptchaConfig.getLoading()) ? 0 : 8;
        LayoutInflater layoutInflater2 = layoutInflater;
        Object object5 = hCaptchaStateListener2;
        Object object6 = object5;
        Object object7 = object5;
        linearLayout.setVisibility(n);
        HCaptchaWebViewHelper hCaptchaWebViewHelper2 = hCaptchaWebViewHelper;
        HCaptchaWebViewHelper hCaptchaWebViewHelper3 = hCaptchaWebViewHelper;
        HCaptchaStateListener hCaptchaStateListener = hCaptchaStateListener2;
        layoutInflater = handler;
        try {
            handler = new Handler(Looper.getMainLooper());
            hCaptchaWebViewHelper2((Handler)layoutInflater, hCaptchaStateListener.requireContext(), hCaptchaConfig, hCaptchaInternalConfig, (IHCaptchaVerifier)((Object)hCaptchaStateListener2), hCaptchaWebView);
            ((HCaptchaDialogFragment)object6).webViewHelper = hCaptchaWebViewHelper3;
            ((HCaptchaDialogFragment)object7).readyForInteraction = false;
            return layoutInflater2;
        }
        catch (ClassCastException classCastException) {
        }
        catch (InflateException inflateException) {
        }
        catch (BadParcelableException badParcelableException) {
        }
        catch (AssertionError assertionError) {}
        HCaptchaDialogFragment hCaptchaDialogFragment2 = hCaptchaStateListener2;
        HCaptchaLog.w("Cannot create view. Dismissing dialog...");
        hCaptchaDialogFragment2.dismiss();
        HCaptchaStateListener hCaptchaStateListener2 = hCaptchaDialogFragment2.listener;
        if (hCaptchaStateListener2 == null) return null;
        hCaptchaStateListener2.onFailure(new HCaptchaException(HCaptchaError.ERROR));
        return null;
    }

    public void onDestroy() {
        HCaptchaDialogFragment hCaptchaDialogFragment = hCaptchaWebViewHelper;
        HCaptchaLog.d("DialogFragment.onDestroy");
        super.onDestroy();
        HCaptchaWebViewHelper hCaptchaWebViewHelper = hCaptchaDialogFragment.webViewHelper;
        if (hCaptchaWebViewHelper != null) {
            hCaptchaWebViewHelper.destroy();
        }
    }

    public void onStart() {
        HCaptchaDialogFragment hCaptchaDialogFragment = this;
        HCaptchaLog.d("DialogFragment.onStart");
        super.onStart();
        Dialog dialog = hCaptchaDialogFragment.getDialog();
        if (dialog != null && this.webViewHelper != null) {
            dialog = dialog.getWindow();
            dialog.setBackgroundDrawable((Drawable)new ColorDrawable(0));
            this.defaultDimAmount = dialog.getAttributes().dimAmount;
            if (Boolean.FALSE.equals(this.webViewHelper.getConfig().getLoading())) {
                Dialog dialog2 = dialog;
                dialog2.clearFlags(2);
                dialog2.setDimAmount(0.0f);
            }
        }
    }

    public void onCancel(@androidx.annotation.NonNull DialogInterface dialogInterface) {
        HCaptchaDialogFragment hCaptchaDialogFragment = this;
        HCaptchaLog.d("DialogFragment.onCancel");
        super.onCancel(dialogInterface);
        hCaptchaDialogFragment.onFailure(new HCaptchaException(HCaptchaError.CHALLENGE_CLOSED));
    }

    @Override
    public void onLoaded() {
        if (!$assertionsDisabled && this.webViewHelper == null) {
            throw new AssertionError();
        }
        if (this.webViewHelper.getConfig().getSize() != HCaptchaSize.INVISIBLE) {
            this.readyForInteraction = true;
            this.hideLoadingContainer();
        }
    }

    @Override
    public void onOpen() {
        if (!$assertionsDisabled && this.webViewHelper == null) {
            throw new AssertionError();
        }
        if (this.webViewHelper.getConfig().getSize() == HCaptchaSize.INVISIBLE) {
            this.hideLoadingContainer();
        }
        this.readyForInteraction = true;
        this.listener.onOpen();
    }

    @Override
    public void onFailure(@androidx.annotation.NonNull HCaptchaException hCaptchaException) {
        HCaptchaWebViewHelper hCaptchaWebViewHelper;
        HCaptchaWebViewHelper hCaptchaWebViewHelper2 = this.webViewHelper;
        boolean bl = hCaptchaWebViewHelper2 != null && hCaptchaWebViewHelper2.shouldRetry(hCaptchaException);
        if (this.isAdded() && !bl) {
            this.dismissAllowingStateLoss();
        }
        if ((hCaptchaWebViewHelper = this.webViewHelper) != null) {
            if (bl) {
                hCaptchaWebViewHelper.resetAndExecute();
            } else {
                this.listener.onFailure(hCaptchaException);
            }
        }
    }

    @Override
    public void onSuccess(String string) {
        if (!$assertionsDisabled && this.webViewHelper == null) {
            throw new AssertionError();
        }
        if (this.isAdded()) {
            this.dismissAllowingStateLoss();
        }
        this.listener.onSuccess(string);
    }

    @Override
    public void startVerification(@androidx.annotation.NonNull Activity activity) {
        block3: {
            String string;
            Fragment fragment = (activity = ((FragmentActivity)activity).getSupportFragmentManager()).findFragmentByTag(string = TAG);
            if (fragment != null && fragment.isAdded()) {
                HCaptchaLog.w("DialogFragment was already added.");
                return;
            }
            try {
                this.show((FragmentManager)activity, string);
            }
            catch (IllegalStateException illegalStateException) {
                HCaptchaLog.w("DialogFragment.startVerification " + illegalStateException.getMessage());
                if (this.webViewHelper == null) break block3;
                this.listener.onFailure(new HCaptchaException(HCaptchaError.ERROR));
            }
        }
    }

    @Override
    public void reset() {
        HCaptchaWebViewHelper hCaptchaWebViewHelper = this.webViewHelper;
        if (hCaptchaWebViewHelper != null) {
            hCaptchaWebViewHelper.reset();
        }
        if (this.isAdded()) {
            this.dismissAllowingStateLoss();
        }
    }
}

