/*
 * Decompiled with CFR 0.152.
 */
package com.hcaptcha.sdk;

import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.view.View;
import android.view.ViewGroup;
import androidx.fragment.app.FragmentActivity;
import com.hcaptcha.sdk.HCaptchaConfig;
import com.hcaptcha.sdk.HCaptchaException;
import com.hcaptcha.sdk.HCaptchaInternalConfig;
import com.hcaptcha.sdk.HCaptchaLog;
import com.hcaptcha.sdk.HCaptchaStateListener;
import com.hcaptcha.sdk.HCaptchaWebView;
import com.hcaptcha.sdk.HCaptchaWebViewHelper;
import com.hcaptcha.sdk.IHCaptchaVerifier;
import com.hcaptcha.sdk.R;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import lombok.Generated;
import lombok.NonNull;

final class HCaptchaHeadlessWebView
implements IHCaptchaVerifier {
    @NonNull
    private final HCaptchaConfig config;
    @NonNull
    private final HCaptchaStateListener listener;
    @NonNull
    private final HCaptchaWebViewHelper webViewHelper;
    private boolean webViewLoaded;
    private boolean shouldExecuteOnLoad;
    private boolean shouldResetOnLoad;

    public HCaptchaHeadlessWebView(@NonNull FragmentActivity fragmentActivity, @NonNull HCaptchaConfig hCaptchaConfig, @NonNull HCaptchaInternalConfig hCaptchaInternalConfig, @NonNull HCaptchaStateListener hCaptchaStateListener) {
        if (fragmentActivity != null) {
            if (hCaptchaConfig != null) {
                if (hCaptchaInternalConfig != null) {
                    if (hCaptchaStateListener != null) {
                        HCaptchaWebView hCaptchaWebView;
                        HCaptchaLog.d("HeadlessWebView.init");
                        this.config = hCaptchaConfig;
                        this.listener = hCaptchaStateListener;
                        HCaptchaWebView hCaptchaWebView2 = hCaptchaWebView;
                        new HCaptchaWebView((Context)fragmentActivity).setId(R.id.webView);
                        hCaptchaWebView2.setVisibility(8);
                        if (hCaptchaWebView2.getParent() == null) {
                            ((ViewGroup)fragmentActivity.getWindow().getDecorView().getRootView()).addView((View)hCaptchaWebView2);
                        }
                        this.webViewHelper = new HCaptchaWebViewHelper(new Handler(Looper.getMainLooper()), (Context)fragmentActivity, hCaptchaConfig, hCaptchaInternalConfig, this, hCaptchaStateListener, hCaptchaWebView2);
                        return;
                    }
                    throw new NullPointerException("listener is marked non-null but is null");
                }
                throw new NullPointerException("internalConfig is marked non-null but is null");
            }
            throw new NullPointerException("config is marked non-null but is null");
        }
        throw new NullPointerException("activity is marked non-null but is null");
    }

    @Override
    public void startVerification(@NonNull FragmentActivity fragmentActivity) {
        if (fragmentActivity != null) {
            if (this.webViewLoaded) {
                this.webViewHelper.resetAndExecute();
            } else {
                this.shouldExecuteOnLoad = true;
            }
            return;
        }
        throw new NullPointerException("activity is marked non-null but is null");
    }

    @Override
    public void onFailure(@NonNull HCaptchaException hCaptchaException) {
        if (hCaptchaException != null) {
            if (this.webViewHelper.shouldRetry(hCaptchaException)) {
                this.webViewHelper.resetAndExecute();
            } else {
                this.listener.onFailure(hCaptchaException);
            }
            return;
        }
        throw new NullPointerException("exception is marked non-null but is null");
    }

    @Override
    public void onSuccess(String string) {
        this.listener.onSuccess(string);
    }

    @Override
    public void onLoaded() {
        this.webViewLoaded = true;
        if (this.shouldResetOnLoad) {
            this.shouldResetOnLoad = false;
            this.reset();
        } else if (this.shouldExecuteOnLoad) {
            this.shouldExecuteOnLoad = false;
            this.webViewHelper.resetAndExecute();
        }
    }

    @Override
    public void onOpen() {
        this.listener.onOpen();
    }

    @Override
    public void reset() {
        if (object.webViewLoaded) {
            HCaptchaHeadlessWebView hCaptchaHeadlessWebView = object;
            hCaptchaHeadlessWebView.webViewHelper.reset();
            Object object = hCaptchaHeadlessWebView.webViewHelper.getWebView();
            if (object.getParent() != null) {
                ((ViewGroup)object.getParent()).removeView((View)object);
            }
        } else {
            object.shouldResetOnLoad = true;
        }
    }

    @NonNull
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public HCaptchaConfig getConfig() {
        return this.config;
    }
}

