/*
 * Decompiled with CFR 0.152.
 */
package tr.com.harunkor.gifviewplayer;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Movie;
import android.os.Build;
import android.os.StrictMode;
import android.os.SystemClock;
import android.util.AttributeSet;
import android.view.View;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0019\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\u0007B!\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0006\u0010\u001a\u001a\u00020\u000fJ\b\u0010\u001b\u001a\u00020\u0017H\u0002J\u0006\u0010\u001c\u001a\u00020\u0014J\u0006\u0010\u001d\u001a\u00020\u0014J\u0012\u0010\u001e\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0014J\u0018\u0010\u001f\u001a\u00020\u00172\u0006\u0010 \u001a\u00020\t2\u0006\u0010!\u001a\u00020\tH\u0014J\u000e\u0010\"\u001a\u00020\u00172\u0006\u0010#\u001a\u00020\u000fJ\u000e\u0010$\u001a\u00020\u00172\u0006\u0010%\u001a\u00020&J\u000e\u0010'\u001a\u00020\u00172\u0006\u0010(\u001a\u00020&J\u000e\u0010)\u001a\u00020\u00172\u0006\u0010*\u001a\u00020\tJ\u000e\u0010+\u001a\u00020\u00172\u0006\u0010,\u001a\u00020-J\u000e\u0010.\u001a\u00020\u00172\u0006\u0010/\u001a\u00020&J\u000e\u00100\u001a\u00020\u00172\u0006\u00101\u001a\u00020\u0014J\b\u00102\u001a\u00020\u0017H\u0002R\u000e\u0010\u000b\u001a\u00020\tX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00063"}, d2={"Ltr/com/harunkor/gifviewplayer/GifMovieView;", "Landroid/view/View;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "attrs", "Landroid/util/AttributeSet;", "(Landroid/content/Context;Landroid/util/AttributeSet;)V", "defStyleAttr", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "DEFAULT_MOVIEW_DURATION", "mCurrentAnimationTime", "mHeight", "mMovie", "Landroid/graphics/Movie;", "mMovieResourceId", "mMovieStart", "", "mPaused", "", "mWidth", "drawMovieFrame", "", "canvas", "Landroid/graphics/Canvas;", "getMovie", "invalidateView", "isPaused", "isPlaying", "onDraw", "onMeasure", "widthMeasureSpec", "heightMeasureSpec", "setMovie", "movie", "setMovieAssets", "assetfilename", "", "setMovieFile", "filename", "setMovieResource", "movieResId", "setMovieStream", "inputstream", "Ljava/io/InputStream;", "setMovieUrl", "sURL", "setPaused", "paused", "updateAnimationTime", "gifviewplayer_release"})
public final class GifMovieView
extends View {
    private final int DEFAULT_MOVIEW_DURATION = 1000;
    private int mMovieResourceId;
    private Movie mMovie;
    private long mMovieStart;
    private int mCurrentAnimationTime;
    private int mWidth;
    private int mHeight;
    private boolean mPaused;
    private HashMap _$_findViewCache;

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        this.setMeasuredDimension(widthMeasureSpec, heightMeasureSpec);
    }

    public final void setMovieResource(int movieResId) {
        this.mMovieResourceId = movieResId;
        Movie movie = this.mMovie = Movie.decodeStream((InputStream)this.getResources().openRawResource(this.mMovieResourceId));
        Integer n = movie != null ? Integer.valueOf(movie.width()) : null;
        if (n == null) {
            Intrinsics.throwNpe();
        }
        this.mWidth = n;
        Movie movie2 = this.mMovie;
        Integer n2 = movie2 != null ? Integer.valueOf(movie2.height()) : null;
        if (n2 == null) {
            Intrinsics.throwNpe();
        }
        this.mHeight = n2;
        this.requestLayout();
        this.invalidateView();
    }

    public final void setMovieStream(@NotNull InputStream inputstream) {
        Intrinsics.checkParameterIsNotNull((Object)inputstream, (String)"inputstream");
        Movie movie = this.mMovie = Movie.decodeStream((InputStream)inputstream);
        if (movie == null) {
            Intrinsics.throwNpe();
        }
        this.mWidth = movie.width();
        Movie movie2 = this.mMovie;
        if (movie2 == null) {
            Intrinsics.throwNpe();
        }
        this.mHeight = movie2.height();
        this.requestLayout();
        this.invalidateView();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setMovieAssets(@NotNull String assetfilename) {
        block6: {
            InputStream inputStream;
            Intrinsics.checkParameterIsNotNull((Object)assetfilename, (String)"assetfilename");
            InputStream inp = null;
            try {
                Context context = this.getContext();
                Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"context");
                inputStream = inp = context.getAssets().open(assetfilename);
            }
            catch (IOException e) {
                e.printStackTrace();
                break block6;
            }
            finally {
                Intrinsics.throwNpe();
                this.setMovieStream(inp);
            }
            if (inputStream == null) {
                Intrinsics.throwNpe();
            }
            this.setMovieStream(inputStream);
        }
    }

    public final void setMovieFile(@NotNull String filename) {
        Intrinsics.checkParameterIsNotNull((Object)filename, (String)"filename");
        Movie movie = this.mMovie = Movie.decodeFile((String)filename);
        Integer n = movie != null ? Integer.valueOf(movie.width()) : null;
        if (n == null) {
            Intrinsics.throwNpe();
        }
        this.mWidth = n;
        Movie movie2 = this.mMovie;
        Integer n2 = movie2 != null ? Integer.valueOf(movie2.height()) : null;
        if (n2 == null) {
            Intrinsics.throwNpe();
        }
        this.mHeight = n2;
        this.requestLayout();
        this.invalidateView();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public final void setMovieUrl(@NotNull String sURL) {
        block37: {
            Intrinsics.checkParameterIsNotNull((Object)sURL, (String)"sURL");
            StrictMode.VmPolicy.Builder builder = new StrictMode.VmPolicy.Builder();
            StrictMode.setVmPolicy((StrictMode.VmPolicy)builder.build());
            StrictMode.ThreadPolicy policy = new StrictMode.ThreadPolicy.Builder().permitAll().build();
            StrictMode.setThreadPolicy((StrictMode.ThreadPolicy)policy);
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            URL url = null;
            url = new URL(sURL);
            try {
                int bytess;
                byte[] chunk = new byte[1024];
                InputStream stream = url.openStream();
                while ((bytess = stream.read(chunk)) > 0) {
                    outputStream.write(chunk, 0, bytess);
                }
                outputStream.flush();
            }
            catch (IOException e2222222222) {
                try {
                    e2222222222.printStackTrace();
                }
                catch (Throwable e2222222222) {
                    Movie movie = this.mMovie = Movie.decodeByteArray((byte[])outputStream.toByteArray(), (int)0, (int)outputStream.toByteArray().length);
                    Integer n = movie != null ? Integer.valueOf(movie.width()) : null;
                    if (n == null) {
                        Intrinsics.throwNpe();
                    }
                    this.mWidth = n;
                    Movie movie2 = this.mMovie;
                    Integer n2 = movie2 != null ? Integer.valueOf(movie2.height()) : null;
                    if (n2 == null) {
                        Intrinsics.throwNpe();
                    }
                    this.mHeight = n2;
                    this.requestLayout();
                    throw e2222222222;
                }
                Movie movie = this.mMovie = Movie.decodeByteArray((byte[])outputStream.toByteArray(), (int)0, (int)outputStream.toByteArray().length);
                Integer n = movie != null ? Integer.valueOf(movie.width()) : null;
                if (n == null) {
                    Intrinsics.throwNpe();
                }
                this.mWidth = n;
                Movie movie3 = this.mMovie;
                Integer n3 = movie3 != null ? Integer.valueOf(movie3.height()) : null;
                if (n3 == null) {
                    Intrinsics.throwNpe();
                }
                this.mHeight = n3;
                this.requestLayout();
                break block37;
            }
            Movie movie = this.mMovie = Movie.decodeByteArray((byte[])outputStream.toByteArray(), (int)0, (int)outputStream.toByteArray().length);
            Integer n = movie != null ? Integer.valueOf(movie.width()) : null;
            if (n == null) {
                Intrinsics.throwNpe();
            }
            this.mWidth = n;
            Movie movie4 = this.mMovie;
            Integer n4 = movie4 != null ? Integer.valueOf(movie4.height()) : null;
            if (n4 == null) {
                Intrinsics.throwNpe();
            }
            this.mHeight = n4;
            this.requestLayout();
            break block37;
            catch (MalformedURLException e) {
                e.printStackTrace();
                try {
                    int bytess;
                    byte[] chunk = new byte[1024];
                    Intrinsics.throwNpe();
                    InputStream stream = url.openStream();
                    while ((bytess = stream.read(chunk)) > 0) {
                        outputStream.write(chunk, 0, bytess);
                    }
                    outputStream.flush();
                }
                catch (IOException e3) {
                    try {
                        e3.printStackTrace();
                    }
                    catch (Throwable throwable) {
                        Movie movie5 = this.mMovie = Movie.decodeByteArray((byte[])outputStream.toByteArray(), (int)0, (int)outputStream.toByteArray().length);
                        Integer n5 = movie5 != null ? Integer.valueOf(movie5.width()) : null;
                        if (n5 == null) {
                            Intrinsics.throwNpe();
                        }
                        this.mWidth = n5;
                        Movie movie6 = this.mMovie;
                        Integer n6 = movie6 != null ? Integer.valueOf(movie6.height()) : null;
                        if (n6 == null) {
                            Intrinsics.throwNpe();
                        }
                        this.mHeight = n6;
                        this.requestLayout();
                        throw throwable;
                    }
                    Movie movie7 = this.mMovie = Movie.decodeByteArray((byte[])outputStream.toByteArray(), (int)0, (int)outputStream.toByteArray().length);
                    Integer n7 = movie7 != null ? Integer.valueOf(movie7.width()) : null;
                    if (n7 == null) {
                        Intrinsics.throwNpe();
                    }
                    this.mWidth = n7;
                    Movie movie8 = this.mMovie;
                    Integer n8 = movie8 != null ? Integer.valueOf(movie8.height()) : null;
                    if (n8 == null) {
                        Intrinsics.throwNpe();
                    }
                    this.mHeight = n8;
                    this.requestLayout();
                    break block37;
                }
                Movie movie9 = this.mMovie = Movie.decodeByteArray((byte[])outputStream.toByteArray(), (int)0, (int)outputStream.toByteArray().length);
                Integer n9 = movie9 != null ? Integer.valueOf(movie9.width()) : null;
                if (n9 == null) {
                    Intrinsics.throwNpe();
                }
                this.mWidth = n9;
                Movie movie10 = this.mMovie;
                Integer n10 = movie10 != null ? Integer.valueOf(movie10.height()) : null;
                if (n10 == null) {
                    Intrinsics.throwNpe();
                }
                this.mHeight = n10;
                this.requestLayout();
                catch (Throwable throwable) {
                    try {
                        int bytess;
                        byte[] chunk = new byte[1024];
                        Intrinsics.throwNpe();
                        InputStream stream = url.openStream();
                        while ((bytess = stream.read(chunk)) > 0) {
                            outputStream.write(chunk, 0, bytess);
                        }
                        outputStream.flush();
                    }
                    catch (IOException e4) {
                        try {
                            e4.printStackTrace();
                        }
                        catch (Throwable throwable2) {
                            Movie movie11 = this.mMovie = Movie.decodeByteArray((byte[])outputStream.toByteArray(), (int)0, (int)outputStream.toByteArray().length);
                            Integer n11 = movie11 != null ? Integer.valueOf(movie11.width()) : null;
                            if (n11 == null) {
                                Intrinsics.throwNpe();
                            }
                            this.mWidth = n11;
                            Movie movie12 = this.mMovie;
                            Integer n12 = movie12 != null ? Integer.valueOf(movie12.height()) : null;
                            if (n12 == null) {
                                Intrinsics.throwNpe();
                            }
                            this.mHeight = n12;
                            this.requestLayout();
                            throw throwable2;
                        }
                        Movie movie13 = this.mMovie = Movie.decodeByteArray((byte[])outputStream.toByteArray(), (int)0, (int)outputStream.toByteArray().length);
                        Integer n13 = movie13 != null ? Integer.valueOf(movie13.width()) : null;
                        if (n13 == null) {
                            Intrinsics.throwNpe();
                        }
                        this.mWidth = n13;
                        Movie movie14 = this.mMovie;
                        Integer n14 = movie14 != null ? Integer.valueOf(movie14.height()) : null;
                        if (n14 == null) {
                            Intrinsics.throwNpe();
                        }
                        this.mHeight = n14;
                        this.requestLayout();
                    }
                    Movie movie15 = this.mMovie = Movie.decodeByteArray((byte[])outputStream.toByteArray(), (int)0, (int)outputStream.toByteArray().length);
                    Integer n15 = movie15 != null ? Integer.valueOf(movie15.width()) : null;
                    if (n15 == null) {
                        Intrinsics.throwNpe();
                    }
                    this.mWidth = n15;
                    Movie movie16 = this.mMovie;
                    Integer n16 = movie16 != null ? Integer.valueOf(movie16.height()) : null;
                    if (n16 == null) {
                        Intrinsics.throwNpe();
                    }
                    this.mHeight = n16;
                    this.requestLayout();
                    throw throwable;
                }
            }
        }
    }

    public final void setMovie(@NotNull Movie movie) {
        Intrinsics.checkParameterIsNotNull((Object)movie, (String)"movie");
        this.mMovie = movie;
        this.requestLayout();
    }

    @NotNull
    public final Movie getMovie() {
        Movie movie = this.mMovie;
        if (movie == null) {
            Intrinsics.throwNpe();
        }
        return movie;
    }

    public final void setPaused(boolean paused) {
        this.mPaused = paused;
        if (!paused) {
            this.mMovieStart = SystemClock.uptimeMillis() - (long)this.mCurrentAnimationTime;
        }
        this.invalidateView();
    }

    public final boolean isPaused() {
        return this.mPaused;
    }

    public final boolean isPlaying() {
        return !this.mPaused;
    }

    protected void onDraw(@Nullable Canvas canvas) {
        if (this.mMovie != null) {
            if (!this.mPaused) {
                this.updateAnimationTime();
                Canvas canvas2 = canvas;
                if (canvas2 == null) {
                    Intrinsics.throwNpe();
                }
                this.drawMovieFrame(canvas2);
                this.invalidateView();
            } else {
                Canvas canvas3 = canvas;
                if (canvas3 == null) {
                    Intrinsics.throwNpe();
                }
                this.drawMovieFrame(canvas3);
            }
        }
    }

    private final void invalidateView() {
        if (Build.VERSION.SDK_INT >= 16) {
            this.postInvalidateOnAnimation();
        } else {
            this.invalidate();
        }
    }

    private final void updateAnimationTime() {
        int dur;
        long now = SystemClock.uptimeMillis();
        if (this.mMovieStart == 0L) {
            this.mMovieStart = now;
        }
        Movie movie = this.mMovie;
        if (movie == null) {
            Intrinsics.throwNpe();
        }
        if ((dur = movie.duration()) == 0) {
            dur = this.DEFAULT_MOVIEW_DURATION;
        }
        this.mCurrentAnimationTime = (int)((now - this.mMovieStart) % (long)dur);
    }

    private final void drawMovieFrame(Canvas canvas) {
        Movie movie = this.mMovie;
        if (movie == null) {
            Intrinsics.throwNpe();
        }
        movie.setTime(this.mCurrentAnimationTime);
        float f = this.getWidth();
        Movie movie2 = this.mMovie;
        if (movie2 == null) {
            Intrinsics.throwNpe();
        }
        float f2 = f / (float)movie2.width();
        float f3 = this.getHeight();
        Movie movie3 = this.mMovie;
        if (movie3 == null) {
            Intrinsics.throwNpe();
        }
        canvas.scale(f2, f3 / (float)movie3.height());
        Movie movie4 = this.mMovie;
        if (movie4 == null) {
            Intrinsics.throwNpe();
        }
        movie4.draw(canvas, 0.0f, 0.0f);
    }

    public GifMovieView(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        this(context, null);
    }

    public GifMovieView(@NotNull Context context, @Nullable AttributeSet attrs) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        this(context, attrs, 0);
    }

    public GifMovieView(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        super(context, attrs, defStyleAttr);
        this.DEFAULT_MOVIEW_DURATION = 1000;
    }

    public View _$_findCachedViewById(int n) {
        View view;
        if (this._$_findViewCache == null) {
            this._$_findViewCache = new HashMap();
        }
        if ((view = (View)this._$_findViewCache.get(n)) == null) {
            view = this.findViewById(n);
            this._$_findViewCache.put(n, view);
        }
        return view;
    }

    public void _$_clearFindViewByIdCache() {
        if (this._$_findViewCache != null) {
            this._$_findViewCache.clear();
        }
    }
}

