/*
 * Decompiled with CFR 0.152.
 */
package info.mqtt.android.service.room;

import android.content.Context;
import androidx.annotation.NonNull;
import androidx.room.DatabaseConfiguration;
import androidx.room.InvalidationTracker;
import androidx.room.RoomDatabase;
import androidx.room.RoomOpenHelper;
import androidx.room.migration.AutoMigrationSpec;
import androidx.room.migration.Migration;
import androidx.room.util.DBUtil;
import androidx.room.util.TableInfo;
import androidx.sqlite.db.SupportSQLiteDatabase;
import androidx.sqlite.db.SupportSQLiteOpenHelper;
import info.mqtt.android.service.room.MqMessageDao;
import info.mqtt.android.service.room.MqMessageDao_Impl;
import info.mqtt.android.service.room.MqMessageDatabase;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class MqMessageDatabase_Impl
extends MqMessageDatabase {
    private volatile MqMessageDao _mqMessageDao;

    @NonNull
    protected SupportSQLiteOpenHelper createOpenHelper(@NonNull DatabaseConfiguration config) {
        RoomOpenHelper _openCallback = new RoomOpenHelper(config, new RoomOpenHelper.Delegate(1){

            public void createAllTables(@NonNull SupportSQLiteDatabase db) {
                db.execSQL("CREATE TABLE IF NOT EXISTS `MqMessageEntity` (`messageId` TEXT NOT NULL, `clientHandle` TEXT NOT NULL, `topic` TEXT NOT NULL, `mqttMessage` TEXT NOT NULL, `qos` INTEGER NOT NULL, `retained` INTEGER NOT NULL, `duplicate` INTEGER NOT NULL, `timestamp` INTEGER NOT NULL, PRIMARY KEY(`messageId`))");
                db.execSQL("CREATE INDEX IF NOT EXISTS `index_MqMessageEntity_clientHandle` ON `MqMessageEntity` (`clientHandle`)");
                db.execSQL("CREATE TABLE IF NOT EXISTS room_master_table (id INTEGER PRIMARY KEY,identity_hash TEXT)");
                db.execSQL("INSERT OR REPLACE INTO room_master_table (id,identity_hash) VALUES(42, '1569b25bb8b179d5ea5abec331608dd1')");
            }

            public void dropAllTables(@NonNull SupportSQLiteDatabase db) {
                db.execSQL("DROP TABLE IF EXISTS `MqMessageEntity`");
                List _callbacks = MqMessageDatabase_Impl.this.mCallbacks;
                if (_callbacks != null) {
                    for (RoomDatabase.Callback _callback : _callbacks) {
                        _callback.onDestructiveMigration(db);
                    }
                }
            }

            public void onCreate(@NonNull SupportSQLiteDatabase db) {
                List _callbacks = MqMessageDatabase_Impl.this.mCallbacks;
                if (_callbacks != null) {
                    for (RoomDatabase.Callback _callback : _callbacks) {
                        _callback.onCreate(db);
                    }
                }
            }

            public void onOpen(@NonNull SupportSQLiteDatabase db) {
                MqMessageDatabase_Impl.this.mDatabase = db;
                MqMessageDatabase_Impl.this.internalInitInvalidationTracker(db);
                List _callbacks = MqMessageDatabase_Impl.this.mCallbacks;
                if (_callbacks != null) {
                    for (RoomDatabase.Callback _callback : _callbacks) {
                        _callback.onOpen(db);
                    }
                }
            }

            public void onPreMigrate(@NonNull SupportSQLiteDatabase db) {
                DBUtil.dropFtsSyncTriggers((SupportSQLiteDatabase)db);
            }

            public void onPostMigrate(@NonNull SupportSQLiteDatabase db) {
            }

            @NonNull
            public RoomOpenHelper.ValidationResult onValidateSchema(@NonNull SupportSQLiteDatabase db) {
                HashMap<String, TableInfo.Column> _columnsMqMessageEntity = new HashMap<String, TableInfo.Column>(8);
                _columnsMqMessageEntity.put("messageId", new TableInfo.Column("messageId", "TEXT", true, 1, null, 1));
                _columnsMqMessageEntity.put("clientHandle", new TableInfo.Column("clientHandle", "TEXT", true, 0, null, 1));
                _columnsMqMessageEntity.put("topic", new TableInfo.Column("topic", "TEXT", true, 0, null, 1));
                _columnsMqMessageEntity.put("mqttMessage", new TableInfo.Column("mqttMessage", "TEXT", true, 0, null, 1));
                _columnsMqMessageEntity.put("qos", new TableInfo.Column("qos", "INTEGER", true, 0, null, 1));
                _columnsMqMessageEntity.put("retained", new TableInfo.Column("retained", "INTEGER", true, 0, null, 1));
                _columnsMqMessageEntity.put("duplicate", new TableInfo.Column("duplicate", "INTEGER", true, 0, null, 1));
                _columnsMqMessageEntity.put("timestamp", new TableInfo.Column("timestamp", "INTEGER", true, 0, null, 1));
                HashSet _foreignKeysMqMessageEntity = new HashSet(0);
                HashSet<TableInfo.Index> _indicesMqMessageEntity = new HashSet<TableInfo.Index>(1);
                _indicesMqMessageEntity.add(new TableInfo.Index("index_MqMessageEntity_clientHandle", false, Arrays.asList("clientHandle"), Arrays.asList("ASC")));
                TableInfo _infoMqMessageEntity = new TableInfo("MqMessageEntity", _columnsMqMessageEntity, _foreignKeysMqMessageEntity, _indicesMqMessageEntity);
                TableInfo _existingMqMessageEntity = TableInfo.read((SupportSQLiteDatabase)db, (String)"MqMessageEntity");
                if (!_infoMqMessageEntity.equals((Object)_existingMqMessageEntity)) {
                    return new RoomOpenHelper.ValidationResult(false, "MqMessageEntity(info.mqtt.android.service.room.entity.MqMessageEntity).\n Expected:\n" + _infoMqMessageEntity + "\n Found:\n" + _existingMqMessageEntity);
                }
                return new RoomOpenHelper.ValidationResult(true, null);
            }
        }, "1569b25bb8b179d5ea5abec331608dd1", "9ccd73a516869ab5a16d53d895bdefd1");
        SupportSQLiteOpenHelper.Configuration _sqliteConfig = SupportSQLiteOpenHelper.Configuration.builder((Context)config.context).name(config.name).callback((SupportSQLiteOpenHelper.Callback)_openCallback).build();
        SupportSQLiteOpenHelper _helper = config.sqliteOpenHelperFactory.create(_sqliteConfig);
        return _helper;
    }

    @NonNull
    protected InvalidationTracker createInvalidationTracker() {
        HashMap _shadowTablesMap = new HashMap(0);
        HashMap _viewTables = new HashMap(0);
        return new InvalidationTracker((RoomDatabase)this, _shadowTablesMap, _viewTables, new String[]{"MqMessageEntity"});
    }

    public void clearAllTables() {
        super.assertNotMainThread();
        SupportSQLiteDatabase _db = super.getOpenHelper().getWritableDatabase();
        try {
            super.beginTransaction();
            _db.execSQL("DELETE FROM `MqMessageEntity`");
            super.setTransactionSuccessful();
        }
        finally {
            super.endTransaction();
            _db.query("PRAGMA wal_checkpoint(FULL)").close();
            if (!_db.inTransaction()) {
                _db.execSQL("VACUUM");
            }
        }
    }

    @NonNull
    protected Map<Class<?>, List<Class<?>>> getRequiredTypeConverters() {
        HashMap _typeConvertersMap = new HashMap();
        _typeConvertersMap.put(MqMessageDao.class, MqMessageDao_Impl.getRequiredConverters());
        return _typeConvertersMap;
    }

    @NonNull
    public Set<Class<? extends AutoMigrationSpec>> getRequiredAutoMigrationSpecs() {
        HashSet<Class<? extends AutoMigrationSpec>> _autoMigrationSpecsSet = new HashSet<Class<? extends AutoMigrationSpec>>();
        return _autoMigrationSpecsSet;
    }

    @NonNull
    public List<Migration> getAutoMigrations(@NonNull Map<Class<? extends AutoMigrationSpec>, AutoMigrationSpec> autoMigrationSpecs) {
        ArrayList<Migration> _autoMigrations = new ArrayList<Migration>();
        return _autoMigrations;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MqMessageDao persistenceDao() {
        if (this._mqMessageDao != null) {
            return this._mqMessageDao;
        }
        MqMessageDatabase_Impl mqMessageDatabase_Impl = this;
        synchronized (mqMessageDatabase_Impl) {
            if (this._mqMessageDao == null) {
                this._mqMessageDao = new MqMessageDao_Impl(this);
            }
            return this._mqMessageDao;
        }
    }
}

