/*
 * Decompiled with CFR 0.152.
 */
package info.mqtt.android.service.room;

import android.database.Cursor;
import androidx.annotation.NonNull;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.sqlite.db.SupportSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteStatement;
import info.mqtt.android.service.QoS;
import info.mqtt.android.service.room.Converters;
import info.mqtt.android.service.room.MqMessageDao;
import info.mqtt.android.service.room.entity.MqMessageEntity;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.paho.client.mqttv3.MqttMessage;

public final class MqMessageDao_Impl
implements MqMessageDao {
    private final RoomDatabase __db;
    private final EntityInsertionAdapter<MqMessageEntity> __insertionAdapterOfMqMessageEntity;
    private final Converters __converters = new Converters();
    private final EntityDeletionOrUpdateAdapter<MqMessageEntity> __deletionAdapterOfMqMessageEntity;
    private final EntityDeletionOrUpdateAdapter<MqMessageEntity> __updateAdapterOfMqMessageEntity;
    private final SharedSQLiteStatement __preparedStmtOfDeleteId;
    private final SharedSQLiteStatement __preparedStmtOfDeleteClientHandle;

    public MqMessageDao_Impl(@NonNull RoomDatabase __db) {
        this.__db = __db;
        this.__insertionAdapterOfMqMessageEntity = new EntityInsertionAdapter<MqMessageEntity>(__db){

            @NonNull
            protected String createQuery() {
                return "INSERT OR REPLACE INTO `MqMessageEntity` (`messageId`,`clientHandle`,`topic`,`mqttMessage`,`qos`,`retained`,`duplicate`,`timestamp`) VALUES (?,?,?,?,?,?,?,?)";
            }

            protected void bind(@NonNull SupportSQLiteStatement statement, @NonNull MqMessageEntity entity) {
                statement.bindString(1, entity.getMessageId());
                statement.bindString(2, entity.getClientHandle());
                statement.bindString(3, entity.getTopic());
                String _tmp = MqMessageDao_Impl.this.__converters.fromMqttMessage(entity.getMqttMessage());
                statement.bindString(4, _tmp);
                int _tmp_1 = MqMessageDao_Impl.this.__converters.fromQoS(entity.getQos());
                statement.bindLong(5, (long)_tmp_1);
                int _tmp_2 = entity.getRetained() ? 1 : 0;
                statement.bindLong(6, (long)_tmp_2);
                int _tmp_3 = entity.getDuplicate() ? 1 : 0;
                statement.bindLong(7, (long)_tmp_3);
                statement.bindLong(8, entity.getTimestamp());
            }
        };
        this.__deletionAdapterOfMqMessageEntity = new EntityDeletionOrUpdateAdapter<MqMessageEntity>(__db){

            @NonNull
            protected String createQuery() {
                return "DELETE FROM `MqMessageEntity` WHERE `messageId` = ?";
            }

            protected void bind(@NonNull SupportSQLiteStatement statement, @NonNull MqMessageEntity entity) {
                statement.bindString(1, entity.getMessageId());
            }
        };
        this.__updateAdapterOfMqMessageEntity = new EntityDeletionOrUpdateAdapter<MqMessageEntity>(__db){

            @NonNull
            protected String createQuery() {
                return "UPDATE OR ABORT `MqMessageEntity` SET `messageId` = ?,`clientHandle` = ?,`topic` = ?,`mqttMessage` = ?,`qos` = ?,`retained` = ?,`duplicate` = ?,`timestamp` = ? WHERE `messageId` = ?";
            }

            protected void bind(@NonNull SupportSQLiteStatement statement, @NonNull MqMessageEntity entity) {
                statement.bindString(1, entity.getMessageId());
                statement.bindString(2, entity.getClientHandle());
                statement.bindString(3, entity.getTopic());
                String _tmp = MqMessageDao_Impl.this.__converters.fromMqttMessage(entity.getMqttMessage());
                statement.bindString(4, _tmp);
                int _tmp_1 = MqMessageDao_Impl.this.__converters.fromQoS(entity.getQos());
                statement.bindLong(5, (long)_tmp_1);
                int _tmp_2 = entity.getRetained() ? 1 : 0;
                statement.bindLong(6, (long)_tmp_2);
                int _tmp_3 = entity.getDuplicate() ? 1 : 0;
                statement.bindLong(7, (long)_tmp_3);
                statement.bindLong(8, entity.getTimestamp());
                statement.bindString(9, entity.getMessageId());
            }
        };
        this.__preparedStmtOfDeleteId = new SharedSQLiteStatement(__db){

            @NonNull
            public String createQuery() {
                String _query = "DELETE FROM MqMessageEntity WHERE clientHandle = ? AND messageId = ?";
                return "DELETE FROM MqMessageEntity WHERE clientHandle = ? AND messageId = ?";
            }
        };
        this.__preparedStmtOfDeleteClientHandle = new SharedSQLiteStatement(__db){

            @NonNull
            public String createQuery() {
                String _query = "DELETE FROM MqMessageEntity WHERE clientHandle = ?";
                return "DELETE FROM MqMessageEntity WHERE clientHandle = ?";
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long insert(MqMessageEntity mqMessageEntity) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            long _result = this.__insertionAdapterOfMqMessageEntity.insertAndReturnId((Object)mqMessageEntity);
            this.__db.setTransactionSuccessful();
            long l = _result;
            return l;
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void delete(MqMessageEntity mqMessageEntity) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__deletionAdapterOfMqMessageEntity.handle((Object)mqMessageEntity);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void updateAll(MqMessageEntity ... mqMessageEntity) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__updateAdapterOfMqMessageEntity.handleMultiple((Object[])mqMessageEntity);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int deleteId(String clientHandle, String id) {
        this.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement _stmt = this.__preparedStmtOfDeleteId.acquire();
        int _argIndex = 1;
        _stmt.bindString(_argIndex, clientHandle);
        _argIndex = 2;
        _stmt.bindString(_argIndex, id);
        try {
            int n;
            this.__db.beginTransaction();
            try {
                int _result = _stmt.executeUpdateDelete();
                this.__db.setTransactionSuccessful();
                n = _result;
            }
            catch (Throwable throwable) {
                this.__db.endTransaction();
                throw throwable;
            }
            this.__db.endTransaction();
            return n;
        }
        finally {
            this.__preparedStmtOfDeleteId.release(_stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int deleteClientHandle(String clientHandle) {
        this.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement _stmt = this.__preparedStmtOfDeleteClientHandle.acquire();
        int _argIndex = 1;
        _stmt.bindString(_argIndex, clientHandle);
        try {
            int n;
            this.__db.beginTransaction();
            try {
                int _result = _stmt.executeUpdateDelete();
                this.__db.setTransactionSuccessful();
                n = _result;
            }
            catch (Throwable throwable) {
                this.__db.endTransaction();
                throw throwable;
            }
            this.__db.endTransaction();
            return n;
        }
        finally {
            this.__preparedStmtOfDeleteClientHandle.release(_stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<MqMessageEntity> getAll() {
        String _sql = "SELECT * FROM MQMessageEntity";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM MQMessageEntity", (int)0);
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
        try {
            int _cursorIndexOfMessageId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"messageId");
            int _cursorIndexOfClientHandle = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clientHandle");
            int _cursorIndexOfTopic = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"topic");
            int _cursorIndexOfMqttMessage = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"mqttMessage");
            int _cursorIndexOfQos = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"qos");
            int _cursorIndexOfRetained = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"retained");
            int _cursorIndexOfDuplicate = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"duplicate");
            int _cursorIndexOfTimestamp = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"timestamp");
            ArrayList<MqMessageEntity> _result = new ArrayList<MqMessageEntity>(_cursor.getCount());
            while (_cursor.moveToNext()) {
                String _tmpMessageId = _cursor.getString(_cursorIndexOfMessageId);
                String _tmpClientHandle = _cursor.getString(_cursorIndexOfClientHandle);
                String _tmpTopic = _cursor.getString(_cursorIndexOfTopic);
                String _tmp = _cursor.getString(_cursorIndexOfMqttMessage);
                MqttMessage _tmpMqttMessage = this.__converters.toMqttMessage(_tmp);
                int _tmp_1 = _cursor.getInt(_cursorIndexOfQos);
                QoS _tmpQos = this.__converters.toQoS(_tmp_1);
                int _tmp_2 = _cursor.getInt(_cursorIndexOfRetained);
                boolean _tmpRetained = _tmp_2 != 0;
                int _tmp_3 = _cursor.getInt(_cursorIndexOfDuplicate);
                boolean _tmpDuplicate = _tmp_3 != 0;
                long _tmpTimestamp = _cursor.getLong(_cursorIndexOfTimestamp);
                MqMessageEntity _item = new MqMessageEntity(_tmpMessageId, _tmpClientHandle, _tmpTopic, _tmpMqttMessage, _tmpQos, _tmpRetained, _tmpDuplicate, _tmpTimestamp);
                _result.add(_item);
            }
            ArrayList<MqMessageEntity> arrayList = _result;
            return arrayList;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<MqMessageEntity> allArrived(String clientHandle) {
        String _sql = "SELECT * FROM MQMessageEntity WHERE clientHandle = ? ORDER BY timestamp ASC";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM MQMessageEntity WHERE clientHandle = ? ORDER BY timestamp ASC", (int)1);
        int _argIndex = 1;
        _statement.bindString(_argIndex, clientHandle);
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
        try {
            int _cursorIndexOfMessageId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"messageId");
            int _cursorIndexOfClientHandle = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"clientHandle");
            int _cursorIndexOfTopic = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"topic");
            int _cursorIndexOfMqttMessage = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"mqttMessage");
            int _cursorIndexOfQos = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"qos");
            int _cursorIndexOfRetained = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"retained");
            int _cursorIndexOfDuplicate = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"duplicate");
            int _cursorIndexOfTimestamp = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"timestamp");
            ArrayList<MqMessageEntity> _result = new ArrayList<MqMessageEntity>(_cursor.getCount());
            while (_cursor.moveToNext()) {
                String _tmpMessageId = _cursor.getString(_cursorIndexOfMessageId);
                String _tmpClientHandle = _cursor.getString(_cursorIndexOfClientHandle);
                String _tmpTopic = _cursor.getString(_cursorIndexOfTopic);
                String _tmp = _cursor.getString(_cursorIndexOfMqttMessage);
                MqttMessage _tmpMqttMessage = this.__converters.toMqttMessage(_tmp);
                int _tmp_1 = _cursor.getInt(_cursorIndexOfQos);
                QoS _tmpQos = this.__converters.toQoS(_tmp_1);
                int _tmp_2 = _cursor.getInt(_cursorIndexOfRetained);
                boolean _tmpRetained = _tmp_2 != 0;
                int _tmp_3 = _cursor.getInt(_cursorIndexOfDuplicate);
                boolean _tmpDuplicate = _tmp_3 != 0;
                long _tmpTimestamp = _cursor.getLong(_cursorIndexOfTimestamp);
                MqMessageEntity _item = new MqMessageEntity(_tmpMessageId, _tmpClientHandle, _tmpTopic, _tmpMqttMessage, _tmpQos, _tmpRetained, _tmpDuplicate, _tmpTimestamp);
                _result.add(_item);
            }
            ArrayList<MqMessageEntity> arrayList = _result;
            return arrayList;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    @NonNull
    public static List<Class<?>> getRequiredConverters() {
        return Collections.emptyList();
    }
}

