/*
 * Decompiled with CFR 0.152.
 */
package info.mqtt.android.service;

import android.annotation.SuppressLint;
import android.app.Notification;
import android.app.Service;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.ConnectivityManager;
import android.net.Network;
import android.net.NetworkCapabilities;
import android.net.NetworkInfo;
import android.os.Build;
import android.os.Bundle;
import android.os.IBinder;
import android.os.Parcelable;
import android.os.PowerManager;
import info.mqtt.android.service.MqttConnection;
import info.mqtt.android.service.MqttService;
import info.mqtt.android.service.MqttServiceBinder;
import info.mqtt.android.service.MqttTraceHandler;
import info.mqtt.android.service.QoS;
import info.mqtt.android.service.Status;
import info.mqtt.android.service.room.MqMessageDatabase;
import java.io.Serializable;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Function;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.FunctionAdapter;
import kotlin.jvm.internal.FunctionReferenceImpl;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CompletableJob;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.Job;
import kotlinx.coroutines.SupervisorKt;
import kotlinx.coroutines.flow.FlowCollector;
import kotlinx.coroutines.flow.MutableSharedFlow;
import kotlinx.coroutines.flow.SharedFlowKt;
import org.eclipse.paho.client.mqttv3.DisconnectedBufferOptions;
import org.eclipse.paho.client.mqttv3.IMqttDeliveryToken;
import org.eclipse.paho.client.mqttv3.IMqttMessageListener;
import org.eclipse.paho.client.mqttv3.MqttClientPersistence;
import org.eclipse.paho.client.mqttv3.MqttConnectOptions;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.eclipse.paho.client.mqttv3.MqttMessage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import timber.log.Timber;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00e6\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0007\u0018\u0000 z2\u00020\u00012\u00020\u0002:\u0002z{B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0016\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\u00062\u0006\u0010%\u001a\u00020\u0006J\u001e\u0010&\u001a\u00020'2\u0006\u0010$\u001a\u00020\u00062\u0006\u0010(\u001a\u00020#2\u0006\u0010)\u001a\u00020\fJ\u000e\u0010*\u001a\u00020'2\u0006\u0010$\u001a\u00020\u0006J\"\u0010+\u001a\u00020'2\u0012\u0010,\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020'0-H\u0086@\u00a2\u0006\u0002\u0010.J\"\u0010/\u001a\u00020'2\u0006\u0010$\u001a\u00020\u00062\b\u00100\u001a\u0004\u0018\u0001012\b\u00102\u001a\u0004\u0018\u00010\u0006J\u0016\u00103\u001a\u00020'2\u0006\u0010$\u001a\u00020\u00062\u0006\u00104\u001a\u000205J*\u00106\u001a\u00020'2\u0006\u0010$\u001a\u00020\u00062\u0006\u00107\u001a\u0002082\b\u00109\u001a\u0004\u0018\u00010\u00062\b\u00102\u001a\u0004\u0018\u00010\u0006J\"\u00106\u001a\u00020'2\u0006\u0010$\u001a\u00020\u00062\b\u00109\u001a\u0004\u0018\u00010\u00062\b\u00102\u001a\u0004\u0018\u00010\u0006J\u0016\u0010:\u001a\u00020;2\u0006\u0010$\u001a\u00020\u00062\u0006\u00104\u001a\u000205J\u000e\u0010<\u001a\u0002052\u0006\u0010$\u001a\u00020\u0006J(\u0010=\u001a\u00020\u00062\u0006\u0010>\u001a\u00020\u00062\u0006\u0010?\u001a\u00020\u00062\u0006\u0010@\u001a\u00020\u00062\b\u0010A\u001a\u0004\u0018\u00010BJ\u0010\u0010C\u001a\u00020\u00072\u0006\u0010$\u001a\u00020\u0006H\u0002J\u000e\u0010D\u001a\u0002052\u0006\u0010$\u001a\u00020\u0006J\u0019\u0010E\u001a\b\u0012\u0004\u0012\u00020G0F2\u0006\u0010$\u001a\u00020\u0006\u00a2\u0006\u0002\u0010HJ\u000e\u0010I\u001a\u00020\u000e2\u0006\u0010$\u001a\u00020\u0006J\u0010\u0010J\u001a\u00020\u000e2\u0006\u0010$\u001a\u00020\u0006H\u0002J\u0010\u0010K\u001a\u00020\u000e2\u0006\u0010L\u001a\u00020MH\u0002J\u000e\u0010N\u001a\u00020\u000e2\u0006\u0010L\u001a\u00020MJ\b\u0010O\u001a\u00020'H\u0002J\u0012\u0010P\u001a\u0004\u0018\u00010Q2\u0006\u0010R\u001a\u00020SH\u0016J\b\u0010T\u001a\u00020'H\u0016J\b\u0010U\u001a\u00020'H\u0016J\"\u0010V\u001a\u0002052\b\u0010R\u001a\u0004\u0018\u00010S2\u0006\u0010W\u001a\u0002052\u0006\u0010X\u001a\u000205H\u0016JD\u0010Y\u001a\u0004\u0018\u00010G2\u0006\u0010$\u001a\u00020\u00062\u0006\u0010Z\u001a\u00020\u00062\u0006\u0010[\u001a\u00020\\2\u0006\u0010]\u001a\u00020^2\u0006\u0010_\u001a\u00020\u000e2\b\u00109\u001a\u0004\u0018\u00010\u00062\b\u00102\u001a\u0004\u0018\u00010\u0006J2\u0010Y\u001a\u0004\u0018\u00010G2\u0006\u0010$\u001a\u00020\u00062\u0006\u0010Z\u001a\u00020\u00062\u0006\u0010`\u001a\u00020;2\b\u00109\u001a\u0004\u0018\u00010\u00062\u0006\u00102\u001a\u00020\u0006J\u000e\u0010a\u001a\u00020'2\u0006\u0010L\u001a\u00020MJ\b\u0010b\u001a\u00020'H\u0002J\u0018\u0010c\u001a\u00020'2\u0006\u0010$\u001a\u00020\u00062\b\u0010d\u001a\u0004\u0018\u00010eJ\u0010\u0010f\u001a\u00020'2\b\u0010!\u001a\u0004\u0018\u00010\u0006J\b\u0010g\u001a\u00020'H\u0002JS\u0010h\u001a\u00020'2\u0006\u0010$\u001a\u00020\u00062\f\u0010i\u001a\b\u0012\u0004\u0012\u00020\u00060F2\f\u0010]\u001a\b\u0012\u0004\u0012\u00020^0F2\b\u00109\u001a\u0004\u0018\u00010\u00062\b\u00102\u001a\u0004\u0018\u00010\u00062\u000e\u0010j\u001a\n\u0012\u0004\u0012\u00020k\u0018\u00010F\u00a2\u0006\u0002\u0010lJ=\u0010h\u001a\u00020'2\u0006\u0010$\u001a\u00020\u00062\f\u0010Z\u001a\b\u0012\u0004\u0012\u00020\u00060F2\b\u0010]\u001a\u0004\u0018\u00010m2\b\u00109\u001a\u0004\u0018\u00010\u00062\u0006\u00102\u001a\u00020\u0006\u00a2\u0006\u0002\u0010nJ0\u0010h\u001a\u00020'2\u0006\u0010$\u001a\u00020\u00062\u0006\u0010Z\u001a\u00020\u00062\u0006\u0010]\u001a\u00020^2\b\u00109\u001a\u0004\u0018\u00010\u00062\u0006\u00102\u001a\u00020\u0006J\u001a\u0010o\u001a\u00020'2\u0006\u0010p\u001a\u00020\u00062\b\u0010`\u001a\u0004\u0018\u00010\u0006H\u0002J\u0012\u0010q\u001a\u00020'2\b\u0010`\u001a\u0004\u0018\u00010\u0006H\u0016J\u0012\u0010r\u001a\u00020'2\b\u0010`\u001a\u0004\u0018\u00010\u0006H\u0016J\"\u0010s\u001a\u00020'2\b\u0010`\u001a\u0004\u0018\u00010\u00062\u000e\u0010t\u001a\n\u0018\u00010uj\u0004\u0018\u0001`vH\u0016J\b\u0010w\u001a\u00020'H\u0002J5\u0010x\u001a\u00020'2\u0006\u0010$\u001a\u00020\u00062\f\u0010Z\u001a\b\u0012\u0004\u0012\u00020\u00060F2\b\u00109\u001a\u0004\u0018\u00010\u00062\b\u00102\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010yJ(\u0010x\u001a\u00020'2\u0006\u0010$\u001a\u00020\u00062\u0006\u0010Z\u001a\u00020\u00062\b\u00109\u001a\u0004\u0018\u00010\u00062\u0006\u00102\u001a\u00020\u0006R \u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000f\u001a\u00020\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0013\u001a\u00020\u0014X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u0010\u0010\u0019\u001a\u0004\u0018\u00010\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001b\u001a\b\u0018\u00010\u001cR\u00020\u0000X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001d\u001a\u0004\u0018\u00010\u001eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001f\u001a\u0004\u0018\u00010 X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010!\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006|"}, d2={"Linfo/mqtt/android/service/MqttService;", "Landroid/app/Service;", "Linfo/mqtt/android/service/MqttTraceHandler;", "()V", "connections", "", "", "Linfo/mqtt/android/service/MqttConnection;", "getConnections$serviceLibrary_release", "()Ljava/util/Map;", "flow", "Lkotlinx/coroutines/flow/MutableSharedFlow;", "Landroid/os/Bundle;", "isForegroundStarted", "", "isTraceEnabled", "()Z", "setTraceEnabled", "(Z)V", "messageDatabase", "Linfo/mqtt/android/service/room/MqMessageDatabase;", "getMessageDatabase", "()Linfo/mqtt/android/service/room/MqMessageDatabase;", "setMessageDatabase", "(Linfo/mqtt/android/service/room/MqMessageDatabase;)V", "mqttServiceBinder", "Linfo/mqtt/android/service/MqttServiceBinder;", "networkConnectionMonitor", "Linfo/mqtt/android/service/MqttService$NetworkConnectionIntentReceiver;", "serviceJob", "Lkotlinx/coroutines/Job;", "serviceScope", "Lkotlinx/coroutines/CoroutineScope;", "traceCallbackId", "acknowledgeMessageArrival", "Linfo/mqtt/android/service/Status;", "clientHandle", "id", "callbackToActivity", "", "status", "dataBundle", "close", "collect", "block", "Lkotlin/Function1;", "(Lkotlin/jvm/functions/Function1;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "connect", "connectOptions", "Lorg/eclipse/paho/client/mqttv3/MqttConnectOptions;", "activityToken", "deleteBufferedMessage", "bufferIndex", "", "disconnect", "quiesceTimeout", "", "invocationContext", "getBufferedMessage", "Lorg/eclipse/paho/client/mqttv3/MqttMessage;", "getBufferedMessageCount", "getClient", "serverURI", "clientId", "contextId", "persistence", "Lorg/eclipse/paho/client/mqttv3/MqttClientPersistence;", "getConnection", "getInFlightMessageCount", "getPendingDeliveryTokens", "", "Lorg/eclipse/paho/client/mqttv3/IMqttDeliveryToken;", "(Ljava/lang/String;)[Lorg/eclipse/paho/client/mqttv3/IMqttDeliveryToken;", "isConnected", "isConnectionAvailable", "isInternetAvailable", "context", "Landroid/content/Context;", "isOnline", "notifyClientsOffline", "onBind", "Landroid/os/IBinder;", "intent", "Landroid/content/Intent;", "onCreate", "onDestroy", "onStartCommand", "flags", "startId", "publish", "topic", "payload", "", "qos", "Linfo/mqtt/android/service/QoS;", "retained", "message", "reconnect", "registerBroadcastReceivers", "setBufferOpts", "bufferOpts", "Lorg/eclipse/paho/client/mqttv3/DisconnectedBufferOptions;", "setTraceCallbackId", "stopService", "subscribe", "topicFilters", "messageListeners", "Lorg/eclipse/paho/client/mqttv3/IMqttMessageListener;", "(Ljava/lang/String;[Ljava/lang/String;[Linfo/mqtt/android/service/QoS;Ljava/lang/String;Ljava/lang/String;[Lorg/eclipse/paho/client/mqttv3/IMqttMessageListener;)V", "", "(Ljava/lang/String;[Ljava/lang/String;[ILjava/lang/String;Ljava/lang/String;)V", "traceCallback", "severity", "traceDebug", "traceError", "traceException", "e", "Ljava/lang/Exception;", "Lkotlin/Exception;", "unregisterBroadcastReceivers", "unsubscribe", "(Ljava/lang/String;[Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "Companion", "NetworkConnectionIntentReceiver", "serviceLibrary_release"})
@SuppressLint(value={"Registered"})
@SourceDebugExtension(value={"SMAP\nMqttService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MqttService.kt\ninfo/mqtt/android/service/MqttService\n+ 2 BundleExt.kt\ninfo/mqtt/android/service/extension/BundleExtKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,689:1\n23#2,4:690\n1855#3,2:694\n*S KotlinDebug\n*F\n+ 1 MqttService.kt\ninfo/mqtt/android/service/MqttService\n*L\n241#1:690,4\n604#1:694,2\n*E\n"})
public final class MqttService
extends Service
implements MqttTraceHandler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Map<String, MqttConnection> connections = new ConcurrentHashMap();
    public MqMessageDatabase messageDatabase;
    @Nullable
    private String traceCallbackId;
    private boolean isForegroundStarted;
    private boolean isTraceEnabled;
    @Nullable
    private NetworkConnectionIntentReceiver networkConnectionMonitor;
    @Nullable
    private MqttServiceBinder mqttServiceBinder;
    @Nullable
    private Job serviceJob;
    @Nullable
    private CoroutineScope serviceScope;
    @NotNull
    private final MutableSharedFlow<Bundle> flow = SharedFlowKt.MutableSharedFlow$default((int)0, (int)0, null, (int)7, null);
    @NotNull
    private static final String MQTT_FOREGROUND_SERVICE_NOTIFICATION_ID = MqttService.class.getSimpleName() + ".FOREGROUND_SERVICE_NOTIFICATION_ID";
    @NotNull
    private static final String MQTT_FOREGROUND_SERVICE_NOTIFICATION = MqttService.class.getSimpleName() + ".FOREGROUND_SERVICE_NOTIFICATION";

    @NotNull
    public final Map<String, MqttConnection> getConnections$serviceLibrary_release() {
        return this.connections;
    }

    @NotNull
    public final MqMessageDatabase getMessageDatabase() {
        MqMessageDatabase mqMessageDatabase = this.messageDatabase;
        if (mqMessageDatabase != null) {
            return mqMessageDatabase;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"messageDatabase");
        return null;
    }

    public final void setMessageDatabase(@NotNull MqMessageDatabase mqMessageDatabase) {
        Intrinsics.checkNotNullParameter((Object)((Object)mqMessageDatabase), (String)"<set-?>");
        this.messageDatabase = mqMessageDatabase;
    }

    public final boolean isTraceEnabled() {
        return this.isTraceEnabled;
    }

    public final void setTraceEnabled(boolean bl) {
        this.isTraceEnabled = bl;
    }

    public void onCreate() {
        super.onCreate();
        CompletableJob supervisorJob = SupervisorKt.SupervisorJob$default(null, (int)1, null);
        this.serviceJob = (Job)supervisorJob;
        this.serviceScope = CoroutineScopeKt.CoroutineScope((CoroutineContext)Dispatchers.getMain().plus((CoroutineContext)supervisorJob));
        this.mqttServiceBinder = new MqttServiceBinder(this);
        this.setMessageDatabase(MqMessageDatabase.Companion.getDatabase$default(MqMessageDatabase.Companion, (Context)this, null, 2, null));
    }

    public void onDestroy() {
        Timber.Forest.i("Destroy service", new Object[0]);
        for (MqttConnection client : this.connections.values()) {
            client.disconnect(null, null);
        }
        Job job = this.serviceJob;
        if (job != null) {
            Job.DefaultImpls.cancel$default((Job)job, null, (int)1, null);
        }
        this.serviceJob = null;
        this.serviceScope = null;
        this.mqttServiceBinder = null;
        this.unregisterBroadcastReceivers();
        super.onDestroy();
    }

    @Nullable
    public IBinder onBind(@NotNull Intent intent) {
        Intrinsics.checkNotNullParameter((Object)intent, (String)"intent");
        String activityToken = intent.getStringExtra(".activityToken");
        MqttServiceBinder mqttServiceBinder = this.mqttServiceBinder;
        Intrinsics.checkNotNull((Object)((Object)mqttServiceBinder));
        mqttServiceBinder.setActivityToken(activityToken);
        return (IBinder)this.mqttServiceBinder;
    }

    public int onStartCommand(@Nullable Intent intent, int flags, int startId) {
        this.registerBroadcastReceivers();
        if (Build.VERSION.SDK_INT >= 26) {
            Notification foregroundServiceNotification;
            Intent intent2 = intent;
            if (intent2 != null) {
                Object object;
                Intent intent3 = intent2;
                String key$iv = MQTT_FOREGROUND_SERVICE_NOTIFICATION;
                boolean $i$f$parcelableExtra = false;
                if (Build.VERSION.SDK_INT >= 33) {
                    object = $this$parcelableExtra$iv.getParcelableExtra(key$iv, Notification.class);
                } else {
                    Parcelable parcelable = $this$parcelableExtra$iv.getParcelableExtra(key$iv);
                    if (!(parcelable instanceof Notification)) {
                        parcelable = null;
                    }
                    object = (Notification)parcelable;
                }
                v3 = (Notification)object;
            } else {
                v3 = foregroundServiceNotification = null;
            }
            if (foregroundServiceNotification != null) {
                this.isForegroundStarted = true;
                this.startForeground(intent.getIntExtra(MQTT_FOREGROUND_SERVICE_NOTIFICATION_ID, 1), foregroundServiceNotification);
            }
        }
        return 1;
    }

    public final void callbackToActivity(@NotNull String clientHandle, @NotNull Status status, @NotNull Bundle dataBundle) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)clientHandle, (String)"clientHandle");
            Intrinsics.checkNotNullParameter((Object)((Object)status), (String)"status");
            Intrinsics.checkNotNullParameter((Object)dataBundle, (String)"dataBundle");
            Bundle bundle = new Bundle(dataBundle);
            bundle.putString(".clientHandle", clientHandle);
            bundle.putSerializable(".callbackStatus", (Serializable)((Object)status));
            CoroutineScope coroutineScope = this.serviceScope;
            if (coroutineScope == null) break block0;
            BuildersKt.launch$default((CoroutineScope)coroutineScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, bundle, null){
                int label;
                final /* synthetic */ MqttService this$0;
                final /* synthetic */ Bundle $bundle;
                {
                    this.this$0 = $receiver;
                    this.$bundle = $bundle;
                    super(2, $completion);
                }

                /*
                 * WARNING - void declaration
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                @Nullable
                public final Object invokeSuspend(@NotNull Object object) {
                    Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            this.label = 1;
                            Object object3 = MqttService.access$getFlow$p(this.this$0).emit((Object)this.$bundle, (Continuation)this);
                            if (object3 != object2) return Unit.INSTANCE;
                            return object2;
                        }
                        case 1: {
                            void $result;
                            ResultKt.throwOnFailure((Object)$result);
                            Object object3 = $result;
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                @Nullable
                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)3, null);
        }
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object collect(@NotNull Function1<? super Bundle, Unit> var1_1, @NotNull Continuation<? super Unit> var2_2) {
        if (!(var2_2 instanceof collect.1)) ** GOTO lbl-1000
        var4_3 = var2_2;
        if ((var4_3.label & -2147483648) != 0) {
            var4_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var2_2){
                /* synthetic */ Object result;
                final /* synthetic */ MqttService this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.collect(null, (Continuation<? super Unit>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var5_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $continuation.label = 1;
                v0 = this.flow.collect(new FlowCollector((Function1<? super Bundle, Unit>)block){
                    final /* synthetic */ Function1<Bundle, Unit> $tmp0;
                    {
                        this.$tmp0 = $tmp0;
                    }

                    @Nullable
                    public final Object emit(@NotNull Bundle p0, @NotNull Continuation<? super Unit> $completion) {
                        Object object = MqttService.access$collect$suspendConversion0(this.$tmp0, p0, $completion);
                        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                            return object;
                        }
                        return Unit.INSTANCE;
                    }

                    @NotNull
                    public final Function<?> getFunctionDelegate() {
                        return (Function)new FunctionReferenceImpl(2, this.$tmp0, Intrinsics.Kotlin.class, "suspendConversion0", "collect$suspendConversion0(Lkotlin/jvm/functions/Function1;Landroid/os/Bundle;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", 0);
                    }

                    public final boolean equals(@Nullable Object other) {
                        return other instanceof FlowCollector ? (other instanceof FunctionAdapter ? Intrinsics.areEqual(this.getFunctionDelegate(), (Object)((FunctionAdapter)other).getFunctionDelegate()) : false) : false;
                    }

                    public final int hashCode() {
                        return this.getFunctionDelegate().hashCode();
                    }
                }, (Continuation)$continuation);
                if (v0 == var5_5) {
                    return var5_5;
                }
                ** GOTO lbl20
            }
            case 1: {
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl20:
                // 2 sources

                throw new KotlinNothingValueException();
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    @NotNull
    public final String getClient(@NotNull String serverURI, @NotNull String clientId, @NotNull String contextId, @Nullable MqttClientPersistence persistence) {
        Intrinsics.checkNotNullParameter((Object)serverURI, (String)"serverURI");
        Intrinsics.checkNotNullParameter((Object)clientId, (String)"clientId");
        Intrinsics.checkNotNullParameter((Object)contextId, (String)"contextId");
        String clientHandle = serverURI + ":" + clientId + ":" + contextId;
        if (!this.connections.containsKey(clientHandle)) {
            MqttConnection client = new MqttConnection(this, serverURI, clientId, persistence, clientHandle);
            this.connections.put(clientHandle, client);
        }
        return clientHandle;
    }

    public final void connect(@NotNull String clientHandle, @Nullable MqttConnectOptions connectOptions, @Nullable String activityToken) throws MqttException {
        Intrinsics.checkNotNullParameter((Object)clientHandle, (String)"clientHandle");
        MqttConnection client = this.getConnection(clientHandle);
        BuildersKt.launch$default((CoroutineScope)CoroutineScopeKt.CoroutineScope((CoroutineContext)((CoroutineContext)Dispatchers.getIO())), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(client, connectOptions, activityToken, null){
            int label;
            final /* synthetic */ MqttConnection $client;
            final /* synthetic */ MqttConnectOptions $connectOptions;
            final /* synthetic */ String $activityToken;
            {
                this.$client = $client;
                this.$connectOptions = $connectOptions;
                this.$activityToken = $activityToken;
                super(2, $completion);
            }

            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.$client.connect(this.$connectOptions, null, this.$activityToken);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    public final void reconnect(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.traceDebug("Reconnect to server, client size=" + this.connections.size());
        for (MqttConnection client : this.connections.values()) {
            this.traceDebug("Reconnect Client:" + client.getClientId() + "/" + client.getServerURI());
            if (!this.isOnline(context)) continue;
            client.reconnect(context);
        }
    }

    public final void close(@NotNull String clientHandle) {
        Intrinsics.checkNotNullParameter((Object)clientHandle, (String)"clientHandle");
        MqttConnection client = this.getConnection(clientHandle);
        client.close();
    }

    private final void stopService() {
        if (this.isForegroundStarted) {
            if (Build.VERSION.SDK_INT >= 24) {
                this.stopForeground(1);
            } else {
                this.stopForeground(true);
            }
        }
        this.stopSelf();
    }

    public final void disconnect(@NotNull String clientHandle, @Nullable String invocationContext, @Nullable String activityToken) {
        Intrinsics.checkNotNullParameter((Object)clientHandle, (String)"clientHandle");
        if (this.isConnectionAvailable(clientHandle)) {
            MqttConnection client = this.getConnection(clientHandle);
            client.disconnect(invocationContext, activityToken);
            this.connections.remove(clientHandle);
        } else {
            Timber.Forest.w("Connection is not available " + clientHandle, new Object[0]);
        }
        this.stopService();
    }

    public final void disconnect(@NotNull String clientHandle, long quiesceTimeout, @Nullable String invocationContext, @Nullable String activityToken) {
        Intrinsics.checkNotNullParameter((Object)clientHandle, (String)"clientHandle");
        MqttConnection client = this.getConnection(clientHandle);
        client.disconnect(quiesceTimeout, invocationContext, activityToken);
        this.connections.remove(clientHandle);
        this.stopService();
    }

    public final boolean isConnected(@NotNull String clientHandle) {
        Intrinsics.checkNotNullParameter((Object)clientHandle, (String)"clientHandle");
        return this.getConnection(clientHandle).isConnected();
    }

    @Nullable
    public final IMqttDeliveryToken publish(@NotNull String clientHandle, @NotNull String topic, @NotNull byte[] payload, @NotNull QoS qos, boolean retained, @Nullable String invocationContext, @Nullable String activityToken) {
        Intrinsics.checkNotNullParameter((Object)clientHandle, (String)"clientHandle");
        Intrinsics.checkNotNullParameter((Object)topic, (String)"topic");
        Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
        Intrinsics.checkNotNullParameter((Object)((Object)qos), (String)"qos");
        MqttConnection mqttConnection = this.getConnection(clientHandle);
        String string = activityToken;
        Intrinsics.checkNotNull((Object)string);
        return mqttConnection.publish(topic, payload, qos, retained, invocationContext, string);
    }

    @Nullable
    public final IMqttDeliveryToken publish(@NotNull String clientHandle, @NotNull String topic, @NotNull MqttMessage message, @Nullable String invocationContext, @NotNull String activityToken) {
        Intrinsics.checkNotNullParameter((Object)clientHandle, (String)"clientHandle");
        Intrinsics.checkNotNullParameter((Object)topic, (String)"topic");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)activityToken, (String)"activityToken");
        return this.getConnection(clientHandle).publish(topic, message, invocationContext, activityToken);
    }

    public final void subscribe(@NotNull String clientHandle, @NotNull String topic, @NotNull QoS qos, @Nullable String invocationContext, @NotNull String activityToken) {
        Intrinsics.checkNotNullParameter((Object)clientHandle, (String)"clientHandle");
        Intrinsics.checkNotNullParameter((Object)topic, (String)"topic");
        Intrinsics.checkNotNullParameter((Object)((Object)qos), (String)"qos");
        Intrinsics.checkNotNullParameter((Object)activityToken, (String)"activityToken");
        this.getConnection(clientHandle).subscribe(topic, qos, invocationContext, activityToken);
    }

    public final void subscribe(@NotNull String clientHandle, @NotNull String[] topic, @Nullable int[] qos, @Nullable String invocationContext, @NotNull String activityToken) {
        Intrinsics.checkNotNullParameter((Object)clientHandle, (String)"clientHandle");
        Intrinsics.checkNotNullParameter((Object)topic, (String)"topic");
        Intrinsics.checkNotNullParameter((Object)activityToken, (String)"activityToken");
        this.getConnection(clientHandle).subscribe(topic, qos, invocationContext, activityToken);
    }

    public final void subscribe(@NotNull String clientHandle, @NotNull String[] topicFilters, @NotNull QoS[] qos, @Nullable String invocationContext, @Nullable String activityToken, @Nullable IMqttMessageListener[] messageListeners) {
        Intrinsics.checkNotNullParameter((Object)clientHandle, (String)"clientHandle");
        Intrinsics.checkNotNullParameter((Object)topicFilters, (String)"topicFilters");
        Intrinsics.checkNotNullParameter((Object)qos, (String)"qos");
        MqttConnection mqttConnection = this.getConnection(clientHandle);
        String string = activityToken;
        Intrinsics.checkNotNull((Object)string);
        mqttConnection.subscribe(topicFilters, qos, invocationContext, string, messageListeners);
    }

    public final void unsubscribe(@NotNull String clientHandle, @NotNull String topic, @Nullable String invocationContext, @NotNull String activityToken) {
        Intrinsics.checkNotNullParameter((Object)clientHandle, (String)"clientHandle");
        Intrinsics.checkNotNullParameter((Object)topic, (String)"topic");
        Intrinsics.checkNotNullParameter((Object)activityToken, (String)"activityToken");
        this.getConnection(clientHandle).unsubscribe(topic, invocationContext, activityToken);
    }

    public final void unsubscribe(@NotNull String clientHandle, @NotNull String[] topic, @Nullable String invocationContext, @Nullable String activityToken) {
        Intrinsics.checkNotNullParameter((Object)clientHandle, (String)"clientHandle");
        Intrinsics.checkNotNullParameter((Object)topic, (String)"topic");
        MqttConnection mqttConnection = this.getConnection(clientHandle);
        String string = activityToken;
        Intrinsics.checkNotNull((Object)string);
        mqttConnection.unsubscribe(topic, invocationContext, string);
    }

    @NotNull
    public final IMqttDeliveryToken[] getPendingDeliveryTokens(@NotNull String clientHandle) {
        Intrinsics.checkNotNullParameter((Object)clientHandle, (String)"clientHandle");
        return this.getConnection(clientHandle).getPendingDeliveryTokens();
    }

    private final MqttConnection getConnection(String clientHandle) {
        MqttConnection mqttConnection = this.connections.get(clientHandle);
        if (mqttConnection == null) {
            throw new IllegalArgumentException("Invalid ClientHandle >" + clientHandle + "<");
        }
        return mqttConnection;
    }

    private final boolean isConnectionAvailable(String clientHandle) {
        return this.connections.containsKey(clientHandle);
    }

    @NotNull
    public final Status acknowledgeMessageArrival(@NotNull String clientHandle, @NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)clientHandle, (String)"clientHandle");
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        return this.getMessageDatabase().discardArrived(clientHandle, id) ? Status.OK : Status.ERROR;
    }

    public final void setTraceCallbackId(@Nullable String traceCallbackId) {
        this.traceCallbackId = traceCallbackId;
    }

    @Override
    public void traceDebug(@Nullable String message) {
        this.traceCallback("debug", message);
    }

    @Override
    public void traceError(@Nullable String message) {
        this.traceCallback("error", message);
    }

    private final void traceCallback(String severity, String message) {
        block1: {
            String string = this.traceCallbackId;
            if (string == null) break block1;
            String it = string;
            boolean bl = false;
            if (this.isTraceEnabled) {
                Bundle dataBundle = new Bundle();
                dataBundle.putString(".callbackAction", "trace");
                dataBundle.putString(".traceSeverity", severity);
                dataBundle.putString(".errorMessage", message);
                this.callbackToActivity(it, Status.ERROR, dataBundle);
            }
        }
    }

    @Override
    public void traceException(@Nullable String message, @Nullable Exception e) {
        block0: {
            String string = this.traceCallbackId;
            if (string == null) break block0;
            String it = string;
            boolean bl = false;
            Bundle dataBundle = new Bundle();
            dataBundle.putString(".callbackAction", "trace");
            dataBundle.putString(".traceSeverity", "exception");
            dataBundle.putString(".errorMessage", message);
            dataBundle.putSerializable(".exception", (Serializable)e);
            this.callbackToActivity(it, Status.ERROR, dataBundle);
        }
    }

    private final void registerBroadcastReceivers() {
        if (this.networkConnectionMonitor == null) {
            this.networkConnectionMonitor = new NetworkConnectionIntentReceiver();
            this.registerReceiver(this.networkConnectionMonitor, new IntentFilter("android.net.conn.CONNECTIVITY_CHANGE"));
        }
    }

    private final void unregisterBroadcastReceivers() {
        if (this.networkConnectionMonitor != null) {
            this.unregisterReceiver(this.networkConnectionMonitor);
            this.networkConnectionMonitor = null;
        }
    }

    public final boolean isOnline(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return this.isInternetAvailable(context);
    }

    private final void notifyClientsOffline() {
        Iterable $this$forEach$iv = this.connections.values();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            MqttConnection it = (MqttConnection)element$iv;
            boolean bl = false;
            it.offline();
        }
    }

    private final boolean isInternetAvailable(Context context) {
        boolean result;
        block8: {
            ConnectivityManager connectivityManager;
            block7: {
                result = false;
                Object object = context.getSystemService("connectivity");
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type android.net.ConnectivityManager");
                connectivityManager = (ConnectivityManager)object;
                if (Build.VERSION.SDK_INT < 23) break block7;
                Network network = connectivityManager.getActiveNetwork();
                if (network == null) {
                    return false;
                }
                Network networkCapabilities = network;
                NetworkCapabilities networkCapabilities2 = connectivityManager.getNetworkCapabilities(networkCapabilities);
                if (networkCapabilities2 == null) {
                    return false;
                }
                NetworkCapabilities actNw = networkCapabilities2;
                result = actNw.hasTransport(1) ? true : (actNw.hasTransport(0) ? true : actNw.hasTransport(3));
                break block8;
            }
            ConnectivityManager $this$isInternetAvailable_u24lambda_u244 = connectivityManager;
            boolean bl = false;
            NetworkInfo networkInfo = connectivityManager.getActiveNetworkInfo();
            if (networkInfo == null) break block8;
            NetworkInfo $this$isInternetAvailable_u24lambda_u244_u24lambda_u243 = networkInfo;
            boolean bl2 = false;
            result = switch ($this$isInternetAvailable_u24lambda_u244_u24lambda_u243.getType()) {
                case 1 -> true;
                case 0 -> true;
                case 9 -> true;
                default -> false;
            };
        }
        return result;
    }

    public final void setBufferOpts(@NotNull String clientHandle, @Nullable DisconnectedBufferOptions bufferOpts) {
        Intrinsics.checkNotNullParameter((Object)clientHandle, (String)"clientHandle");
        MqttConnection client = this.getConnection(clientHandle);
        client.setBufferOpts(bufferOpts);
    }

    public final int getBufferedMessageCount(@NotNull String clientHandle) {
        Intrinsics.checkNotNullParameter((Object)clientHandle, (String)"clientHandle");
        return this.getConnection(clientHandle).getBufferedMessageCount();
    }

    @NotNull
    public final MqttMessage getBufferedMessage(@NotNull String clientHandle, int bufferIndex) {
        Intrinsics.checkNotNullParameter((Object)clientHandle, (String)"clientHandle");
        return this.getConnection(clientHandle).getBufferedMessage(bufferIndex);
    }

    public final void deleteBufferedMessage(@NotNull String clientHandle, int bufferIndex) {
        Intrinsics.checkNotNullParameter((Object)clientHandle, (String)"clientHandle");
        this.getConnection(clientHandle).deleteBufferedMessage(bufferIndex);
    }

    public final int getInFlightMessageCount(@NotNull String clientHandle) {
        Intrinsics.checkNotNullParameter((Object)clientHandle, (String)"clientHandle");
        return this.getConnection(clientHandle).getInFlightMessageCount();
    }

    private static final /* synthetic */ Object collect$suspendConversion0(Function1 $this$collect_u24suspendConversion0, Bundle p0, Continuation $completion) {
        $this$collect_u24suspendConversion0.invoke((Object)p0);
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ MutableSharedFlow access$getFlow$p(MqttService $this) {
        return $this.flow;
    }

    public static final /* synthetic */ Object access$collect$suspendConversion0(Function1 $receiver, Bundle p0, Continuation $completion) {
        return MqttService.collect$suspendConversion0($receiver, p0, $completion);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006\u00a8\u0006\t"}, d2={"Linfo/mqtt/android/service/MqttService$Companion;", "", "()V", "MQTT_FOREGROUND_SERVICE_NOTIFICATION", "", "getMQTT_FOREGROUND_SERVICE_NOTIFICATION", "()Ljava/lang/String;", "MQTT_FOREGROUND_SERVICE_NOTIFICATION_ID", "getMQTT_FOREGROUND_SERVICE_NOTIFICATION_ID", "serviceLibrary_release"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String getMQTT_FOREGROUND_SERVICE_NOTIFICATION_ID() {
            return MQTT_FOREGROUND_SERVICE_NOTIFICATION_ID;
        }

        @NotNull
        public final String getMQTT_FOREGROUND_SERVICE_NOTIFICATION() {
            return MQTT_FOREGROUND_SERVICE_NOTIFICATION;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0017\u00a8\u0006\t"}, d2={"Linfo/mqtt/android/service/MqttService$NetworkConnectionIntentReceiver;", "Landroid/content/BroadcastReceiver;", "(Linfo/mqtt/android/service/MqttService;)V", "onReceive", "", "context", "Landroid/content/Context;", "intent", "Landroid/content/Intent;", "serviceLibrary_release"})
    private final class NetworkConnectionIntentReceiver
    extends BroadcastReceiver {
        @SuppressLint(value={"Wakelock"})
        public void onReceive(@NotNull Context context, @NotNull Intent intent) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)intent, (String)"intent");
            MqttService.this.traceDebug("Internal network status receive.");
            Object object = MqttService.this.getSystemService("power");
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type android.os.PowerManager");
            PowerManager pm = (PowerManager)object;
            PowerManager.WakeLock wl = pm.newWakeLock(1, "MQTT:tag");
            wl.acquire(600000L);
            MqttService.this.traceDebug("Reconnect for Network recovery.");
            if (MqttService.this.isOnline(context)) {
                MqttService.this.traceDebug("Online,reconnect.");
                MqttService.this.reconnect(context);
            } else {
                MqttService.this.notifyClientsOffline();
            }
            wl.release();
        }
    }
}

