/*
 * Decompiled with CFR 0.152.
 */
package info.appdev.charting.formatter;

import info.appdev.charting.components.AxisBase;
import info.appdev.charting.data.Entry;
import info.appdev.charting.formatter.IAxisValueFormatter;
import info.appdev.charting.formatter.IValueFormatter;
import info.appdev.charting.utils.ViewPortHandler;
import java.text.DecimalFormat;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0016\u0018\u00002\u00020\u00012\u00020\u0002B\t\b\u0016\u00a2\u0006\u0004\b\u0003\u0010\u0004B\u0011\b\u0016\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0003\u0010\u0007J.\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0016J\u001a\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0016R\u001a\u0010\b\u001a\u00020\u0006X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\u0007R\u0011\u0010\u0018\u001a\u00020\u00138F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006\u001b"}, d2={"Linfo/appdev/charting/formatter/PercentFormatter;", "Linfo/appdev/charting/formatter/IValueFormatter;", "Linfo/appdev/charting/formatter/IAxisValueFormatter;", "<init>", "()V", "format", "Ljava/text/DecimalFormat;", "(Ljava/text/DecimalFormat;)V", "decimalFormat", "getDecimalFormat", "()Ljava/text/DecimalFormat;", "setDecimalFormat", "getFormattedValue", "", "value", "", "entry", "Linfo/appdev/charting/data/Entry;", "dataSetIndex", "", "viewPortHandler", "Linfo/appdev/charting/utils/ViewPortHandler;", "axis", "Linfo/appdev/charting/components/AxisBase;", "decimalDigits", "getDecimalDigits", "()I", "chartLib_release"})
public class PercentFormatter
implements IValueFormatter,
IAxisValueFormatter {
    @NotNull
    private DecimalFormat decimalFormat;

    @NotNull
    protected final DecimalFormat getDecimalFormat() {
        return this.decimalFormat;
    }

    protected final void setDecimalFormat(@NotNull DecimalFormat decimalFormat) {
        Intrinsics.checkNotNullParameter((Object)decimalFormat, (String)"<set-?>");
        this.decimalFormat = decimalFormat;
    }

    public PercentFormatter() {
        this.decimalFormat = new DecimalFormat("###,###,##0.0");
    }

    public PercentFormatter(@NotNull DecimalFormat format) {
        Intrinsics.checkNotNullParameter((Object)format, (String)"format");
        this.decimalFormat = format;
    }

    @Override
    @Nullable
    public String getFormattedValue(float value, @Nullable Entry entry, int dataSetIndex, @Nullable ViewPortHandler viewPortHandler) {
        return this.decimalFormat.format(value) + " %";
    }

    @Override
    @NotNull
    public String getFormattedValue(float value, @Nullable AxisBase axis) {
        return this.decimalFormat.format(value) + " %";
    }

    public final int getDecimalDigits() {
        return 1;
    }
}

