/*
 * Decompiled with CFR 0.152.
 */
package info.appdev.charting.renderer;

import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.drawable.Drawable;
import info.appdev.charting.animation.ChartAnimator;
import info.appdev.charting.data.BubbleData;
import info.appdev.charting.data.BubbleEntry;
import info.appdev.charting.data.ChartData;
import info.appdev.charting.data.Entry;
import info.appdev.charting.highlight.Highlight;
import info.appdev.charting.interfaces.dataprovider.BubbleDataProvider;
import info.appdev.charting.interfaces.datasets.IBubbleDataSet;
import info.appdev.charting.renderer.BarLineScatterCandleBubbleRenderer;
import info.appdev.charting.utils.CanvasUtilsKt;
import info.appdev.charting.utils.NumberUtilsKt;
import info.appdev.charting.utils.PaintUtilsKt;
import info.appdev.charting.utils.PointF;
import info.appdev.charting.utils.Transformer;
import info.appdev.charting.utils.ViewPortHandler;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0014\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J(\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\u00172\u0006\u0010\u001b\u001a\u00020\u001cH\u0004J\u0018\u0010\u001d\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u001e\u001a\u00020\u001fH\u0004J\u0010\u0010 \u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010!\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J#\u0010#\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010$\u001a\b\u0012\u0004\u0012\u00020&0%H\u0016\u00a2\u0006\u0002\u0010'R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Linfo/appdev/charting/renderer/BubbleChartRenderer;", "Linfo/appdev/charting/renderer/BarLineScatterCandleBubbleRenderer;", "dataProvider", "Linfo/appdev/charting/interfaces/dataprovider/BubbleDataProvider;", "animator", "Linfo/appdev/charting/animation/ChartAnimator;", "viewPortHandler", "Linfo/appdev/charting/utils/ViewPortHandler;", "<init>", "(Linfo/appdev/charting/interfaces/dataprovider/BubbleDataProvider;Linfo/appdev/charting/animation/ChartAnimator;Linfo/appdev/charting/utils/ViewPortHandler;)V", "getDataProvider", "()Linfo/appdev/charting/interfaces/dataprovider/BubbleDataProvider;", "setDataProvider", "(Linfo/appdev/charting/interfaces/dataprovider/BubbleDataProvider;)V", "initBuffers", "", "drawData", "canvas", "Landroid/graphics/Canvas;", "sizeBuffer", "", "pointBuffer", "getShapeSize", "", "entrySize", "maxSize", "reference", "normalizeSize", "", "drawDataSet", "dataSet", "Linfo/appdev/charting/interfaces/datasets/IBubbleDataSet;", "drawValues", "drawExtras", "_hsvBuffer", "drawHighlighted", "indices", "", "Linfo/appdev/charting/highlight/Highlight;", "(Landroid/graphics/Canvas;[Linfo/appdev/charting/highlight/Highlight;)V", "chartLib_release"})
@SourceDebugExtension(value={"SMAP\nBubbleChartRenderer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BubbleChartRenderer.kt\ninfo/appdev/charting/renderer/BubbleChartRenderer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,270:1\n1915#2,2:271\n*S KotlinDebug\n*F\n+ 1 BubbleChartRenderer.kt\ninfo/appdev/charting/renderer/BubbleChartRenderer\n*L\n33#1:271,2\n*E\n"})
public class BubbleChartRenderer
extends BarLineScatterCandleBubbleRenderer {
    @NotNull
    private BubbleDataProvider dataProvider;
    @NotNull
    private final float[] sizeBuffer;
    @NotNull
    private final float[] pointBuffer;
    @NotNull
    private final float[] _hsvBuffer;

    public BubbleChartRenderer(@NotNull BubbleDataProvider dataProvider, @NotNull ChartAnimator animator, @NotNull ViewPortHandler viewPortHandler) {
        Intrinsics.checkNotNullParameter((Object)dataProvider, (String)"dataProvider");
        Intrinsics.checkNotNullParameter((Object)animator, (String)"animator");
        Intrinsics.checkNotNullParameter((Object)viewPortHandler, (String)"viewPortHandler");
        super(animator, viewPortHandler);
        this.dataProvider = dataProvider;
        this.sizeBuffer = new float[4];
        this.pointBuffer = new float[2];
        this._hsvBuffer = new float[3];
        this.getPaintRender().setStyle(Paint.Style.FILL);
        this.getPaintHighlight().setStyle(Paint.Style.STROKE);
        this.getPaintHighlight().setStrokeWidth(NumberUtilsKt.convertDpToPixel(1.5f));
    }

    @NotNull
    public final BubbleDataProvider getDataProvider() {
        return this.dataProvider;
    }

    public final void setDataProvider(@NotNull BubbleDataProvider bubbleDataProvider) {
        Intrinsics.checkNotNullParameter((Object)bubbleDataProvider, (String)"<set-?>");
        this.dataProvider = bubbleDataProvider;
    }

    @Override
    public void initBuffers() {
    }

    @Override
    public void drawData(@NotNull Canvas canvas) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
            BubbleData bubbleData = this.dataProvider.getBubbleData();
            Object object = bubbleData;
            if (object == null || (object = ((ChartData)object).getDataSets()) == null) break block1;
            Iterable $this$forEach$iv = (Iterable)object;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                IBubbleDataSet set = (IBubbleDataSet)element$iv;
                boolean bl = false;
                if (!set.isVisible()) continue;
                this.drawDataSet(canvas, set);
            }
        }
    }

    protected final float getShapeSize(float entrySize, float maxSize, float reference, boolean normalizeSize) {
        float factor = normalizeSize ? (maxSize == 0.0f ? 1.0f : (float)Math.sqrt(entrySize / maxSize)) : entrySize;
        float shapeSize = reference * factor;
        return shapeSize;
    }

    protected final void drawDataSet(@NotNull Canvas canvas, @NotNull IBubbleDataSet dataSet) {
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        Intrinsics.checkNotNullParameter((Object)dataSet, (String)"dataSet");
        if (dataSet.getEntryCount() < 1) {
            return;
        }
        Transformer trans = this.dataProvider.getTransformer(dataSet.getAxisDependency());
        float phaseY = this.getAnimator().getPhaseY();
        this.getXBounds().set(this.dataProvider, dataSet);
        this.sizeBuffer[0] = 0.0f;
        this.sizeBuffer[2] = 1.0f;
        Transformer transformer = trans;
        Intrinsics.checkNotNull((Object)transformer);
        transformer.pointValuesToPixel(this.sizeBuffer);
        boolean normalizeSize = dataSet.isNormalizeSizeEnabled();
        float maxBubbleWidth = (float)Math.abs((double)(this.sizeBuffer[2] - this.sizeBuffer[0]));
        float maxBubbleHeight = (float)Math.abs((double)(this.getViewPortHandler().contentBottom() - this.getViewPortHandler().contentTop()));
        float referenceSize = (float)Math.min((double)maxBubbleHeight, (double)maxBubbleWidth);
        int j = this.getXBounds().getMin();
        int n = this.getXBounds().getRange() + this.getXBounds().getMin();
        if (j <= n) {
            while (true) {
                BubbleEntry bubbleEntry;
                if ((bubbleEntry = (BubbleEntry)dataSet.getEntryForIndex(j)) != null) {
                    BubbleEntry it;
                    boolean bl = false;
                    this.pointBuffer[0] = it.getX();
                    this.pointBuffer[1] = it.getY() * phaseY;
                    trans.pointValuesToPixel(this.pointBuffer);
                    float shapeHalf = this.getShapeSize(it.getSize(), dataSet.getMaxSize(), referenceSize, normalizeSize) / 2.0f;
                    if (this.getViewPortHandler().isInBoundsTop(this.pointBuffer[1] + shapeHalf) && this.getViewPortHandler().isInBoundsBottom(this.pointBuffer[1] - shapeHalf) && this.getViewPortHandler().isInBoundsLeft(this.pointBuffer[0] + shapeHalf)) {
                        if (!this.getViewPortHandler().isInBoundsRight(this.pointBuffer[0] - shapeHalf)) break;
                        int color = dataSet.getColorByIndex(j);
                        this.getPaintRender().setColor(color);
                        canvas.drawCircle(this.pointBuffer[0], this.pointBuffer[1], shapeHalf, this.getPaintRender());
                    }
                }
                if (j == n) break;
                ++j;
            }
        }
    }

    @Override
    public void drawValues(@NotNull Canvas canvas) {
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        BubbleData bubbleData = this.dataProvider.getBubbleData();
        if (bubbleData == null) {
            return;
        }
        BubbleData bubbleData2 = bubbleData;
        if (this.isDrawingValuesAllowed(this.dataProvider)) {
            List dataSets = bubbleData2.getDataSets();
            float lineHeight = PaintUtilsKt.calcTextHeight(this.getPaintValues(), "1");
            int n = ((Collection)dataSets).size();
            for (int i = 0; i < n; ++i) {
                Transformer transformer;
                IBubbleDataSet dataSet = (IBubbleDataSet)dataSets.get(i);
                if (dataSet.getEntryCount() == 0 || !this.shouldDrawValues(dataSet) || dataSet.getEntryCount() < 1) continue;
                this.applyValueTextStyle(dataSet);
                float phaseX = (float)Math.max(0.0, Math.min(1.0, (double)this.getAnimator().getPhaseX()));
                float phaseY = this.getAnimator().getPhaseY();
                this.getXBounds().set(this.dataProvider, dataSet);
                if (this.dataProvider.getTransformer(dataSet.getAxisDependency()) == null) continue;
                boolean bl = false;
                float[] positions = transformer.generateTransformedValuesBubble(dataSet, phaseY, this.getXBounds().getMin(), this.getXBounds().getMax());
                float alpha = phaseX == 1.0f ? phaseY : phaseX;
                PointF iconsOffset = PointF.Companion.getInstance(dataSet.getIconsOffset());
                iconsOffset.setX(NumberUtilsKt.convertDpToPixel(iconsOffset.getX()));
                iconsOffset.setY(NumberUtilsKt.convertDpToPixel(iconsOffset.getY()));
                int j = 0;
                while (j < positions.length) {
                    int valueTextColor = 0;
                    valueTextColor = dataSet.getValueTextColor(j / 2 + this.getXBounds().getMin());
                    valueTextColor = Color.argb((int)MathKt.roundToInt((float)(255.0f * alpha)), (int)Color.red((int)valueTextColor), (int)Color.green((int)valueTextColor), (int)Color.blue((int)valueTextColor));
                    float x = positions[j];
                    float y = positions[j + 1];
                    if (!this.getViewPortHandler().isInBoundsRight(x)) break;
                    if (!this.getViewPortHandler().isInBoundsLeft(x) || !this.getViewPortHandler().isInBoundsY(y)) {
                        j += 2;
                        continue;
                    }
                    BubbleEntry bubbleEntry = (BubbleEntry)dataSet.getEntryForIndex(j / 2 + this.getXBounds().getMin());
                    if (bubbleEntry != null) {
                        boolean bl2 = false;
                        if (dataSet.isDrawValues()) {
                            this.drawValue(canvas, dataSet.getValueFormatter(), bubbleEntry.getSize(), bubbleEntry, i, x, y + 0.5f * lineHeight, valueTextColor);
                        }
                        if (bubbleEntry.getIcon() != null && dataSet.isDrawIcons()) {
                            Drawable icon = bubbleEntry.getIcon();
                            if (icon != null) {
                                Drawable ico;
                                boolean bl3 = false;
                                CanvasUtilsKt.drawImage(canvas, ico, (int)(x + iconsOffset.getX()), (int)(y + iconsOffset.getY()));
                            }
                        }
                    }
                    j += 2;
                }
                PointF.Companion.recycleInstance(iconsOffset);
            }
        }
    }

    @Override
    public void drawExtras(@NotNull Canvas canvas) {
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
    }

    @Override
    public void drawHighlighted(@NotNull Canvas canvas, @NotNull Highlight[] indices) {
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        Intrinsics.checkNotNullParameter((Object)indices, (String)"indices");
        BubbleData bubbleData = this.dataProvider.getBubbleData();
        float phaseY = this.getAnimator().getPhaseY();
        for (Highlight high : indices) {
            IBubbleDataSet set;
            BubbleData bubbleData2 = bubbleData;
            IBubbleDataSet iBubbleDataSet = set = bubbleData2 != null ? (IBubbleDataSet)bubbleData2.getDataSetByIndex(high.getDataSetIndex()) : null;
            if (set == null || !set.isHighlight()) continue;
            Object t = set.getEntryForXValue(high.getX(), high.getY());
            Intrinsics.checkNotNull(t);
            BubbleEntry bubbleEntry = (BubbleEntry)t;
            if (!(bubbleEntry.getY() == high.getY()) || !this.isInBoundsX((Entry)bubbleEntry, set)) continue;
            Transformer trans = this.dataProvider.getTransformer(set.getAxisDependency());
            this.sizeBuffer[0] = 0.0f;
            this.sizeBuffer[2] = 1.0f;
            Transformer transformer = trans;
            Intrinsics.checkNotNull((Object)transformer);
            transformer.pointValuesToPixel(this.sizeBuffer);
            boolean normalizeSize = set.isNormalizeSizeEnabled();
            float maxBubbleWidth = (float)Math.abs((double)(this.sizeBuffer[2] - this.sizeBuffer[0]));
            float maxBubbleHeight = (float)Math.abs((double)(this.getViewPortHandler().contentBottom() - this.getViewPortHandler().contentTop()));
            float referenceSize = (float)Math.min((double)maxBubbleHeight, (double)maxBubbleWidth);
            this.pointBuffer[0] = bubbleEntry.getX();
            this.pointBuffer[1] = bubbleEntry.getY() * phaseY;
            trans.pointValuesToPixel(this.pointBuffer);
            high.setDraw(this.pointBuffer[0], this.pointBuffer[1]);
            float shapeHalf = this.getShapeSize(bubbleEntry.getSize(), set.getMaxSize(), referenceSize, normalizeSize) / 2.0f;
            if (!this.getViewPortHandler().isInBoundsTop(this.pointBuffer[1] + shapeHalf) || !this.getViewPortHandler().isInBoundsBottom(this.pointBuffer[1] - shapeHalf) || !this.getViewPortHandler().isInBoundsLeft(this.pointBuffer[0] + shapeHalf)) continue;
            if (!this.getViewPortHandler().isInBoundsRight(this.pointBuffer[0] - shapeHalf)) break;
            int originalColor = set.getColorByIndex((int)bubbleEntry.getX());
            Color.RGBToHSV((int)Color.red((int)originalColor), (int)Color.green((int)originalColor), (int)Color.blue((int)originalColor), (float[])this._hsvBuffer);
            float[] fArray = this._hsvBuffer;
            fArray[2] = fArray[2] * 0.5f;
            int color = Color.HSVToColor((int)Color.alpha((int)originalColor), (float[])this._hsvBuffer);
            this.getPaintHighlight().setColor(color);
            this.getPaintHighlight().setStrokeWidth(set.getHighlightCircleWidth());
            canvas.drawCircle(this.pointBuffer[0], this.pointBuffer[1], shapeHalf, this.getPaintHighlight());
        }
    }
}

