/*
 * Decompiled with CFR 0.152.
 */
package info.appdev.charting.listener;

import android.annotation.SuppressLint;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.View;
import android.view.animation.AnimationUtils;
import info.appdev.charting.charts.Chart;
import info.appdev.charting.charts.PieRadarChartBase;
import info.appdev.charting.highlight.Highlight;
import info.appdev.charting.listener.ChartTouchListener;
import info.appdev.charting.listener.OnChartGestureListener;
import info.appdev.charting.utils.NumberUtilsKt;
import info.appdev.charting.utils.PointF;
import java.util.ArrayList;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0012\u0018\u00002\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00020\u0001:\u0001)B\u0013\u0012\n\u0010\u0003\u001a\u0006\u0012\u0002\b\u00030\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001a\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0017J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0016H\u0016J\u0010\u0010\u001a\u001a\u00020\u00122\u0006\u0010\u001b\u001a\u00020\u0016H\u0016J\u0010\u0010\u001c\u001a\u00020\u00122\u0006\u0010\u001d\u001a\u00020\u0016H\u0016J\b\u0010\u001e\u001a\u00020\u0018H\u0002J\u0018\u0010\u001f\u001a\u00020\u00182\u0006\u0010 \u001a\u00020\t2\u0006\u0010!\u001a\u00020\tH\u0002J\b\u0010\"\u001a\u00020\tH\u0002J\u0016\u0010#\u001a\u00020\u00182\u0006\u0010$\u001a\u00020\t2\u0006\u0010%\u001a\u00020\tJ\u0016\u0010&\u001a\u00020\u00182\u0006\u0010$\u001a\u00020\t2\u0006\u0010%\u001a\u00020\tJ\u0006\u0010'\u001a\u00020\u0018J\u0006\u0010(\u001a\u00020\u0018R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\n\u001a\u0012\u0012\u0004\u0012\u00020\f0\u000bj\b\u0012\u0004\u0012\u00020\f`\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Linfo/appdev/charting/listener/PieRadarChartTouchListener;", "Linfo/appdev/charting/listener/ChartTouchListener;", "Linfo/appdev/charting/charts/PieRadarChartBase;", "chart", "<init>", "(Linfo/appdev/charting/charts/PieRadarChartBase;)V", "touchStartPoint", "Linfo/appdev/charting/utils/PointF;", "startAngle", "", "velocitySamples", "Ljava/util/ArrayList;", "Linfo/appdev/charting/listener/PieRadarChartTouchListener$AngularVelocitySample;", "Lkotlin/collections/ArrayList;", "decelerationLastTime", "", "decelerationAngularVelocity", "onTouch", "", "v", "Landroid/view/View;", "event", "Landroid/view/MotionEvent;", "onLongPress", "", "me", "onSingleTapConfirmed", "motionEvent", "onSingleTapUp", "e", "resetVelocity", "sampleVelocity", "touchLocationX", "touchLocationY", "calculateVelocity", "setGestureStartAngle", "x", "y", "updateGestureRotation", "stopDeceleration", "computeScroll", "AngularVelocitySample", "chartLib_release"})
public final class PieRadarChartTouchListener
extends ChartTouchListener<PieRadarChartBase<?>> {
    @NotNull
    private final PointF touchStartPoint;
    private float startAngle;
    @NotNull
    private final ArrayList<AngularVelocitySample> velocitySamples;
    private long decelerationLastTime;
    private float decelerationAngularVelocity;

    public PieRadarChartTouchListener(@NotNull PieRadarChartBase<?> chart) {
        Intrinsics.checkNotNullParameter(chart, (String)"chart");
        super((Chart)chart);
        this.touchStartPoint = PointF.Companion.getInstance(0.0f, 0.0f);
        this.velocitySamples = new ArrayList();
    }

    @SuppressLint(value={"ClickableViewAccessibility"})
    public boolean onTouch(@Nullable View v, @NotNull MotionEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        GestureDetector gestureDetector = this.getGestureDetector();
        Intrinsics.checkNotNull((Object)gestureDetector);
        if (gestureDetector.onTouchEvent(event)) {
            return true;
        }
        if (((PieRadarChartBase)this.getChart()).isRotationEnabled()) {
            float x = event.getX();
            float y = event.getY();
            switch (event.getAction()) {
                case 0: {
                    this.startAction(event);
                    this.stopDeceleration();
                    this.resetVelocity();
                    if (((PieRadarChartBase)this.getChart()).isDragDeceleration()) {
                        this.sampleVelocity(x, y);
                    }
                    this.setGestureStartAngle(x, y);
                    this.touchStartPoint.setX(x);
                    this.touchStartPoint.setY(y);
                    break;
                }
                case 2: {
                    if (((PieRadarChartBase)this.getChart()).isDragDeceleration()) {
                        this.sampleVelocity(x, y);
                    }
                    if (this.getTouchMode() == 0 && ChartTouchListener.Companion.distance(x, this.touchStartPoint.getX(), y, this.touchStartPoint.getY()) > NumberUtilsKt.convertDpToPixel(8.0f)) {
                        this.setLastGesture(ChartTouchListener.ChartGesture.ROTATE);
                        this.setTouchMode(6);
                        ((PieRadarChartBase)this.getChart()).disableScroll();
                    } else if (this.getTouchMode() == 6) {
                        this.updateGestureRotation(x, y);
                        ((PieRadarChartBase)this.getChart()).invalidate();
                    }
                    this.endAction(event);
                    break;
                }
                case 1: {
                    if (((PieRadarChartBase)this.getChart()).isDragDeceleration()) {
                        this.stopDeceleration();
                        this.sampleVelocity(x, y);
                        this.decelerationAngularVelocity = this.calculateVelocity();
                        if (!(this.decelerationAngularVelocity == 0.0f)) {
                            this.decelerationLastTime = AnimationUtils.currentAnimationTimeMillis();
                            ((PieRadarChartBase)this.getChart()).postInvalidateOnAnimation();
                        }
                    }
                    ((PieRadarChartBase)this.getChart()).enableScroll();
                    this.setTouchMode(0);
                    this.endAction(event);
                }
            }
        }
        return true;
    }

    public void onLongPress(@NotNull MotionEvent me) {
        block0: {
            OnChartGestureListener onChartGestureListener;
            Intrinsics.checkNotNullParameter((Object)me, (String)"me");
            this.setLastGesture(ChartTouchListener.ChartGesture.LONG_PRESS);
            OnChartGestureListener onChartGestureListener2 = onChartGestureListener = ((PieRadarChartBase)this.getChart()).getOnChartGestureListener();
            if (onChartGestureListener2 == null) break block0;
            onChartGestureListener2.onChartLongPressed(me);
        }
    }

    public boolean onSingleTapConfirmed(@NotNull MotionEvent motionEvent) {
        Intrinsics.checkNotNullParameter((Object)motionEvent, (String)"motionEvent");
        return true;
    }

    public boolean onSingleTapUp(@NotNull MotionEvent e) {
        OnChartGestureListener onChartGestureListener;
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        this.setLastGesture(ChartTouchListener.ChartGesture.SINGLE_TAP);
        OnChartGestureListener onChartGestureListener2 = onChartGestureListener = ((PieRadarChartBase)this.getChart()).getOnChartGestureListener();
        if (onChartGestureListener2 != null) {
            onChartGestureListener2.onChartSingleTapped(e);
        }
        if (!((PieRadarChartBase)this.getChart()).isHighlightPerTap()) {
            return false;
        }
        Highlight high = ((PieRadarChartBase)this.getChart()).getHighlightByTouchPoint(e.getX(), e.getY());
        this.performHighlight(high);
        return true;
    }

    private final void resetVelocity() {
        this.velocitySamples.clear();
    }

    private final void sampleVelocity(float touchLocationX, float touchLocationY) {
        long currentTime = AnimationUtils.currentAnimationTimeMillis();
        this.velocitySamples.add(new AngularVelocitySample(currentTime, ((PieRadarChartBase)this.getChart()).getAngleForPoint(touchLocationX, touchLocationY)));
        int count = this.velocitySamples.size();
        for (int i = 0; i < count - 2 && currentTime - this.velocitySamples.get(i).getTime() > 1000L; ++i) {
            this.velocitySamples.remove(0);
            --i;
            --count;
        }
    }

    private final float calculateVelocity() {
        boolean clockwise;
        float timeDelta;
        if (this.velocitySamples.isEmpty()) {
            return 0.0f;
        }
        AngularVelocitySample angularVelocitySample = this.velocitySamples.get(0);
        Intrinsics.checkNotNullExpressionValue((Object)angularVelocitySample, (String)"get(...)");
        AngularVelocitySample firstSample = angularVelocitySample;
        AngularVelocitySample angularVelocitySample2 = this.velocitySamples.get(this.velocitySamples.size() - 1);
        Intrinsics.checkNotNullExpressionValue((Object)angularVelocitySample2, (String)"get(...)");
        AngularVelocitySample lastSample = angularVelocitySample2;
        AngularVelocitySample beforeLastSample = firstSample;
        int n = ((Collection)this.velocitySamples).size() + -1;
        if (0 <= n) {
            do {
                int i = n--;
                Intrinsics.checkNotNullExpressionValue((Object)this.velocitySamples.get(i), (String)"get(...)");
            } while (beforeLastSample.getAngle() == lastSample.getAngle() && 0 <= n);
        }
        if ((timeDelta = (float)(lastSample.getTime() - firstSample.getTime()) / 1000.0f) == 0.0f) {
            timeDelta = 0.1f;
        }
        boolean bl = clockwise = lastSample.getAngle() >= beforeLastSample.getAngle();
        if ((double)Math.abs(lastSample.getAngle() - beforeLastSample.getAngle()) > 270.0) {
            boolean bl2 = clockwise = !clockwise;
        }
        if ((double)(lastSample.getAngle() - firstSample.getAngle()) > 180.0) {
            firstSample.setAngle(firstSample.getAngle() + 360.0f);
        } else if ((double)(firstSample.getAngle() - lastSample.getAngle()) > 180.0) {
            lastSample.setAngle(lastSample.getAngle() + 360.0f);
        }
        float velocity = Math.abs((lastSample.getAngle() - firstSample.getAngle()) / timeDelta);
        if (!clockwise) {
            velocity = -velocity;
        }
        return velocity;
    }

    public final void setGestureStartAngle(float x, float y) {
        this.startAngle = ((PieRadarChartBase)this.getChart()).getAngleForPoint(x, y) - ((PieRadarChartBase)this.getChart()).getRawRotationAngle();
    }

    public final void updateGestureRotation(float x, float y) {
        ((PieRadarChartBase)this.getChart()).setRotationAngle(((PieRadarChartBase)this.getChart()).getAngleForPoint(x, y) - this.startAngle);
    }

    public final void stopDeceleration() {
        this.decelerationAngularVelocity = 0.0f;
    }

    public final void computeScroll() {
        if (this.decelerationAngularVelocity == 0.0f) {
            return;
        }
        long currentTime = AnimationUtils.currentAnimationTimeMillis();
        this.decelerationAngularVelocity *= ((PieRadarChartBase)this.getChart()).getDragDecelerationFrictionCoef();
        float timeInterval = (float)(currentTime - this.decelerationLastTime) / 1000.0f;
        PieRadarChartBase pieRadarChartBase = (PieRadarChartBase)this.getChart();
        pieRadarChartBase.setRotationAngle(pieRadarChartBase.getRotationAngle() + this.decelerationAngularVelocity * timeInterval);
        this.decelerationLastTime = currentTime;
        if ((double)Math.abs(this.decelerationAngularVelocity) >= 0.001) {
            ((PieRadarChartBase)this.getChart()).postInvalidateOnAnimation();
        } else {
            this.stopDeceleration();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u000b\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0010"}, d2={"Linfo/appdev/charting/listener/PieRadarChartTouchListener$AngularVelocitySample;", "", "time", "", "angle", "", "<init>", "(JF)V", "getTime", "()J", "setTime", "(J)V", "getAngle", "()F", "setAngle", "(F)V", "chartLib_release"})
    private static final class AngularVelocitySample {
        private long time;
        private float angle;

        public AngularVelocitySample(long time, float angle) {
            this.time = time;
            this.angle = angle;
        }

        public final long getTime() {
            return this.time;
        }

        public final void setTime(long l) {
            this.time = l;
        }

        public final float getAngle() {
            return this.angle;
        }

        public final void setAngle(float f) {
            this.angle = f;
        }
    }
}

