/*
 * Decompiled with CFR 0.152.
 */
package info.appdev.charting.highlight;

import info.appdev.charting.charts.PieRadarChartBase;
import info.appdev.charting.charts.RadarChart;
import info.appdev.charting.data.Entry;
import info.appdev.charting.data.RadarData;
import info.appdev.charting.data.RadarEntry;
import info.appdev.charting.highlight.Highlight;
import info.appdev.charting.highlight.PieRadarHighlighter;
import info.appdev.charting.interfaces.datasets.IRadarDataSet;
import info.appdev.charting.utils.PointF;
import info.appdev.charting.utils.PointFKt;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010!\n\u0000\b\u0016\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\"\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bH\u0014J\u0016\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00070\u000e2\u0006\u0010\b\u001a\u00020\tH\u0004\u00a8\u0006\u000f"}, d2={"Linfo/appdev/charting/highlight/RadarHighlighter;", "Linfo/appdev/charting/highlight/PieRadarHighlighter;", "Linfo/appdev/charting/charts/RadarChart;", "chart", "<init>", "(Linfo/appdev/charting/charts/RadarChart;)V", "getClosestHighlight", "Linfo/appdev/charting/highlight/Highlight;", "index", "", "x", "", "y", "getHighlightsAtIndex", "", "chartLib_release"})
public class RadarHighlighter
extends PieRadarHighlighter<RadarChart> {
    public RadarHighlighter(@NotNull RadarChart chart) {
        Intrinsics.checkNotNullParameter((Object)chart, (String)"chart");
        super((PieRadarChartBase)chart);
    }

    @Override
    @Nullable
    protected Highlight getClosestHighlight(int index, float x, float y) {
        List<Highlight> highlights = this.getHighlightsAtIndex(index);
        float distanceToCenter = ((RadarChart)this.getChartPieRadar()).distanceToCenter(x, y) / ((RadarChart)this.getChartPieRadar()).getFactor();
        Highlight closest = null;
        float distance = Float.MAX_VALUE;
        int n = ((Collection)highlights).size();
        for (int i = 0; i < n; ++i) {
            Highlight high = highlights.get(i);
            float cDistance = Math.abs(high.getY() - distanceToCenter);
            if (!(cDistance < distance)) continue;
            closest = high;
            distance = cDistance;
        }
        return closest;
    }

    @NotNull
    protected final List<Highlight> getHighlightsAtIndex(int index) {
        block1: {
            this.getHighlightBuffer().clear();
            float phaseX = ((RadarChart)this.getChartPieRadar()).getAnimator().getPhaseX();
            float phaseY = ((RadarChart)this.getChartPieRadar()).getAnimator().getPhaseY();
            float sliceAngle = ((RadarChart)this.getChartPieRadar()).getSliceAngle();
            float factor = ((RadarChart)this.getChartPieRadar()).getFactor();
            PointF pOut = PointF.Companion.getInstance(0.0f, 0.0f);
            RadarData radarData = (RadarData)((RadarChart)this.getChartPieRadar()).getData();
            if (radarData == null) break block1;
            RadarData data = radarData;
            boolean bl = false;
            int n = data.getDataSetCount();
            for (int i = 0; i < n; ++i) {
                Entry entry;
                IRadarDataSet dataSet;
                IRadarDataSet iRadarDataSet = dataSet = (IRadarDataSet)data.getDataSetByIndex(i);
                Entry entry2 = entry = (Entry)(iRadarDataSet != null ? (RadarEntry)iRadarDataSet.getEntryForIndex(index) : null);
                Intrinsics.checkNotNull((Object)entry2);
                float y = entry2.getY() - ((RadarChart)this.getChartPieRadar()).getYChartMin();
                PointFKt.changePosition(((RadarChart)this.getChartPieRadar()).getCenterOffsets(), y * factor * phaseY, sliceAngle * (float)index * phaseX + ((RadarChart)this.getChartPieRadar()).getRotationAngle(), pOut);
                this.getHighlightBuffer().add(new Highlight(index, entry.getY(), pOut.getX(), pOut.getY(), i, dataSet.getAxisDependency()));
            }
        }
        return this.getHighlightBuffer();
    }
}

