/*
 * Decompiled with CFR 0.152.
 */
package info.appdev.charting.data;

import android.graphics.Typeface;
import info.appdev.charting.components.YAxis;
import info.appdev.charting.data.Entry;
import info.appdev.charting.formatter.IValueFormatter;
import info.appdev.charting.highlight.Highlight;
import info.appdev.charting.interfaces.datasets.IDataSet;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import timber.log.Timber;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u001e\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0013\n\u0002\u0010\u0015\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0010\b&\u0018\u0000*\u0010\b\u0000\u0010\u0001*\n\u0012\u0006\b\u0001\u0012\u00020\u00030\u00022\u00020\u0004B\t\b\u0016\u00a2\u0006\u0004\b\u0005\u0010\u0006B\u001d\b\u0016\u0012\u0012\u0010\u0007\u001a\n\u0012\u0006\b\u0001\u0012\u00028\u00000\b\"\u00028\u0000\u00a2\u0006\u0004\b\u0005\u0010\tB\u0017\b\u0016\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00028\u00000\u000b\u00a2\u0006\u0004\b\u0005\u0010\fJ\b\u0010,\u001a\u00020-H\u0016J\u0016\u0010.\u001a\u00020-2\u0006\u0010/\u001a\u00020\u000e2\u0006\u00100\u001a\u00020\u000eJ\b\u00101\u001a\u00020-H\u0016J\u0010\u0010\u0015\u001a\u00020\u000e2\b\u00106\u001a\u0004\u0018\u000107J\u0010\u0010\u0010\u001a\u00020\u000e2\b\u00106\u001a\u0004\u0018\u000107J&\u00108\u001a\u0002032\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00000\u000b2\u0006\u00109\u001a\u00020:2\u0006\u0010;\u001a\u00020<H\u0004J\u0012\u0010@\u001a\u0004\u0018\u00010\u00032\u0006\u0010A\u001a\u00020BH\u0016J\u001f\u0010C\u001a\u0004\u0018\u00018\u00002\u0006\u00109\u001a\u00020:2\u0006\u0010;\u001a\u00020<H\u0016\u00a2\u0006\u0002\u0010DJ\u0017\u0010E\u001a\u0004\u0018\u00018\u00002\u0006\u0010F\u001a\u000203H\u0016\u00a2\u0006\u0002\u0010GJ\u0015\u0010H\u001a\u00020-2\b\u0010I\u001a\u0004\u0018\u00018\u0000\u00a2\u0006\u0002\u0010JJ\u0017\u0010K\u001a\u00020<2\b\u0010I\u001a\u0004\u0018\u00018\u0000H\u0016\u00a2\u0006\u0002\u0010LJ\u0010\u0010K\u001a\u00020<2\u0006\u0010F\u001a\u000203H\u0016J\u0016\u0010M\u001a\u00020-2\u0006\u0010N\u001a\u00020\u00032\u0006\u0010O\u001a\u000203J\u001a\u00101\u001a\u00020-2\u0006\u0010P\u001a\u00020\u00032\b\u00106\u001a\u0004\u0018\u000107H\u0004J\u0017\u00101\u001a\u00020-2\b\u0010I\u001a\u0004\u0018\u00018\u0000H\u0004\u00a2\u0006\u0002\u0010JJ\u0018\u0010Q\u001a\u00020<2\u0006\u0010N\u001a\u00020\u00032\u0006\u0010O\u001a\u000203H\u0016J\u0018\u0010Q\u001a\u00020<2\u0006\u0010R\u001a\u00020\u000e2\u0006\u0010O\u001a\u000203H\u0016J\u0015\u0010S\u001a\u0004\u0018\u00018\u00002\u0006\u0010P\u001a\u00020\u0003\u00a2\u0006\u0002\u0010TJ\u0015\u0010Y\u001a\u0002032\b\u0010Z\u001a\u0004\u0018\u00018\u0000\u00a2\u0006\u0002\u0010[J\u001d\u0010\\\u001a\u0004\u0018\u00018\u00002\f\u0010\n\u001a\b\u0012\u0004\u0012\u00028\u00000\u000bH\u0004\u00a2\u0006\u0002\u0010]J\u001b\u0010^\u001a\u0004\u0018\u00018\u00002\f\u0010\n\u001a\b\u0012\u0004\u0012\u00028\u00000\u000b\u00a2\u0006\u0002\u0010]J\u000e\u0010_\u001a\u00020-2\u0006\u0010`\u001a\u00020aJ\u000e\u0010b\u001a\u00020-2\u0006\u0010c\u001a\u000203J\u0014\u0010d\u001a\u00020-2\f\u0010U\u001a\b\u0012\u0004\u0012\u0002030\u000bJ\u0010\u0010e\u001a\u00020-2\b\u0010f\u001a\u0004\u0018\u00010gJ\u000e\u0010h\u001a\u00020-2\u0006\u0010i\u001a\u00020\u000eJ\u000e\u0010j\u001a\u00020-2\u0006\u0010k\u001a\u00020<J\u0006\u0010p\u001a\u00020-J\u0015\u0010q\u001a\u00020<2\b\u0010Z\u001a\u0004\u0018\u00018\u0000\u00a2\u0006\u0002\u0010LR$\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\r\u001a\u00020\u000e@DX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R$\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\r\u001a\u00020\u000e@DX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0011\"\u0004\b\u0016\u0010\u0013R$\u0010\u0017\u001a\u00020\u000e2\u0006\u0010\r\u001a\u00020\u000e@DX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0011\"\u0004\b\u0019\u0010\u0013R$\u0010\u001a\u001a\u00020\u000e2\u0006\u0010\r\u001a\u00020\u000e@DX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u0011\"\u0004\b\u001c\u0010\u0013R\u001a\u0010\u001d\u001a\u00020\u000eX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u0011\"\u0004\b\u001f\u0010\u0013R\u001a\u0010 \u001a\u00020\u000eX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\u0011\"\u0004\b\"\u0010\u0013R\u001a\u0010#\u001a\u00020\u000eX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b$\u0010\u0011\"\u0004\b%\u0010\u0013R\u001a\u0010&\u001a\u00020\u000eX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b'\u0010\u0011\"\u0004\b(\u0010\u0013R0\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00000\u000b2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00028\u00000\u000b@TX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b)\u0010*\"\u0004\b+\u0010\fR\u0011\u00102\u001a\u0002038F\u00a2\u0006\u0006\u001a\u0004\b4\u00105R\u0019\u0010=\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010:0\b8F\u00a2\u0006\u0006\u001a\u0004\b>\u0010?R\u0011\u0010U\u001a\u00020V8F\u00a2\u0006\u0006\u001a\u0004\bW\u0010XR$\u0010l\u001a\u00020<2\u0006\u0010\r\u001a\u00020<8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\bl\u0010m\"\u0004\bn\u0010oR\u0011\u0010r\u001a\u0002038F\u00a2\u0006\u0006\u001a\u0004\bs\u00105R\u0013\u0010t\u001a\u0004\u0018\u00018\u00008F\u00a2\u0006\u0006\u001a\u0004\bu\u0010v\u00a8\u0006w"}, d2={"Linfo/appdev/charting/data/ChartData;", "T", "Linfo/appdev/charting/interfaces/datasets/IDataSet;", "Linfo/appdev/charting/data/Entry;", "Ljava/io/Serializable;", "<init>", "()V", "dataSets", "", "([Linfo/appdev/charting/interfaces/datasets/IDataSet;)V", "sets", "", "(Ljava/util/List;)V", "value", "", "yMax", "getYMax", "()F", "setYMax", "(F)V", "yMin", "getYMin", "setYMin", "xMax", "getXMax", "setXMax", "xMin", "getXMin", "setXMin", "mLeftAxisMax", "getMLeftAxisMax", "setMLeftAxisMax", "mLeftAxisMin", "getMLeftAxisMin", "setMLeftAxisMin", "mRightAxisMax", "getMRightAxisMax", "setMRightAxisMax", "mRightAxisMin", "getMRightAxisMin", "setMRightAxisMin", "getDataSets", "()Ljava/util/List;", "setDataSets", "notifyDataChanged", "", "calcMinMaxY", "fromX", "toX", "calcMinMax", "dataSetCount", "", "getDataSetCount", "()I", "axis", "Linfo/appdev/charting/components/YAxis$AxisDependency;", "getDataSetIndexByLabel", "label", "", "ignoreCase", "", "dataSetLabels", "getDataSetLabels", "()[Ljava/lang/String;", "getEntryForHighlight", "highlight", "Linfo/appdev/charting/highlight/Highlight;", "getDataSetByLabel", "(Ljava/lang/String;Z)Linfo/appdev/charting/interfaces/datasets/IDataSet;", "getDataSetByIndex", "index", "(I)Linfo/appdev/charting/interfaces/datasets/IDataSet;", "addDataSet", "d", "(Linfo/appdev/charting/interfaces/datasets/IDataSet;)V", "removeDataSet", "(Linfo/appdev/charting/interfaces/datasets/IDataSet;)Z", "addEntry", "entry", "dataSetIndex", "e", "removeEntry", "xValue", "getDataSetForEntry", "(Linfo/appdev/charting/data/Entry;)Linfo/appdev/charting/interfaces/datasets/IDataSet;", "colors", "", "getColors", "()[I", "getIndexOfDataSet", "dataSet", "(Linfo/appdev/charting/interfaces/datasets/IDataSet;)I", "getFirstLeft", "(Ljava/util/List;)Linfo/appdev/charting/interfaces/datasets/IDataSet;", "getFirstRight", "setValueFormatter", "f", "Linfo/appdev/charting/formatter/IValueFormatter;", "setValueTextColor", "color", "setValueTextColors", "setValueTypeface", "tf", "Landroid/graphics/Typeface;", "setValueTextSize", "size", "setDrawValues", "enabled", "isHighlight", "()Z", "setHighlight", "(Z)V", "clearValues", "contains", "entryCount", "getEntryCount", "maxEntryCountSet", "getMaxEntryCountSet", "()Linfo/appdev/charting/interfaces/datasets/IDataSet;", "chartLib_release"})
public abstract class ChartData<T extends IDataSet<? extends Entry>>
implements Serializable {
    private float yMax;
    private float yMin;
    private float xMax;
    private float xMin;
    private float mLeftAxisMax;
    private float mLeftAxisMin;
    private float mRightAxisMax;
    private float mRightAxisMin;
    @NotNull
    private List<T> dataSets;

    public final float getYMax() {
        return this.yMax;
    }

    protected final void setYMax(float f) {
        this.yMax = f;
    }

    public final float getYMin() {
        return this.yMin;
    }

    protected final void setYMin(float f) {
        this.yMin = f;
    }

    public final float getXMax() {
        return this.xMax;
    }

    protected final void setXMax(float f) {
        this.xMax = f;
    }

    public final float getXMin() {
        return this.xMin;
    }

    protected final void setXMin(float f) {
        this.xMin = f;
    }

    protected final float getMLeftAxisMax() {
        return this.mLeftAxisMax;
    }

    protected final void setMLeftAxisMax(float f) {
        this.mLeftAxisMax = f;
    }

    protected final float getMLeftAxisMin() {
        return this.mLeftAxisMin;
    }

    protected final void setMLeftAxisMin(float f) {
        this.mLeftAxisMin = f;
    }

    protected final float getMRightAxisMax() {
        return this.mRightAxisMax;
    }

    protected final void setMRightAxisMax(float f) {
        this.mRightAxisMax = f;
    }

    protected final float getMRightAxisMin() {
        return this.mRightAxisMin;
    }

    protected final void setMRightAxisMin(float f) {
        this.mRightAxisMin = f;
    }

    @NotNull
    public List<T> getDataSets() {
        return this.dataSets;
    }

    protected void setDataSets(@NotNull List<T> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.dataSets = list;
    }

    public ChartData() {
        this.yMax = -3.4028235E38f;
        this.yMin = Float.MAX_VALUE;
        this.xMax = -3.4028235E38f;
        this.xMin = Float.MAX_VALUE;
        this.mLeftAxisMax = -3.4028235E38f;
        this.mLeftAxisMin = Float.MAX_VALUE;
        this.mRightAxisMax = -3.4028235E38f;
        this.mRightAxisMin = Float.MAX_VALUE;
        this.dataSets = new ArrayList();
        this.setDataSets(new ArrayList());
    }

    public ChartData(T ... dataSets) {
        Intrinsics.checkNotNullParameter(dataSets, (String)"dataSets");
        this.yMax = -3.4028235E38f;
        this.yMin = Float.MAX_VALUE;
        this.xMax = -3.4028235E38f;
        this.xMin = Float.MAX_VALUE;
        this.mLeftAxisMax = -3.4028235E38f;
        this.mLeftAxisMin = Float.MAX_VALUE;
        this.mRightAxisMax = -3.4028235E38f;
        this.mRightAxisMin = Float.MAX_VALUE;
        this.dataSets = new ArrayList();
        this.setDataSets(ArraysKt.toMutableList((Object[])dataSets));
        this.notifyDataChanged();
    }

    public ChartData(@NotNull List<T> sets) {
        Intrinsics.checkNotNullParameter(sets, (String)"sets");
        this.yMax = -3.4028235E38f;
        this.yMin = Float.MAX_VALUE;
        this.xMax = -3.4028235E38f;
        this.xMin = Float.MAX_VALUE;
        this.mLeftAxisMax = -3.4028235E38f;
        this.mLeftAxisMin = Float.MAX_VALUE;
        this.mRightAxisMax = -3.4028235E38f;
        this.mRightAxisMin = Float.MAX_VALUE;
        this.dataSets = new ArrayList();
        this.setDataSets(sets);
        this.notifyDataChanged();
    }

    public void notifyDataChanged() {
        this.calcMinMax();
    }

    public final void calcMinMaxY(float fromX, float toX) {
        for (IDataSet set : this.getDataSets()) {
            set.calcMinMaxY(fromX, toX);
        }
        this.calcMinMax();
    }

    public void calcMinMax() {
        T firstRight;
        this.yMax = -3.4028235E38f;
        this.yMin = Float.MAX_VALUE;
        this.xMax = -3.4028235E38f;
        this.xMin = Float.MAX_VALUE;
        for (Object set : this.getDataSets()) {
            this.calcMinMax(set);
        }
        this.mLeftAxisMax = -3.4028235E38f;
        this.mLeftAxisMin = Float.MAX_VALUE;
        this.mRightAxisMax = -3.4028235E38f;
        this.mRightAxisMin = Float.MAX_VALUE;
        T firstLeft = this.getFirstLeft(this.getDataSets());
        if (firstLeft != null) {
            this.mLeftAxisMax = firstLeft.getYMax();
            this.mLeftAxisMin = firstLeft.getYMin();
            for (IDataSet dataSet : this.getDataSets()) {
                if (dataSet.getAxisDependency() != YAxis.AxisDependency.LEFT) continue;
                if (dataSet.getYMin() < this.mLeftAxisMin) {
                    this.mLeftAxisMin = dataSet.getYMin();
                }
                if (!(dataSet.getYMax() > this.mLeftAxisMax)) continue;
                this.mLeftAxisMax = dataSet.getYMax();
            }
        }
        if ((firstRight = this.getFirstRight(this.getDataSets())) != null) {
            this.mRightAxisMax = firstRight.getYMax();
            this.mRightAxisMin = firstRight.getYMin();
            for (IDataSet dataSet : this.getDataSets()) {
                if (dataSet.getAxisDependency() != YAxis.AxisDependency.RIGHT) continue;
                if (dataSet.getYMin() < this.mRightAxisMin) {
                    this.mRightAxisMin = dataSet.getYMin();
                }
                if (!(dataSet.getYMax() > this.mRightAxisMax)) continue;
                this.mRightAxisMax = dataSet.getYMax();
            }
        }
    }

    public final int getDataSetCount() {
        return this.getDataSets().size();
    }

    public final float getYMin(@Nullable YAxis.AxisDependency axis) {
        return axis == YAxis.AxisDependency.LEFT ? (this.mLeftAxisMin == Float.MAX_VALUE ? this.mRightAxisMin : this.mLeftAxisMin) : (this.mRightAxisMin == Float.MAX_VALUE ? this.mLeftAxisMin : this.mRightAxisMin);
    }

    public final float getYMax(@Nullable YAxis.AxisDependency axis) {
        return axis == YAxis.AxisDependency.LEFT ? (this.mLeftAxisMax == -3.4028235E38f ? this.mRightAxisMax : this.mLeftAxisMax) : (this.mRightAxisMax == -3.4028235E38f ? this.mLeftAxisMax : this.mRightAxisMax);
    }

    protected final int getDataSetIndexByLabel(@NotNull List<T> dataSets, @NotNull String label, boolean ignoreCase) {
        Intrinsics.checkNotNullParameter(dataSets, (String)"dataSets");
        Intrinsics.checkNotNullParameter((Object)label, (String)"label");
        if (ignoreCase) {
            int n = ((Collection)dataSets).size();
            for (int i = 0; i < n; ++i) {
                if (!StringsKt.equals((String)label, (String)((IDataSet)dataSets.get(i)).getLabel(), (boolean)true)) continue;
                return i;
            }
        } else {
            int n = ((Collection)dataSets).size();
            for (int i = 0; i < n; ++i) {
                if (!Intrinsics.areEqual((Object)label, (Object)((IDataSet)dataSets.get(i)).getLabel())) continue;
                return i;
            }
        }
        return -1;
    }

    @NotNull
    public final String[] getDataSetLabels() {
        String[] types = new String[this.getDataSets().size()];
        int n = ((Collection)this.getDataSets()).size();
        for (int i = 0; i < n; ++i) {
            types[i] = ((IDataSet)this.getDataSets().get(i)).getLabel();
        }
        return types;
    }

    @Nullable
    public Entry getEntryForHighlight(@NotNull Highlight highlight) {
        Intrinsics.checkNotNullParameter((Object)highlight, (String)"highlight");
        return highlight.getDataSetIndex() >= this.getDataSets().size() ? null : (Entry)((IDataSet)this.getDataSets().get(highlight.getDataSetIndex())).getEntryForXValue(highlight.getX(), highlight.getY());
    }

    @Nullable
    public T getDataSetByLabel(@NotNull String label, boolean ignoreCase) {
        Intrinsics.checkNotNullParameter((Object)label, (String)"label");
        int index = this.getDataSetIndexByLabel(this.getDataSets(), label, ignoreCase);
        return (T)(index < 0 || index >= this.getDataSets().size() ? null : (IDataSet)this.getDataSets().get(index));
    }

    @Nullable
    public T getDataSetByIndex(int index) {
        if (index < 0 || index >= this.getDataSets().size()) {
            return null;
        }
        return (T)((IDataSet)this.getDataSets().get(index));
    }

    public final void addDataSet(@Nullable T d) {
        if (d == null) {
            return;
        }
        this.calcMinMax(d);
        this.getDataSets().add(d);
    }

    public boolean removeDataSet(@Nullable T d) {
        if (d == null) {
            return false;
        }
        boolean removed = this.getDataSets().remove(d);
        if (removed) {
            this.notifyDataChanged();
        }
        return removed;
    }

    public boolean removeDataSet(int index) {
        if (index >= this.getDataSets().size() || index < 0) {
            return false;
        }
        IDataSet set = (IDataSet)this.getDataSets().get(index);
        return this.removeDataSet(set);
    }

    public final void addEntry(@NotNull Entry entry, int dataSetIndex) {
        Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
        if (this.getDataSets().size() > dataSetIndex && dataSetIndex >= 0) {
            IDataSet set = (IDataSet)this.getDataSets().get(dataSetIndex);
            Intrinsics.checkNotNull((Object)set, (String)"null cannot be cast to non-null type info.appdev.charting.interfaces.datasets.IDataSet<info.appdev.charting.data.Entry>");
            IDataSet dataSet = set;
            if (!dataSet.addEntry(entry)) {
                return;
            }
            this.calcMinMax(entry, set.getAxisDependency());
        } else {
            Timber.Forest.e("Cannot add Entry because dataSetIndex too high or too low.", new Object[0]);
        }
    }

    protected final void calcMinMax(@NotNull Entry e, @Nullable YAxis.AxisDependency axis) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        if (this.yMax < e.getY()) {
            this.yMax = e.getY();
        }
        if (this.yMin > e.getY()) {
            this.yMin = e.getY();
        }
        if (this.xMax < e.getX()) {
            this.xMax = e.getX();
        }
        if (this.xMin > e.getX()) {
            this.xMin = e.getX();
        }
        if (axis == YAxis.AxisDependency.LEFT) {
            if (this.mLeftAxisMax < e.getY()) {
                this.mLeftAxisMax = e.getY();
            }
            if (this.mLeftAxisMin > e.getY()) {
                this.mLeftAxisMin = e.getY();
            }
        } else {
            if (this.mRightAxisMax < e.getY()) {
                this.mRightAxisMax = e.getY();
            }
            if (this.mRightAxisMin > e.getY()) {
                this.mRightAxisMin = e.getY();
            }
        }
    }

    protected final void calcMinMax(@Nullable T d) {
        T t = d;
        Intrinsics.checkNotNull(t);
        if (this.yMax < t.getYMax()) {
            this.yMax = d.getYMax();
        }
        if (this.yMin > d.getYMin()) {
            this.yMin = d.getYMin();
        }
        if (this.xMax < d.getXMax()) {
            this.xMax = d.getXMax();
        }
        if (this.xMin > d.getXMin()) {
            this.xMin = d.getXMin();
        }
        if (d.getAxisDependency() == YAxis.AxisDependency.LEFT) {
            if (this.mLeftAxisMax < d.getYMax()) {
                this.mLeftAxisMax = d.getYMax();
            }
            if (this.mLeftAxisMin > d.getYMin()) {
                this.mLeftAxisMin = d.getYMin();
            }
        } else {
            if (this.mRightAxisMax < d.getYMax()) {
                this.mRightAxisMax = d.getYMax();
            }
            if (this.mRightAxisMin > d.getYMin()) {
                this.mRightAxisMin = d.getYMin();
            }
        }
    }

    public boolean removeEntry(@NotNull Entry entry, int dataSetIndex) {
        Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
        if (dataSetIndex >= this.getDataSets().size()) {
            return false;
        }
        IDataSet set = (IDataSet)this.getDataSets().get(dataSetIndex);
        Intrinsics.checkNotNull((Object)set, (String)"null cannot be cast to non-null type info.appdev.charting.interfaces.datasets.IDataSet<info.appdev.charting.data.Entry>");
        IDataSet dataSet = set;
        boolean removed = dataSet.removeEntry(entry);
        if (removed) {
            this.notifyDataChanged();
        }
        return removed;
    }

    public boolean removeEntry(float xValue, int dataSetIndex) {
        if (dataSetIndex >= this.getDataSets().size()) {
            return false;
        }
        IDataSet dataSet = (IDataSet)this.getDataSets().get(dataSetIndex);
        Object t = dataSet.getEntryForXValue(xValue, Float.NaN);
        if (t == null) {
            return false;
        }
        Object entry = t;
        return this.removeEntry((Entry)entry, dataSetIndex);
    }

    @Nullable
    public final T getDataSetForEntry(@NotNull Entry e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        int n = ((Collection)this.getDataSets()).size();
        for (int i = 0; i < n; ++i) {
            IDataSet set = (IDataSet)this.getDataSets().get(i);
            int n2 = set.getEntryCount();
            for (int j = 0; j < n2; ++j) {
                if (!e.equalTo((Entry)set.getEntryForXValue(e.getX(), e.getY()))) continue;
                return (T)set;
            }
        }
        return null;
    }

    @NotNull
    public final int[] getColors() {
        int clrCount = 0;
        int n = ((Collection)this.getDataSets()).size();
        for (int i = 0; i < n; ++i) {
            clrCount += ((IDataSet)this.getDataSets().get(i)).getColors().size();
        }
        int[] colorArray = new int[clrCount];
        int cnt = 0;
        int n2 = ((Collection)this.getDataSets()).size();
        for (int i = 0; i < n2; ++i) {
            List<Integer> clrs = ((IDataSet)this.getDataSets().get(i)).getColors();
            Iterator<Integer> iterator = clrs.iterator();
            while (iterator.hasNext()) {
                int clr;
                colorArray[cnt] = clr = ((Number)iterator.next()).intValue();
                ++cnt;
            }
        }
        return colorArray;
    }

    public final int getIndexOfDataSet(@Nullable T dataSet) {
        return CollectionsKt.indexOf(this.getDataSets(), dataSet);
    }

    @Nullable
    protected final T getFirstLeft(@NotNull List<T> sets) {
        Intrinsics.checkNotNullParameter(sets, (String)"sets");
        for (IDataSet dataSet : sets) {
            if (dataSet.getAxisDependency() != YAxis.AxisDependency.LEFT) continue;
            return (T)dataSet;
        }
        return null;
    }

    @Nullable
    public final T getFirstRight(@NotNull List<T> sets) {
        Intrinsics.checkNotNullParameter(sets, (String)"sets");
        for (IDataSet dataSet : sets) {
            if (dataSet.getAxisDependency() != YAxis.AxisDependency.RIGHT) continue;
            return (T)dataSet;
        }
        return null;
    }

    public final void setValueFormatter(@NotNull IValueFormatter f) {
        Intrinsics.checkNotNullParameter((Object)f, (String)"f");
        for (IDataSet set : this.getDataSets()) {
            set.setValueFormatter(f);
        }
    }

    public final void setValueTextColor(int color) {
        for (IDataSet set : this.getDataSets()) {
            set.setValueTextColor(color);
        }
    }

    public final void setValueTextColors(@NotNull List<Integer> colors) {
        Intrinsics.checkNotNullParameter(colors, (String)"colors");
        for (IDataSet set : this.getDataSets()) {
            set.setValueTextColors(colors);
        }
    }

    public final void setValueTypeface(@Nullable Typeface tf) {
        for (IDataSet set : this.getDataSets()) {
            set.setValueTypeface(tf);
        }
    }

    public final void setValueTextSize(float size) {
        for (IDataSet set : this.getDataSets()) {
            set.setValueTextSize(size);
        }
    }

    public final void setDrawValues(boolean enabled) {
        for (IDataSet set : this.getDataSets()) {
            set.setDrawValues(enabled);
        }
    }

    public final boolean isHighlight() {
        for (IDataSet set : this.getDataSets()) {
            if (set.isHighlight()) continue;
            return false;
        }
        return true;
    }

    public final void setHighlight(boolean value) {
        for (IDataSet set : this.getDataSets()) {
            set.setHighlight(value);
        }
    }

    public final void clearValues() {
        this.getDataSets().clear();
        this.notifyDataChanged();
    }

    public final boolean contains(@Nullable T dataSet) {
        for (IDataSet set : this.getDataSets()) {
            if (!Intrinsics.areEqual((Object)set, dataSet)) continue;
            return true;
        }
        return false;
    }

    public final int getEntryCount() {
        int count = 0;
        for (IDataSet set : this.getDataSets()) {
            count += set.getEntryCount();
        }
        return count;
    }

    @Nullable
    public final T getMaxEntryCountSet() {
        if (this.getDataSets().isEmpty()) {
            return null;
        }
        IDataSet max = (IDataSet)this.getDataSets().get(0);
        for (IDataSet set : this.getDataSets()) {
            if (set.getEntryCount() <= max.getEntryCount()) continue;
            max = set;
        }
        return (T)max;
    }
}

