/*
 * Decompiled with CFR 0.152.
 */
package info.appdev.charting.utils;

import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\b\b\u0018\u0000 (*\u000e\b\u0000\u0010\u0001*\b\u0012\u0004\u0012\u0002H\u00010\u00022\u00020\u0003:\u0002'(B\u001b\b\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00018\u0000\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0012\u0010\u0019\u001a\u00020\u001a2\b\b\u0002\u0010\u001b\u001a\u00020\u0013H\u0002J\u000b\u0010\u001c\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u001dJ\u0015\u0010\u001e\u001a\u00020\u001a2\b\u0010\u001f\u001a\u0004\u0018\u00018\u0000\u00a2\u0006\u0002\u0010 J\u0014\u0010\u001e\u001a\u00020\u001a2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00028\u00000!J\b\u0010\"\u001a\u00020\u001aH\u0002R\u001e\u0010\n\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u0005@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u000e\u001a\u0012\u0012\u0004\u0012\u00028\u00000\u000fj\b\u0012\u0004\u0012\u00028\u0000`\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0011\u001a\u0004\u0018\u00018\u0000X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0012R$\u0010\u0014\u001a\u00020\u00132\u0006\u0010\t\u001a\u00020\u0013@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u0011\u0010#\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b$\u0010\fR\u0011\u0010%\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b&\u0010\f\u00a8\u0006)"}, d2={"Linfo/appdev/charting/utils/ObjectPool;", "T", "Linfo/appdev/charting/utils/ObjectPool$Poolable;", "", "withCapacity", "", "poolObject", "<init>", "(ILinfo/appdev/charting/utils/ObjectPool$Poolable;)V", "value", "poolId", "getPoolId", "()I", "desiredCapacity", "objects", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "modelObject", "Linfo/appdev/charting/utils/ObjectPool$Poolable;", "", "replenishPercentage", "getReplenishPercentage", "()F", "setReplenishPercentage", "(F)V", "refillPool", "", "percentage", "get", "()Linfo/appdev/charting/utils/ObjectPool$Poolable;", "recycle", "object", "(Linfo/appdev/charting/utils/ObjectPool$Poolable;)V", "", "resizePool", "poolCapacity", "getPoolCapacity", "poolCount", "getPoolCount", "Poolable", "Companion", "chartLib_release"})
@SourceDebugExtension(value={"SMAP\nObjectPool.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ObjectPool.kt\ninfo/appdev/charting/utils/ObjectPool\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,183:1\n1#2:184\n*E\n"})
public final class ObjectPool<T extends Poolable<T>> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private int poolId;
    private int desiredCapacity;
    @NotNull
    private final ArrayList<T> objects;
    @Nullable
    private final T modelObject;
    private float replenishPercentage;
    private static int ids;

    private ObjectPool(int withCapacity, T poolObject) {
        this.objects = new ArrayList(withCapacity);
        this.replenishPercentage = 1.0f;
        if (!(withCapacity > 0)) {
            boolean bl = false;
            String string = "Object Pool must be instantiated with a capacity greater than 0!";
            throw new IllegalArgumentException(string.toString());
        }
        this.desiredCapacity = withCapacity;
        this.modelObject = poolObject;
        ObjectPool.refillPool$default(this, 0.0f, 1, null);
    }

    public final int getPoolId() {
        return this.poolId;
    }

    public final float getReplenishPercentage() {
        return this.replenishPercentage;
    }

    public final void setReplenishPercentage(float value) {
        float p = value;
        if (p > 1.0f) {
            p = 1.0f;
        } else if (p < 0.0f) {
            p = 0.0f;
        }
        this.replenishPercentage = p;
    }

    private final void refillPool(float percentage) {
        int portionOfCapacity = (int)((float)this.desiredCapacity * percentage);
        if (portionOfCapacity < 1) {
            portionOfCapacity = 1;
        } else if (portionOfCapacity > this.desiredCapacity) {
            portionOfCapacity = this.desiredCapacity;
        }
        this.objects.clear();
        int n = 0;
        while (n < portionOfCapacity) {
            int it = n++;
            boolean bl = false;
            T t = this.modelObject;
            Intrinsics.checkNotNull(t);
            this.objects.add(((Poolable)t).instantiate());
        }
    }

    static /* synthetic */ void refillPool$default(ObjectPool objectPool, float f, int n, Object object) {
        if ((n & 1) != 0) {
            f = objectPool.replenishPercentage;
        }
        objectPool.refillPool(f);
    }

    @NotNull
    public final synchronized T get() {
        if (this.objects.isEmpty() && this.replenishPercentage > 0.0f) {
            ObjectPool.refillPool$default(this, 0.0f, 1, null);
        }
        T t = this.objects.remove(CollectionsKt.getLastIndex((List)this.objects));
        Intrinsics.checkNotNullExpressionValue(t, (String)"removeAt(...)");
        Poolable result = (Poolable)t;
        result.setCurrentOwnerId(Poolable.Companion.getNO_OWNER());
        return (T)result;
    }

    public final synchronized void recycle(@Nullable T object) {
        if (object == null) {
            return;
        }
        if (((Poolable)object).getCurrentOwnerId() != Poolable.Companion.getNO_OWNER()) {
            if (!(((Poolable)object).getCurrentOwnerId() != this.poolId)) {
                boolean bl = false;
                String string = "The object passed is already stored in this pool!";
                throw new IllegalArgumentException(string.toString());
            }
            throw new IllegalArgumentException("The object to recycle already belongs to poolId " + ((Poolable)object).getCurrentOwnerId() + ".  Object cannot belong to two different pool instances simultaneously!");
        }
        ((Poolable)object).setCurrentOwnerId(this.poolId);
        this.objects.add(object);
        if (this.objects.size() > this.desiredCapacity) {
            this.resizePool();
        }
    }

    public final synchronized void recycle(@NotNull List<? extends T> objects) {
        Intrinsics.checkNotNullParameter(objects, (String)"objects");
        int objectsListSize = objects.size();
        while (objectsListSize + this.objects.size() > this.desiredCapacity) {
            this.resizePool();
        }
        for (int i = 0; i < objectsListSize; ++i) {
            Poolable object = (Poolable)objects.get(i);
            if (object.getCurrentOwnerId() != Poolable.Companion.getNO_OWNER()) {
                if (!(object.getCurrentOwnerId() != this.poolId)) {
                    boolean bl = false;
                    String string = "The object passed is already stored in this pool!";
                    throw new IllegalArgumentException(string.toString());
                }
                throw new IllegalArgumentException("The object to recycle already belongs to poolId " + object.getCurrentOwnerId() + ".  Object cannot belong to two different pool instances simultaneously!");
            }
            object.setCurrentOwnerId(this.poolId);
            this.objects.add(object);
        }
    }

    private final void resizePool() {
        this.desiredCapacity *= 2;
    }

    public final int getPoolCapacity() {
        return this.desiredCapacity;
    }

    public final int getPoolCount() {
        return this.objects.size();
    }

    public /* synthetic */ ObjectPool(int withCapacity, Poolable poolObject, DefaultConstructorMarker $constructor_marker) {
        this(withCapacity, poolObject);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J1\u0010\u0006\u001a\b\u0012\u0004\u0012\u0002H\b0\u0007\"\u000e\b\u0001\u0010\b*\b\u0012\u0004\u0012\u0002H\b0\t2\u0006\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u0002H\b\u00a2\u0006\u0002\u0010\fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Linfo/appdev/charting/utils/ObjectPool$Companion;", "", "<init>", "()V", "ids", "", "create", "Linfo/appdev/charting/utils/ObjectPool;", "T", "Linfo/appdev/charting/utils/ObjectPool$Poolable;", "withCapacity", "object", "(ILinfo/appdev/charting/utils/ObjectPool$Poolable;)Linfo/appdev/charting/utils/ObjectPool;", "chartLib_release"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final synchronized <T extends Poolable<T>> ObjectPool<T> create(int withCapacity, @NotNull T object) {
            Intrinsics.checkNotNullParameter(object, (String)"object");
            ObjectPool result = new ObjectPool(withCapacity, object, null);
            result.poolId = ids;
            int n = ids;
            ids = n + 1;
            return result;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\b\b&\u0018\u0000 \r*\u000e\b\u0001\u0010\u0001*\b\u0012\u0004\u0012\u0002H\u00010\u00002\u00020\u0002:\u0001\rB\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\r\u0010\u000b\u001a\u00028\u0001H&\u00a2\u0006\u0002\u0010\fR\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\n\u00a8\u0006\u000e"}, d2={"Linfo/appdev/charting/utils/ObjectPool$Poolable;", "T", "", "<init>", "()V", "currentOwnerId", "", "getCurrentOwnerId", "()I", "setCurrentOwnerId", "(I)V", "instantiate", "()Linfo/appdev/charting/utils/ObjectPool$Poolable;", "Companion", "chartLib_release"})
    public static abstract class Poolable<T extends Poolable<T>> {
        @NotNull
        public static final Companion Companion = new Companion(null);
        private int currentOwnerId = NO_OWNER;
        private static int NO_OWNER = -1;

        public final int getCurrentOwnerId() {
            return this.currentOwnerId;
        }

        public final void setCurrentOwnerId(int n) {
            this.currentOwnerId = n;
        }

        @NotNull
        public abstract T instantiate();

        @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Linfo/appdev/charting/utils/ObjectPool$Poolable$Companion;", "", "<init>", "()V", "NO_OWNER", "", "getNO_OWNER", "()I", "setNO_OWNER", "(I)V", "chartLib_release"})
        public static final class Companion {
            private Companion() {
            }

            public final int getNO_OWNER() {
                return NO_OWNER;
            }

            public final void setNO_OWNER(int n) {
                NO_OWNER = n;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

