/*
 * Decompiled with CFR 0.152.
 */
package info.appdev.charting.renderer;

import info.appdev.charting.animation.ChartAnimator;
import info.appdev.charting.data.DataSet;
import info.appdev.charting.data.Entry;
import info.appdev.charting.interfaces.dataprovider.base.BarLineScatterCandleBubbleDataProvider;
import info.appdev.charting.interfaces.datasets.IBarLineScatterCandleBubbleDataSet;
import info.appdev.charting.interfaces.datasets.IDataSet;
import info.appdev.charting.renderer.DataRenderer;
import info.appdev.charting.utils.ViewPortHandler;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u00002\u00020\u0001:\u0001\u0018B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0014\u0010\u000e\u001a\u00020\u000f2\n\u0010\u0010\u001a\u0006\u0012\u0002\b\u00030\u0011H\u0004J-\u0010\u0012\u001a\u00020\u000f\"\b\b\u0000\u0010\u0013*\u00020\u00142\u0006\u0010\u0015\u001a\u0002H\u00132\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u0002H\u00130\u0016H\u0004\u00a2\u0006\u0002\u0010\u0017R\u001e\u0010\b\u001a\u00060\tR\u00020\u0000X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\r\u00a8\u0006\u0019"}, d2={"Linfo/appdev/charting/renderer/BarLineScatterCandleBubbleRenderer;", "Linfo/appdev/charting/renderer/DataRenderer;", "animator", "Linfo/appdev/charting/animation/ChartAnimator;", "viewPortHandler", "Linfo/appdev/charting/utils/ViewPortHandler;", "<init>", "(Linfo/appdev/charting/animation/ChartAnimator;Linfo/appdev/charting/utils/ViewPortHandler;)V", "xBounds", "Linfo/appdev/charting/renderer/BarLineScatterCandleBubbleRenderer$XBounds;", "getXBounds", "()Linfo/appdev/charting/renderer/BarLineScatterCandleBubbleRenderer$XBounds;", "setXBounds", "(Linfo/appdev/charting/renderer/BarLineScatterCandleBubbleRenderer$XBounds;)V", "shouldDrawValues", "", "set", "Linfo/appdev/charting/interfaces/datasets/IDataSet;", "isInBoundsX", "T", "Linfo/appdev/charting/data/Entry;", "entry", "Linfo/appdev/charting/interfaces/datasets/IBarLineScatterCandleBubbleDataSet;", "(Linfo/appdev/charting/data/Entry;Linfo/appdev/charting/interfaces/datasets/IBarLineScatterCandleBubbleDataSet;)Z", "XBounds", "chartLib_release"})
public abstract class BarLineScatterCandleBubbleRenderer
extends DataRenderer {
    @NotNull
    private XBounds xBounds;

    public BarLineScatterCandleBubbleRenderer(@NotNull ChartAnimator animator, @NotNull ViewPortHandler viewPortHandler) {
        Intrinsics.checkNotNullParameter((Object)animator, (String)"animator");
        Intrinsics.checkNotNullParameter((Object)viewPortHandler, (String)"viewPortHandler");
        super(animator, viewPortHandler);
        this.xBounds = new XBounds();
    }

    @NotNull
    protected final XBounds getXBounds() {
        return this.xBounds;
    }

    protected final void setXBounds(@NotNull XBounds xBounds) {
        Intrinsics.checkNotNullParameter((Object)xBounds, (String)"<set-?>");
        this.xBounds = xBounds;
    }

    protected final boolean shouldDrawValues(@NotNull IDataSet<?> set) {
        Intrinsics.checkNotNullParameter(set, (String)"set");
        return set.isVisible() && (set.isDrawValues() || set.isDrawIcons());
    }

    protected final <T extends Entry> boolean isInBoundsX(@NotNull T entry, @NotNull IBarLineScatterCandleBubbleDataSet<T> set) {
        Intrinsics.checkNotNullParameter(entry, (String)"entry");
        Intrinsics.checkNotNullParameter(set, (String)"set");
        float entryIndex = set.getEntryIndex(entry);
        return !(entryIndex >= (float)set.getEntryCount() * this.getAnimator().getPhaseX());
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0084\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J*\u0010\u0010\u001a\u00020\u0011\"\b\b\u0000\u0010\u0012*\u00020\u00132\n\u0010\u0014\u001a\u0006\u0012\u0002\b\u00030\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u0002H\u00120\u0017R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\u0007\"\u0004\b\f\u0010\tR\u001a\u0010\r\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u0007\"\u0004\b\u000f\u0010\t\u00a8\u0006\u0018"}, d2={"Linfo/appdev/charting/renderer/BarLineScatterCandleBubbleRenderer$XBounds;", "", "<init>", "(Linfo/appdev/charting/renderer/BarLineScatterCandleBubbleRenderer;)V", "min", "", "getMin", "()I", "setMin", "(I)V", "max", "getMax", "setMax", "range", "getRange", "setRange", "set", "", "T", "Linfo/appdev/charting/data/Entry;", "chart", "Linfo/appdev/charting/interfaces/dataprovider/base/BarLineScatterCandleBubbleDataProvider;", "dataSet", "Linfo/appdev/charting/interfaces/datasets/IBarLineScatterCandleBubbleDataSet;", "chartLib_release"})
    protected final class XBounds {
        private int min;
        private int max;
        private int range;

        public final int getMin() {
            return this.min;
        }

        public final void setMin(int n) {
            this.min = n;
        }

        public final int getMax() {
            return this.max;
        }

        public final void setMax(int n) {
            this.max = n;
        }

        public final int getRange() {
            return this.range;
        }

        public final void setRange(int n) {
            this.range = n;
        }

        public final <T extends Entry> void set(@NotNull BarLineScatterCandleBubbleDataProvider<?> chart, @NotNull IBarLineScatterCandleBubbleDataSet<T> dataSet) {
            Intrinsics.checkNotNullParameter(chart, (String)"chart");
            Intrinsics.checkNotNullParameter(dataSet, (String)"dataSet");
            float phaseX = Math.max(0.0f, Math.min(1.0f, BarLineScatterCandleBubbleRenderer.this.getAnimator().getPhaseX()));
            float low = chart.getLowestVisibleX();
            float high = chart.getHighestVisibleX();
            Object entryFrom = dataSet.getEntryForXValue(low, Float.NaN, DataSet.Rounding.DOWN);
            Object entryTo = dataSet.getEntryForXValue(high, Float.NaN, DataSet.Rounding.UP);
            Object t = entryFrom;
            this.min = t == null ? 0 : dataSet.getEntryIndex(t);
            Object t2 = entryTo;
            this.max = t2 == null ? 0 : dataSet.getEntryIndex(t2);
            this.range = (int)((float)(this.max - this.min) * phaseX);
        }
    }
}

