/*
 * Decompiled with CFR 0.152.
 */
package info.appdev.charting.jobs;

import android.graphics.Matrix;
import android.view.View;
import info.appdev.charting.charts.BarLineChartBase;
import info.appdev.charting.components.YAxis;
import info.appdev.charting.jobs.ViewPortJob;
import info.appdev.charting.utils.ObjectPool;
import info.appdev.charting.utils.Transformer;
import info.appdev.charting.utils.ViewPortHandler;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0016\u0018\u0000 $2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001$BM\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u0012\u0006\u0010\b\u001a\u00020\u0005\u0012\b\u0010\t\u001a\u0004\u0018\u00010\n\u0012\b\u0010\u000b\u001a\u0004\u0018\u00010\f\u0012\b\u0010\r\u001a\u0004\u0018\u00010\u000e\u00a2\u0006\u0004\b\u000f\u0010\u0010J\b\u0010!\u001a\u00020\"H\u0016J\b\u0010#\u001a\u00020\u0000H\u0016R\u001a\u0010\u0004\u001a\u00020\u0005X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0006\u001a\u00020\u0005X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0012\"\u0004\b\u0016\u0010\u0014R\u001c\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u001a\u0010\u001b\u001a\u00020\u001cX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 \u00a8\u0006%"}, d2={"Linfo/appdev/charting/jobs/ZoomJob;", "Linfo/appdev/charting/jobs/ViewPortJob;", "viewPortHandler", "Linfo/appdev/charting/utils/ViewPortHandler;", "scaleX", "", "scaleY", "xValue", "yValue", "trans", "Linfo/appdev/charting/utils/Transformer;", "axisDependency", "Linfo/appdev/charting/components/YAxis$AxisDependency;", "v", "Landroid/view/View;", "<init>", "(Linfo/appdev/charting/utils/ViewPortHandler;FFFFLinfo/appdev/charting/utils/Transformer;Linfo/appdev/charting/components/YAxis$AxisDependency;Landroid/view/View;)V", "getScaleX", "()F", "setScaleX", "(F)V", "getScaleY", "setScaleY", "getAxisDependency", "()Linfo/appdev/charting/components/YAxis$AxisDependency;", "setAxisDependency", "(Linfo/appdev/charting/components/YAxis$AxisDependency;)V", "mRunMatrixBuffer", "Landroid/graphics/Matrix;", "getMRunMatrixBuffer", "()Landroid/graphics/Matrix;", "setMRunMatrixBuffer", "(Landroid/graphics/Matrix;)V", "run", "", "instantiate", "Companion", "chartLib_release"})
public class ZoomJob
extends ViewPortJob<ZoomJob> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private float scaleX;
    private float scaleY;
    @Nullable
    private YAxis.AxisDependency axisDependency;
    @NotNull
    private Matrix mRunMatrixBuffer;
    @NotNull
    private static final ObjectPool<ZoomJob> pool = ObjectPool.Companion.create(1, (ObjectPool.Poolable)new ZoomJob(new ViewPortHandler(), 0.0f, 0.0f, 0.0f, 0.0f, null, null, null));

    public ZoomJob(@NotNull ViewPortHandler viewPortHandler, float scaleX, float scaleY, float xValue, float yValue, @Nullable Transformer trans, @Nullable YAxis.AxisDependency axisDependency, @Nullable View v) {
        Intrinsics.checkNotNullParameter((Object)viewPortHandler, (String)"viewPortHandler");
        super(viewPortHandler, xValue, yValue, trans, v);
        this.scaleX = scaleX;
        this.scaleY = scaleY;
        this.axisDependency = axisDependency;
        this.mRunMatrixBuffer = new Matrix();
    }

    protected final float getScaleX() {
        return this.scaleX;
    }

    protected final void setScaleX(float f) {
        this.scaleX = f;
    }

    protected final float getScaleY() {
        return this.scaleY;
    }

    protected final void setScaleY(float f) {
        this.scaleY = f;
    }

    @Nullable
    protected final YAxis.AxisDependency getAxisDependency() {
        return this.axisDependency;
    }

    protected final void setAxisDependency(@Nullable YAxis.AxisDependency axisDependency) {
        this.axisDependency = axisDependency;
    }

    @NotNull
    protected final Matrix getMRunMatrixBuffer() {
        return this.mRunMatrixBuffer;
    }

    protected final void setMRunMatrixBuffer(@NotNull Matrix matrix) {
        Intrinsics.checkNotNullParameter((Object)matrix, (String)"<set-?>");
        this.mRunMatrixBuffer = matrix;
    }

    @Override
    public void run() {
        Matrix save = this.mRunMatrixBuffer;
        this.getMViewPortHandler().zoom(this.scaleX, this.scaleY, save);
        this.getMViewPortHandler().refresh(save, this.getView(), false);
        View view = this.getView();
        BarLineChartBase barLineChartBase = view instanceof BarLineChartBase ? (BarLineChartBase)view : null;
        if (barLineChartBase != null) {
            BarLineChartBase view2 = barLineChartBase;
            boolean bl = false;
            float yValsInView = view2.getAxis(this.axisDependency).getMAxisRange() / this.getMViewPortHandler().getScaleY();
            float xValsInView = view2.getXAxis().getMAxisRange() / this.getMViewPortHandler().getScaleX();
            this.getPts()[0] = this.getXValue() - xValsInView / 2.0f;
            this.getPts()[1] = this.getYValue() + yValsInView / 2.0f;
            Transformer transformer = this.getMTrans();
            if (transformer != null) {
                transformer.pointValuesToPixel(this.getPts());
            }
            this.getMViewPortHandler().translate(this.getPts(), save);
            this.getMViewPortHandler().refresh(save, (View)view2, false);
            view2.calculateOffsets();
            view2.postInvalidate();
        }
        Companion.recycleInstance(this);
    }

    @Override
    @NotNull
    public ZoomJob instantiate() {
        return new ZoomJob(new ViewPortHandler(), 0.0f, 0.0f, 0.0f, 0.0f, null, null, null);
    }

    static {
        pool.setReplenishPercentage(0.5f);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003JL\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000b2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014J\u000e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0006R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Linfo/appdev/charting/jobs/ZoomJob$Companion;", "", "<init>", "()V", "pool", "Linfo/appdev/charting/utils/ObjectPool;", "Linfo/appdev/charting/jobs/ZoomJob;", "getInstance", "viewPortHandler", "Linfo/appdev/charting/utils/ViewPortHandler;", "scaleX", "", "scaleY", "xValue", "yValue", "trans", "Linfo/appdev/charting/utils/Transformer;", "axis", "Linfo/appdev/charting/components/YAxis$AxisDependency;", "v", "Landroid/view/View;", "recycleInstance", "", "instance", "chartLib_release"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ZoomJob getInstance(@NotNull ViewPortHandler viewPortHandler, float scaleX, float scaleY, float xValue, float yValue, @Nullable Transformer trans, @Nullable YAxis.AxisDependency axis, @Nullable View v) {
            Intrinsics.checkNotNullParameter((Object)viewPortHandler, (String)"viewPortHandler");
            ZoomJob result = (ZoomJob)pool.get();
            result.setXValue(xValue);
            result.setYValue(yValue);
            result.setScaleX(scaleX);
            result.setScaleY(scaleY);
            result.setMViewPortHandler(viewPortHandler);
            result.setMTrans(trans);
            result.setAxisDependency(axis);
            result.setView(v);
            return result;
        }

        public final void recycleInstance(@NotNull ZoomJob instance) {
            Intrinsics.checkNotNullParameter((Object)instance, (String)"instance");
            instance.setXValue(0.0f);
            instance.setYValue(0.0f);
            instance.setScaleX(0.0f);
            instance.setScaleY(0.0f);
            instance.setAxisDependency(null);
            instance.recycle();
            pool.recycle((ObjectPool.Poolable)instance);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

