/*
 * Decompiled with CFR 0.152.
 */
package info.appdev.charting.data;

import info.appdev.charting.data.ChartData;
import info.appdev.charting.data.Entry;
import info.appdev.charting.data.PieEntry;
import info.appdev.charting.highlight.Highlight;
import info.appdev.charting.interfaces.datasets.IDataSet;
import info.appdev.charting.interfaces.datasets.IPieDataSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import timber.log.Timber;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010!\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0011\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0012\u0010\u0010\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u001a\u0010\u0013\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0012\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0016R$\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00028F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\u0005R4\u0010\u000b\u001a\n\u0012\u0004\u0012\u00020\u0002\u0018\u00010\n2\u000e\u0010\t\u001a\n\u0012\u0004\u0012\u00020\u0002\u0018\u00010\n8V@TX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u0011\u0010\u001c\u001a\u00020\u001d8F\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001f\u00a8\u0006 "}, d2={"Linfo/appdev/charting/data/PieData;", "Linfo/appdev/charting/data/ChartData;", "Linfo/appdev/charting/interfaces/datasets/IPieDataSet;", "dataSet", "<init>", "(Linfo/appdev/charting/interfaces/datasets/IPieDataSet;)V", "getDataSet", "()Linfo/appdev/charting/interfaces/datasets/IPieDataSet;", "setDataSet", "value", "", "dataSets", "getDataSets", "()Ljava/util/List;", "setDataSets", "(Ljava/util/List;)V", "getDataSetByIndex", "index", "", "getDataSetByLabel", "label", "", "ignoreCase", "", "getEntryForHighlight", "Linfo/appdev/charting/data/Entry;", "highlight", "Linfo/appdev/charting/highlight/Highlight;", "yValueSum", "", "getYValueSum", "()F", "chartLib_release"})
public final class PieData
extends ChartData<IPieDataSet> {
    public PieData(@NotNull IPieDataSet dataSet) {
        Intrinsics.checkNotNullParameter((Object)dataSet, (String)"dataSet");
        IPieDataSet[] iPieDataSetArray = new IPieDataSet[]{dataSet};
        super((IDataSet[])iPieDataSetArray);
    }

    @NotNull
    public final IPieDataSet getDataSet() {
        List<IPieDataSet> list = this.getDataSets();
        Intrinsics.checkNotNull(list);
        return list.get(0);
    }

    public final void setDataSet(@NotNull IPieDataSet dataSet) {
        Intrinsics.checkNotNullParameter((Object)dataSet, (String)"dataSet");
        List<IPieDataSet> list = this.getDataSets();
        if (list != null) {
            list.clear();
        }
        List<IPieDataSet> list2 = this.getDataSets();
        if (list2 != null) {
            list2.add(dataSet);
        }
        this.notifyDataChanged();
    }

    @Override
    @Nullable
    public List<IPieDataSet> getDataSets() {
        block1: {
            List list = super.getDataSets();
            if (list == null) break block1;
            List it = list;
            boolean bl = false;
            if (it.isEmpty()) {
                Timber.Forest.e("Found multiple data sets while pie chart only allows one", new Object[0]);
            }
        }
        return super.getDataSets();
    }

    @Override
    protected void setDataSets(@Nullable List<IPieDataSet> value) {
        super.setDataSets(value);
    }

    @Override
    @Nullable
    public IPieDataSet getDataSetByIndex(int index) {
        return index == 0 ? this.getDataSet() : null;
    }

    @Override
    @Nullable
    public IPieDataSet getDataSetByLabel(@NotNull String label, boolean ignoreCase) {
        IPieDataSet iPieDataSet;
        Intrinsics.checkNotNullParameter((Object)label, (String)"label");
        if (ignoreCase) {
            List<IPieDataSet> list = this.getDataSets();
            Intrinsics.checkNotNull(list);
            if (StringsKt.equals((String)label, (String)list.get(0).getLabel(), (boolean)true)) {
                List<IPieDataSet> list2 = this.getDataSets();
                Intrinsics.checkNotNull(list2);
                iPieDataSet = list2.get(0);
            } else {
                iPieDataSet = null;
            }
        } else {
            List<IPieDataSet> list = this.getDataSets();
            Intrinsics.checkNotNull(list);
            if (Intrinsics.areEqual((Object)label, (Object)list.get(0).getLabel())) {
                List<IPieDataSet> list3 = this.getDataSets();
                Intrinsics.checkNotNull(list3);
                iPieDataSet = list3.get(0);
            } else {
                iPieDataSet = null;
            }
        }
        return iPieDataSet;
    }

    @Override
    @Nullable
    public Entry getEntryForHighlight(@NotNull Highlight highlight) {
        Intrinsics.checkNotNullParameter((Object)highlight, (String)"highlight");
        return this.getDataSet().getEntryForIndex((int)highlight.getX());
    }

    public final float getYValueSum() {
        float sum = 0.0f;
        int n = this.getDataSet().getEntryCount();
        for (int i = 0; i < n; ++i) {
            Object t = this.getDataSet().getEntryForIndex(i);
            Intrinsics.checkNotNull(t);
            sum += ((PieEntry)t).getY();
        }
        return sum;
    }
}

