/*
 * Decompiled with CFR 0.152.
 */
package info.appdev.charting.charts;

import android.animation.ObjectAnimator;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.RectF;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import info.appdev.charting.animation.Easing;
import info.appdev.charting.charts.Chart;
import info.appdev.charting.charts.RadarChart;
import info.appdev.charting.components.Legend;
import info.appdev.charting.components.XAxis;
import info.appdev.charting.data.ChartData;
import info.appdev.charting.data.Entry;
import info.appdev.charting.interfaces.datasets.IDataSet;
import info.appdev.charting.listener.ChartTouchListener;
import info.appdev.charting.listener.PieRadarChartTouchListener;
import info.appdev.charting.renderer.LegendRenderer;
import info.appdev.charting.utils.NumberUtilsKt;
import info.appdev.charting.utils.PointF;
import info.appdev.charting.utils.ViewPortHandler;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import timber.log.Timber;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u001a\n\u0002\u0018\u0002\n\u0000\b&\u0018\u0000*\u0018\b\u0000\u0010\u0001*\u0012\u0012\u000e\b\u0001\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u00030\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0005B\u0013\b\u0016\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0004\b\b\u0010\tB\u001d\b\u0016\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\u0004\b\b\u0010\fB%\b\u0016\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u0012\u0006\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0004\b\b\u0010\u000fJ\b\u0010\u001f\u001a\u00020 H\u0014J\b\u0010!\u001a\u00020 H\u0014J\u0012\u0010%\u001a\u00020\u00172\b\u0010&\u001a\u0004\u0018\u00010'H\u0016J\b\u0010(\u001a\u00020 H\u0016J\b\u0010)\u001a\u00020 H\u0016J\b\u0010*\u001a\u00020 H\u0016J\u0016\u0010+\u001a\u00020\u00112\u0006\u0010,\u001a\u00020\u00112\u0006\u0010-\u001a\u00020\u0011J\u001e\u0010.\u001a\u00020/2\u0006\u00100\u001a\u00020/2\u0006\u00101\u001a\u00020\u00112\u0006\u00102\u001a\u00020\u0011J&\u0010.\u001a\u00020 2\u0006\u00100\u001a\u00020/2\u0006\u00101\u001a\u00020\u00112\u0006\u00102\u001a\u00020\u00112\u0006\u00103\u001a\u00020/J\u0016\u00104\u001a\u00020\u00112\u0006\u0010,\u001a\u00020\u00112\u0006\u0010-\u001a\u00020\u0011J\u0010\u00105\u001a\u00020\u000e2\u0006\u00102\u001a\u00020\u0011H&J*\u0010E\u001a\u00020 2\u0006\u0010F\u001a\u00020\u000e2\u0006\u0010G\u001a\u00020\u00112\u0006\u0010H\u001a\u00020\u00112\b\u0010I\u001a\u0004\u0018\u00010JH\u0007R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0013\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0011@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u001a\u0010\u0016\u001a\u00020\u0017X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u001a\u0010\u001b\u001a\u00020\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u0015\"\u0004\b\u001d\u0010\u001eR\u0014\u0010\"\u001a\u00020\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b#\u0010$R$\u00106\u001a\u00020\u00112\u0006\u00102\u001a\u00020\u00118F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b7\u0010\u0015\"\u0004\b8\u0010\u001eR\u0011\u00109\u001a\u00020\u00118F\u00a2\u0006\u0006\u001a\u0004\b:\u0010\u0015R\u0012\u0010;\u001a\u00020\u0011X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b<\u0010\u0015R\u0012\u0010=\u001a\u00020\u0011X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b>\u0010\u0015R\u0012\u0010?\u001a\u00020\u0011X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b@\u0010\u0015R\u0014\u0010A\u001a\u00020\u00118VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bB\u0010\u0015R\u0014\u0010C\u001a\u00020\u00118VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bD\u0010\u0015\u00a8\u0006K"}, d2={"Linfo/appdev/charting/charts/PieRadarChartBase;", "T", "Linfo/appdev/charting/data/ChartData;", "Linfo/appdev/charting/interfaces/datasets/IDataSet;", "Linfo/appdev/charting/data/Entry;", "Linfo/appdev/charting/charts/Chart;", "context", "Landroid/content/Context;", "<init>", "(Landroid/content/Context;)V", "attrs", "Landroid/util/AttributeSet;", "(Landroid/content/Context;Landroid/util/AttributeSet;)V", "defStyle", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "mRotationAngle", "", "value", "rawRotationAngle", "getRawRotationAngle", "()F", "isRotationEnabled", "", "()Z", "setRotationEnabled", "(Z)V", "minOffset", "getMinOffset", "setMinOffset", "(F)V", "init", "", "calcMinMax", "maxVisibleCount", "getMaxVisibleCount", "()I", "onTouchEvent", "event", "Landroid/view/MotionEvent;", "computeScroll", "notifyDataSetChanged", "calculateOffsets", "getAngleForPoint", "x", "y", "getPosition", "Linfo/appdev/charting/utils/PointF;", "center", "dist", "angle", "outputPoint", "distanceToCenter", "getIndexForAngle", "rotationAngle", "getRotationAngle", "setRotationAngle", "diameter", "getDiameter", "radius", "getRadius", "requiredLegendOffset", "getRequiredLegendOffset", "requiredBaseOffset", "getRequiredBaseOffset", "yChartMax", "getYChartMax", "yChartMin", "getYChartMin", "spin", "durationMillis", "fromAngle", "toAngle", "easing", "Linfo/appdev/charting/animation/Easing$EasingFunction;", "chartLib_release"})
public abstract class PieRadarChartBase<T extends ChartData<? extends IDataSet<? extends Entry>>>
extends Chart<T> {
    private float mRotationAngle = 270.0f;
    private float rawRotationAngle = 270.0f;
    private boolean isRotationEnabled = true;
    private float minOffset;

    public final float getRawRotationAngle() {
        return this.rawRotationAngle;
    }

    public final boolean isRotationEnabled() {
        return this.isRotationEnabled;
    }

    public final void setRotationEnabled(boolean bl) {
        this.isRotationEnabled = bl;
    }

    public final float getMinOffset() {
        return this.minOffset;
    }

    public final void setMinOffset(float f) {
        this.minOffset = f;
    }

    public PieRadarChartBase(@Nullable Context context) {
        super(context);
    }

    public PieRadarChartBase(@Nullable Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
    }

    public PieRadarChartBase(@Nullable Context context, @Nullable AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
    }

    @Override
    protected void init() {
        super.init();
        this.setChartTouchListener(new PieRadarChartTouchListener(this));
    }

    @Override
    protected void calcMinMax() {
    }

    @Override
    public int getMaxVisibleCount() {
        Object t = this.getMData();
        Intrinsics.checkNotNull(t);
        return ((ChartData)t).getEntryCount();
    }

    public boolean onTouchEvent(@Nullable MotionEvent event) {
        boolean bl;
        if (this.getMTouchEnabled() && this.getChartTouchListener() != null) {
            ChartTouchListener<?> chartTouchListener = this.getChartTouchListener();
            Intrinsics.checkNotNull(chartTouchListener);
            bl = chartTouchListener.onTouch((View)this, event);
        } else {
            bl = super.onTouchEvent(event);
        }
        return bl;
    }

    public void computeScroll() {
        if (this.getChartTouchListener() instanceof PieRadarChartTouchListener) {
            ChartTouchListener<?> chartTouchListener = this.getChartTouchListener();
            Intrinsics.checkNotNull(chartTouchListener, (String)"null cannot be cast to non-null type info.appdev.charting.listener.PieRadarChartTouchListener");
            ((PieRadarChartTouchListener)chartTouchListener).computeScroll();
        }
    }

    @Override
    public void notifyDataSetChanged() {
        if (this.getMData() == null) {
            return;
        }
        this.calcMinMax();
        LegendRenderer legendRenderer = this.getLegendRenderer();
        if (legendRenderer != null) {
            Object t = this.getMData();
            Intrinsics.checkNotNull(t);
            legendRenderer.computeLegend((ChartData<?>)t);
        }
        this.calculateOffsets();
    }

    @Override
    public void calculateOffsets() {
        XAxis x;
        float fullLegendWidth;
        float legendLeft = 0.0f;
        float legendRight = 0.0f;
        float legendBottom = 0.0f;
        float legendTop = 0.0f;
        if (this.getLegend().isEnabled() && !this.getLegend().isDrawInsideEnabled()) {
            fullLegendWidth = Math.min(this.getLegend().getNeededWidth(), this.getViewPortHandler().getChartWidth() * this.getLegend().getMaxSizePercent());
            float fullLegendHeight = Math.min(this.getLegend().getNeededHeight(), this.getViewPortHandler().getChartHeight() * this.getLegend().getMaxSizePercent());
            block0 : switch (WhenMappings.$EnumSwitchMapping$2[this.getLegend().getOrientation().ordinal()]) {
                case 1: {
                    switch (WhenMappings.$EnumSwitchMapping$0[this.getLegend().getHorizontalAlignment().ordinal()]) {
                        case 1: {
                            legendLeft = fullLegendWidth;
                            break block0;
                        }
                        case 2: {
                            legendRight = fullLegendWidth;
                            break block0;
                        }
                        case 3: {
                            break block0;
                        }
                    }
                    throw new NoWhenBranchMatchedException();
                }
                case 2: {
                    switch (WhenMappings.$EnumSwitchMapping$1[this.getLegend().getVerticalAlignment().ordinal()]) {
                        case 1: {
                            legendTop = fullLegendHeight;
                            break block0;
                        }
                        case 2: {
                            legendBottom = fullLegendHeight;
                            break block0;
                        }
                        case 3: {
                            break block0;
                        }
                    }
                    throw new NoWhenBranchMatchedException();
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
        }
        if (this.getLegend().isEnabled() && !this.getLegend().isDrawInsideEnabled()) {
            fullLegendWidth = Math.min(this.getLegend().getNeededWidth(), this.getViewPortHandler().getChartWidth() * this.getLegend().getMaxSizePercent());
            block14 : switch (WhenMappings.$EnumSwitchMapping$2[this.getLegend().getOrientation().ordinal()]) {
                case 1: {
                    float xLegendOffset = 0.0f;
                    if (this.getLegend().getHorizontalAlignment() == Legend.LegendHorizontalAlignment.LEFT || this.getLegend().getHorizontalAlignment() == Legend.LegendHorizontalAlignment.RIGHT) {
                        if (this.getLegend().getVerticalAlignment() == Legend.LegendVerticalAlignment.CENTER) {
                            spacing = NumberUtilsKt.convertDpToPixel(13.0f);
                            xLegendOffset = fullLegendWidth + spacing;
                        } else {
                            spacing = NumberUtilsKt.convertDpToPixel(8.0f);
                            float legendWidth = fullLegendWidth + spacing;
                            float legendHeight = this.getLegend().getNeededHeight() + this.getLegend().getMTextHeightMax();
                            float bottomX = this.getLegend().getHorizontalAlignment() == Legend.LegendHorizontalAlignment.RIGHT ? (float)this.getWidth() - legendWidth + 15.0f : legendWidth - 15.0f;
                            float bottomY = legendHeight + 15.0f;
                            float distLegend = this.distanceToCenter(bottomX, bottomY);
                            PointF reference = this.getPosition(this.getCenter(), this.getRadius(), this.getAngleForPoint(bottomX, bottomY));
                            float distReference = this.distanceToCenter(reference.getX(), reference.getY());
                            float minOffset = NumberUtilsKt.convertDpToPixel(5.0f);
                            if (bottomY >= this.getCenter().getY() && (float)this.getHeight() - legendWidth > (float)this.getWidth()) {
                                xLegendOffset = legendWidth;
                            } else if (distLegend < distReference) {
                                float diff = distReference - distLegend;
                                xLegendOffset = minOffset + diff;
                            }
                            PointF.Companion.recycleInstance(this.getCenter());
                            PointF.Companion.recycleInstance(reference);
                        }
                    }
                    switch (WhenMappings.$EnumSwitchMapping$0[this.getLegend().getHorizontalAlignment().ordinal()]) {
                        case 1: {
                            legendLeft = xLegendOffset;
                            break block14;
                        }
                        case 2: {
                            legendRight = xLegendOffset;
                            break block14;
                        }
                        case 3: {
                            switch (WhenMappings.$EnumSwitchMapping$1[this.getLegend().getVerticalAlignment().ordinal()]) {
                                case 1: {
                                    legendTop = Math.min(this.getLegend().getNeededHeight(), this.getViewPortHandler().getChartHeight() * this.getLegend().getMaxSizePercent());
                                    break block14;
                                }
                                case 2: {
                                    legendBottom = Math.min(this.getLegend().getNeededHeight(), this.getViewPortHandler().getChartHeight() * this.getLegend().getMaxSizePercent());
                                    break block14;
                                }
                                case 3: {
                                    Timber.Forest.e("LegendCenter/VerticalCenter not supported for PieRadarChart", new Object[0]);
                                    break block14;
                                }
                            }
                            throw new NoWhenBranchMatchedException();
                        }
                    }
                    throw new NoWhenBranchMatchedException();
                }
                case 2: {
                    float yLegendOffset = 0.0f;
                    if (this.getLegend().getVerticalAlignment() != Legend.LegendVerticalAlignment.TOP && this.getLegend().getVerticalAlignment() != Legend.LegendVerticalAlignment.BOTTOM) break;
                    float yOffset = this.getRequiredLegendOffset();
                    yLegendOffset = Math.min(this.getLegend().getNeededHeight() + yOffset, this.getViewPortHandler().getChartHeight() * this.getLegend().getMaxSizePercent());
                    switch (WhenMappings.$EnumSwitchMapping$1[this.getLegend().getVerticalAlignment().ordinal()]) {
                        case 1: {
                            legendTop = yLegendOffset;
                            break block14;
                        }
                        case 2: {
                            legendBottom = yLegendOffset;
                            break block14;
                        }
                        case 3: {
                            Timber.Forest.e("LegendCenter/HorizontalCenter not supported for PieRadarChart", new Object[0]);
                            break block14;
                        }
                    }
                    throw new NoWhenBranchMatchedException();
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            legendLeft += this.getRequiredBaseOffset();
            legendRight += this.getRequiredBaseOffset();
            legendTop += this.getRequiredBaseOffset();
            legendBottom += this.getRequiredBaseOffset();
        }
        float minOffset = NumberUtilsKt.convertDpToPixel(this.minOffset);
        if (this instanceof RadarChart && (x = ((RadarChart)this).getXAxis()).isEnabled() && x.isDrawLabelsEnabled()) {
            minOffset = Math.max(minOffset, (float)x.getMLabelWidth());
        }
        float offsetLeft = Math.max(minOffset, legendLeft += this.getExtraLeftOffset());
        float offsetTop = Math.max(minOffset, legendTop += this.getExtraTopOffset());
        float offsetRight = Math.max(minOffset, legendRight += this.getExtraRightOffset());
        float offsetBottom = Math.max(minOffset, Math.max(this.getRequiredBaseOffset(), legendBottom += this.getExtraBottomOffset()));
        ViewPortHandler.restrainViewPort$default(this.getViewPortHandler(), offsetLeft, offsetTop, offsetRight, offsetBottom, false, 16, null);
        if (this.isLogEnabled()) {
            Timber.Forest.i("offsetLeft: " + offsetLeft + ", offsetTop: " + offsetTop + ", offsetRight: " + offsetRight + ", offsetBottom: " + offsetBottom, new Object[0]);
        }
    }

    public final float getAngleForPoint(float x, float y) {
        PointF c = this.getCenterOffsets();
        boolean bl = false;
        double tx = x - c.getX();
        double ty = y - c.getY();
        double length = Math.sqrt(tx * tx + ty * ty);
        double r = Math.acos(ty / length);
        float angle = (float)Math.toDegrees(r);
        if (x > c.getX()) {
            angle = 360.0f - angle;
        }
        if ((angle += 90.0f) > 360.0f) {
            angle -= 360.0f;
        }
        PointF.Companion.recycleInstance(c);
        return angle;
    }

    @NotNull
    public final PointF getPosition(@NotNull PointF center, float dist, float angle) {
        Intrinsics.checkNotNullParameter((Object)center, (String)"center");
        PointF p = PointF.Companion.getInstance(0.0f, 0.0f);
        this.getPosition(center, dist, angle, p);
        return p;
    }

    public final void getPosition(@NotNull PointF center, float dist, float angle, @NotNull PointF outputPoint) {
        Intrinsics.checkNotNullParameter((Object)center, (String)"center");
        Intrinsics.checkNotNullParameter((Object)outputPoint, (String)"outputPoint");
        outputPoint.setX((float)((double)center.getX() + (double)dist * Math.cos(Math.toRadians(angle))));
        outputPoint.setY((float)((double)center.getY() + (double)dist * Math.sin(Math.toRadians(angle))));
    }

    public final float distanceToCenter(float x, float y) {
        PointF c = this.getCenterOffsets();
        boolean bl = false;
        float dist = 0.0f;
        float xDist = x > c.getX() ? x - c.getX() : c.getX() - x;
        float yDist = y > c.getY() ? y - c.getY() : c.getY() - y;
        dist = (float)Math.sqrt(Math.pow(xDist, 2.0) + Math.pow(yDist, 2.0));
        PointF.Companion.recycleInstance(c);
        return dist;
    }

    public abstract int getIndexForAngle(float var1);

    public final float getRotationAngle() {
        return this.mRotationAngle;
    }

    public final void setRotationAngle(float angle) {
        this.rawRotationAngle = angle;
        this.mRotationAngle = NumberUtilsKt.getNormalizedAngle(this.rawRotationAngle);
    }

    public final float getDiameter() {
        RectF content = this.getViewPortHandler().getContentRect();
        content.left += this.getExtraLeftOffset();
        content.top += this.getExtraTopOffset();
        content.right -= this.getExtraRightOffset();
        content.bottom -= this.getExtraBottomOffset();
        return Math.min(content.width(), content.height());
    }

    public abstract float getRadius();

    protected abstract float getRequiredLegendOffset();

    protected abstract float getRequiredBaseOffset();

    @Override
    public float getYChartMax() {
        return 0.0f;
    }

    @Override
    public float getYChartMin() {
        return 0.0f;
    }

    @SuppressLint(value={"NewApi"})
    public final void spin(int durationMillis, float fromAngle, float toAngle, @Nullable Easing.EasingFunction easing) {
        this.setRotationAngle(fromAngle);
        float[] fArray = new float[]{fromAngle, toAngle};
        ObjectAnimator spinAnimator = ObjectAnimator.ofFloat((Object)this, (String)"rotationAngle", (float[])fArray);
        spinAnimator.setDuration((long)durationMillis);
        spinAnimator.setInterpolator((TimeInterpolator)easing);
        spinAnimator.addUpdateListener(arg_0 -> PieRadarChartBase.spin$lambda$0(this, arg_0));
        spinAnimator.start();
    }

    private static final void spin$lambda$0(PieRadarChartBase this$0, ValueAnimator it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.postInvalidate();
    }

    @Metadata(mv={2, 3, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;
        public static final /* synthetic */ int[] $EnumSwitchMapping$2;

        static {
            int[] nArray = new int[Legend.LegendHorizontalAlignment.values().length];
            try {
                nArray[Legend.LegendHorizontalAlignment.LEFT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Legend.LegendHorizontalAlignment.RIGHT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Legend.LegendHorizontalAlignment.CENTER.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[Legend.LegendVerticalAlignment.values().length];
            try {
                nArray[Legend.LegendVerticalAlignment.TOP.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Legend.LegendVerticalAlignment.BOTTOM.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Legend.LegendVerticalAlignment.CENTER.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
            nArray = new int[Legend.LegendOrientation.values().length];
            try {
                nArray[Legend.LegendOrientation.VERTICAL.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Legend.LegendOrientation.HORIZONTAL.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$2 = nArray;
        }
    }
}

