/*
 * Decompiled with CFR 0.152.
 */
package info.appdev.charting.renderer;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PathEffect;
import android.graphics.RectF;
import info.appdev.charting.components.LimitLine;
import info.appdev.charting.components.LimitRange;
import info.appdev.charting.components.YAxis;
import info.appdev.charting.formatter.IAxisValueFormatter;
import info.appdev.charting.renderer.AxisRenderer;
import info.appdev.charting.utils.NumberUtilsKt;
import info.appdev.charting.utils.PaintUtilsKt;
import info.appdev.charting.utils.PointD;
import info.appdev.charting.utils.Transformer;
import info.appdev.charting.utils.ViewPortHandler;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0014\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\b\n\u0002\b\u001b\b\u0016\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0018\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\u0010\u0010 \u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J(\u0010!\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\"\u001a\u00020\u00152\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\u0015H\u0014J\u0010\u0010,\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\"\u00105\u001a\u0004\u0018\u00010'2\u0006\u00106\u001a\u00020'2\u0006\u00107\u001a\u0002082\u0006\u0010#\u001a\u00020$H\u0014J\u0010\u0010F\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0014J\u0010\u0010J\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016R\u001a\u0010\u0004\u001a\u00020\u0005X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\u00020\u000fX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u001a\u0010&\u001a\u00020'X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b(\u0010)\"\u0004\b*\u0010+R\u001a\u0010-\u001a\u00020.X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b/\u00100\"\u0004\b1\u00102R\u0016\u00103\u001a\u0004\u0018\u00010.8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b4\u00100R\u001a\u00109\u001a\u00020$X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b:\u0010;\"\u0004\b<\u0010=R\u0014\u0010>\u001a\u00020$8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b?\u0010;R\u001a\u0010@\u001a\u00020'X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bA\u0010)\"\u0004\bB\u0010+R\u001a\u0010C\u001a\u00020.X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bD\u00100\"\u0004\bE\u00102R\u001a\u0010G\u001a\u00020'X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bH\u0010)\"\u0004\bI\u0010+R\u001a\u0010J\u001a\u00020'X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bK\u0010)\"\u0004\bL\u0010+R\u001a\u0010M\u001a\u00020$X\u0094\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bN\u0010;\"\u0004\bO\u0010=R\u001a\u0010P\u001a\u00020.X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bQ\u00100\"\u0004\bR\u00102\u00a8\u0006S"}, d2={"Linfo/appdev/charting/renderer/YAxisRenderer;", "Linfo/appdev/charting/renderer/AxisRenderer;", "viewPortHandler", "Linfo/appdev/charting/utils/ViewPortHandler;", "yAxis", "Linfo/appdev/charting/components/YAxis;", "trans", "Linfo/appdev/charting/utils/Transformer;", "<init>", "(Linfo/appdev/charting/utils/ViewPortHandler;Linfo/appdev/charting/components/YAxis;Linfo/appdev/charting/utils/Transformer;)V", "getYAxis", "()Linfo/appdev/charting/components/YAxis;", "setYAxis", "(Linfo/appdev/charting/components/YAxis;)V", "zeroLinePaint", "Landroid/graphics/Paint;", "getZeroLinePaint", "()Landroid/graphics/Paint;", "setZeroLinePaint", "(Landroid/graphics/Paint;)V", "calculateAxisLabelsXPosition", "", "dependency", "Linfo/appdev/charting/components/YAxis$AxisDependency;", "labelPosition", "Linfo/appdev/charting/components/YAxis$YAxisLabelPosition;", "getAxisLabelTextAlign", "Landroid/graphics/Paint$Align;", "renderAxisLabels", "", "canvas", "Landroid/graphics/Canvas;", "renderAxisLine", "drawYLabels", "fixedPosition", "positions", "", "offset", "renderGridLinesPath", "Landroid/graphics/Path;", "getRenderGridLinesPath", "()Landroid/graphics/Path;", "setRenderGridLinesPath", "(Landroid/graphics/Path;)V", "renderGridLines", "mGridClippingRect", "Landroid/graphics/RectF;", "getMGridClippingRect", "()Landroid/graphics/RectF;", "setMGridClippingRect", "(Landroid/graphics/RectF;)V", "gridClippingRect", "getGridClippingRect", "linePath", "p", "i", "", "mGetTransformedPositionsBuffer", "getMGetTransformedPositionsBuffer", "()[F", "setMGetTransformedPositionsBuffer", "([F)V", "transformedPositions", "getTransformedPositions", "drawZeroLinePath", "getDrawZeroLinePath", "setDrawZeroLinePath", "zeroLineClippingRect", "getZeroLineClippingRect", "setZeroLineClippingRect", "drawZeroLine", "renderLimitRanges", "getRenderLimitRanges", "setRenderLimitRanges", "renderLimitLines", "getRenderLimitLines", "setRenderLimitLines", "renderLimitLinesBuffer", "getRenderLimitLinesBuffer", "setRenderLimitLinesBuffer", "limitLineClippingRect", "getLimitLineClippingRect", "setLimitLineClippingRect", "chartLib_release"})
@SourceDebugExtension(value={"SMAP\nYAxisRenderer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 YAxisRenderer.kt\ninfo/appdev/charting/renderer/YAxisRenderer\n+ 2 Canvas.kt\nandroidx/core/graphics/CanvasKt\n*L\n1#1,490:1\n135#2,8:491\n27#2,7:499\n*S KotlinDebug\n*F\n+ 1 YAxisRenderer.kt\ninfo/appdev/charting/renderer/YAxisRenderer\n*L\n145#1:491,8\n286#1:499,7\n*E\n"})
public class YAxisRenderer
extends AxisRenderer {
    @NotNull
    private YAxis yAxis;
    @NotNull
    private Paint zeroLinePaint;
    @NotNull
    private Path renderGridLinesPath;
    @NotNull
    private RectF mGridClippingRect;
    @NotNull
    private float[] mGetTransformedPositionsBuffer;
    @NotNull
    private Path drawZeroLinePath;
    @NotNull
    private RectF zeroLineClippingRect;
    @NotNull
    private Path renderLimitRanges;
    @NotNull
    private Path renderLimitLines;
    @NotNull
    private float[] renderLimitLinesBuffer;
    @NotNull
    private RectF limitLineClippingRect;

    /*
     * WARNING - void declaration
     */
    public YAxisRenderer(@NotNull ViewPortHandler viewPortHandler, @NotNull YAxis yAxis, @Nullable Transformer trans) {
        void $this$zeroLinePaint_u24lambda_u240;
        Paint paint;
        Intrinsics.checkNotNullParameter((Object)viewPortHandler, (String)"viewPortHandler");
        Intrinsics.checkNotNullParameter((Object)yAxis, (String)"yAxis");
        super(viewPortHandler, trans, yAxis);
        this.yAxis = yAxis;
        Paint paint2 = paint = new Paint(1);
        YAxisRenderer yAxisRenderer = this;
        boolean bl = false;
        $this$zeroLinePaint_u24lambda_u240.setColor(-7829368);
        $this$zeroLinePaint_u24lambda_u240.setStrokeWidth(1.0f);
        $this$zeroLinePaint_u24lambda_u240.setStyle(Paint.Style.STROKE);
        yAxisRenderer.zeroLinePaint = paint;
        this.renderGridLinesPath = new Path();
        this.mGridClippingRect = new RectF();
        this.mGetTransformedPositionsBuffer = new float[2];
        this.drawZeroLinePath = new Path();
        this.zeroLineClippingRect = new RectF();
        this.renderLimitRanges = new Path();
        this.renderLimitLines = new Path();
        this.renderLimitLinesBuffer = new float[2];
        this.limitLineClippingRect = new RectF();
        Paint $this$_init__u24lambda_u240 = paint = this.getPaintAxisLabels();
        boolean bl2 = false;
        $this$_init__u24lambda_u240.setColor(-16777216);
        $this$_init__u24lambda_u240.setTextSize(NumberUtilsKt.convertDpToPixel(10.0f));
    }

    @NotNull
    protected final YAxis getYAxis() {
        return this.yAxis;
    }

    protected final void setYAxis(@NotNull YAxis yAxis) {
        Intrinsics.checkNotNullParameter((Object)yAxis, (String)"<set-?>");
        this.yAxis = yAxis;
    }

    @NotNull
    protected final Paint getZeroLinePaint() {
        return this.zeroLinePaint;
    }

    protected final void setZeroLinePaint(@NotNull Paint paint) {
        Intrinsics.checkNotNullParameter((Object)paint, (String)"<set-?>");
        this.zeroLinePaint = paint;
    }

    private final float calculateAxisLabelsXPosition(YAxis.AxisDependency dependency, YAxis.YAxisLabelPosition labelPosition) {
        float viewPortBase = dependency == YAxis.AxisDependency.LEFT ? this.getViewPortHandler().offsetLeft() : this.getViewPortHandler().contentRight();
        float xOffset = this.yAxis.getXOffset() * (float)(labelPosition == YAxis.YAxisLabelPosition.OUTSIDE_CHART ? -1 : 1);
        return viewPortBase + xOffset;
    }

    private final Paint.Align getAxisLabelTextAlign(YAxis.AxisDependency dependency, YAxis.YAxisLabelPosition labelPosition) {
        if (dependency == YAxis.AxisDependency.LEFT ^ labelPosition == YAxis.YAxisLabelPosition.OUTSIDE_CHART) {
            return Paint.Align.LEFT;
        }
        return Paint.Align.RIGHT;
    }

    @Override
    public void renderAxisLabels(@NotNull Canvas canvas) {
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        if (!this.yAxis.isEnabled() || !this.yAxis.isDrawLabelsEnabled()) {
            return;
        }
        float[] positions = this.getTransformedPositions();
        this.getPaintAxisLabels().setTypeface(this.yAxis.getTypeface());
        this.getPaintAxisLabels().setTextSize(this.yAxis.getTextSize());
        this.getPaintAxisLabels().setColor(this.yAxis.getTextColor());
        float yOffset = (float)PaintUtilsKt.calcTextHeight(this.getPaintAxisLabels(), "A") / 2.5f + this.yAxis.getYOffset();
        YAxis.AxisDependency axisDependency = this.yAxis.getAxisDependency();
        YAxis.YAxisLabelPosition labelPosition = this.yAxis.getLabelPosition();
        if (axisDependency != null && labelPosition != null) {
            float xPos = this.calculateAxisLabelsXPosition(axisDependency, labelPosition);
            this.getPaintAxisLabels().setTextAlign(this.getAxisLabelTextAlign(axisDependency, labelPosition));
            this.drawYLabels(canvas, xPos, positions, yOffset);
        }
    }

    @Override
    public void renderAxisLine(@NotNull Canvas canvas) {
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        if (!this.yAxis.isEnabled() || !this.yAxis.isDrawAxisLineEnabled()) {
            return;
        }
        this.getPaintAxisLine().setColor(this.yAxis.getAxisLineColor());
        this.getPaintAxisLine().setStrokeWidth(this.yAxis.getAxisLineWidth());
        if (this.yAxis.getAxisDependency() == YAxis.AxisDependency.LEFT) {
            canvas.drawLine(this.getViewPortHandler().contentLeft(), this.getViewPortHandler().contentTop(), this.getViewPortHandler().contentLeft(), this.getViewPortHandler().contentBottom(), this.getPaintAxisLine());
        } else {
            canvas.drawLine(this.getViewPortHandler().contentRight(), this.getViewPortHandler().contentTop(), this.getViewPortHandler().contentRight(), this.getViewPortHandler().contentBottom(), this.getPaintAxisLine());
        }
    }

    protected void drawYLabels(@NotNull Canvas canvas, float fixedPosition, @NotNull float[] positions, float offset) {
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        Intrinsics.checkNotNullParameter((Object)positions, (String)"positions");
        int from = 0;
        int to = 0;
        if (this.yAxis.isShowSpecificPositions()) {
            from = 0;
            to = this.yAxis.isDrawTopYLabelEntryEnabled() ? this.yAxis.getSpecificPositions().length : this.yAxis.getSpecificPositions().length - 1;
        } else {
            from = this.yAxis.isDrawBottomYLabelEntryEnabled() ? 0 : 1;
            to = this.yAxis.isDrawTopYLabelEntryEnabled() ? this.yAxis.getEntryCount() : this.yAxis.getEntryCount() - 1;
        }
        float xOffset = this.yAxis.getLabelXOffset();
        for (int i = from; i < to; ++i) {
            String text;
            String string;
            if (this.yAxis.isShowSpecificPositions()) {
                IAxisValueFormatter iAxisValueFormatter = this.yAxis.getValueFormatter();
                string = iAxisValueFormatter != null ? iAxisValueFormatter.getFormattedValue(this.yAxis.getSpecificPositions()[i], this.yAxis) : null;
            } else {
                string = this.yAxis.getFormattedLabel(i);
            }
            String string2 = text = string;
            Intrinsics.checkNotNull((Object)string2);
            canvas.drawText(string2, fixedPosition + xOffset, positions[i * 2 + 1] + offset, this.getPaintAxisLabels());
        }
    }

    @NotNull
    protected final Path getRenderGridLinesPath() {
        return this.renderGridLinesPath;
    }

    protected final void setRenderGridLinesPath(@NotNull Path path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"<set-?>");
        this.renderGridLinesPath = path;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public void renderGridLines(@NotNull Canvas canvas) {
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        if (!this.yAxis.isEnabled()) {
            return;
        }
        if (this.yAxis.isDrawGridLinesEnabled()) {
            void $this$withClip$iv;
            Canvas canvas2 = canvas;
            RectF rectF = this.getGridClippingRect();
            Intrinsics.checkNotNull((Object)rectF);
            RectF clipRect$iv = rectF;
            boolean $i$f$withClip = false;
            int checkpoint$iv = $this$withClip$iv.save();
            $this$withClip$iv.clipRect(clipRect$iv);
            try {
                void $this$renderGridLines_u24lambda_u240 = $this$withClip$iv;
                boolean bl = false;
                float[] positions = this.getTransformedPositions();
                this.getPaintGrid().setColor(this.yAxis.getGridColor());
                this.getPaintGrid().setStrokeWidth(this.yAxis.getGridLineWidth());
                this.getPaintGrid().setPathEffect((PathEffect)this.yAxis.getGridDashPathEffect());
                Path gridLinePath = this.renderGridLinesPath;
                gridLinePath.reset();
                for (int i = 0; i < positions.length; i += 2) {
                    Path path = this.linePath(gridLinePath, i, positions);
                    Intrinsics.checkNotNull((Object)path);
                    canvas.drawPath(path, this.getPaintGrid());
                    gridLinePath.reset();
                }
            }
            finally {
                $this$withClip$iv.restoreToCount(checkpoint$iv);
            }
        }
        if (this.yAxis.isDrawZeroLineEnabled()) {
            this.drawZeroLine(canvas);
        }
    }

    @NotNull
    protected final RectF getMGridClippingRect() {
        return this.mGridClippingRect;
    }

    protected final void setMGridClippingRect(@NotNull RectF rectF) {
        Intrinsics.checkNotNullParameter((Object)rectF, (String)"<set-?>");
        this.mGridClippingRect = rectF;
    }

    @Nullable
    public RectF getGridClippingRect() {
        this.mGridClippingRect.set(this.getViewPortHandler().getContentRect());
        this.mGridClippingRect.inset(0.0f, -this.getAxis().getGridLineWidth());
        return this.mGridClippingRect;
    }

    @Nullable
    protected Path linePath(@NotNull Path p, int i, @NotNull float[] positions) {
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        Intrinsics.checkNotNullParameter((Object)positions, (String)"positions");
        p.moveTo(this.getViewPortHandler().offsetLeft(), positions[i + 1]);
        p.lineTo(this.getViewPortHandler().contentRight(), positions[i + 1]);
        return p;
    }

    @NotNull
    protected final float[] getMGetTransformedPositionsBuffer() {
        return this.mGetTransformedPositionsBuffer;
    }

    protected final void setMGetTransformedPositionsBuffer(@NotNull float[] fArray) {
        Intrinsics.checkNotNullParameter((Object)fArray, (String)"<set-?>");
        this.mGetTransformedPositionsBuffer = fArray;
    }

    @NotNull
    protected float[] getTransformedPositions() {
        float[] positions;
        block5: {
            if (this.yAxis.isShowSpecificPositions()) {
                if (this.mGetTransformedPositionsBuffer.length != this.yAxis.getSpecificPositions().length * 2) {
                    this.mGetTransformedPositionsBuffer = new float[this.yAxis.getSpecificPositions().length * 2];
                }
            } else if (this.mGetTransformedPositionsBuffer.length != this.yAxis.getEntryCount() * 2) {
                this.mGetTransformedPositionsBuffer = new float[this.yAxis.getEntryCount() * 2];
            }
            positions = this.mGetTransformedPositionsBuffer;
            for (int i = 0; i < positions.length; i += 2) {
                positions[i + 1] = this.yAxis.isShowSpecificPositions() ? this.yAxis.getSpecificPositions()[i / 2] : this.yAxis.getEntries()[i / 2];
            }
            Transformer transformer = this.getTransformer();
            if (transformer == null) break block5;
            transformer.pointValuesToPixel(positions);
        }
        return positions;
    }

    @NotNull
    protected final Path getDrawZeroLinePath() {
        return this.drawZeroLinePath;
    }

    protected final void setDrawZeroLinePath(@NotNull Path path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"<set-?>");
        this.drawZeroLinePath = path;
    }

    @NotNull
    protected final RectF getZeroLineClippingRect() {
        return this.zeroLineClippingRect;
    }

    protected final void setZeroLineClippingRect(@NotNull RectF rectF) {
        Intrinsics.checkNotNullParameter((Object)rectF, (String)"<set-?>");
        this.zeroLineClippingRect = rectF;
    }

    protected void drawZeroLine(@NotNull Canvas canvas) {
        PointD pos;
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        int clipRestoreCount = canvas.save();
        this.zeroLineClippingRect.set(this.getViewPortHandler().getContentRect());
        this.zeroLineClippingRect.inset(0.0f, -this.yAxis.getZeroLineWidth());
        canvas.clipRect(this.zeroLineClippingRect);
        Transformer transformer = this.getTransformer();
        PointD pointD = pos = transformer != null ? transformer.getPixelForValues(0.0f, 0.0f) : null;
        if (pointD != null) {
            PointD it = pointD;
            boolean bl = false;
            this.zeroLinePaint.setColor(this.yAxis.getZeroLineColor());
            this.zeroLinePaint.setStrokeWidth(this.yAxis.getZeroLineWidth());
            Path zeroLinePath = this.drawZeroLinePath;
            zeroLinePath.reset();
            zeroLinePath.moveTo(this.getViewPortHandler().contentLeft(), (float)it.getY());
            zeroLinePath.lineTo(this.getViewPortHandler().contentRight(), (float)it.getY());
            canvas.drawPath(zeroLinePath, this.zeroLinePaint);
        }
        canvas.restoreToCount(clipRestoreCount);
    }

    @NotNull
    protected final Path getRenderLimitRanges() {
        return this.renderLimitRanges;
    }

    protected final void setRenderLimitRanges(@NotNull Path path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"<set-?>");
        this.renderLimitRanges = path;
    }

    @NotNull
    protected final Path getRenderLimitLines() {
        return this.renderLimitLines;
    }

    protected final void setRenderLimitLines(@NotNull Path path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"<set-?>");
        this.renderLimitLines = path;
    }

    @NotNull
    protected float[] getRenderLimitLinesBuffer() {
        return this.renderLimitLinesBuffer;
    }

    protected void setRenderLimitLinesBuffer(@NotNull float[] fArray) {
        Intrinsics.checkNotNullParameter((Object)fArray, (String)"<set-?>");
        this.renderLimitLinesBuffer = fArray;
    }

    @NotNull
    protected final RectF getLimitLineClippingRect() {
        return this.limitLineClippingRect;
    }

    protected final void setLimitLineClippingRect(@NotNull RectF rectF) {
        Intrinsics.checkNotNullParameter((Object)rectF, (String)"<set-?>");
        this.limitLineClippingRect = rectF;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void renderLimitLines(@NotNull Canvas canvas) {
        List<LimitRange> limitRanges;
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        List<LimitLine> limitLines = this.yAxis.getLimitLines();
        if (!((Collection)limitLines).isEmpty()) {
            float[] pts = this.getRenderLimitLinesBuffer();
            pts[0] = 0.0f;
            pts[1] = 0.0f;
            Path limitLinePath = this.renderLimitLines;
            limitLinePath.reset();
            int n = ((Collection)limitLines).size();
            for (int i = 0; i < n; ++i) {
                LimitLine limitLine = limitLines.get(i);
                if (!limitLine.isEnabled()) continue;
                Canvas $this$withSave$iv = canvas;
                boolean $i$f$withSave = false;
                int checkpoint$iv = $this$withSave$iv.save();
                try {
                    LimitLine.LimitLabelPosition position;
                    Canvas $this$renderLimitLines_u24lambda_u240 = $this$withSave$iv;
                    boolean bl = false;
                    this.limitLineClippingRect.set(this.getViewPortHandler().getContentRect());
                    this.limitLineClippingRect.inset(0.0f, -limitLine.getLineWidth());
                    canvas.clipRect(this.limitLineClippingRect);
                    this.getLimitLinePaint().setStyle(Paint.Style.STROKE);
                    this.getLimitLinePaint().setColor(limitLine.getLineColor());
                    this.getLimitLinePaint().setStrokeWidth(limitLine.getLineWidth());
                    this.getLimitLinePaint().setPathEffect((PathEffect)limitLine.getDashPathEffect());
                    pts[1] = limitLine.getLimit();
                    Transformer transformer = this.getTransformer();
                    if (transformer != null) {
                        transformer.pointValuesToPixel(pts);
                    }
                    limitLinePath.moveTo(this.getViewPortHandler().contentLeft(), pts[1]);
                    limitLinePath.lineTo(this.getViewPortHandler().contentRight(), pts[1]);
                    canvas.drawPath(limitLinePath, this.getLimitLinePaint());
                    limitLinePath.reset();
                    String label = limitLine.getLabel();
                    if (label == null || Intrinsics.areEqual((Object)label, (Object)"")) continue;
                    this.getLimitLinePaint().setStyle(limitLine.getTextStyle());
                    this.getLimitLinePaint().setPathEffect(null);
                    this.getLimitLinePaint().setColor(limitLine.getTextColor());
                    this.getLimitLinePaint().setTypeface(limitLine.getTypeface());
                    this.getLimitLinePaint().setStrokeWidth(0.5f);
                    this.getLimitLinePaint().setTextSize(limitLine.getTextSize());
                    float labelLineHeight = PaintUtilsKt.calcTextHeight(this.getLimitLinePaint(), label);
                    float xOffset = NumberUtilsKt.convertDpToPixel(4.0f) + limitLine.getXOffset();
                    float yOffset = limitLine.getLineWidth() + labelLineHeight + limitLine.getYOffset();
                    LimitLine.LimitLabelPosition limitLabelPosition = position = limitLine.getLabelPosition();
                    switch (limitLabelPosition == null ? -1 : WhenMappings.$EnumSwitchMapping$0[limitLabelPosition.ordinal()]) {
                        case 1: {
                            this.getLimitLinePaint().setTextAlign(Paint.Align.RIGHT);
                            canvas.drawText(label, this.getViewPortHandler().contentRight() - xOffset, pts[1] - yOffset + labelLineHeight, this.getLimitLinePaint());
                            break;
                        }
                        case 2: {
                            this.getLimitLinePaint().setTextAlign(Paint.Align.RIGHT);
                            canvas.drawText(label, this.getViewPortHandler().contentRight() - xOffset, pts[1] + yOffset, this.getLimitLinePaint());
                            break;
                        }
                        case 3: {
                            this.getLimitLinePaint().setTextAlign(Paint.Align.LEFT);
                            canvas.drawText(label, this.getViewPortHandler().contentLeft() + xOffset, pts[1] - yOffset + labelLineHeight, this.getLimitLinePaint());
                            break;
                        }
                        default: {
                            this.getLimitLinePaint().setTextAlign(Paint.Align.LEFT);
                            canvas.drawText(label, this.getViewPortHandler().offsetLeft() + xOffset, pts[1] + yOffset, this.getLimitLinePaint());
                        }
                    }
                    continue;
                }
                finally {
                    $this$withSave$iv.restoreToCount(checkpoint$iv);
                }
            }
        }
        if (!((Collection)(limitRanges = this.yAxis.getLimitRanges())).isEmpty()) {
            float[] ptsr = new float[]{0.0f, 0.0f};
            float[] ptsr2 = new float[]{0.0f, 0.0f};
            Path limitRangePath = this.renderLimitRanges;
            Path limitRangePathFill = this.renderLimitRanges;
            limitRangePath.reset();
            limitRangePathFill.reset();
            int n = ((Collection)limitRanges).size();
            for (int limitRangeIndex = 0; limitRangeIndex < n; ++limitRangeIndex) {
                LimitRange limitRange = limitRanges.get(limitRangeIndex);
                if (!limitRange.isEnabled()) continue;
                int clipRestoreCount = canvas.save();
                this.limitLineClippingRect.set(this.getViewPortHandler().getContentRect());
                this.limitLineClippingRect.inset(0.0f, -limitRange.getLineWidth());
                canvas.clipRect(this.limitLineClippingRect);
                this.getLimitRangePaint().setStyle(Paint.Style.STROKE);
                this.getLimitRangePaint().setColor(limitRange.getLineColor());
                this.getLimitRangePaint().setStrokeWidth(limitRange.getLineWidth());
                this.getLimitRangePaint().setPathEffect((PathEffect)limitRange.getDashPathEffect());
                this.getLimitRangePaintFill().setStyle(Paint.Style.FILL);
                this.getLimitRangePaintFill().setColor(limitRange.getRangeColor());
                ptsr[1] = limitRange.getLimit().getHigh();
                ptsr2[1] = limitRange.getLimit().getLow();
                Transformer transformer = this.getTransformer();
                if (transformer != null) {
                    transformer.pointValuesToPixel(ptsr);
                }
                Transformer transformer2 = this.getTransformer();
                if (transformer2 != null) {
                    transformer2.pointValuesToPixel(ptsr2);
                }
                limitRangePathFill.moveTo(this.getViewPortHandler().contentLeft(), ptsr[1]);
                limitRangePathFill.addRect(this.getViewPortHandler().contentLeft(), ptsr[1], this.getViewPortHandler().contentRight(), ptsr2[1], Path.Direction.CW);
                canvas.drawPath(limitRangePathFill, this.getLimitRangePaintFill());
                limitRangePathFill.reset();
                if (limitRange.getLineWidth() > 0.0f) {
                    limitRangePath.moveTo(this.getViewPortHandler().contentLeft(), ptsr[1]);
                    limitRangePath.lineTo(this.getViewPortHandler().contentRight(), ptsr[1]);
                    canvas.drawPath(limitRangePath, this.getLimitRangePaint());
                    limitRangePath.moveTo(this.getViewPortHandler().contentLeft(), ptsr2[1]);
                    limitRangePath.lineTo(this.getViewPortHandler().contentRight(), ptsr2[1]);
                    canvas.drawPath(limitRangePath, this.getLimitRangePaint());
                }
                limitRangePath.reset();
                String label = limitRange.getLabel();
                if (label != null && !Intrinsics.areEqual((Object)label, (Object)"")) {
                    LimitLine.LimitLabelPosition position;
                    this.getLimitRangePaint().setStyle(limitRange.getTextStyle());
                    this.getLimitRangePaint().setPathEffect(null);
                    this.getLimitRangePaint().setColor(limitRange.getTextColor());
                    this.getLimitRangePaint().setTypeface(limitRange.getTypeface());
                    this.getLimitRangePaint().setStrokeWidth(0.5f);
                    this.getLimitRangePaint().setTextSize(limitRange.getTextSize());
                    float labelLineHeight = PaintUtilsKt.calcTextHeight(this.getLimitRangePaint(), label);
                    float xOffset = NumberUtilsKt.convertDpToPixel(4.0f) + limitRange.getXOffset();
                    float yOffset = limitRange.getLineWidth() + labelLineHeight + limitRange.getYOffset();
                    LimitLine.LimitLabelPosition limitLabelPosition = position = limitRange.getLabelPosition();
                    switch (limitLabelPosition == null ? -1 : WhenMappings.$EnumSwitchMapping$0[limitLabelPosition.ordinal()]) {
                        case 1: {
                            this.getLimitRangePaint().setTextAlign(Paint.Align.RIGHT);
                            canvas.drawText(label, this.getViewPortHandler().contentRight() - xOffset, ptsr[1] - yOffset + labelLineHeight, this.getLimitRangePaint());
                            break;
                        }
                        case 2: {
                            this.getLimitRangePaint().setTextAlign(Paint.Align.RIGHT);
                            canvas.drawText(label, this.getViewPortHandler().contentRight() - xOffset, ptsr[1] + yOffset, this.getLimitRangePaint());
                            break;
                        }
                        case 3: {
                            this.getLimitRangePaint().setTextAlign(Paint.Align.LEFT);
                            canvas.drawText(label, this.getViewPortHandler().contentLeft() + xOffset, ptsr[1] - yOffset + labelLineHeight, this.getLimitRangePaint());
                            break;
                        }
                        default: {
                            this.getLimitRangePaint().setTextAlign(Paint.Align.LEFT);
                            canvas.drawText(label, this.getViewPortHandler().offsetLeft() + xOffset, ptsr[1] + yOffset, this.getLimitRangePaint());
                        }
                    }
                }
                canvas.restoreToCount(clipRestoreCount);
            }
        }
    }

    @Metadata(mv={2, 3, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[LimitLine.LimitLabelPosition.values().length];
            try {
                nArray[LimitLine.LimitLabelPosition.RIGHT_TOP.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LimitLine.LimitLabelPosition.RIGHT_BOTTOM.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LimitLine.LimitLabelPosition.LEFT_TOP.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

