/*
 * Decompiled with CFR 0.152.
 */
package info.appdev.charting.renderer;

import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.drawable.Drawable;
import info.appdev.charting.animation.ChartAnimator;
import info.appdev.charting.charts.RadarChart;
import info.appdev.charting.data.Entry;
import info.appdev.charting.data.RadarData;
import info.appdev.charting.data.RadarEntry;
import info.appdev.charting.highlight.Highlight;
import info.appdev.charting.interfaces.datasets.IRadarDataSet;
import info.appdev.charting.renderer.LineRadarRenderer;
import info.appdev.charting.utils.CanvasUtilsKt;
import info.appdev.charting.utils.ColorTemplate;
import info.appdev.charting.utils.NumberUtilsKt;
import info.appdev.charting.utils.PointF;
import info.appdev.charting.utils.PointFKt;
import info.appdev.charting.utils.ViewPortHandler;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0005\b\u0016\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\u001d\u001a\u00020\u001eH\u0016J\u0010\u0010\u001f\u001a\u00020\u001e2\u0006\u0010 \u001a\u00020!H\u0016J \u0010'\u001a\u00020\u001e2\u0006\u0010 \u001a\u00020!2\u0006\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020+H\u0004J\u0010\u0010,\u001a\u00020\u001e2\u0006\u0010 \u001a\u00020!H\u0016J\u0010\u0010-\u001a\u00020\u001e2\u0006\u0010 \u001a\u00020!H\u0016J\u0010\u0010.\u001a\u00020\u001e2\u0006\u0010 \u001a\u00020!H\u0004J#\u0010/\u001a\u00020\u001e2\u0006\u0010 \u001a\u00020!2\f\u00100\u001a\b\u0012\u0004\u0012\u00020201H\u0016\u00a2\u0006\u0002\u00103J>\u00107\u001a\u00020\u001e2\u0006\u0010 \u001a\u00020!2\u0006\u00108\u001a\u0002092\u0006\u0010:\u001a\u00020;2\u0006\u0010<\u001a\u00020;2\u0006\u0010=\u001a\u00020+2\u0006\u0010>\u001a\u00020+2\u0006\u0010?\u001a\u00020;R\u001a\u0010\u0002\u001a\u00020\u0003X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR$\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020\u000f@DX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0015\u001a\u00020\u000fX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0012\"\u0004\b\u0017\u0010\u0014R\u000e\u0010\u0018\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\"\u001a\u00020\u001aX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010$\"\u0004\b%\u0010&R\u001a\u00104\u001a\u00020\u001aX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b5\u0010$\"\u0004\b6\u0010&\u00a8\u0006@"}, d2={"Linfo/appdev/charting/renderer/RadarChartRenderer;", "Linfo/appdev/charting/renderer/LineRadarRenderer;", "chart", "Linfo/appdev/charting/charts/RadarChart;", "animator", "Linfo/appdev/charting/animation/ChartAnimator;", "viewPortHandler", "Linfo/appdev/charting/utils/ViewPortHandler;", "<init>", "(Linfo/appdev/charting/charts/RadarChart;Linfo/appdev/charting/animation/ChartAnimator;Linfo/appdev/charting/utils/ViewPortHandler;)V", "getChart", "()Linfo/appdev/charting/charts/RadarChart;", "setChart", "(Linfo/appdev/charting/charts/RadarChart;)V", "value", "Landroid/graphics/Paint;", "webPaint", "getWebPaint", "()Landroid/graphics/Paint;", "setWebPaint", "(Landroid/graphics/Paint;)V", "highlightCirclePaint", "getHighlightCirclePaint", "setHighlightCirclePaint", "paint", "previousPath", "Landroid/graphics/Path;", "innerAreaPath", "tempPath", "initBuffers", "", "drawData", "canvas", "Landroid/graphics/Canvas;", "drawDataSetSurfacePathBuffer", "getDrawDataSetSurfacePathBuffer", "()Landroid/graphics/Path;", "setDrawDataSetSurfacePathBuffer", "(Landroid/graphics/Path;)V", "drawDataSet", "dataSet", "Linfo/appdev/charting/interfaces/datasets/IRadarDataSet;", "mostEntries", "", "drawValues", "drawExtras", "drawWeb", "drawHighlighted", "indices", "", "Linfo/appdev/charting/highlight/Highlight;", "(Landroid/graphics/Canvas;[Linfo/appdev/charting/highlight/Highlight;)V", "mDrawHighlightCirclePathBuffer", "getMDrawHighlightCirclePathBuffer", "setMDrawHighlightCirclePathBuffer", "drawHighlightCircle", "point", "Linfo/appdev/charting/utils/PointF;", "innerRadius", "", "outerRadius", "fillColor", "strokeColor", "strokeWidth", "chartLib_release"})
@SourceDebugExtension(value={"SMAP\nRadarChartRenderer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RadarChartRenderer.kt\ninfo/appdev/charting/renderer/RadarChartRenderer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Canvas.kt\nandroidx/core/graphics/CanvasKt\n*L\n1#1,402:1\n1915#2,2:403\n27#3,7:405\n*S KotlinDebug\n*F\n+ 1 RadarChartRenderer.kt\ninfo/appdev/charting/renderer/RadarChartRenderer\n*L\n41#1:403,2\n376#1:405,7\n*E\n"})
public class RadarChartRenderer
extends LineRadarRenderer {
    @NotNull
    private RadarChart chart;
    @NotNull
    private Paint webPaint;
    @NotNull
    private Paint highlightCirclePaint;
    @NotNull
    private final Paint paint;
    @NotNull
    private final Path previousPath;
    @NotNull
    private final Path innerAreaPath;
    @NotNull
    private final Path tempPath;
    @NotNull
    private Path drawDataSetSurfacePathBuffer;
    @NotNull
    private Path mDrawHighlightCirclePathBuffer;

    public RadarChartRenderer(@NotNull RadarChart chart, @NotNull ChartAnimator animator, @NotNull ViewPortHandler viewPortHandler) {
        Intrinsics.checkNotNullParameter((Object)chart, (String)"chart");
        Intrinsics.checkNotNullParameter((Object)animator, (String)"animator");
        Intrinsics.checkNotNullParameter((Object)viewPortHandler, (String)"viewPortHandler");
        super(animator, viewPortHandler);
        this.chart = chart;
        this.paint = new Paint(1);
        this.previousPath = new Path();
        this.innerAreaPath = new Path();
        this.tempPath = new Path();
        this.drawDataSetSurfacePathBuffer = new Path();
        this.mDrawHighlightCirclePathBuffer = new Path();
        this.setPaintHighlight(new Paint(1));
        this.getPaintHighlight().setStyle(Paint.Style.STROKE);
        this.getPaintHighlight().setStrokeWidth(2.0f);
        this.getPaintHighlight().setColor(Color.rgb((int)255, (int)187, (int)115));
        this.paint.setStyle(Paint.Style.FILL);
        this.paint.setStrokeWidth(2.0f);
        this.paint.setColor(-65536);
        this.webPaint = new Paint(1);
        this.webPaint.setStyle(Paint.Style.STROKE);
        this.highlightCirclePaint = new Paint(1);
    }

    @NotNull
    protected final RadarChart getChart() {
        return this.chart;
    }

    protected final void setChart(@NotNull RadarChart radarChart) {
        Intrinsics.checkNotNullParameter((Object)radarChart, (String)"<set-?>");
        this.chart = radarChart;
    }

    @NotNull
    public final Paint getWebPaint() {
        return this.webPaint;
    }

    protected final void setWebPaint(@NotNull Paint paint) {
        Intrinsics.checkNotNullParameter((Object)paint, (String)"<set-?>");
        this.webPaint = paint;
    }

    @NotNull
    protected final Paint getHighlightCirclePaint() {
        return this.highlightCirclePaint;
    }

    protected final void setHighlightCirclePaint(@NotNull Paint paint) {
        Intrinsics.checkNotNullParameter((Object)paint, (String)"<set-?>");
        this.highlightCirclePaint = paint;
    }

    @Override
    public void initBuffers() {
    }

    @Override
    public void drawData(@NotNull Canvas canvas) {
        block2: {
            Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
            RadarData radarData = (RadarData)this.chart.getData();
            if (radarData == null) break block2;
            RadarData radarData2 = radarData;
            boolean bl = false;
            IRadarDataSet iRadarDataSet = (IRadarDataSet)radarData2.getMaxEntryCountSet();
            int mostEntries = iRadarDataSet != null ? iRadarDataSet.getEntryCount() : 0;
            List list = radarData2.getDataSets();
            if (list != null) {
                Iterable $this$forEach$iv = list;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    IRadarDataSet set = (IRadarDataSet)element$iv;
                    boolean bl2 = false;
                    if (!set.isVisible()) continue;
                    this.drawDataSet(canvas, set, mostEntries);
                }
            }
        }
    }

    @NotNull
    protected final Path getDrawDataSetSurfacePathBuffer() {
        return this.drawDataSetSurfacePathBuffer;
    }

    protected final void setDrawDataSetSurfacePathBuffer(@NotNull Path path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"<set-?>");
        this.drawDataSetSurfacePathBuffer = path;
    }

    protected final void drawDataSet(@NotNull Canvas canvas, @NotNull IRadarDataSet dataSet, int mostEntries) {
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        Intrinsics.checkNotNullParameter((Object)dataSet, (String)"dataSet");
        float phaseX = this.getAnimator().getPhaseX();
        float phaseY = this.getAnimator().getPhaseY();
        float sliceAngle = this.chart.getSliceAngle();
        float factor = this.chart.getFactor();
        PointF center = this.chart.getCenterOffsets();
        PointF pOut = null;
        pOut = PointF.Companion.getInstance(0.0f, 0.0f);
        Path surface = this.drawDataSetSurfacePathBuffer;
        surface.reset();
        boolean hasMovedToPoint = false;
        int n = dataSet.getEntryCount();
        for (int j = 0; j < n; ++j) {
            this.getPaintRender().setColor(dataSet.getColorByIndex(j));
            if ((RadarEntry)dataSet.getEntryForIndex(j) != null) {
                RadarEntry e;
                boolean bl = false;
                pOut = PointFKt.getPosition(center, (e.getY() - this.chart.getYChartMin()) * factor * phaseY, sliceAngle * (float)j * phaseX + this.chart.getRotationAngle());
            }
            if (Float.isNaN(pOut.getX())) continue;
            if (!hasMovedToPoint) {
                surface.moveTo(pOut.getX(), pOut.getY());
                hasMovedToPoint = true;
                continue;
            }
            surface.lineTo(pOut.getX(), pOut.getY());
        }
        if (dataSet.getEntryCount() > mostEntries) {
            surface.lineTo(center.getX(), center.getY());
        }
        surface.close();
        if (dataSet.isDrawFilledEnabled()) {
            Drawable drawable = dataSet.getFillDrawable();
            if (drawable != null) {
                this.drawFilledPath(canvas, surface, drawable);
            } else {
                this.drawFilledPath(canvas, surface, dataSet.getFillColor(), dataSet.getFillAlpha());
            }
        }
        this.getPaintRender().setStrokeWidth(dataSet.getLineWidth());
        this.getPaintRender().setStyle(Paint.Style.STROKE);
        if (!dataSet.isDrawFilledEnabled() || dataSet.getFillAlpha() < 255) {
            canvas.drawPath(surface, this.getPaintRender());
        }
        PointF.Companion.recycleInstance(center);
        PointF.Companion.recycleInstance(pOut);
    }

    @Override
    public void drawValues(@NotNull Canvas canvas) {
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        float phaseX = this.getAnimator().getPhaseX();
        float phaseY = this.getAnimator().getPhaseY();
        float sliceAngle = this.chart.getSliceAngle();
        float factor = this.chart.getFactor();
        PointF center = this.chart.getCenterOffsets();
        PointF pOut = null;
        pOut = PointF.Companion.getInstance(0.0f, 0.0f);
        PointF pIcon = null;
        pIcon = PointF.Companion.getInstance(0.0f, 0.0f);
        float yOffset = NumberUtilsKt.convertDpToPixel(5.0f);
        Object t = this.chart.getData();
        Intrinsics.checkNotNull(t);
        int n = ((RadarData)t).getDataSetCount();
        for (int i = 0; i < n; ++i) {
            IRadarDataSet dataSet;
            Object t2 = this.chart.getData();
            Intrinsics.checkNotNull(t2);
            if ((IRadarDataSet)((RadarData)t2).getDataSetByIndex(i) == null) continue;
            boolean bl = false;
            Object t3 = this.chart.getData();
            Intrinsics.checkNotNull(t3);
            ((RadarData)t3).getDataSetByIndex(i);
            if (dataSet.getEntryCount() == 0 || !this.shouldDrawValues(dataSet)) continue;
            this.applyValueTextStyle(dataSet);
            PointF iconsOffset = PointF.Companion.getInstance(dataSet.getIconsOffset());
            iconsOffset.setX(NumberUtilsKt.convertDpToPixel(iconsOffset.getX()));
            iconsOffset.setY(NumberUtilsKt.convertDpToPixel(iconsOffset.getY()));
            int n2 = dataSet.getEntryCount();
            for (int j = 0; j < n2; ++j) {
                Drawable it;
                RadarEntry entry;
                if ((RadarEntry)dataSet.getEntryForIndex(j) == null) continue;
                boolean bl2 = false;
                pOut = PointFKt.getPosition(center, (entry.getY() - this.chart.getYChartMin()) * factor * phaseY, sliceAngle * (float)j * phaseX + this.chart.getRotationAngle());
                if (dataSet.isDrawValues()) {
                    this.drawValue(canvas, dataSet.getValueFormatter(), entry.getY(), entry, i, pOut.getX(), pOut.getY() - yOffset, dataSet.getValueTextColor(j));
                }
                if (entry.getIcon() == null || !dataSet.isDrawIcons()) continue;
                Drawable icon = entry.getIcon();
                PointF pointF = pIcon = PointFKt.getPosition(center, entry.getY() * factor * phaseY + iconsOffset.getY(), sliceAngle * (float)j * phaseX + this.chart.getRotationAngle());
                pointF.setY(pointF.getY() + iconsOffset.getX());
                if (icon == null) continue;
                boolean bl3 = false;
                CanvasUtilsKt.drawImage(canvas, it, (int)pIcon.getX(), (int)pIcon.getY());
            }
            PointF.Companion.recycleInstance(iconsOffset);
        }
        PointF.Companion.recycleInstance(center);
        PointF.Companion.recycleInstance(pOut);
        PointF.Companion.recycleInstance(pIcon);
    }

    @Override
    public void drawExtras(@NotNull Canvas canvas) {
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        this.drawWeb(canvas);
    }

    protected final void drawWeb(@NotNull Canvas canvas) {
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        float sliceAngle = this.chart.getSliceAngle();
        float factor = this.chart.getFactor();
        float rotationAngle = this.chart.getRotationAngle();
        PointF center = this.chart.getCenterOffsets();
        this.webPaint.setStrokeWidth(this.chart.getWebLineWidth());
        this.webPaint.setColor(this.chart.getWebColor());
        this.webPaint.setAlpha(this.chart.getWebAlpha());
        int xIncrements = 1 + this.chart.getSkipWebLineCount();
        Object t = this.chart.getData();
        Intrinsics.checkNotNull(t);
        IRadarDataSet iRadarDataSet = (IRadarDataSet)((RadarData)t).getMaxEntryCountSet();
        int maxEntryCount = iRadarDataSet != null ? iRadarDataSet.getEntryCount() : 0;
        PointF p = PointF.Companion.getInstance(0.0f, 0.0f);
        for (int i = 0; i < maxEntryCount; i += xIncrements) {
            p = PointFKt.getPosition(center, this.chart.getYRange() * factor, sliceAngle * (float)i + rotationAngle);
            canvas.drawLine(center.getX(), center.getY(), p.getX(), p.getY(), this.webPaint);
        }
        PointF.Companion.recycleInstance(p);
        this.webPaint.setStrokeWidth(this.chart.getWebLineWidthInner());
        this.webPaint.setColor(this.chart.getWebColorInner());
        this.webPaint.setAlpha(this.chart.getWebAlpha());
        int labelCount = this.chart.getYAxis().getEntryCount();
        PointF p1out = PointF.Companion.getInstance(0.0f, 0.0f);
        PointF p2out = PointF.Companion.getInstance(0.0f, 0.0f);
        for (int j = 0; j < labelCount; ++j) {
            boolean result;
            if (this.chart.isCustomLayerColorEnable()) {
                this.innerAreaPath.rewind();
                this.paint.setColor(((Number)this.chart.getLayerColorList().get(j)).intValue());
            }
            Object t2 = this.chart.getData();
            Intrinsics.checkNotNull(t2);
            int n = ((RadarData)t2).getEntryCount();
            for (int i = 0; i < n; ++i) {
                float r = (this.chart.getYAxis().getEntries()[j] - this.chart.getYChartMin()) * factor;
                p1out = PointFKt.getPosition(center, r, sliceAngle * (float)i + rotationAngle);
                p2out = PointFKt.getPosition(center, r, sliceAngle * (float)(i + 1) + rotationAngle);
                canvas.drawLine(p1out.getX(), p1out.getY(), p2out.getX(), p2out.getY(), this.webPaint);
                if (!this.chart.isCustomLayerColorEnable() || p1out.getX() == p2out.getX()) continue;
                if (i == 0) {
                    this.innerAreaPath.moveTo(p1out.getX(), p1out.getY());
                } else {
                    this.innerAreaPath.lineTo(p1out.getX(), p1out.getY());
                }
                this.innerAreaPath.lineTo(p2out.getX(), p2out.getY());
            }
            if (!this.chart.isCustomLayerColorEnable()) continue;
            this.tempPath.set(this.innerAreaPath);
            if (!this.innerAreaPath.isEmpty() && (result = this.innerAreaPath.op(this.previousPath, Path.Op.DIFFERENCE))) {
                canvas.drawPath(this.innerAreaPath, this.paint);
            }
            this.previousPath.set(this.tempPath);
        }
        PointF.Companion.recycleInstance(p1out);
        PointF.Companion.recycleInstance(p2out);
    }

    @Override
    public void drawHighlighted(@NotNull Canvas canvas, @NotNull Highlight[] indices) {
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        Intrinsics.checkNotNullParameter((Object)indices, (String)"indices");
        float sliceAngle = this.chart.getSliceAngle();
        float factor = this.chart.getFactor();
        PointF center = this.chart.getCenterOffsets();
        PointF pOut = null;
        pOut = PointF.Companion.getInstance(0.0f, 0.0f);
        RadarData radarData = (RadarData)this.chart.getData();
        for (Highlight high : indices) {
            RadarData radarData2 = radarData;
            Intrinsics.checkNotNull((Object)radarData2);
            IRadarDataSet set = (IRadarDataSet)radarData2.getDataSetByIndex(high.getDataSetIndex());
            if (set == null || !set.isHighlightEnabled()) continue;
            if ((RadarEntry)set.getEntryForIndex((int)high.getX()) != null) {
                RadarEntry radarEntry;
                boolean bl = false;
                high.setY(radarEntry.getY());
                if (!this.isInBoundsX((Entry)radarEntry, set)) continue;
                float y = radarEntry.getY() - this.chart.getYChartMin();
                pOut = PointFKt.getPosition(center, y * factor * this.getAnimator().getPhaseY(), sliceAngle * high.getX() * this.getAnimator().getPhaseX() + this.chart.getRotationAngle());
            }
            high.setDraw(pOut.getX(), pOut.getY());
            this.drawHighlightLines(canvas, pOut.getX(), pOut.getY(), set);
            if (!set.isDrawHighlightCircleEnabled() || Float.isNaN(pOut.getX()) || Float.isNaN(pOut.getY())) continue;
            int strokeColor = set.getHighlightCircleStrokeColor();
            if (strokeColor == 0x112233) {
                strokeColor = set.getColorByIndex(0);
            }
            if (set.getHighlightCircleStrokeAlpha() < 255) {
                strokeColor = ColorTemplate.INSTANCE.colorWithAlpha(strokeColor, set.getHighlightCircleStrokeAlpha());
            }
            this.drawHighlightCircle(canvas, pOut, set.getHighlightCircleInnerRadius(), set.getHighlightCircleOuterRadius(), set.getHighlightCircleFillColor(), strokeColor, set.getHighlightCircleStrokeWidth());
        }
        PointF.Companion.recycleInstance(center);
        PointF.Companion.recycleInstance(pOut);
    }

    @NotNull
    protected final Path getMDrawHighlightCirclePathBuffer() {
        return this.mDrawHighlightCirclePathBuffer;
    }

    protected final void setMDrawHighlightCirclePathBuffer(@NotNull Path path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"<set-?>");
        this.mDrawHighlightCirclePathBuffer = path;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void drawHighlightCircle(@NotNull Canvas canvas, @NotNull PointF point, float innerRadius, float outerRadius, int fillColor, int strokeColor, float strokeWidth) {
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        Intrinsics.checkNotNullParameter((Object)point, (String)"point");
        float innerRadiusLocal = 0.0f;
        innerRadiusLocal = innerRadius;
        float outerRadiusLocal = 0.0f;
        outerRadiusLocal = outerRadius;
        Canvas $this$withSave$iv = canvas;
        boolean $i$f$withSave = false;
        int checkpoint$iv = $this$withSave$iv.save();
        try {
            Canvas $this$drawHighlightCircle_u24lambda_u240 = $this$withSave$iv;
            boolean bl = false;
            outerRadiusLocal = NumberUtilsKt.convertDpToPixel(outerRadiusLocal);
            innerRadiusLocal = NumberUtilsKt.convertDpToPixel(innerRadiusLocal);
            if (fillColor != 0x112233) {
                Path p = this.mDrawHighlightCirclePathBuffer;
                p.reset();
                p.addCircle(point.getX(), point.getY(), outerRadiusLocal, Path.Direction.CW);
                if (innerRadiusLocal > 0.0f) {
                    p.addCircle(point.getX(), point.getY(), innerRadiusLocal, Path.Direction.CCW);
                }
                this.highlightCirclePaint.setColor(fillColor);
                this.highlightCirclePaint.setStyle(Paint.Style.FILL);
                $this$drawHighlightCircle_u24lambda_u240.drawPath(p, this.highlightCirclePaint);
            }
            if (strokeColor != 0x112233) {
                this.highlightCirclePaint.setColor(strokeColor);
                this.highlightCirclePaint.setStyle(Paint.Style.STROKE);
                this.highlightCirclePaint.setStrokeWidth(NumberUtilsKt.convertDpToPixel(strokeWidth));
                $this$drawHighlightCircle_u24lambda_u240.drawCircle(point.getX(), point.getY(), outerRadiusLocal, this.highlightCirclePaint);
            }
        }
        finally {
            $this$withSave$iv.restoreToCount(checkpoint$iv);
        }
    }
}

