/*
 * Decompiled with CFR 0.152.
 */
package info.appdev.charting.renderer;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PathEffect;
import android.graphics.drawable.Drawable;
import info.appdev.charting.animation.ChartAnimator;
import info.appdev.charting.data.BaseEntry;
import info.appdev.charting.data.Entry;
import info.appdev.charting.data.LineData;
import info.appdev.charting.data.LineDataSet;
import info.appdev.charting.formatter.IFillFormatter;
import info.appdev.charting.highlight.Highlight;
import info.appdev.charting.interfaces.dataprovider.LineDataProvider;
import info.appdev.charting.interfaces.datasets.IDataSet;
import info.appdev.charting.interfaces.datasets.ILineDataSet;
import info.appdev.charting.renderer.BarLineScatterCandleBubbleRenderer;
import info.appdev.charting.renderer.LineRadarRenderer;
import info.appdev.charting.utils.CanvasUtilsKt;
import info.appdev.charting.utils.NumberUtilsKt;
import info.appdev.charting.utils.PointD;
import info.appdev.charting.utils.PointF;
import info.appdev.charting.utils.Transformer;
import info.appdev.charting.utils.ViewPortHandler;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u009a\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0014\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0016\u0018\u00002\u00020\u0001:\u0001\\B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u00102\u001a\u000203H\u0016J\u0010\u00104\u001a\u0002032\u0006\u00105\u001a\u00020\u001eH\u0016J\u0018\u00106\u001a\u0002032\u0006\u00105\u001a\u00020\u001e2\u0006\u00107\u001a\u000208H\u0004J\u0010\u00109\u001a\u0002032\u0006\u00107\u001a\u000208H\u0004J\u0010\u0010:\u001a\u0002032\u0006\u00107\u001a\u000208H\u0004J4\u0010;\u001a\u0002032\u0006\u00105\u001a\u00020\u001e2\u0006\u00107\u001a\u0002082\u0006\u0010<\u001a\u00020*2\u0006\u0010=\u001a\u00020>2\n\u0010?\u001a\u00060@R\u00020AH\u0004J\u0018\u0010B\u001a\u0002032\u0006\u0010C\u001a\u00020\u001e2\u0006\u00107\u001a\u000208H\u0004J,\u0010G\u001a\u0002032\u0006\u00105\u001a\u00020\u001e2\u0006\u00107\u001a\u0002082\u0006\u0010=\u001a\u00020>2\n\u0010?\u001a\u00060@R\u00020AH\u0004J(\u0010H\u001a\u0002032\u0006\u00107\u001a\u0002082\u0006\u0010I\u001a\u00020J2\u0006\u0010K\u001a\u00020J2\u0006\u0010L\u001a\u00020*H\u0002J\u0010\u0010M\u001a\u0002032\u0006\u00105\u001a\u00020\u001eH\u0016J\u0010\u0010N\u001a\u0002032\u0006\u00105\u001a\u00020\u001eH\u0016J\u0010\u0010U\u001a\u0002032\u0006\u00105\u001a\u00020\u001eH\u0004J#\u0010V\u001a\u0002032\u0006\u00105\u001a\u00020\u001e2\f\u0010W\u001a\b\u0012\u0004\u0012\u00020Y0XH\u0016\u00a2\u0006\u0002\u0010ZJ\u0006\u0010[\u001a\u000203R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\u00020\u000fX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\"\u0010\u0016\u001a\n\u0012\u0004\u0012\u00020\u0018\u0018\u00010\u0017X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR\u001c\u0010\u001d\u001a\u0004\u0018\u00010\u001eX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010 \"\u0004\b!\u0010\"R\u001a\u0010#\u001a\u00020$X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b%\u0010&\"\u0004\b'\u0010(R\u001a\u0010)\u001a\u00020*X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b+\u0010,\"\u0004\b-\u0010.R\u001a\u0010/\u001a\u00020*X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b0\u0010,\"\u0004\b1\u0010.R\u001a\u0010D\u001a\u00020*X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bE\u0010,\"\u0004\bF\u0010.R:\u0010O\u001a.\u0012\b\u0012\u0006\u0012\u0002\b\u00030Q\u0012\b\u0012\u00060RR\u00020\u00000Pj\u0016\u0012\b\u0012\u0006\u0012\u0002\b\u00030Q\u0012\b\u0012\u00060RR\u00020\u0000`SX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010T\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006]"}, d2={"Linfo/appdev/charting/renderer/LineChartRenderer;", "Linfo/appdev/charting/renderer/LineRadarRenderer;", "dataProvider", "Linfo/appdev/charting/interfaces/dataprovider/LineDataProvider;", "animator", "Linfo/appdev/charting/animation/ChartAnimator;", "viewPortHandler", "Linfo/appdev/charting/utils/ViewPortHandler;", "<init>", "(Linfo/appdev/charting/interfaces/dataprovider/LineDataProvider;Linfo/appdev/charting/animation/ChartAnimator;Linfo/appdev/charting/utils/ViewPortHandler;)V", "getDataProvider", "()Linfo/appdev/charting/interfaces/dataprovider/LineDataProvider;", "setDataProvider", "(Linfo/appdev/charting/interfaces/dataprovider/LineDataProvider;)V", "circlePaintInner", "Landroid/graphics/Paint;", "getCirclePaintInner", "()Landroid/graphics/Paint;", "setCirclePaintInner", "(Landroid/graphics/Paint;)V", "lineBuffer", "", "drawBitmap", "Ljava/lang/ref/WeakReference;", "Landroid/graphics/Bitmap;", "getDrawBitmap", "()Ljava/lang/ref/WeakReference;", "setDrawBitmap", "(Ljava/lang/ref/WeakReference;)V", "bitmapCanvas", "Landroid/graphics/Canvas;", "getBitmapCanvas", "()Landroid/graphics/Canvas;", "setBitmapCanvas", "(Landroid/graphics/Canvas;)V", "mBitmapConfig", "Landroid/graphics/Bitmap$Config;", "getMBitmapConfig", "()Landroid/graphics/Bitmap$Config;", "setMBitmapConfig", "(Landroid/graphics/Bitmap$Config;)V", "cubicPath", "Landroid/graphics/Path;", "getCubicPath", "()Landroid/graphics/Path;", "setCubicPath", "(Landroid/graphics/Path;)V", "cubicFillPath", "getCubicFillPath", "setCubicFillPath", "initBuffers", "", "drawData", "canvas", "drawDataSet", "dataSet", "Linfo/appdev/charting/interfaces/datasets/ILineDataSet;", "drawHorizontalBezier", "drawCubicBezier", "drawCubicFill", "spline", "trans", "Linfo/appdev/charting/utils/Transformer;", "bounds", "Linfo/appdev/charting/renderer/BarLineScatterCandleBubbleRenderer$XBounds;", "Linfo/appdev/charting/renderer/BarLineScatterCandleBubbleRenderer;", "drawLinear", "c", "mGenerateFilledPathBuffer", "getMGenerateFilledPathBuffer", "setMGenerateFilledPathBuffer", "drawLinearFill", "generateFilledPath", "startIndex", "", "endIndex", "outputPath", "drawValues", "drawExtras", "mImageCaches", "Ljava/util/HashMap;", "Linfo/appdev/charting/interfaces/datasets/IDataSet;", "Linfo/appdev/charting/renderer/LineChartRenderer$DataSetImageCache;", "Lkotlin/collections/HashMap;", "mCirclesBuffer", "drawCircles", "drawHighlighted", "indices", "", "Linfo/appdev/charting/highlight/Highlight;", "(Landroid/graphics/Canvas;[Linfo/appdev/charting/highlight/Highlight;)V", "releaseBitmap", "DataSetImageCache", "chartLib_release"})
@SourceDebugExtension(value={"SMAP\nLineChartRenderer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LineChartRenderer.kt\ninfo/appdev/charting/renderer/LineChartRenderer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,772:1\n1915#2,2:773\n1#3:775\n*S KotlinDebug\n*F\n+ 1 LineChartRenderer.kt\ninfo/appdev/charting/renderer/LineChartRenderer\n*L\n80#1:773,2\n*E\n"})
public class LineChartRenderer
extends LineRadarRenderer {
    @NotNull
    private LineDataProvider dataProvider;
    @NotNull
    private Paint circlePaintInner;
    @NotNull
    private float[] lineBuffer;
    @Nullable
    private WeakReference<Bitmap> drawBitmap;
    @Nullable
    private Canvas bitmapCanvas;
    @NotNull
    private Bitmap.Config mBitmapConfig;
    @NotNull
    private Path cubicPath;
    @NotNull
    private Path cubicFillPath;
    @NotNull
    private Path mGenerateFilledPathBuffer;
    @NotNull
    private final HashMap<IDataSet<?>, DataSetImageCache> mImageCaches;
    @NotNull
    private final float[] mCirclesBuffer;

    public LineChartRenderer(@NotNull LineDataProvider dataProvider, @NotNull ChartAnimator animator, @NotNull ViewPortHandler viewPortHandler) {
        Intrinsics.checkNotNullParameter((Object)dataProvider, (String)"dataProvider");
        Intrinsics.checkNotNullParameter((Object)animator, (String)"animator");
        Intrinsics.checkNotNullParameter((Object)viewPortHandler, (String)"viewPortHandler");
        super(animator, viewPortHandler);
        this.dataProvider = dataProvider;
        this.circlePaintInner = new Paint(1);
        this.lineBuffer = new float[4];
        this.mBitmapConfig = Bitmap.Config.ARGB_8888;
        this.cubicPath = new Path();
        this.cubicFillPath = new Path();
        this.mGenerateFilledPathBuffer = new Path();
        this.mImageCaches = new HashMap();
        this.mCirclesBuffer = new float[2];
        this.circlePaintInner.setStyle(Paint.Style.FILL);
        this.circlePaintInner.setColor(-1);
    }

    @NotNull
    public final LineDataProvider getDataProvider() {
        return this.dataProvider;
    }

    public final void setDataProvider(@NotNull LineDataProvider lineDataProvider) {
        Intrinsics.checkNotNullParameter((Object)lineDataProvider, (String)"<set-?>");
        this.dataProvider = lineDataProvider;
    }

    @NotNull
    protected final Paint getCirclePaintInner() {
        return this.circlePaintInner;
    }

    protected final void setCirclePaintInner(@NotNull Paint paint) {
        Intrinsics.checkNotNullParameter((Object)paint, (String)"<set-?>");
        this.circlePaintInner = paint;
    }

    @Nullable
    protected final WeakReference<Bitmap> getDrawBitmap() {
        return this.drawBitmap;
    }

    protected final void setDrawBitmap(@Nullable WeakReference<Bitmap> weakReference) {
        this.drawBitmap = weakReference;
    }

    @Nullable
    protected final Canvas getBitmapCanvas() {
        return this.bitmapCanvas;
    }

    protected final void setBitmapCanvas(@Nullable Canvas canvas) {
        this.bitmapCanvas = canvas;
    }

    @NotNull
    protected final Bitmap.Config getMBitmapConfig() {
        return this.mBitmapConfig;
    }

    protected final void setMBitmapConfig(@NotNull Bitmap.Config config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"<set-?>");
        this.mBitmapConfig = config;
    }

    @NotNull
    protected final Path getCubicPath() {
        return this.cubicPath;
    }

    protected final void setCubicPath(@NotNull Path path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"<set-?>");
        this.cubicPath = path;
    }

    @NotNull
    protected final Path getCubicFillPath() {
        return this.cubicFillPath;
    }

    protected final void setCubicFillPath(@NotNull Path path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"<set-?>");
        this.cubicFillPath = path;
    }

    @Override
    public void initBuffers() {
    }

    @Override
    public void drawData(@NotNull Canvas canvas) {
        Bitmap drawBitmapLocal;
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        int width = (int)this.getViewPortHandler().getChartWidth();
        int height = (int)this.getViewPortHandler().getChartHeight();
        if (this.drawBitmap == null) {
            v0 = null;
        } else {
            WeakReference<Bitmap> weakReference = this.drawBitmap;
            Intrinsics.checkNotNull(weakReference);
            v0 = drawBitmapLocal = (Bitmap)weakReference.get();
        }
        if (drawBitmapLocal == null || drawBitmapLocal.getWidth() != width || drawBitmapLocal.getHeight() != height) {
            if (width > 0 && height > 0) {
                drawBitmapLocal = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)this.mBitmapConfig);
                this.drawBitmap = new WeakReference<Bitmap>(drawBitmapLocal);
                this.bitmapCanvas = new Canvas(drawBitmapLocal);
            } else {
                return;
            }
        }
        drawBitmapLocal.eraseColor(0);
        LineData lineData = this.dataProvider.getLineData();
        if (lineData != null) {
            LineData lineData2 = lineData;
            boolean bl = false;
            List list = lineData2.getDataSets();
            if (list != null) {
                Iterable $this$forEach$iv = list;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    ILineDataSet set = (ILineDataSet)element$iv;
                    boolean bl2 = false;
                    if (!set.isVisible()) continue;
                    this.drawDataSet(canvas, set);
                }
            }
        }
        canvas.drawBitmap(drawBitmapLocal, 0.0f, 0.0f, null);
    }

    protected final void drawDataSet(@NotNull Canvas canvas, @NotNull ILineDataSet dataSet) {
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        Intrinsics.checkNotNullParameter((Object)dataSet, (String)"dataSet");
        if (dataSet.getEntryCount() < 1) {
            return;
        }
        this.getPaintRender().setStrokeWidth(dataSet.getLineWidth());
        this.getPaintRender().setPathEffect((PathEffect)dataSet.getDashPathEffect());
        switch (WhenMappings.$EnumSwitchMapping$0[dataSet.getLineMode().ordinal()]) {
            case 1: 
            case 2: {
                this.drawLinear(canvas, dataSet);
                break;
            }
            case 3: {
                this.drawCubicBezier(dataSet);
                break;
            }
            case 4: {
                this.drawHorizontalBezier(dataSet);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        this.getPaintRender().setPathEffect(null);
    }

    protected final void drawHorizontalBezier(@NotNull ILineDataSet dataSet) {
        Intrinsics.checkNotNullParameter((Object)dataSet, (String)"dataSet");
        float phaseY = this.getAnimator().getPhaseY();
        Transformer trans = this.dataProvider.getTransformer(dataSet.getAxisDependency());
        this.getXBounds().set(this.dataProvider, dataSet);
        this.cubicPath.reset();
        if (this.getXBounds().getRange() >= 1) {
            Object prev;
            Object t = dataSet.getEntryForIndex(this.getXBounds().getMin());
            Intrinsics.checkNotNull(t);
            Object cur = prev = t;
            this.cubicPath.moveTo(((Entry)cur).getX(), ((BaseEntry)cur).getY() * phaseY);
            int j = this.getXBounds().getMin() + 1;
            int n = this.getXBounds().getRange() + this.getXBounds().getMin();
            if (j <= n) {
                while (true) {
                    prev = cur;
                    Intrinsics.checkNotNull(dataSet.getEntryForIndex(j));
                    float cpx = ((Entry)prev).getX() + (((Entry)cur).getX() - ((Entry)prev).getX()) / 2.0f;
                    this.cubicPath.cubicTo(cpx, ((BaseEntry)prev).getY() * phaseY, cpx, ((BaseEntry)cur).getY() * phaseY, ((Entry)cur).getX(), ((BaseEntry)cur).getY() * phaseY);
                    if (j == n) break;
                    ++j;
                }
            }
        }
        if (dataSet.isDrawFilledEnabled()) {
            this.cubicFillPath.reset();
            this.cubicFillPath.addPath(this.cubicPath);
            Canvas canvas = this.bitmapCanvas;
            if (canvas != null) {
                Canvas it = canvas;
                boolean bl = false;
                Transformer transformer = trans;
                Intrinsics.checkNotNull((Object)transformer);
                this.drawCubicFill(it, dataSet, this.cubicFillPath, transformer, this.getXBounds());
            }
        }
        this.getPaintRender().setColor(dataSet.getColor());
        this.getPaintRender().setStyle(Paint.Style.STROKE);
        Transformer transformer = trans;
        Intrinsics.checkNotNull((Object)transformer);
        transformer.pathValueToPixel(this.cubicPath);
        Canvas canvas = this.bitmapCanvas;
        Intrinsics.checkNotNull((Object)canvas);
        canvas.drawPath(this.cubicPath, this.getPaintRender());
        this.getPaintRender().setPathEffect(null);
    }

    protected final void drawCubicBezier(@NotNull ILineDataSet dataSet) {
        Intrinsics.checkNotNullParameter((Object)dataSet, (String)"dataSet");
        float phaseY = this.getAnimator().getPhaseY();
        Transformer trans = this.dataProvider.getTransformer(dataSet.getAxisDependency());
        this.getXBounds().set(this.dataProvider, dataSet);
        float intensity = dataSet.getCubicIntensity();
        this.cubicPath.reset();
        if (this.getXBounds().getRange() >= 1) {
            Object cur;
            float prevDx = 0.0f;
            float prevDy = 0.0f;
            float curDx = 0.0f;
            float curDy = 0.0f;
            int firstIndex = this.getXBounds().getMin() + 1;
            Entry prevPrev = null;
            Object prev = dataSet.getEntryForIndex((int)Math.max((double)(firstIndex - 2), 0.0));
            Object next = cur = dataSet.getEntryForIndex((int)Math.max((double)(firstIndex - 1), 0.0));
            int nextIndex = -1;
            if (cur == null) {
                return;
            }
            this.cubicPath.moveTo(((Entry)cur).getX(), ((BaseEntry)cur).getY() * phaseY);
            int j = this.getXBounds().getMin() + 1;
            int n = this.getXBounds().getRange() + this.getXBounds().getMin();
            if (j <= n) {
                while (true) {
                    prevPrev = (Entry)prev;
                    prev = cur;
                    cur = nextIndex == j ? next : dataSet.getEntryForIndex(j);
                    nextIndex = j + 1 < dataSet.getEntryCount() ? j + 1 : j;
                    Intrinsics.checkNotNull(dataSet.getEntryForIndex(nextIndex));
                    Object t = cur;
                    Intrinsics.checkNotNull(t);
                    float f = ((Entry)t).getX();
                    Entry entry = prevPrev;
                    Intrinsics.checkNotNull(entry);
                    prevDx = (f - entry.getX()) * intensity;
                    prevDy = (((BaseEntry)cur).getY() - prevPrev.getY()) * intensity;
                    curDx = (((Entry)next).getX() - ((Entry)prev).getX()) * intensity;
                    curDy = (((BaseEntry)next).getY() - ((BaseEntry)prev).getY()) * intensity;
                    this.cubicPath.cubicTo(((Entry)prev).getX() + prevDx, (((BaseEntry)prev).getY() + prevDy) * phaseY, ((Entry)cur).getX() - curDx, (((BaseEntry)cur).getY() - curDy) * phaseY, ((Entry)cur).getX(), ((BaseEntry)cur).getY() * phaseY);
                    if (j == n) break;
                    ++j;
                }
            }
        }
        if (dataSet.isDrawFilledEnabled()) {
            this.cubicFillPath.reset();
            this.cubicFillPath.addPath(this.cubicPath);
            Canvas canvas = this.bitmapCanvas;
            if (canvas != null) {
                Canvas it = canvas;
                boolean bl = false;
                Transformer transformer = trans;
                Intrinsics.checkNotNull((Object)transformer);
                this.drawCubicFill(it, dataSet, this.cubicFillPath, transformer, this.getXBounds());
            }
        }
        this.getPaintRender().setColor(dataSet.getColor());
        this.getPaintRender().setStyle(Paint.Style.STROKE);
        Transformer transformer = trans;
        Intrinsics.checkNotNull((Object)transformer);
        transformer.pathValueToPixel(this.cubicPath);
        Canvas canvas = this.bitmapCanvas;
        Intrinsics.checkNotNull((Object)canvas);
        canvas.drawPath(this.cubicPath, this.getPaintRender());
        this.getPaintRender().setPathEffect(null);
    }

    protected final void drawCubicFill(@NotNull Canvas canvas, @NotNull ILineDataSet dataSet, @NotNull Path spline, @NotNull Transformer trans, @NotNull BarLineScatterCandleBubbleRenderer.XBounds bounds) {
        Object it;
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        Intrinsics.checkNotNullParameter((Object)dataSet, (String)"dataSet");
        Intrinsics.checkNotNullParameter((Object)spline, (String)"spline");
        Intrinsics.checkNotNullParameter((Object)trans, (String)"trans");
        Intrinsics.checkNotNullParameter((Object)bounds, (String)"bounds");
        IFillFormatter iFillFormatter = dataSet.getFillFormatter();
        Intrinsics.checkNotNull((Object)iFillFormatter);
        float fillMin = iFillFormatter.getFillLinePosition(dataSet, this.dataProvider);
        Object t = dataSet.getEntryForIndex(bounds.getMin() + bounds.getRange());
        if (t != null) {
            it = t;
            boolean bl = false;
            spline.lineTo(((Entry)it).getX(), fillMin);
        }
        Object t2 = dataSet.getEntryForIndex(bounds.getMin());
        if (t2 != null) {
            it = t2;
            boolean bl = false;
            spline.lineTo(((Entry)it).getX(), fillMin);
        }
        spline.close();
        trans.pathValueToPixel(spline);
        Drawable drawable = dataSet.getFillDrawable();
        if (drawable != null) {
            this.drawFilledPath(canvas, spline, drawable);
        } else {
            this.drawFilledPath(canvas, spline, dataSet.getFillColor(), dataSet.getFillAlpha());
        }
    }

    protected final void drawLinear(@NotNull Canvas c, @NotNull ILineDataSet dataSet) {
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        Intrinsics.checkNotNullParameter((Object)dataSet, (String)"dataSet");
        int entryCount = dataSet.getEntryCount();
        int pointsPerEntryPair = dataSet.isDrawSteppedEnabled() ? 4 : 2;
        Transformer trans = this.dataProvider.getTransformer(dataSet.getAxisDependency());
        float phaseY = this.getAnimator().getPhaseY();
        this.getPaintRender().setStyle(Paint.Style.STROKE);
        Canvas canvas = dataSet.isDashedLineEnabled() ? this.bitmapCanvas : c;
        this.getXBounds().set(this.dataProvider, dataSet);
        if (dataSet.isDrawFilledEnabled() && entryCount > 0) {
            Transformer transformer = trans;
            Intrinsics.checkNotNull((Object)transformer);
            this.drawLinearFill(c, dataSet, transformer, this.getXBounds());
        }
        if (dataSet.getColors().size() > 1) {
            int numberOfFloats = pointsPerEntryPair * 2;
            if (this.lineBuffer.length <= numberOfFloats) {
                this.lineBuffer = new float[numberOfFloats * 2];
            }
            int max = this.getXBounds().getMin() + this.getXBounds().getRange();
            for (int j = this.getXBounds().getMin(); j < max; ++j) {
                Object entry;
                if (dataSet.getEntryForIndex(j) == null) continue;
                this.lineBuffer[0] = ((Entry)entry).getX();
                this.lineBuffer[1] = ((BaseEntry)entry).getY() * phaseY;
                if (j < this.getXBounds().getMax()) {
                    Object t = dataSet.getEntryForIndex(j + 1);
                    Intrinsics.checkNotNull(t);
                    entry = t;
                    if (dataSet.isDrawSteppedEnabled()) {
                        this.lineBuffer[2] = ((Entry)entry).getX();
                        this.lineBuffer[3] = this.lineBuffer[1];
                        this.lineBuffer[4] = this.lineBuffer[2];
                        this.lineBuffer[5] = this.lineBuffer[3];
                        this.lineBuffer[6] = ((Entry)entry).getX();
                        this.lineBuffer[7] = ((BaseEntry)entry).getY() * phaseY;
                    } else {
                        this.lineBuffer[2] = ((Entry)entry).getX();
                        this.lineBuffer[3] = ((BaseEntry)entry).getY() * phaseY;
                    }
                } else {
                    this.lineBuffer[2] = this.lineBuffer[0];
                    this.lineBuffer[3] = this.lineBuffer[1];
                }
                float firstCoordinateX = this.lineBuffer[0];
                float firstCoordinateY = this.lineBuffer[1];
                float lastCoordinateX = this.lineBuffer[numberOfFloats - 2];
                float lastCoordinateY = this.lineBuffer[numberOfFloats - 1];
                if (firstCoordinateX == lastCoordinateX && firstCoordinateY == lastCoordinateY) continue;
                Transformer transformer = trans;
                Intrinsics.checkNotNull((Object)transformer);
                transformer.pointValuesToPixel(this.lineBuffer);
                if (this.getViewPortHandler().isInBoundsRight(firstCoordinateX)) {
                    if (!this.getViewPortHandler().isInBoundsLeft(lastCoordinateX)) continue;
                    if (!this.getViewPortHandler().isInBoundsTop((float)Math.max((double)firstCoordinateY, (double)lastCoordinateY)) || !this.getViewPortHandler().isInBoundsBottom((float)Math.min((double)firstCoordinateY, (double)lastCoordinateY))) continue;
                    this.getPaintRender().setColor(dataSet.getColorByIndex(j));
                    Canvas canvas2 = canvas;
                    Intrinsics.checkNotNull((Object)canvas2);
                    canvas2.drawLines(this.lineBuffer, 0, pointsPerEntryPair * 2, this.getPaintRender());
                    continue;
                }
                break;
            }
        } else {
            if ((double)this.lineBuffer.length < Math.max((double)(entryCount * pointsPerEntryPair), (double)pointsPerEntryPair) * (double)2) {
                this.lineBuffer = new float[(int)(Math.max((double)(entryCount * pointsPerEntryPair), (double)pointsPerEntryPair) * (double)4)];
            }
            Entry e1 = null;
            Entry e2 = null;
            e1 = (Entry)dataSet.getEntryForIndex(this.getXBounds().getMin());
            if (e1 != null) {
                int n;
                int j = 0;
                int x = this.getXBounds().getMin();
                if (x <= (n = this.getXBounds().getRange() + this.getXBounds().getMin())) {
                    while (true) {
                        e1 = (Entry)dataSet.getEntryForIndex(x == 0 ? 0 : x - 1);
                        e2 = (Entry)dataSet.getEntryForIndex(x);
                        if (e1 != null && e2 != null) {
                            this.lineBuffer[j++] = e1.getX();
                            this.lineBuffer[j++] = e1.getY() * phaseY;
                            if (dataSet.isDrawSteppedEnabled()) {
                                this.lineBuffer[j++] = e2.getX();
                                this.lineBuffer[j++] = e1.getY() * phaseY;
                                this.lineBuffer[j++] = e2.getX();
                                this.lineBuffer[j++] = e1.getY() * phaseY;
                            }
                            this.lineBuffer[j++] = e2.getX();
                            this.lineBuffer[j++] = e2.getY() * phaseY;
                        }
                        if (x == n) break;
                        ++x;
                    }
                }
                if (j > 0) {
                    Transformer transformer = trans;
                    Intrinsics.checkNotNull((Object)transformer);
                    transformer.pointValuesToPixel(this.lineBuffer);
                    int size = (int)(Math.max((double)((this.getXBounds().getRange() + 1) * pointsPerEntryPair), (double)pointsPerEntryPair) * (double)2);
                    this.getPaintRender().setColor(dataSet.getColor());
                    Canvas canvas3 = canvas;
                    Intrinsics.checkNotNull((Object)canvas3);
                    canvas3.drawLines(this.lineBuffer, 0, size, this.getPaintRender());
                }
            }
        }
        this.getPaintRender().setPathEffect(null);
    }

    @NotNull
    protected final Path getMGenerateFilledPathBuffer() {
        return this.mGenerateFilledPathBuffer;
    }

    protected final void setMGenerateFilledPathBuffer(@NotNull Path path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"<set-?>");
        this.mGenerateFilledPathBuffer = path;
    }

    protected final void drawLinearFill(@NotNull Canvas canvas, @NotNull ILineDataSet dataSet, @NotNull Transformer trans, @NotNull BarLineScatterCandleBubbleRenderer.XBounds bounds) {
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        Intrinsics.checkNotNullParameter((Object)dataSet, (String)"dataSet");
        Intrinsics.checkNotNullParameter((Object)trans, (String)"trans");
        Intrinsics.checkNotNullParameter((Object)bounds, (String)"bounds");
        Path filled = this.mGenerateFilledPathBuffer;
        int startingIndex = bounds.getMin();
        int endingIndex = bounds.getRange() + bounds.getMin();
        int indexInterval = 128;
        int currentStartIndex = 0;
        int currentEndIndex = 0;
        int iterations = 0;
        do {
            currentStartIndex = startingIndex + iterations * indexInterval;
            currentEndIndex = currentStartIndex + indexInterval;
            if (currentStartIndex <= (currentEndIndex = (int)Math.min((double)currentEndIndex, (double)endingIndex))) {
                Drawable drawable = dataSet.getFillDrawable();
                this.generateFilledPath(dataSet, currentStartIndex, currentEndIndex, filled);
                trans.pathValueToPixel(filled);
                if (drawable != null) {
                    this.drawFilledPath(canvas, filled, drawable);
                } else {
                    this.drawFilledPath(canvas, filled, dataSet.getFillColor(), dataSet.getFillAlpha());
                }
            }
            ++iterations;
        } while (currentStartIndex <= currentEndIndex);
    }

    private final void generateFilledPath(ILineDataSet dataSet, int startIndex, int endIndex, Path outputPath) {
        IFillFormatter iFillFormatter = dataSet.getFillFormatter();
        Intrinsics.checkNotNull((Object)iFillFormatter);
        float fillMin = iFillFormatter.getFillLinePosition(dataSet, this.dataProvider);
        float phaseY = this.getAnimator().getPhaseY();
        boolean isDrawSteppedEnabled = dataSet.getLineMode() == LineDataSet.Mode.STEPPED;
        outputPath.reset();
        Object t = dataSet.getEntryForIndex(startIndex);
        if (t != null) {
            Object entry = t;
            boolean bl = false;
            outputPath.moveTo(((Entry)entry).getX(), fillMin);
            outputPath.lineTo(((Entry)entry).getX(), ((BaseEntry)entry).getY() * phaseY);
            Entry currentEntry = null;
            Object previousEntry = entry;
            int x = startIndex + 1;
            if (x <= endIndex) {
                while (true) {
                    if ((currentEntry = (Entry)dataSet.getEntryForIndex(x)) != null) {
                        if (isDrawSteppedEnabled) {
                            outputPath.lineTo(currentEntry.getX(), ((BaseEntry)previousEntry).getY() * phaseY);
                        }
                        outputPath.lineTo(currentEntry.getX(), currentEntry.getY() * phaseY);
                        previousEntry = currentEntry;
                    }
                    if (x == endIndex) break;
                    ++x;
                }
            }
            if (currentEntry != null) {
                outputPath.lineTo(currentEntry.getX(), fillMin);
            }
        }
        outputPath.close();
    }

    @Override
    public void drawValues(@NotNull Canvas canvas) {
        block9: {
            List dataSets;
            Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
            if (!this.isDrawingValuesAllowed(this.dataProvider)) break block9;
            LineData lineData = this.dataProvider.getLineData();
            List list = dataSets = lineData != null ? lineData.getDataSets() : null;
            if (list != null) {
                List it = list;
                boolean bl = false;
                int n = ((Collection)it).size();
                for (int i = 0; i < n; ++i) {
                    ILineDataSet dataSet = (ILineDataSet)dataSets.get(i);
                    if (dataSet.getEntryCount() == 0 || !this.shouldDrawValues(dataSet) || dataSet.getEntryCount() < 1) continue;
                    this.applyValueTextStyle(dataSet);
                    Transformer trans = this.dataProvider.getTransformer(dataSet.getAxisDependency());
                    int valOffset = (int)(dataSet.getCircleRadius() * 1.75f);
                    if (!dataSet.isDrawCirclesEnabled()) {
                        valOffset /= 2;
                    }
                    this.getXBounds().set(this.dataProvider, dataSet);
                    Transformer transformer = trans;
                    Intrinsics.checkNotNull((Object)transformer);
                    float[] positions = transformer.generateTransformedValuesLine(dataSet, this.getAnimator().getPhaseX(), this.getAnimator().getPhaseY(), this.getXBounds().getMin(), this.getXBounds().getMax());
                    PointF iconsOffset = PointF.Companion.getInstance(dataSet.getIconsOffset());
                    iconsOffset.setX(NumberUtilsKt.convertDpToPixel(iconsOffset.getX()));
                    iconsOffset.setY(NumberUtilsKt.convertDpToPixel(iconsOffset.getY()));
                    int j = 0;
                    while (j < positions.length) {
                        float x = positions[j];
                        float y = positions[j + 1];
                        if (!this.getViewPortHandler().isInBoundsRight(x)) break;
                        if (!this.getViewPortHandler().isInBoundsLeft(x) || !this.getViewPortHandler().isInBoundsY(y)) {
                            j += 2;
                            continue;
                        }
                        Object entry = dataSet.getEntryForIndex(j / 2 + this.getXBounds().getMin());
                        if (entry != null) {
                            if (dataSet.isDrawValues()) {
                                this.drawValue(canvas, dataSet.getValueFormatter(), ((BaseEntry)entry).getY(), (Entry)entry, i, x, y - (float)valOffset, dataSet.getValueTextColor(j / 2));
                            }
                            if (((BaseEntry)entry).getIcon() != null && dataSet.isDrawIcons()) {
                                Drawable icon = ((BaseEntry)entry).getIcon();
                                if (icon != null) {
                                    Drawable it2;
                                    boolean bl2 = false;
                                    CanvasUtilsKt.drawImage(canvas, it2, (int)(x + iconsOffset.getX()), (int)(y + iconsOffset.getY()));
                                }
                            }
                        }
                        j += 2;
                    }
                    PointF.Companion.recycleInstance(iconsOffset);
                }
            }
        }
    }

    @Override
    public void drawExtras(@NotNull Canvas canvas) {
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        this.drawCircles(canvas);
    }

    protected final void drawCircles(@NotNull Canvas canvas) {
        block6: {
            List dataSets;
            Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
            this.getPaintRender().setStyle(Paint.Style.FILL);
            float phaseY = this.getAnimator().getPhaseY();
            this.mCirclesBuffer[0] = 0.0f;
            this.mCirclesBuffer[1] = 0.0f;
            LineData lineData = this.dataProvider.getLineData();
            List list = dataSets = lineData != null ? lineData.getDataSets() : null;
            if (list == null) break block6;
            List it = list;
            boolean bl = false;
            int n = ((Collection)it).size();
            block0: for (int i = 0; i < n; ++i) {
                ILineDataSet dataSet = (ILineDataSet)dataSets.get(i);
                if (!dataSet.isVisible() || !dataSet.isDrawCirclesEnabled() || dataSet.getEntryCount() == 0) continue;
                this.circlePaintInner.setColor(dataSet.getCircleHoleColor());
                Transformer trans = this.dataProvider.getTransformer(dataSet.getAxisDependency());
                this.getXBounds().set(this.dataProvider, dataSet);
                float circleRadius = dataSet.getCircleRadius();
                float circleHoleRadius = dataSet.getCircleHoleRadius();
                boolean drawCircleHole = dataSet.isDrawCircleHoleEnabled() && circleHoleRadius < circleRadius && circleHoleRadius > 0.0f;
                boolean drawTransparentCircleHole = drawCircleHole && dataSet.getCircleHoleColor() == 0x112233;
                DataSetImageCache imageCache = null;
                if (this.mImageCaches.containsKey(dataSet)) {
                    imageCache = this.mImageCaches.get(dataSet);
                } else {
                    imageCache = new DataSetImageCache();
                    ((Map)this.mImageCaches).put(dataSet, imageCache);
                }
                DataSetImageCache dataSetImageCache = imageCache;
                Intrinsics.checkNotNull((Object)dataSetImageCache);
                boolean changeRequired = dataSetImageCache.init(dataSet);
                if (changeRequired) {
                    imageCache.fill(dataSet, drawCircleHole, drawTransparentCircleHole);
                }
                int boundsRangeCount = this.getXBounds().getRange() + this.getXBounds().getMin();
                int j = this.getXBounds().getMin();
                if (j > boundsRangeCount) continue;
                while (dataSet.getEntryForIndex(j) != null) {
                    Bitmap circleBitmap;
                    Object e;
                    this.mCirclesBuffer[0] = ((Entry)e).getX();
                    this.mCirclesBuffer[1] = ((BaseEntry)e).getY() * phaseY;
                    Transformer transformer = trans;
                    Intrinsics.checkNotNull((Object)transformer);
                    transformer.pointValuesToPixel(this.mCirclesBuffer);
                    if (!this.getViewPortHandler().isInBoundsRight(this.mCirclesBuffer[0])) continue block0;
                    if (this.getViewPortHandler().isInBoundsLeft(this.mCirclesBuffer[0]) && this.getViewPortHandler().isInBoundsY(this.mCirclesBuffer[1]) && (circleBitmap = imageCache.getBitmap(j)) != null) {
                        canvas.drawBitmap(circleBitmap, this.mCirclesBuffer[0] - circleRadius, this.mCirclesBuffer[1] - circleRadius, null);
                    }
                    if (j == boundsRangeCount) continue block0;
                    ++j;
                }
            }
        }
    }

    @Override
    public void drawHighlighted(@NotNull Canvas canvas, @NotNull Highlight[] indices) {
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        Intrinsics.checkNotNullParameter((Object)indices, (String)"indices");
        LineData lineData = this.dataProvider.getLineData();
        for (Highlight high : indices) {
            Object entry;
            ILineDataSet set;
            LineData lineData2 = lineData;
            ILineDataSet iLineDataSet = set = lineData2 != null ? (ILineDataSet)lineData2.getDataSetByIndex(high.getDataSetIndex()) : null;
            if (set == null || !set.isHighlightEnabled()) continue;
            if (set.getEntryForXValue(high.getX(), high.getY()) == null) continue;
            boolean bl = false;
            if (!this.isInBoundsX(entry, set)) continue;
            Transformer transformer = this.dataProvider.getTransformer(set.getAxisDependency());
            Intrinsics.checkNotNull((Object)transformer);
            PointD pix = transformer.getPixelForValues(((Entry)entry).getX(), ((BaseEntry)entry).getY() * this.getAnimator().getPhaseY());
            high.setDraw((float)pix.getX(), (float)pix.getY());
            this.drawHighlightLines(canvas, (float)pix.getX(), (float)pix.getY(), set);
        }
    }

    public final void releaseBitmap() {
        Canvas canvas = this.bitmapCanvas;
        if (canvas != null) {
            canvas.setBitmap(null);
        }
        this.bitmapCanvas = null;
        if (this.drawBitmap != null) {
            Bitmap drawBitmap;
            WeakReference<Bitmap> weakReference = this.drawBitmap;
            Bitmap bitmap = drawBitmap = weakReference != null ? (Bitmap)weakReference.get() : null;
            if (bitmap != null) {
                bitmap.recycle();
            }
            WeakReference<Bitmap> weakReference2 = this.drawBitmap;
            if (weakReference2 != null) {
                weakReference2.clear();
            }
            this.drawBitmap = null;
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ\u001e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u000bJ\u0010\u0010\u0012\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0013\u001a\u00020\u0014R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\b\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\t\u00a8\u0006\u0015"}, d2={"Linfo/appdev/charting/renderer/LineChartRenderer$DataSetImageCache;", "", "<init>", "(Linfo/appdev/charting/renderer/LineChartRenderer;)V", "mCirclePathBuffer", "Landroid/graphics/Path;", "circleBitmaps", "", "Landroid/graphics/Bitmap;", "[Landroid/graphics/Bitmap;", "init", "", "set", "Linfo/appdev/charting/interfaces/datasets/ILineDataSet;", "fill", "", "drawCircleHole", "drawTransparentCircleHole", "getBitmap", "index", "", "chartLib_release"})
    private final class DataSetImageCache {
        @NotNull
        private final Path mCirclePathBuffer = new Path();
        @Nullable
        private Bitmap[] circleBitmaps;

        public final boolean init(@NotNull ILineDataSet set) {
            Intrinsics.checkNotNullParameter((Object)set, (String)"set");
            int size = set.getCircleColorCount();
            boolean changeRequired = false;
            if (this.circleBitmaps == null) {
                this.circleBitmaps = new Bitmap[size];
                changeRequired = true;
            } else {
                Intrinsics.checkNotNull((Object)this.circleBitmaps);
                if (this.circleBitmaps.length != size) {
                    this.circleBitmaps = new Bitmap[size];
                    changeRequired = true;
                }
            }
            return changeRequired;
        }

        public final void fill(@NotNull ILineDataSet set, boolean drawCircleHole, boolean drawTransparentCircleHole) {
            Intrinsics.checkNotNullParameter((Object)set, (String)"set");
            int colorCount = set.getCircleColorCount();
            float circleRadius = set.getCircleRadius();
            float circleHoleRadius = set.getCircleHoleRadius();
            for (int i = 0; i < colorCount; ++i) {
                Bitmap circleBitmap;
                Bitmap.Config conf = Bitmap.Config.ARGB_4444;
                Intrinsics.checkNotNullExpressionValue((Object)Bitmap.createBitmap((int)((int)((double)circleRadius * 2.1)), (int)((int)((double)circleRadius * 2.1)), (Bitmap.Config)conf), (String)"createBitmap(...)");
                Canvas canvas = new Canvas(circleBitmap);
                Intrinsics.checkNotNull((Object)this.circleBitmaps);
                this.circleBitmaps[i] = circleBitmap;
                LineChartRenderer.this.getPaintRender().setColor(set.getCircleColor(i));
                if (drawTransparentCircleHole) {
                    this.mCirclePathBuffer.reset();
                    this.mCirclePathBuffer.addCircle(circleRadius, circleRadius, circleRadius, Path.Direction.CW);
                    this.mCirclePathBuffer.addCircle(circleRadius, circleRadius, circleHoleRadius, Path.Direction.CCW);
                    canvas.drawPath(this.mCirclePathBuffer, LineChartRenderer.this.getPaintRender());
                    continue;
                }
                canvas.drawCircle(circleRadius, circleRadius, circleRadius, LineChartRenderer.this.getPaintRender());
                if (!drawCircleHole) continue;
                canvas.drawCircle(circleRadius, circleRadius, circleHoleRadius, LineChartRenderer.this.getCirclePaintInner());
            }
        }

        @Nullable
        public final Bitmap getBitmap(int index) {
            Intrinsics.checkNotNull((Object)this.circleBitmaps);
            Intrinsics.checkNotNull((Object)this.circleBitmaps);
            return this.circleBitmaps[index % this.circleBitmaps.length];
        }
    }

    @Metadata(mv={2, 3, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[LineDataSet.Mode.values().length];
            try {
                nArray[LineDataSet.Mode.LINEAR.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LineDataSet.Mode.STEPPED.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LineDataSet.Mode.CUBIC_BEZIER.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LineDataSet.Mode.HORIZONTAL_BEZIER.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

