/*
 * Decompiled with CFR 0.152.
 */
package info.appdev.charting.components;

import android.graphics.Paint;
import info.appdev.charting.components.AxisBase;
import info.appdev.charting.utils.NumberUtilsKt;
import info.appdev.charting.utils.PaintUtilsKt;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0007\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0010\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\b\b\u0016\u0018\u00002\u00020\u0001:\u0002GHB\t\b\u0016\u00a2\u0006\u0004\b\u0002\u0010\u0003B\u0013\b\u0016\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0002\u0010\u0006J\u0010\u00104\u001a\u0002052\b\u00106\u001a\u0004\u0018\u00010$J\u0010\u00107\u001a\u0002052\u0006\u00108\u001a\u00020\bH\u0007J\u000e\u00109\u001a\u0002052\u0006\u0010:\u001a\u00020\bJ\u000e\u0010?\u001a\u00020\u00192\u0006\u0010@\u001a\u00020AJ\u000e\u0010B\u001a\u00020\u00192\u0006\u0010@\u001a\u00020AJ\u0006\u0010C\u001a\u00020\bJ\u0018\u0010D\u001a\u0002052\u0006\u0010E\u001a\u00020\u00192\u0006\u0010F\u001a\u00020\u0019H\u0016R\u0014\u0010\u0007\u001a\u00020\bX\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\tR\u001a\u0010\n\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\t\"\u0004\b\u000b\u0010\fR\u001a\u0010\r\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\t\"\u0004\b\u000e\u0010\fR$\u0010\u0010\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\b@DX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\t\"\u0004\b\u0011\u0010\fR\u001a\u0010\u0012\u001a\u00020\u0013X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u001a\u0010\u0018\u001a\u00020\u0019X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR\u001a\u0010\u001e\u001a\u00020\u0019X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010\u001b\"\u0004\b \u0010\u001dR\u001a\u0010!\u001a\u00020\u0019X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010\u001b\"\u0004\b#\u0010\u001dR\"\u0010%\u001a\u0004\u0018\u00010$2\b\u0010\u000f\u001a\u0004\u0018\u00010$@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010'R\u001a\u0010(\u001a\u00020\u0019X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b)\u0010\u001b\"\u0004\b*\u0010\u001dR\u0013\u0010+\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b,\u0010-R\u001a\u0010.\u001a\u00020\u0019X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b/\u0010\u001b\"\u0004\b0\u0010\u001dR\u001a\u00101\u001a\u00020\u0019X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b2\u0010\u001b\"\u0004\b3\u0010\u001dR$\u0010<\u001a\u00020\u00192\u0006\u0010;\u001a\u00020\u00198F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b=\u0010\u001b\"\u0004\b>\u0010\u001d\u00a8\u0006I"}, d2={"Linfo/appdev/charting/components/YAxis;", "Linfo/appdev/charting/components/AxisBase;", "<init>", "()V", "position", "Linfo/appdev/charting/components/YAxis$AxisDependency;", "(Linfo/appdev/charting/components/YAxis$AxisDependency;)V", "isDrawBottomYLabelEntryEnabled", "", "()Z", "isDrawTopYLabelEntryEnabled", "setDrawTopYLabelEntryEnabled", "(Z)V", "isInverted", "setInverted", "value", "isDrawZeroLineEnabled", "setDrawZeroLineEnabled", "zeroLineColor", "", "getZeroLineColor", "()I", "setZeroLineColor", "(I)V", "mZeroLineWidth", "", "getMZeroLineWidth", "()F", "setMZeroLineWidth", "(F)V", "spaceTop", "getSpaceTop", "setSpaceTop", "spaceBottom", "getSpaceBottom", "setSpaceBottom", "Linfo/appdev/charting/components/YAxis$YAxisLabelPosition;", "labelPosition", "getLabelPosition", "()Linfo/appdev/charting/components/YAxis$YAxisLabelPosition;", "labelXOffset", "getLabelXOffset", "setLabelXOffset", "axisDependency", "getAxisDependency", "()Linfo/appdev/charting/components/YAxis$AxisDependency;", "minWidth", "getMinWidth", "setMinWidth", "maxWidth", "getMaxWidth", "setMaxWidth", "setPosition", "", "pos", "setStartAtZero", "startAtZero", "setDrawZeroLine", "mDrawZeroLine", "width", "zeroLineWidth", "getZeroLineWidth", "setZeroLineWidth", "getRequiredWidthSpace", "p", "Landroid/graphics/Paint;", "getRequiredHeightSpace", "needsOffset", "calculate", "dataMin", "dataMax", "YAxisLabelPosition", "AxisDependency", "chartLib_release"})
public class YAxis
extends AxisBase {
    private final boolean isDrawBottomYLabelEntryEnabled;
    private boolean isDrawTopYLabelEntryEnabled = true;
    private boolean isInverted;
    private boolean isDrawZeroLineEnabled;
    private int zeroLineColor = -7829368;
    private float mZeroLineWidth = 1.0f;
    private float spaceTop = 10.0f;
    private float spaceBottom = 10.0f;
    @Nullable
    private YAxisLabelPosition labelPosition = YAxisLabelPosition.OUTSIDE_CHART;
    private float labelXOffset;
    @Nullable
    private final AxisDependency axisDependency;
    private float minWidth;
    private float maxWidth = Float.POSITIVE_INFINITY;

    public final boolean isDrawBottomYLabelEntryEnabled() {
        return this.isDrawBottomYLabelEntryEnabled;
    }

    public final boolean isDrawTopYLabelEntryEnabled() {
        return this.isDrawTopYLabelEntryEnabled;
    }

    public final void setDrawTopYLabelEntryEnabled(boolean bl) {
        this.isDrawTopYLabelEntryEnabled = bl;
    }

    public final boolean isInverted() {
        return this.isInverted;
    }

    public final void setInverted(boolean bl) {
        this.isInverted = bl;
    }

    public final boolean isDrawZeroLineEnabled() {
        return this.isDrawZeroLineEnabled;
    }

    protected final void setDrawZeroLineEnabled(boolean bl) {
        this.isDrawZeroLineEnabled = bl;
    }

    public final int getZeroLineColor() {
        return this.zeroLineColor;
    }

    public final void setZeroLineColor(int n) {
        this.zeroLineColor = n;
    }

    protected final float getMZeroLineWidth() {
        return this.mZeroLineWidth;
    }

    protected final void setMZeroLineWidth(float f) {
        this.mZeroLineWidth = f;
    }

    public final float getSpaceTop() {
        return this.spaceTop;
    }

    public final void setSpaceTop(float f) {
        this.spaceTop = f;
    }

    public final float getSpaceBottom() {
        return this.spaceBottom;
    }

    public final void setSpaceBottom(float f) {
        this.spaceBottom = f;
    }

    @Nullable
    public final YAxisLabelPosition getLabelPosition() {
        return this.labelPosition;
    }

    public final float getLabelXOffset() {
        return this.labelXOffset;
    }

    public final void setLabelXOffset(float f) {
        this.labelXOffset = f;
    }

    @Nullable
    public final AxisDependency getAxisDependency() {
        return this.axisDependency;
    }

    public final float getMinWidth() {
        return this.minWidth;
    }

    public final void setMinWidth(float f) {
        this.minWidth = f;
    }

    public final float getMaxWidth() {
        return this.maxWidth;
    }

    public final void setMaxWidth(float f) {
        this.maxWidth = f;
    }

    public YAxis() {
        this.isDrawBottomYLabelEntryEnabled = true;
        this.axisDependency = AxisDependency.LEFT;
        this.setMYOffset(0.0f);
    }

    public YAxis(@Nullable AxisDependency position) {
        this.isDrawBottomYLabelEntryEnabled = true;
        this.axisDependency = position;
        this.setMYOffset(0.0f);
    }

    public final void setPosition(@Nullable YAxisLabelPosition pos) {
        this.labelPosition = pos;
    }

    @Deprecated(message="Use setAxisMinimum(...) / setAxisMaximum(...) instead.")
    public final void setStartAtZero(boolean startAtZero) {
        if (startAtZero) {
            this.setAxisMinimum(0.0f);
        } else {
            this.resetAxisMinimum();
        }
    }

    public final void setDrawZeroLine(boolean mDrawZeroLine) {
        this.isDrawZeroLineEnabled = mDrawZeroLine;
    }

    public final float getZeroLineWidth() {
        return this.mZeroLineWidth;
    }

    public final void setZeroLineWidth(float width) {
        this.mZeroLineWidth = NumberUtilsKt.convertDpToPixel(width);
    }

    public final float getRequiredWidthSpace(@NotNull Paint p) {
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        p.setTextSize(this.getMTextSize());
        String label = this.getLongestLabel(p);
        float width = (float)PaintUtilsKt.calcTextWidth(p, label) + this.getXOffset() * 2.0f;
        float minWidth = this.minWidth;
        float maxWidth = this.maxWidth;
        if (minWidth > 0.0f) {
            minWidth = NumberUtilsKt.convertDpToPixel(minWidth);
        }
        if (maxWidth > 0.0f && !(maxWidth == Float.POSITIVE_INFINITY)) {
            maxWidth = NumberUtilsKt.convertDpToPixel(maxWidth);
        }
        width = Math.max(minWidth, Math.min(width, (double)maxWidth > 0.0 ? maxWidth : width));
        return width;
    }

    public final float getRequiredHeightSpace(@NotNull Paint p) {
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        p.setTextSize(this.getMTextSize());
        String label = this.getLongestLabel(p);
        return (float)PaintUtilsKt.calcTextHeight(p, label) + this.getYOffset() * 2.0f;
    }

    public final boolean needsOffset() {
        return this.isEnabled() && this.isDrawLabelsEnabled() && this.labelPosition == YAxisLabelPosition.OUTSIDE_CHART;
    }

    @Override
    public void calculate(float dataMin, float dataMax) {
        float range;
        float min = dataMin;
        float max = dataMax;
        if (min > max) {
            if (this.isAxisMaxCustom() && this.isAxisMinCustom()) {
                float t = min;
                min = max;
                max = t;
            } else if (this.isAxisMaxCustom()) {
                min = max < 0.0f ? max * 1.5f : max * 0.5f;
            } else if (this.isAxisMinCustom()) {
                max = min < 0.0f ? min * 0.5f : min * 1.5f;
            }
        }
        if ((range = Math.abs(max - min)) == 0.0f) {
            max += 1.0f;
            min -= 1.0f;
        }
        range = Math.abs(max - min);
        this.setMAxisMinimum(this.isAxisMinCustom() ? this.getMAxisMinimum() : min - range / 100.0f * this.spaceBottom);
        this.setMAxisMaximum(this.isAxisMaxCustom() ? this.getMAxisMaximum() : max + range / 100.0f * this.spaceTop);
        this.setMAxisRange(Math.abs(this.getMAxisMinimum() - this.getMAxisMaximum()));
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Linfo/appdev/charting/components/YAxis$AxisDependency;", "", "<init>", "(Ljava/lang/String;I)V", "LEFT", "RIGHT", "chartLib_release"})
    public static final class AxisDependency
    extends Enum<AxisDependency> {
        public static final /* enum */ AxisDependency LEFT = new AxisDependency();
        public static final /* enum */ AxisDependency RIGHT = new AxisDependency();
        private static final /* synthetic */ AxisDependency[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static AxisDependency[] values() {
            return (AxisDependency[])$VALUES.clone();
        }

        public static AxisDependency valueOf(String value) {
            return Enum.valueOf(AxisDependency.class, value);
        }

        @NotNull
        public static EnumEntries<AxisDependency> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = axisDependencyArray = new AxisDependency[]{AxisDependency.LEFT, AxisDependency.RIGHT};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Linfo/appdev/charting/components/YAxis$YAxisLabelPosition;", "", "<init>", "(Ljava/lang/String;I)V", "OUTSIDE_CHART", "INSIDE_CHART", "chartLib_release"})
    public static final class YAxisLabelPosition
    extends Enum<YAxisLabelPosition> {
        public static final /* enum */ YAxisLabelPosition OUTSIDE_CHART = new YAxisLabelPosition();
        public static final /* enum */ YAxisLabelPosition INSIDE_CHART = new YAxisLabelPosition();
        private static final /* synthetic */ YAxisLabelPosition[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static YAxisLabelPosition[] values() {
            return (YAxisLabelPosition[])$VALUES.clone();
        }

        public static YAxisLabelPosition valueOf(String value) {
            return Enum.valueOf(YAxisLabelPosition.class, value);
        }

        @NotNull
        public static EnumEntries<YAxisLabelPosition> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = yAxisLabelPositionArray = new YAxisLabelPosition[]{YAxisLabelPosition.OUTSIDE_CHART, YAxisLabelPosition.INSIDE_CHART};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

