/*
 * Decompiled with CFR 0.152.
 */
package info.appdev.charting.buffer;

import info.appdev.charting.buffer.AbstractBuffer;
import info.appdev.charting.data.BarEntry;
import info.appdev.charting.interfaces.datasets.IBarDataSet;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0011\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0016\u0018\u00002\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0001B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u000e\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u0004J(\u0010!\u001a\u00020\u001f2\u0006\u0010\"\u001a\u00020\u00192\u0006\u0010#\u001a\u00020\u00192\u0006\u0010$\u001a\u00020\u00192\u0006\u0010%\u001a\u00020\u0019H\u0004J\n\u0010&\u001a\u00020'H\u0096\u0080\u0004J\u0012\u0010(\u001a\u00020\u001f2\b\u0010)\u001a\u0004\u0018\u00010\u0002H\u0016R\u001a\u0010\n\u001a\u00020\u0004X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001a\u0010\u0005\u001a\u00020\u0004X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\f\"\u0004\b\u0010\u0010\u000eR\u001a\u0010\u0006\u001a\u00020\u0007X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0015\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0012\"\u0004\b\u0017\u0010\u0014R\u001a\u0010\u0018\u001a\u00020\u0019X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001d\u00a8\u0006*"}, d2={"Linfo/appdev/charting/buffer/BarBuffer;", "Linfo/appdev/charting/buffer/AbstractBuffer;", "Linfo/appdev/charting/interfaces/datasets/IBarDataSet;", "size", "", "dataSetCount", "containsStacks", "", "<init>", "(IIZ)V", "dataSetIndex", "getDataSetIndex", "()I", "setDataSetIndex", "(I)V", "getDataSetCount", "setDataSetCount", "getContainsStacks", "()Z", "setContainsStacks", "(Z)V", "inverted", "getInverted", "setInverted", "barWidth", "", "getBarWidth", "()F", "setBarWidth", "(F)V", "setDataSet", "", "index", "addBar", "left", "top", "right", "bottom", "toString", "", "feed", "data", "chartLib_release"})
public class BarBuffer
extends AbstractBuffer<IBarDataSet> {
    private int dataSetIndex;
    private int dataSetCount = 1;
    private boolean containsStacks;
    private boolean inverted;
    private float barWidth = 1.0f;

    public BarBuffer(int size, int dataSetCount, boolean containsStacks) {
        super(size);
        this.dataSetCount = dataSetCount;
        this.containsStacks = containsStacks;
    }

    protected final int getDataSetIndex() {
        return this.dataSetIndex;
    }

    protected final void setDataSetIndex(int n) {
        this.dataSetIndex = n;
    }

    protected final int getDataSetCount() {
        return this.dataSetCount;
    }

    protected final void setDataSetCount(int n) {
        this.dataSetCount = n;
    }

    protected final boolean getContainsStacks() {
        return this.containsStacks;
    }

    protected final void setContainsStacks(boolean bl) {
        this.containsStacks = bl;
    }

    public final boolean getInverted() {
        return this.inverted;
    }

    public final void setInverted(boolean bl) {
        this.inverted = bl;
    }

    public final float getBarWidth() {
        return this.barWidth;
    }

    public final void setBarWidth(float f) {
        this.barWidth = f;
    }

    public final void setDataSet(int index) {
        this.dataSetIndex = index;
    }

    protected final void addBar(float left, float top, float right, float bottom) {
        float[] fArray = this.getBuffer();
        int n = this.getIndex();
        this.setIndex(n + 1);
        fArray[n] = left;
        float[] fArray2 = this.getBuffer();
        n = this.getIndex();
        this.setIndex(n + 1);
        fArray2[n] = top;
        float[] fArray3 = this.getBuffer();
        n = this.getIndex();
        this.setIndex(n + 1);
        fArray3[n] = right;
        float[] fArray4 = this.getBuffer();
        n = this.getIndex();
        this.setIndex(n + 1);
        fArray4[n] = bottom;
    }

    @NotNull
    public String toString() {
        String string = Arrays.toString(this.getBuffer());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return "BarBuffer{dataSetIndex=" + this.dataSetIndex + ", dataSetCount=" + this.dataSetCount + ", containsStacks=" + this.containsStacks + ", inverted=" + this.inverted + ", barWidth=" + this.barWidth + ", buffer=" + string + ", index=" + this.getIndex() + "}";
    }

    @Override
    public void feed(@Nullable IBarDataSet data) {
        IBarDataSet iBarDataSet = data;
        float size = (float)(iBarDataSet != null ? iBarDataSet.getEntryCount() : 0) * this.getPhaseX();
        float barWidthHalf = this.barWidth / 2.0f;
        int i = 0;
        while ((float)i < size) {
            BarEntry e;
            IBarDataSet iBarDataSet2 = data;
            BarEntry barEntry = e = iBarDataSet2 != null ? (BarEntry)iBarDataSet2.getEntryForIndex(i) : null;
            if (e == null) {
                ++i;
                continue;
            }
            float x = e.getX();
            float y = e.getY();
            float[] vals = e.getYVals();
            if (!this.containsStacks || vals == null) {
                float left = x - barWidthHalf;
                float right = x + barWidthHalf;
                float bottom = 0.0f;
                float top = 0.0f;
                if (this.inverted) {
                    bottom = y >= 0.0f ? y : 0.0f;
                    top = y <= 0.0f ? y : 0.0f;
                } else {
                    top = y >= 0.0f ? y : 0.0f;
                    float f = bottom = y <= 0.0f ? y : 0.0f;
                }
                if (top > 0.0f) {
                    top *= this.getPhaseY();
                } else {
                    bottom *= this.getPhaseY();
                }
                this.addBar(left, top, right, bottom);
            } else {
                float posY = 0.0f;
                float negY = -e.getNegativeSum();
                float yStart = 0.0f;
                for (float value : vals) {
                    if (value == 0.0f && (posY == 0.0f || negY == 0.0f)) {
                        yStart = y = value;
                    } else if (value >= 0.0f) {
                        y = posY;
                        posY = yStart = posY + value;
                    } else {
                        y = negY;
                        yStart = (float)((double)negY + Math.abs((double)value));
                        negY += (float)Math.abs((double)value);
                    }
                    float left = x - barWidthHalf;
                    float right = x + barWidthHalf;
                    float bottom = 0.0f;
                    float top = 0.0f;
                    if (this.inverted) {
                        bottom = y >= yStart ? y : yStart;
                        top = y <= yStart ? y : yStart;
                    } else {
                        top = y >= yStart ? y : yStart;
                        bottom = y <= yStart ? y : yStart;
                    }
                    this.addBar(left, top *= this.getPhaseY(), right, bottom *= this.getPhaseY());
                }
            }
            ++i;
        }
        this.reset();
    }
}

