/*
 * Decompiled with CFR 0.152.
 */
package info.appdev.charting.utils;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.view.MotionEvent;
import android.view.VelocityTracker;
import android.view.ViewConfiguration;
import info.appdev.charting.formatter.DefaultValueFormatter;
import info.appdev.charting.formatter.IValueFormatter;
import info.appdev.charting.utils.FSize;
import info.appdev.charting.utils.PointF;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017J\b\u0010 \u001a\u00020\u001dH\u0002J\u0016\u0010!\u001a\u00020\u00152\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%J&\u0010(\u001a\u00020\u00152\u0006\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020\u00052\u0006\u0010.\u001a\u00020\u0005J\u001e\u0010/\u001a\u0002002\u0006\u00101\u001a\u00020\u00102\u0006\u00102\u001a\u00020\u00102\u0006\u00103\u001a\u00020\u0010J\u001e\u00104\u001a\u0002002\u0006\u00101\u001a\u00020\u00102\u0006\u00102\u001a\u00020\u00102\u0006\u00105\u001a\u00020\u0010R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\u0007\"\u0004\b\f\u0010\tR\u000e\u0010\r\u001a\u00020\u000eX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0011\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0018\u001a\u00020\u0019\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0011\u0010\u001c\u001a\u00020\u001d\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u000e\u0010&\u001a\u00020'X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00066"}, d2={"Linfo/appdev/charting/utils/Utils;", "", "<init>", "()V", "minimumFlingVelocity", "", "getMinimumFlingVelocity", "()I", "setMinimumFlingVelocity", "(I)V", "maximumFlingVelocity", "getMaximumFlingVelocity", "setMaximumFlingVelocity", "DEG2RAD", "", "FDEG2RAD", "", "FLOAT_EPSILON", "getFLOAT_EPSILON", "()F", "init", "", "context", "Landroid/content/Context;", "POW_10", "", "getPOW_10", "()[I", "defaultValueFormatter", "Linfo/appdev/charting/formatter/IValueFormatter;", "getDefaultValueFormatter", "()Linfo/appdev/charting/formatter/IValueFormatter;", "generateDefaultValueFormatter", "velocityTrackerPointerUpCleanUpIfNecessary", "ev", "Landroid/view/MotionEvent;", "tracker", "Landroid/view/VelocityTracker;", "mDrawableBoundsCache", "Landroid/graphics/Rect;", "drawImage", "canvas", "Landroid/graphics/Canvas;", "drawable", "Landroid/graphics/drawable/Drawable;", "x", "y", "getSizeOfRotatedRectangleByDegrees", "Linfo/appdev/charting/utils/FSize;", "rectangleWidth", "rectangleHeight", "degrees", "getSizeOfRotatedRectangleByRadians", "radians", "chartLib_release"})
public final class Utils {
    @NotNull
    public static final Utils INSTANCE = new Utils();
    private static int minimumFlingVelocity = 50;
    private static int maximumFlingVelocity = 8000;
    public static final double DEG2RAD = Math.PI / 180;
    public static final float FDEG2RAD = (float)Math.PI / 180;
    private static final float FLOAT_EPSILON = Float.intBitsToFloat(1);
    @NotNull
    private static final int[] POW_10;
    @NotNull
    private static final IValueFormatter defaultValueFormatter;
    @NotNull
    private static final Rect mDrawableBoundsCache;

    private Utils() {
    }

    public final int getMinimumFlingVelocity() {
        return minimumFlingVelocity;
    }

    public final void setMinimumFlingVelocity(int n) {
        minimumFlingVelocity = n;
    }

    public final int getMaximumFlingVelocity() {
        return maximumFlingVelocity;
    }

    public final void setMaximumFlingVelocity(int n) {
        maximumFlingVelocity = n;
    }

    public final float getFLOAT_EPSILON() {
        return FLOAT_EPSILON;
    }

    public final void init(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        ViewConfiguration viewConfiguration = ViewConfiguration.get((Context)context);
        minimumFlingVelocity = viewConfiguration.getScaledMinimumFlingVelocity();
        maximumFlingVelocity = viewConfiguration.getScaledMaximumFlingVelocity();
    }

    @NotNull
    public final int[] getPOW_10() {
        return POW_10;
    }

    @NotNull
    public final IValueFormatter getDefaultValueFormatter() {
        return defaultValueFormatter;
    }

    private final IValueFormatter generateDefaultValueFormatter() {
        return new DefaultValueFormatter(1);
    }

    public final void velocityTrackerPointerUpCleanUpIfNecessary(@NotNull MotionEvent ev, @NotNull VelocityTracker tracker) {
        Intrinsics.checkNotNullParameter((Object)ev, (String)"ev");
        Intrinsics.checkNotNullParameter((Object)tracker, (String)"tracker");
        tracker.computeCurrentVelocity(1000, (float)maximumFlingVelocity);
        int upIndex = ev.getActionIndex();
        int id1 = ev.getPointerId(upIndex);
        float x1 = tracker.getXVelocity(id1);
        float y1 = tracker.getYVelocity(id1);
        int i = 0;
        int count = ev.getPointerCount();
        while (i < count) {
            float y;
            if (i == upIndex) {
                ++i;
                continue;
            }
            int id2 = ev.getPointerId(i);
            float x = x1 * tracker.getXVelocity(id2);
            float dot = x + (y = y1 * tracker.getYVelocity(id2));
            if (dot < 0.0f) {
                tracker.clear();
                break;
            }
            ++i;
        }
    }

    public final void drawImage(@NotNull Canvas canvas, @NotNull Drawable drawable, int x, int y) {
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        Intrinsics.checkNotNullParameter((Object)drawable, (String)"drawable");
        int width = drawable.getIntrinsicWidth();
        int height = drawable.getIntrinsicHeight();
        PointF drawOffset = PointF.Companion.getInstance();
        drawOffset.setX((float)x - (float)(width / 2));
        drawOffset.setY((float)y - (float)(height / 2));
        drawable.copyBounds(mDrawableBoundsCache);
        drawable.setBounds(Utils.mDrawableBoundsCache.left, Utils.mDrawableBoundsCache.top, Utils.mDrawableBoundsCache.left + width, Utils.mDrawableBoundsCache.top + width);
        int saveId = canvas.save();
        canvas.translate(drawOffset.getX(), drawOffset.getY());
        drawable.draw(canvas);
        canvas.restoreToCount(saveId);
    }

    @NotNull
    public final FSize getSizeOfRotatedRectangleByDegrees(float rectangleWidth, float rectangleHeight, float degrees) {
        float radians = degrees * ((float)Math.PI / 180);
        return this.getSizeOfRotatedRectangleByRadians(rectangleWidth, rectangleHeight, radians);
    }

    @NotNull
    public final FSize getSizeOfRotatedRectangleByRadians(float rectangleWidth, float rectangleHeight, float radians) {
        return FSize.Companion.getInstance(Math.abs(rectangleWidth * (float)Math.cos(radians)) + Math.abs(rectangleHeight * (float)Math.sin(radians)), Math.abs(rectangleWidth * (float)Math.sin(radians)) + Math.abs(rectangleHeight * (float)Math.cos(radians)));
    }

    static {
        int[] nArray = new int[]{1, 10, 100, 1000, 10000, 100000, 1000000, 10000000, 100000000, 1000000000};
        POW_10 = nArray;
        defaultValueFormatter = INSTANCE.generateDefaultValueFormatter();
        mDrawableBoundsCache = new Rect();
    }
}

