/*
 * Decompiled with CFR 0.152.
 */
package info.appdev.charting.utils;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import info.appdev.charting.utils.FSize;
import info.appdev.charting.utils.PointF;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000H\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\u001a\"\u0010\u0002\u001a\u00020\u0003*\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b\u001a<\u0010\r\u001a\u00020\u0003*\u00020\u00042\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0007\u001a\u00020\u00102\u0006\u0010\t\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0010\u001a\u0014\u0010\u0016\u001a\u00020\b*\u00020\u00122\b\u0010\u0017\u001a\u0004\u0018\u00010\u000f\u001a\u001e\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00102\u0006\u0010\u001b\u001a\u00020\u00102\u0006\u0010\u001c\u001a\u00020\u0010\u001a\u001e\u0010\u001d\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00102\u0006\u0010\u001b\u001a\u00020\u00102\u0006\u0010\u001e\u001a\u00020\u0010\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\n\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"mDrawableBoundsCache", "Landroid/graphics/Rect;", "drawImage", "", "Landroid/graphics/Canvas;", "drawable", "Landroid/graphics/drawable/Drawable;", "x", "", "y", "mDrawTextRectBuffer", "mFontMetricsBuffer", "Landroid/graphics/Paint$FontMetrics;", "drawXAxisValue", "text", "", "", "paint", "Landroid/graphics/Paint;", "anchor", "Linfo/appdev/charting/utils/PointF;", "angleDegrees", "calcTextWidth", "demoText", "getSizeOfRotatedRectangleByDegrees", "Linfo/appdev/charting/utils/FSize;", "rectangleWidth", "rectangleHeight", "degrees", "getSizeOfRotatedRectangleByRadians", "radians", "chartLib_release"})
@SourceDebugExtension(value={"SMAP\nCanvasUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CanvasUtils.kt\ninfo/appdev/charting/utils/CanvasUtilsKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,153:1\n1#2:154\n*E\n"})
public final class CanvasUtilsKt {
    @NotNull
    private static final Rect mDrawableBoundsCache = new Rect();
    @NotNull
    private static final Rect mDrawTextRectBuffer = new Rect();
    @NotNull
    private static final Paint.FontMetrics mFontMetricsBuffer = new Paint.FontMetrics();

    public static final void drawImage(@NotNull Canvas $this$drawImage, @NotNull Drawable drawable, int x, int y) {
        Intrinsics.checkNotNullParameter((Object)$this$drawImage, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)drawable, (String)"drawable");
        int width = drawable.getIntrinsicWidth();
        int height = drawable.getIntrinsicHeight();
        PointF drawOffset = PointF.Companion.getInstance(width, height);
        drawOffset.setX((float)x - (float)width / (float)2);
        drawOffset.setY((float)y - (float)height / (float)2);
        drawable.copyBounds(mDrawableBoundsCache);
        drawable.setBounds(CanvasUtilsKt.mDrawableBoundsCache.left, CanvasUtilsKt.mDrawableBoundsCache.top, CanvasUtilsKt.mDrawableBoundsCache.left + width, CanvasUtilsKt.mDrawableBoundsCache.top + width);
        int saveId = $this$drawImage.save();
        $this$drawImage.translate(drawOffset.getX(), drawOffset.getY());
        drawable.draw($this$drawImage);
        $this$drawImage.restoreToCount(saveId);
    }

    public static final void drawXAxisValue(@NotNull Canvas $this$drawXAxisValue, @Nullable String text, float x, float y, @NotNull Paint paint, @NotNull PointF anchor, float angleDegrees) {
        Intrinsics.checkNotNullParameter((Object)$this$drawXAxisValue, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)paint, (String)"paint");
        Intrinsics.checkNotNullParameter((Object)anchor, (String)"anchor");
        float drawOffsetX = 0.0f;
        float drawOffsetY = 0.0f;
        float lineHeight = paint.getFontMetrics(mFontMetricsBuffer);
        String string = text;
        if (string != null) {
            String it = string;
            boolean bl = false;
            paint.getTextBounds(text, 0, it.length(), mDrawTextRectBuffer);
        }
        drawOffsetX -= (float)CanvasUtilsKt.mDrawTextRectBuffer.left;
        drawOffsetY -= CanvasUtilsKt.mFontMetricsBuffer.ascent;
        Paint.Align originalTextAlign = paint.getTextAlign();
        paint.setTextAlign(Paint.Align.LEFT);
        if (!(angleDegrees == 0.0f)) {
            drawOffsetX -= (float)mDrawTextRectBuffer.width() * 0.5f;
            drawOffsetY -= lineHeight * 0.5f;
            float translateX = x;
            float translateY = y;
            if (!(anchor.getX() == 0.5f) || !(anchor.getY() == 0.5f)) {
                FSize rotatedSize = CanvasUtilsKt.getSizeOfRotatedRectangleByDegrees(mDrawTextRectBuffer.width(), lineHeight, angleDegrees);
                translateX -= rotatedSize.getWidth() * (anchor.getX() - 0.5f);
                translateY -= rotatedSize.getHeight() * (anchor.getY() - 0.5f);
                FSize.Companion.recycleInstance(rotatedSize);
            }
            $this$drawXAxisValue.save();
            $this$drawXAxisValue.translate(translateX, translateY);
            $this$drawXAxisValue.rotate(angleDegrees);
            String string2 = text;
            if (string2 != null) {
                String it = string2;
                boolean bl = false;
                $this$drawXAxisValue.drawText(it, drawOffsetX, drawOffsetY, paint);
            }
            $this$drawXAxisValue.restore();
        } else {
            if (!(anchor.getX() == 0.0f) || !(anchor.getY() == 0.0f)) {
                drawOffsetX -= (float)mDrawTextRectBuffer.width() * anchor.getX();
                drawOffsetY -= lineHeight * anchor.getY();
            }
            drawOffsetX += x;
            drawOffsetY += y;
            String string3 = text;
            if (string3 != null) {
                String it = string3;
                boolean bl = false;
                $this$drawXAxisValue.drawText(it, drawOffsetX, drawOffsetY, paint);
            }
        }
        paint.setTextAlign(originalTextAlign);
    }

    public static final int calcTextWidth(@NotNull Paint $this$calcTextWidth, @Nullable String demoText) {
        Intrinsics.checkNotNullParameter((Object)$this$calcTextWidth, (String)"<this>");
        return (int)$this$calcTextWidth.measureText(demoText);
    }

    @NotNull
    public static final FSize getSizeOfRotatedRectangleByDegrees(float rectangleWidth, float rectangleHeight, float degrees) {
        float radians = degrees * ((float)Math.PI / 180);
        return CanvasUtilsKt.getSizeOfRotatedRectangleByRadians(rectangleWidth, rectangleHeight, radians);
    }

    @NotNull
    public static final FSize getSizeOfRotatedRectangleByRadians(float rectangleWidth, float rectangleHeight, float radians) {
        return FSize.Companion.getInstance(Math.abs(rectangleWidth * (float)Math.cos(radians)) + Math.abs(rectangleHeight * (float)Math.sin(radians)), Math.abs(rectangleWidth * (float)Math.sin(radians)) + Math.abs(rectangleHeight * (float)Math.cos(radians)));
    }
}

